#include <unistd.h>
#include <stdlib.h>
#include "settings.h"
#include <kapp.h>
#include <qpushbt.h>
#include <qlined.h>
#include <kfiledialog.h>
#include <kmsgbox.h>

#define warnMissing(x) { \
KMsgBox::message(this,x,"a widget is missing",KMsgBox::STOP,"Abort"); \
kapp->quit();\
}


settings::settings() : settingsdlg()
{
	setCaption("kdsing Preferences");
	QPushButton *bt=(QPushButton *)ktl->findWidget("apply");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(saveconfig()));
	else	warnMissing("apply");
	bt=(QPushButton *)ktl->findWidget("cancel");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(closeDialog()));
	else	warnMissing("cancel");
	bt=(QPushButton *)ktl->findWidget("ok");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(closeDialog()));
	else	warnMissing("ok");
	bt=(QPushButton *)ktl->findWidget("browse");
	if (bt)
		connect(bt,SIGNAL(clicked()),this,SLOT(browsePressed()));
	else	warnMissing("browse");
	cb1=(QCheckBox *)ktl->findWidget("cb1");
	if (!cb1) warnMissing("cb1");
	cb2=(QCheckBox *)ktl->findWidget("cb2");
	if (cb2)
		connect(cb2,SIGNAL(toggled(bool)),this,SLOT(cb2toggled(bool)));
	else	warnMissing("cb2");
	cb3=(QCheckBox *)ktl->findWidget("cb3");
	if (!cb3) warnMissing("cb3");
	cb4=(QCheckBox *)ktl->findWidget("cb4");
	if (!cb4) warnMissing("cb4");
	cb5=(QCheckBox *)ktl->findWidget("cb5");
	if (!cb5) warnMissing("cb5");
	cb6=(QCheckBox *)ktl->findWidget("cb6");
	if (!cb6) warnMissing("cb6");
	cb7=(QCheckBox *)ktl->findWidget("cb7");
	if (!cb7) warnMissing("cb7");
	cb8=(QCheckBox *)ktl->findWidget("cb8");
	if (!cb8) warnMissing("cb8");
	le1=(QLineEdit *)ktl->findWidget("le1");
	if (!le1) warnMissing("le1");
	le2=(QLineEdit *)ktl->findWidget("le2");
	if (!le2) warnMissing("le2");
	le3=(QLineEdit *)ktl->findWidget("le3");
	if (le3) le3->setEnabled(false);
	else	warnMissing("le3");
}

void settings::cancelDialog()
{
	emit dialogClosed(false);
}

void settings::closeDialog()
{
	saveconfig();
	emit dialogClosed(true);
}

void settings::browsePressed()
{
	if (le1) {
		QString filename(KFileDialog::getOpenFileName(0,"*",0,"Words Data Base"));
		if (!filename.isEmpty())
			le1->setText(filename.data());
		}
}

void settings::cb2toggled(bool on)
{
	le3->setEnabled(!on);
}


void settings::readconfig()
{
	QString mh;
	KConfig *config=kapp->getConfig();
	config->setGroup("kdsing");

	le1->setText(config->readEntry("words",DEFWORDS));
	le2->setText(config->readEntry("delimiter",DEFDELIMITER));
	mh.sprintf("%d",config->readNumEntry("maxhits",DEFHITS));
	le3->setText(mh);
	cb1->setChecked(config->readBoolEntry("clearlist",true));
	cb2->setChecked(config->readBoolEntry("showall",true));
	cb3->setChecked(config->readBoolEntry("wordsearch",false));
	cb4->setChecked(config->readBoolEntry("ignorecase",false));
	cb5->setChecked(config->readBoolEntry("atbeginning",false));
	cb6->setChecked(config->readBoolEntry("zgrep",false));
	cb7->setChecked(config->readBoolEntry("showcommand",false));
	cb8->setChecked(config->readBoolEntry("regexp",false));
	le3->setEnabled(!(cb2->isChecked()));
}

void settings::saveconfig()
{
	KConfig *config=kapp->getConfig();
	config->setGroup("kdsing");

	config->writeEntry("words",le1->text());
	config->writeEntry("delimiter",le2->text());
	config->writeEntry("maxhits",atoi(le3->text()));
	config->writeEntry("clearlist",cb1->isChecked());
	config->writeEntry("showall",cb2->isChecked());
	config->writeEntry("wordsearch",cb3->isChecked());
	config->writeEntry("ignorecase",cb4->isChecked());
	config->writeEntry("atbeginning",cb5->isChecked());
	config->writeEntry("zgrep",cb6->isChecked());
	config->writeEntry("showcommand",cb7->isChecked());
	config->writeEntry("regexp",cb8->isChecked());
	config->sync();
}

#include "settings.moc"

