// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef BIBLINED_H
#define BIBLINED_H

#include <klined.h>
#include <qstringlist.h>


class QString;

class BibLined : public KLineEdit
{
    Q_OBJECT
public:
    BibLined( QStringList *completionsList, QWidget *parent, const char *name = 0 );
    ~BibLined();
    
    
public slots:
    void doCompletion();
    void doRotation();
    void stopRotation();
    
protected:    
    void setupCompletions( const QString &string );
    void insertCompletion();
    
private:
    QStringList *mTemplates;
    QStringList mCompletions;
    QStringList::Iterator mNextComp;
    
    bool mRotate;
    bool mIgnoreTextChanged;
    
    QString mOrigText;
    int mCompBeg;
    int mCompLen;
    
};




#endif










