#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#define TARGETHOST	"localhost"

extern char *readable_address(char *buf_add,long addr);

void main(int argc,char* argv[])
{
struct sockaddr_in sin;
struct hostent *hp;
int s,c;
int rc;
int fd;
int connected,resend;
char from[1024],to[1024],host[1024],message[1024],*p;
char tmpname[1024];
struct stat st;
time_t ft;
char buf[1024];

	*from=0; *to=0; *host=0; *message=0;
	resend=0;

	while((c=getopt(argc,argv,"f:h:t:m:r:"))!=EOF) {
		switch(c) {
		case 'f' :
			strcpy(from,optarg); break;
		case 'h' :
			strcpy(host,optarg); break;
		case 't' :
			strcpy(to,optarg); break;
		case 'm' :
			strcpy(message,optarg); break;
		case 'r' :
			resend=1;
			strcpy(message,optarg); break;
		}
	}

	rc=stat(message,&st);
	if (!rc) ft=st.st_ctime;
	else exit(1);

	hp=gethostbyname(TARGETHOST);
	if (hp==NULL)
	{
		fprintf(stderr,"smbsend: could not get address of %s\n",
		TARGETHOST);
		exit(1);
	}

	bzero((char *)&sin,sizeof(sin));
	bcopy(hp->h_addr,(char *)&sin.sin_addr,hp->h_length);
	sin.sin_family=hp->h_addrtype;
	sin.sin_port=htons(4414);
	s=socket(AF_INET,SOCK_STREAM,0);
	if (s<0)
	{	
		perror("smbsend:socket");
		exit(1);
	}

	printf("smbsend: trying to connect to %s on port %d\n",
		readable_address(buf,ntohl(sin.sin_addr.s_addr)),ntohs(sin.sin_port));

	if(connect(s,(struct sockaddr *)&sin,sizeof(sin))<0)
	{
		perror("smbsend:connect");
		close(s);
		if (resend) exit(1);
		tmpnam(tmpname);
		if (tmpname && *tmpname) {
			strcat(tmpname,".kdepopup");
			s=open(tmpname,O_WRONLY|O_CREAT,0666);
			} else s=-2;
		connected=0;
		if (s<0) exit(1);
		printf("saving to %s\n",tmpname);
	}
	else	connected=1;

	fd=open(message,O_RDONLY);
	if (fd<0) {
		sprintf(buf,"No Message\n");
		rc=strlen(buf);
		write(s,buf,rc);
	} else {

	if (!resend) {

	sprintf(buf,"DATE:%s",ctime(&ft));
	write(s,buf,strlen(buf));

	sprintf(buf,"FROM:%s\n",from);
	write(s,buf,strlen(buf));

	sprintf(buf,"TO:%s\n",to);
	write(s,buf,strlen(buf));

	sprintf(buf,"HOST:%s\n",host);
	write(s,buf,strlen(buf));

	}

	while (1) {
		rc=read(fd,buf,sizeof(buf));
		if (!rc) break;
		write(s,buf,rc);
		}
	close(fd);
	}

	if(connected) shutdown(s,2);

	close(s);

}
