/***************************************************************************
                          vvokabel.h  -  description
                             -------------------
    begin                : Fri Sep 24 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VVOKABEL_H
#define VVOKABEL_H

#include <qstring.h>
#include <iostream.h>

#include "vtyp.h"
#include "vwissen.h"

#define TermColumn  0
#define TranslationColumn 1

/** VVokabel implements the basic typ of vocabel. It has all needed attributes like
  * term, its translation, the knowledge, type( one of the defined), errortypes
  * @see VVokabelList 
  * @see VVokList
  * 
  * @author Friedrich W. H. Kossebau
  * @version 0.1.1 The very beginning of DokVok
  */


class VVokabel : public VTyp, public VWissen 
{
  public: 
  	VVokabel();
  	VVokabel ( const QString &, const QString & );
  	~VVokabel();
  	inline void ChangeColumn ( int C ) { C = abs (C - 1); }
    
    /** sets the strings of the vokabel */
    void setString( const int Column, const QString &Term ) { String[Column] = Term.stripWhiteSpace(); }
    /** returns string of column  */
    const QString& string( const int Column ) const { return String[Column]; }
    
    /** sets the remark of the vokabel */
    void setRemark( const QString &NewRemark ) { Remark = NewRemark; }
    /** returns Remark */
    const QString& remark() const { return Remark; }
    
//    /** sets the typ of the vokabel */
//    void setTyp( VTypSymbol NewTyp ) { Typ.setSymbol( NewTyp ); }
//    /** returns typ */
//    VTypSymbol typ() { return Typ.symbol(); }
//    /** inits typ */
//    void initTyp() { Typ.initSymbol(); }
    
//    /** sets the wissen of the vokabel */
//    void setWissen( VWissen NewWissen ) { Wissen = NewWissen; }
//    /** returns wissen */
//    VWissen wissen() const { return Wissen; }
//    /** increases Wissen*/
//    void incWissen() { Wissen.inc(); }
//    /** decreases Wissen*/
//    void decWissen() { Wissen.dec(); }
//    /** inits wissen */
//    void initWissen() { Wissen.init(); }
  
  private:
  	QString String [2];
  	QString Remark;
//  	VWissen Wissen;
//  	VTypBase Typ;
  	
};

#endif







