/***************************************************************************
                          vvocabulary.h  -  description
                             -------------------
    begin                : Wed Mar 15 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VVOCABULARY_H
#define VVOCABULARY_H

#include <qobject.h>

#include "vlanguage.h"
#include "vvokabellist.h"

/**
  *@author Friedrich W. H. Kossebau
  */

class VVocabulary : public QObject, public VVokabelList
{
  Q_OBJECT
  
  public: 
	  VVocabulary( QObject * parent=0, const char * name=0 );
  	~VVocabulary();
  	
 	  /** clears the lists and sets strings to 0 */
    void clear( bool total = false );

	  /** returns the titel */
    const QString& titel() { return Titel; }
    /** sets titel and emits signal*/
    void setTitel( const QString NewTitel ) { Titel = NewTitel;  emit newTitel(); }
    
    /** returns the comment */
    const QString& comment() { return Comment; }
    /** sets comment */
    void setComment( const QString NewComment ) { Comment = NewComment; }
    
    /** returns the keywords */
    const QString& keyWords() { return KeyWords; }
    /** sets keywords */
    void setKeyWords( const QString NewKeyWords ) { KeyWords = NewKeyWords; }
    
    /** returns the titel of column nr Number */
    const QString& columnTitel( const int Column ) { return ColumnTitel[Column]; }
    /** sets titel of column nr Number and emits signal */
    void setColumnTitel( const int Column, const char* NewTitel );
    /** sets titel of column nr Number and emits signal */
    void setColumnTitel( const int Column, const QString &NewTitel ); 
    
    /** returns the titel of column nr Column */
    const QString & language( const int Column ) { return Language[Column]; }
    /** sets language of column nr Column and emits signal */
    void setLanguage( const int Column, const QString &NewLanguage ); 
    
    /** returns the author */
    const QString& author() { return Author; }
    /** sets Author */
    void setAuthor( const QString &Name ) { Author = Name; }
    
  protected:	// properties
  	/**  names of the columns */
  	QString ColumnTitel[2];
  	/**  stores the titel */
  	QString Titel;
  	/**  the languages */
  	QString Language[2];
  	/**  explaination or comment */
  	QString Comment;
  	/**  some Keywords */
  	QString KeyWords;
  	/**  author of the list */
  	QString Author;
  
  signals: // Signals
    /**  */
    void newTitel();
    /**  */
    void newColumnTitel( int, const char * );
    /**  */
    void newLanguage( int, const char * );
  
};

#endif
