/***************************************************************************
                          vTypListEdit.cpp  -  description
                             -------------------
    begin                : Thu Mar 23 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>
 
#include <kapp.h>
#include <kmsgbox.h>

#include "veditdialog.h"
#include "vtypedit.h"

VTypListEdit::VTypListEdit( VTypInfoList *GivenList, QWidget *parent, const char *name )
  : QGroupBox( i18n("Types"), parent, name ),
    Layout( this, 10 ),
    TypLayout(),
    TypListBox( this ),
    
    LeftLayout(),
    TypControl( this ),
    NameEdit( this ),
    NameLabel( &NameEdit, i18n("Symbolic Name"), this ),
    LocalNameEdit( this ),
    LocalNameLabel( &LocalNameEdit, i18n("Name"), this ),
    SymbolEdit( this ),
    SymbolLabel( &SymbolEdit, i18n("Symbol"), this )
{
  setLayout();
  
  setList( GivenList );
  
  TypListBox.setMultiSelection( false );

  connect( &TypListBox, SIGNAL(highlighted(int)), SLOT(selected(int)) );
  connect( &LocalNameEdit, SIGNAL(textChanged(const char*)), SLOT(refreshLocalName(const char*)) );
  connect( &SymbolEdit, SIGNAL(textChanged(const char*)), SLOT(refreshSymbol(const char*)) );
  
  connect( New, SIGNAL(clicked()), SLOT(createTyp()) );
  connect( Delete, SIGNAL(clicked()), SLOT(deleteTyp()) );
}



VTypListEdit::~VTypListEdit()
{
}

void VTypListEdit::setEnabled ( bool Enable )
{
  QGroupBox::setEnabled( Enable );
  SymbolEdit.setEnabled( Enable );
  NameEdit.setEnabled( Enable );
  LocalNameEdit.setEnabled( Enable );
  SymbolLabel.setEnabled( Enable );
  NameLabel.setEnabled( Enable );
  LocalNameLabel.setEnabled( Enable );
  Delete->setEnabled( Enable );
  New->setEnabled( Enable );
  TypListBox.setEnabled( Enable );
}


/** sets the layout */
void VTypListEdit::setLayout()
{
  // the layout
  Layout.addSpacing( fontMetrics().height() );
  Layout.addLayout( &TypLayout );
  
  TypLayout.addLayout( &LeftLayout,2 );
  TypLayout.addWidget( &TypListBox,1 );
  
  // the left layout
  LeftLayout.addWidget( &TypControl );
  LeftLayout.addWidget( &NameLabel, 0, AlignLeft );
  LeftLayout.addWidget( &NameEdit );
  LeftLayout.addWidget( &LocalNameLabel, 0, AlignLeft );
  LeftLayout.addWidget( &LocalNameEdit );
  LeftLayout.addWidget( &SymbolLabel, 0, AlignLeft );
  LeftLayout.addWidget( &SymbolEdit, 0, AlignLeft );

    // the typ control
  	New = TypControl.addButton( i18n("&New") );
  	Delete = TypControl.addButton( i18n("&Delete") );
  	TypControl.layout();
    
    // the name edit
    NameLabel.setFixedSize( NameLabel.sizeHint() );
    NameEdit.setFixedHeight( NameEdit.sizeHint().height() );
    NameEdit.setMinimumWidth( NameEdit.sizeHint().width() );
    NameEdit.setFocusPolicy( QWidget::NoFocus );
    NameEdit.setCursor( arrowCursor );

    // the local name edit
    LocalNameLabel.setFixedSize( LocalNameLabel.sizeHint() );
    LocalNameEdit.setFixedHeight( LocalNameEdit.sizeHint().height() );
    LocalNameEdit.setMinimumWidth( LocalNameEdit.sizeHint().width() );

    // the symbol edit
    SymbolLabel.setFixedSize( SymbolLabel.sizeHint() );
    SymbolEdit.setFixedHeight( SymbolEdit.sizeHint().height() );
    QFontMetrics SEFontMetrics( SymbolEdit.fontMetrics() );
    SymbolEdit.setFixedWidth( SEFontMetrics.width("0")*3 );
    SymbolEdit.setMaxLength( 1 );
    
    // the typ listbox
//    TypListBox.setMinimumSize( TypListBox.sizeHint() );

  Layout.activate();
}


  
void VTypListEdit::setList( VTypInfoList *GivenList )
{
  TypInfo = 0;
  List = GivenList;
  
  fillBox();
}



void VTypListEdit::createTyp()
{
  QString Name = "";
  if( !VEditDialog::edit(Name,i18n("Symbolic name"),this,0) )
    return;

  if( Name.isEmpty() )  
  {
    KMsgBox::message( this, i18n("Sorry"), i18n("An empty Name is not possible."), KMsgBox::STOP );
    return;
  }

  VTypInfo *NewTypInfo = new VTypInfo(Name[0],Name,Name);  
//  NewTyp->LocalName = Name;
//  NewTyp->Name = Name;
//  NewTyp->Symbol = ' ';
    
  List->append( NewTypInfo );
  TypListBox.insertItem( Name );
  
  TypListBox.setCurrentItem( TypListBox.count()-1 );
}



void VTypListEdit::deleteTyp()
{
  int Index = TypListBox.currentItem();
  if( Index != -1 )
  {
    QString Question = NameEdit.text();
    Question = i18n("Are you sure that you want\nto delete the typ ") + Question + "?";
    
    if( KMsgBox::yesNo( 0L, i18n("Resurance"), Question, KMsgBox::QUESTION ) == 2 )
      return;

    List->remove( Index );        
    TypListBox.removeItem( Index );  
  }
  
  if( TypListBox.count() == 0 )
    selected( -1 );
}

  

void VTypListEdit::refreshLocalName( const char *Text )
{
  if( TypInfo )
    TypInfo->localName() = Text;
    
  TypListBox.changeItem( Text, TypListBox.currentItem() );
}



void VTypListEdit::refreshSymbol( const char *Text )
{
  if( TypInfo )
  {
    if( *Text == '\0' )
      TypInfo->initSymbol();
    else
      TypInfo->setSymbol( *Text );
  }
}



void VTypListEdit::selected( int Index )
{
  if( Index == -1 )
  {
    SymbolEdit.setText( "" );
    NameEdit.setText( "" );
    LocalNameEdit.setText( "" );
  }
  else if( List )
  {
    // set new Typ
    TypInfo = List->at( Index );
    
    // fill edit with data of new typ
    if( TypInfo )
    {
      LocalNameEdit.setText( TypInfo->localName() );
      NameEdit.setText( TypInfo->name() );         
      SymbolEdit.setText( TypInfo->symbolString() );
    }
  }   
  
  bool Enable = (Index != -1);
  if( NameEdit.isEnabled() != Enable )
  {
    SymbolEdit.setEnabled( Enable );
    NameEdit.setEnabled( Enable );
    LocalNameEdit.setEnabled( Enable );
    SymbolLabel.setEnabled( Enable );
    NameLabel.setEnabled( Enable );
    LocalNameLabel.setEnabled( Enable );
    Delete->setEnabled( Enable );
    TypListBox.setEnabled( Enable );
  }
  
}


/** fills the ListBox with all types in the list */
void VTypListEdit::fillBox()
{
  TypListBox.setAutoUpdate( false );
  TypListBox.clear();

  if( List )
  {
    VTypInfo *TypInfoDummy;
    for( TypInfoDummy=List->first(); TypInfoDummy; TypInfoDummy=List->next() )
      TypListBox.insertItem( TypInfoDummy->localName().data() );
  }
    
  TypListBox.setAutoUpdate( true );
  
  if( TypListBox.count() == 0 )
    selected( -1 );
  else
  {
    TypListBox.setCurrentItem( 0 );  
    selected( 0 ); 
  }
}
