/***************************************************************************
                          dokvokDialog.cpp  -  description
                             -------------------
    begin                : Wed Jan 12 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qfileinfo.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kpixmap.h>
#include "dokvokdialog.h"

DokVokDialog::DokVokDialog(QWidget *parent, const char *name) 
  : VDialog( parent, name),
    General( this ),
    GeneralLayout( &General, 10 ),
    DirectoryLayout(),
    DirectoryEdit( &General, "StandardDirectoryEdit" ),
    DirectoryLabel( &DirectoryEdit, i18n("&Standard Directory"), &General ),
  	Select( &General ),
  	AutoLoadLastFileCheck( &General )
{
  setLayout();

  // power to the buttons  
	connect( &Select, SIGNAL(clicked()), SLOT(slotDirectorySelect()) );
  
  // set Inputdefaults
  DirectoryEdit.setFocus();
  
}

DokVokDialog::~DokVokDialog()
{

}

/** sets the layout */
void DokVokDialog::setLayout()
{
  setCaption( i18n("Properties of DokVok") );
  
  // the general box
  General.setTitle( i18n( "General" ) );
  
  GeneralLayout.addSpacing( fontMetrics().height() ); // to gain distance to box titel
  GeneralLayout.addWidget( &DirectoryLabel, 0, AlignLeft );
  GeneralLayout.addLayout( &DirectoryLayout );
  GeneralLayout.addWidget( &AutoLoadLastFileCheck );
  GeneralLayout.addStretch();
  
  DirectoryLayout.addWidget( &DirectoryEdit, 1 );
  DirectoryLayout.addWidget( &Select );
  
    // the standard directory edit
    DirectoryLabel.setFixedSize( DirectoryLabel.sizeHint() );
    QFontMetrics SDFontMetrics( DirectoryEdit.fontMetrics());
    DirectoryEdit.setFixedHeight( DirectoryEdit.sizeHint().height() );
    DirectoryEdit.setMinimumWidth( SDFontMetrics.width("0")*55 );
  	KPixmap Pix;
  	Pix.load( KApplication::kde_toolbardir() + "/fileopen.xpm" );
  	Select.setPixmap( Pix );
  	Select.setMinimumHeight( DirectoryEdit.sizeHint().height() );
    Select.setFixedWidth( Pix.width()+4 );
    
    // the autoload last file checker
    AutoLoadLastFileCheck.setText( i18n("Start with last file") );
    AutoLoadLastFileCheck.setFixedHeight( AutoLoadLastFileCheck.sizeHint().height() );
    AutoLoadLastFileCheck.setMinimumWidth( AutoLoadLastFileCheck.sizeHint().width() );
      
  GeneralLayout.activate();
    
  Layout.addWidget( &General );
  
  finishLayout();
}


/** opens the dialog and returns true if anything was modified 
  * TODO: if anything is default it will be selected to have quick deleting
  */
bool DokVokDialog::wasModified( QString StandardDirectory, bool AutoLoadLastFile )
{
  DirectoryEdit.setText( StandardDirectory );
  AutoLoadLastFileCheck.setChecked( AutoLoadLastFile );
  
  return exec(); 
}

void DokVokDialog::slotDirectorySelect()
{
  QString DirectoryName;
  bool Done = false;
  
  while( !Done )
  {
    DirectoryName = KDirDialog::getDirectory( DirectoryEdit.text() );
  
    if (!DirectoryName.isEmpty())
    {
      if( !QFileInfo( DirectoryName ).isDir() )
      {
        Done = ( 1 != KMsgBox::yesNo( this, 
        i18n("Warning"), 
        i18n("The selected file is not a directory. Please choose a directory."), 0, i18n("Back"), i18n("Cancel") ) );
      }
      else
      {
        DirectoryEdit.setText( DirectoryName );
        Done = true;
      }
    }
    else
      Done = true;
  }
}

