/***************************************************************************
                          vchecker.h  -  description
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VCHECKER_H
#define VCHECKER_H

#include <qobject.h>
#include <kapp.h>
#include "vstring.h"

struct VCheckerSettings
{
  bool Partial;                  
  char UnknownCharacter;
};

/** checks a string whether it meets the given with contribution to settings
  * @author Friedrich W. H. Kossebau
  * @short                      
  * @see VAbfrageDialog                                  
  */
    
enum VCorrectness { Right, PartiallyRight, Faulty, Wrong, NoInput };

class VChecker : public QObject
{
  Q_OBJECT
  
  public: 
  	VChecker( VCheckerSettings *GivenSettings, QObject *parent=0, const char *name=0 );
  	~VChecker();
  	
    /** divides Original in parts, given by separators, and compares with input
        returns true if one is in the answer (should be turned to equal) */
    bool checkPart( const QString &Input );
    /** sets new original */
    void setOriginal( const VString &NewOriginal ) { Original = NewOriginal; }
    QString &recognizedInput() { return RecognizedInput; }
  public slots:
    /** checks if Input does fit to the original */
    void check( const QString &Input );
  
  protected:
    QString recognized( const QString &Input );
  
  protected:
    VString Original;
    QString RecognizedInput;
    VCheckerSettings *Settings;
  
  signals: // Signals
    void result( VCorrectness );
};

#endif
