/***************************************************************************
                          vchecker.cpp  -  description
                             -------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "vchecker.h"
#include <iostream.h>

VChecker::VChecker( VCheckerSettings *GivenSettings, QObject *parent=0, const char *name=0 )
  : QObject(parent,name), Original( "" )
{
  Settings = GivenSettings;
}


VChecker::~VChecker()
{
}


/** checks if Input does fit to the original */
void VChecker::check( const QString &Input )
{
  VCorrectness Correctness;

//  Input.parse( Input )
  if( Input == Original )
    Correctness = Right;
  else if( Input.isEmpty() )
    Correctness = NoInput;
  else
  {     
    RecognizedInput = recognized( Input );                            
    if( RecognizedInput == Original )
      Correctness = PartiallyRight;
    else if( Settings->Partial && checkPart( Input ) )
      Correctness = PartiallyRight;
    else if( (unsigned int)RecognizedInput.contains('#')+5 < Original.length() )
      Correctness = Faulty;
    else
      Correctness = Wrong;
  }
  emit result( Correctness );
}


/** recognizing methods that works in 4 steps:
    1. find equal words 
    2. find equal pairs of characters 
    3. compare first and last letters as they are not honored by step 2
    4. sets marks */
//TODO: implement step 3!!! 
QString VChecker::recognized( const QString &Input )
{
  unsigned int OriginalLength = Original.length();
  
  QString KnownOriginal; // inhabits known parts of the original
  KnownOriginal.fill( Settings->UnknownCharacter, OriginalLength );
  
  QString UsedOriginal;  // a mask that blinds used original parts
  UsedOriginal.fill( ' ', OriginalLength );
  
  QString UsedInput;     // a mask that blinds used input parts
  UsedInput.fill( ' ', Input.length() );
  
  QString Part;
  int Position;
   
  // check presence of words from original:
  // if contained in input and not used already take them over to known
  int WordBegin;
  int WordEnd = -1;
  while( WordEnd < (int)OriginalLength )
  {
    WordBegin = Original.findWordBegin( WordEnd+1 );
    if( WordBegin == -1 )
    {
      WordEnd = OriginalLength;
    }
    else
    {
      WordEnd = Original.findWordEnd( WordBegin );
      int WordLength = WordEnd-WordBegin+1;
      Part = Original.mid( WordBegin, WordLength );

      Position = Input.find( Part, 0, false );
      if( Position != -1 )
      // word from original is found in input
      { 
        if( UsedInput.mid(Position, WordLength).find('#') == -1 )
        // not used already
        {
          KnownOriginal.replace( WordBegin, WordLength, Part );
          // set used part to used
          Part.fill( '#', WordLength );
          UsedOriginal.replace( WordBegin, WordLength, Part );
          UsedInput.replace( Position, WordLength, Part );   
        }
      }
    }
  }

  // check all pairs of characters from original: 
  // if contained in input and not used already take them over to known
  unsigned int Number;
  QString Mask;
  unsigned int Index;
  
  for( Number = 4; Number > 1; Number-- )
  {
    unsigned int LastPair = OriginalLength - Number;
    Mask.fill( '#', Number );
    
    for( Index = 0; Index <= LastPair; Index++ )
    {
      Part = Original.mid( Index, Number );
      
      Position = Input.find( Part, 0, false );
      if( Position != -1 )
      // pair from original is found in input
      { 
        if( (UsedOriginal.mid( Index, Number ) != Mask ) 
            && (UsedInput.mid( Position, Number ).find( '#' ) == -1) )
        // not used yet
        {
          KnownOriginal.replace( Index, Number, Part );
          // only set first character as used
          UsedOriginal[Index] = '#';            
          UsedInput[Position] = '#';        
        }
      }                                 
    }
  }
   
  // check first and last letters
  
  // set all known marks
  static const QString AllMarks = " ,;.()-:+/?'!\"";
  for( Index = 0; Index < OriginalLength; Index++ )
  {
    char Character = Original[Index];
    if( AllMarks.find(Character) != -1 )
    {
      // write mark
      KnownOriginal[Index] = Character;
    }
  }
   
  return KnownOriginal;
}   


/** divides Original in parts, given by separators, and compares with input
    returns true if one is in the answer (should be turned to equal)  */
bool VChecker::checkPart( const QString &Input ) 
{
  VString Text = Input.copy();
  const char Mark[3] = { ';', ',', '/' };
  // remove additional entries 
  Text.delInBrackets ( VString::Curved ); //TODO: Make this configurable (-> languages )
  Text.delInBrackets ( VString::Round );
  
  bool PartIsCorrect = false;
 
  int Pos;      
  int Length = Text.length() - 1; // so Length starts with 0
  int MarkIndex;
  // separate by all given marks and compare parts with input
  for( MarkIndex = 1; MarkIndex < 3; MarkIndex++ )
  {
    Pos = 0;
    while( Pos <= Length )
    // go through the whole text
    {
      // ignore any characters in front of the next word
      int WordBegin = Text.findWordBegin( Pos );
 
      if( WordBegin == -1 )
        // no more words after Pos, so set Pos after end
        Pos = Length + 1;
      else
      {
        // search next separating mark
        Pos = Text.find( Mark[MarkIndex], WordBegin );
 
        if( Pos == -1 )
          // this part reaches till the end
          Pos = Length + 1;
          
        // compare selected part with input: is part in input?
        //TODO: think about... would be isequal better?
        if( Original.find( Text.mid( WordBegin, Pos-WordBegin ) ) != -1 ) 
          PartIsCorrect = true;
      }
    }
  }
    
  return PartIsCorrect;
}                          
