/***************************************************************************
                          vabfragedialog.cpp  -  description
                             -------------------
    begin                : Tue Jan 18 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 
#include "vabfragedialog.h"
#include "vquestdialog.h"


VAbfrageDialog::VAbfrageDialog( VVokabelList *VokList, 
                                QString GivenLanguage,
                                QString AskLanguage,
                                VQuestionSettings *QSettings,
                                QWidget *parent=0, 
                                const char *name=0 ) 
  : QDialog( parent,name,true ), 
    Layout( this, 10 ),
    AbfrageRahmen( this ),
    RahmenLayout( &AbfrageRahmen, 10 ),
    LeftLayout(),
    Figure( &AbfrageRahmen ),
    Abfrage( &AbfrageRahmen ),
    ReportBox( &AbfrageRahmen ),
    Buttons( this ),
    Checker( &(QSettings->CheckerSettings) ),
    GoOn( false ),
    WasNoInput( false )
{
  FullList = VokList;
  UnknownList = new VVokabelList;
  
  GivenColumn = 0;
  AskedColumn = 1;
  
  RightSoundFileName = KApplication::kde_datadir() + "/dokvok/sounds/right.wav";
  WrongSoundFileName = KApplication::kde_datadir() + "/dokvok/sounds/wrong.wav";
  
  QuestionSettings = QSettings;
  
  setLayout();
  Abfrage.setLanguage( 0, GivenLanguage );
  Abfrage.setLanguage( 1, AskLanguage );
  
  // power to the buttons
  connect( Cancel, SIGNAL(clicked()), SLOT(reject()) );
  connect( Settings, SIGNAL(clicked()), SLOT(editSettings()) );
  
  connect( &Abfrage, SIGNAL( inputFinished( const QString & ) ), &Checker, SLOT( check(const QString & ) ) );
  connect( &Abfrage, SIGNAL(confirmed()), SLOT(askNext()) );
  connect( &Figure, SIGNAL(looksNormalAgain()), SLOT(reactionFinished()) );
  
  // and power to checker
  connect( &Checker, SIGNAL( result( VCorrectness ) ), SLOT( answerIs( VCorrectness ) ) );
}


VAbfrageDialog::~VAbfrageDialog()
{
  // check if no groups were used and therefor a FullLists list was used
  if( (FullList != RoundList) && (FullList != UnknownList) )
    delete FullList;
  
  delete RoundList;
  delete UnknownList;
}


/** sets the layout */
void VAbfrageDialog::setLayout()
{
  setCaption( i18n("Learning") );
  
  // layout 
  Layout.addWidget( &AbfrageRahmen, 10 );
  Layout.addSpacing( 10 );
	Layout.addWidget( &Buttons, 0, AlignBottom );

  
  // the AbfrageRahmen...
  RahmenLayout.addLayout( &LeftLayout );
  RahmenLayout.addWidget( &ReportBox );
  
  LeftLayout.addWidget( &Figure, 0, AlignRight );
  LeftLayout.addWidget( &Abfrage );
  LeftLayout.addStretch( 1 );
  
    AbfrageRahmen.setFrameStyle( QFrame::Panel | QFrame::Sunken );
    AbfrageRahmen.setLineWidth( 1 );
    AbfrageRahmen.setBackgroundColor( QColor( 60,207,6) );
    AbfrageRahmen.setMinimumHeight( Abfrage.sizeHint().height() );
    
    // DokVok itself...
    Figure.setMinimumHeight( Figure.sizeHint().height() );
    Figure.setBackgroundColor( QColor( 60,207,6) );
  
    // the Abfrage
    Abfrage.setMinimumHeight( Abfrage.sizeHint().height() );

    // the report box
    ReportBox.setFrameStyle( QFrame::Panel | QFrame::Plain );
    ReportBox.setLineWidth( 1 );
    ReportBox.setMargin( 10 );

    
  RahmenLayout.activate();
   
  // buttonrow at bottom of Window
	Help = Buttons.addButton( i18n("&Help") );
	Settings = Buttons.addButton( i18n("&Settings") );
	Buttons.addStretch();
	Cancel = Buttons.addButton( i18n("&Cancel") );
	
	Buttons.layout();

  // finally do it!
  Layout.activate();
}


/**  */
bool VAbfrageDialog::learn()
{
  KnowledgeChange = false;
  QuestionSettings->GroupSize = 3; 
  
  // prepare round list
  if( QuestionSettings->GroupSize < 1 )
    // no group size specified so RoundList gets the whole list
    RoundList = FullList;
  else
  {
    RoundList = new VVokabelList;
    fillRoundList();
  }

  if( (Vokabel = RoundList->first()) )
  {  
    Round = 1;
    ask();
    
    show();
  }
  
  return KnowledgeChange;
}


/** asks the next vocabel
    or opens new round if actual is done */
void VAbfrageDialog::askNext()
{
  if( WasNoInput )
    WasNoInput = false;
  else
    Vokabel = RoundList->next();  
  
  if( !Vokabel )
  // no vocabel left in the round list
  {
    // so clear the list...
    RoundList->clear();
    
    if( !UnknownList->isEmpty() )
    // have the list of unknown as round list and start another round
    {
      VVokabelList *Helper = RoundList;
      RoundList = UnknownList;
      UnknownList = Helper;
      Round++;        
    }
    else if( !FullList->isEmpty() )
    // all vocabels of last round are done, but some in the full list aren't yet
    {
      fillRoundList();
    }
      
    Vokabel = RoundList->first();  
  }
  
  // after all, do we have a vocabel to ask?
  if( Vokabel )
  {
    ReportBox.clear();
    Abfrage.setFocusPolicy( QWidget::ClickFocus );
    ask();
  }
  else
    done(0);
}


/** */
void VAbfrageDialog::ask()
{
  Trial = 1;
  Checker.setOriginal( Vokabel->string(AskedColumn) );
  Abfrage.ask( Vokabel->string(GivenColumn) );
}



/** */
void VAbfrageDialog::reportWrongAnswer( const char *Report1, const char *Report2, const char *Report3 )
{
  if( (QuestionSettings->SecondChance) && (Trial == 1) ) 
  // was only the first try, a second is allowed...
  {
    Trial = 2;
    ReportBox.setText( Report1 );
    if( QuestionSettings->ShowCorrectedInput )
      Abfrage.askAgain( Checker.recognizedInput(), true );
    else
      Abfrage.askAgain( 0, true );
  }
  else
  // no, wrong, tell user and ask next
  {
    UnknownList->append( Vokabel );
    
    if( (QuestionSettings->SecondChance) ) 
      ReportBox.setText( Report2 );
    else
      ReportBox.setText( Report3 );
      
    Abfrage.askAgain( Vokabel->string(AskedColumn), true, true );
  }
  Figure.lookWrong();
}



/** */
void VAbfrageDialog::answerIs( VCorrectness Correctness )
{
  // adjust knowledge data of vocabel
  if( Round == 1 ) 
  { 
    if( Correctness < PartiallyRight ) 
      Vokabel->decLevel();
    else
      Vokabel->incLevel();
      
    KnowledgeChange = true;
  }


//  AudioServer.play( RightSoundFileName );  
//  AudioServer.play( WrongSoundFileName );  


  QString Faulty1TryFailedR = i18n("Faulty.\n\nBut there was\nsomething right...\n\nTry it again.");
  QString Faulty2TryFailedR = i18n("Still Faulty.\n\nMemorize...");
  QString FaultyR           = i18n("Faulty.\n\nSomething was right but not enough...");

  QString Wrong1TryFailedR = i18n("Wrong.\n\nOne more guess, please!");
  QString Wrong2TryFailedR = i18n("Wrong again.\n\nConcentrate.");
  QString WrongR           = i18n("Wrong.\n\nYou had no clue, had you...");

  // react 
  switch( Correctness )
  {
                 // Melde kurz Erfolg und frage nchste
    case Right : ReportBox.setText( i18n("Right!") );
                 GoOn = true; 
				         Figure.lookRight();
				         break;
                          // Entweder melde Erfolg, zeige Richtig an, lasse besttigen (?) und frage nchste
                          // (oder melde Mierfolg, zeige Richtig an, lasse besttigen und gib 2. Chance oder frage nchste)
		case PartiallyRight : ReportBox.setText( i18n("Right!\n\nAt least it's sufficient.") );
                          Abfrage.askAgain( Vokabel->string(AskedColumn), true, true );
                          Figure.lookRight();
                          break;
                  // Melde Misserfolg, zeige Richtig an, lasse besttigen und gib 2. Chance oder frage nchste
    case Faulty : reportWrongAnswer( Faulty1TryFailedR, Faulty2TryFailedR, FaultyR );
				         break;
                 // Melde Misserfolg, zeige Richtig an, lasse besttigen und gib 2. Chance oder frage nchste
    case Wrong : reportWrongAnswer( Wrong1TryFailedR, Wrong2TryFailedR, WrongR );
				         break;
                   // Melde Misserfolg, zeige Richtig an, lasse besttigen und frage erneut ab ( wieder Versuch 1, aber ohne Wissenssteigerung? )
    case NoInput : ReportBox.setText( i18n("Oh, too sad.\nYou don't know.\n\nWell, look what it was supposed to be...") );
                   WasNoInput = true; 
                   Abfrage.askAgain( Vokabel->string(AskedColumn), true, true );
                   break;
  }
}


/**  */
void VAbfrageDialog::editSettings()
{
  VQuestionDialog Dialog;
  
  Dialog.edit( QuestionSettings );
}

  
/** moves vocabels from full list to round list according to groupsize */
void VAbfrageDialog::fillRoundList()
{
  int Index;
  int GroupSize = QuestionSettings->GroupSize;
  for( Index = 0; Index < GroupSize; Index++ )
  {
    if( !(Vokabel = FullList->take(0)) )
      break;
    RoundList->append( Vokabel );
  }
}

  
/**  */
void VAbfrageDialog::reactionFinished()
{
  if( GoOn ) askNext();
  GoOn = false;
}