/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [status.cpp]                Status Line                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

/* Plan
   - different states
     - welcome.
     - terminating
     - disconnected
     - connected
     - file transfer
*/

#include "status.h"
#include <stdio.h>
#include <math.h>

#include "status.moc"

StatusLine::StatusLine(QWidget *parent=0, const char *name=0)
           :QFrame(parent,name)
{ 
  setFrameStyle( QFrame::Panel | QFrame::Raised );
  status = new QLabel(this);
  progress = new KProgress(this);
  progress->setBackgroundColor( QColor(0,255,255) );
  QToolTip::add(progress,"Advance of file transport");
  connected = new QLabel(this);
  connected->setFrameStyle( QFrame::Panel | QFrame::Raised );
  connected->setLineWidth( 2 );
  QToolTip::add(connected,
              "Connection status: red - connected, watch your phone bill");
  gm = new QBoxLayout(this,QBoxLayout::LeftToRight,4);
  gm->addWidget(connected,2);
  gm->addWidget(status,100);
  gm->addWidget(progress,20);
  gm->activate();

  setMinimumSize(0,25);
  setMaximumSize(10000,25);
//setBackgroundColor(blue);


}

StatusLine::setValue(int val)
{
  progress->setValue(val);
}

StatusLine::setStatus(char* text)
{
  status->setText(text);
}

StatusLine::~StatusLine()
{
  delete gm;
}

/* --| Display ZMODEM Transfer State |--------------------------------------- */

#define HERE printf("%s(%d): here\n",__FILE__,__LINE__)

void StatusLine::fileinfo()
{ char buf[100];
  float speed = bytesDone/(clock.elapsed()/1000.0);
  int remain = (int)((speed>0)?(bytesFile-bytesDone)/speed+0.5:0);
  char* unit = "";
  if (speed > 1.0e6) { speed = speed / 1.0e6; unit = "M"; } else
  if (speed > 1.0e3) { speed = speed / 1.0e3; unit = "K"; }
  sprintf(buf,"%s \"%s\" (%d bytes) at %.1f%sB/sec. "
              "Remaining %02d:%02d:%02d.",
          direction, filename.data(), bytesFile, speed, unit, 
          remain/60/60, remain/60%60, remain%60
         );
  status->setText(buf);
  progress->setValue(bytesFile?100*bytesDone/bytesFile:100);
}

void StatusLine::ZmodemEvent(Zmodem::EventType event, const char *text, long value)
{
  switch( event )
  {
    case Zmodem::eventSndFile      : direction = "sending";   goto eventFile;
    case Zmodem::eventRcvFile      : direction = "receiving"; goto eventFile;
                 eventFile         : filename = text;
                                     bytesFile = value;
                                     bytesDone = 0; 
                                     clock.start();
                                     fileinfo();
                                     break;
    case Zmodem::eventSndData      :
    case Zmodem::eventRcvData      : bytesDone += value;
                                     fileinfo();
                                     break;
    case Zmodem::eventSndError     : 
    case Zmodem::eventRcvError     : fileinfo();
                                     break;
    case Zmodem::eventSndDone      : status->setText("File send.");
                                     break;
    case Zmodem::eventRcvDone      : status->setText("File received.");
                                     break;
    case Zmodem::eventDoneProtocol : status->setText("Transmission completed.");
                                     progress->setValue(0);
                                     break;
  }
}

void StatusLine::setConnect(bool c)
{
  connected->setBackgroundColor(c?red.dark(130):green.dark());
  status->setText(c?"Connected":"Local");
  
  // eventuell set timer (or get this from setConnect)
}
