/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [te_screen.h]                 Screen Data Type                             */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef TESCREEN_H
#define TESCREEN_H

#include "TECommon.h"

#define MODE_Origin    0
#define MODE_Wrap      1
#define MODE_Insert    2

struct ScreenParm
{
  int mode[3];
};

class TEScreen
{
public:
    TEScreen(int lines, int columns);
    ~TEScreen();

public: // these are all `Screen' operations
    //
    // VT100/2 Operations ------------------
    //
    // Cursor Movement
    //
    void cursorUp    (int n);
    void cursorDown  (int n);
    void cursorLeft  (int n);
    void cursorRight (int n);
    void setCursorYX (int y, int x);
    void setMargins  (int t, int b);
    //
    // Cursor Movement with Scrolling
    //
    void NewLine     ();
    void NextLine    ();
    void index       ();
    void reverseIndex();
    //
    void Return      ();
    void BackSpace   ();
    void Tabulate    ();
    //
    // Editing
    //
    void deleteChars (int n);
    void insertChars (int n);
    void deleteLines (int n);
    void insertLines (int n);
    //
    // -------------------------------------
    //
    void resetMode   (int n);
    void setMode     (int n);
    void saveMode    (int n);
    void restoreMode (int n);
    //
    void saveCursor  ();
    void restoreCursor();
    //
    // -------------------------------------
    //
    void clearEntireScreen();
    void clearToEndOfScreen();
    void clearToBeginOfScreen();
    //
    void clearEntireLine();
    void clearToEndOfLine();
    void clearToBeginOfLine();
    //
    void helpAlign   ();
    //
    // -------------------------------------
    //
    void setInvert   ();
    void setBold     ();
    void setForeColor(int fgcolor);
    void setBackColor(int bgcolor);
    //
    void setDefaultRendition();
    void setForeColorToDefault();
    void setBackColorToDefault();
    //
    // -------------------------------------
    //
    BOOL getMode     (int n);
    //
    // only for report cursor position
    //
    int  getCursorX();
    int  getCursorY();
    //
    // -------------------------------------
    //
    void ColorTest();
    //
    void clear();
    void home();
    void reset();
    //
    void ShowCharacter(unsigned char c);
    //
    void setCharset(int n, int cs); //FIXME: evtl. move to emulation
    void useCharset(int n);         //FIXME: evtl. move to emulation
    //
    void swapCursor();
    //
    void resizeImage(int new_lines, int new_columns);
    //
    ca* const getImage() const;
    int getLines() const { return lines; }
    int getColumns() const { return columns; }

private: // helper

    void clearImage(int loca, int loce, char c);
    void moveImage(int dst, int loca, int loce);
    
    void scrollUp(int from, int i);
    void scrollDown(int from, int i);

private:

    char charset[4]; //FIXME: evtl. move to emulation

    // rendition info
    bool  graphic;    //FIXME: evtl. move to emulation
    UINT8 cu_fg;
    UINT8 cu_bg;
    BOOL  cu_bold;

    // cursor location
    int cuX;
    int cuY;

    // save cursor & rendition  --------------------

    // rendition info
    bool  sa_graphic;    //FIXME: evtl. move to emulation
    BOOL  sa_cu_bold;
    UINT8 sa_cu_fg;
    UINT8 sa_cu_bg;

    // cursor location
    int sa_cuX;
    int sa_cuY;

    // margins ----------------

    int bmargin;
    int tmargin;

    // states ----------------
    // FIXME: this is a first try
    ScreenParm currParm;
    ScreenParm saveParm;

    // screen image ----------------
    int lines;
    int columns;
    ca *image; // [lines][columns]
};

#endif // TESCREEN_H
