/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [iemsi.h]              FSC-0056.001 IEMSI Client                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#ifndef IEMSI_H
#define IEMSI_H

#include <qobject.h>
#include <qglobal.h>
#include <stdio.h>
#include <time.h>
#include "modem.h"

class IemsiClientInfo
{
public:
  QString user;         /* User's Name        */
  QString password;     /* Password           */
  QString location;     /* Location           */
  QString voice_pno;    /* Voice Phone Number */
  QString data_pno;     /* Data Phone Number  */
  QString alias;        /* aka handle         */
  UINT32  birthdate;    /* 0                  */
  QString crtdef;       /* ANSI,24,80,0       */
  QString protocols;    /* ZMO                */
  QString capabilities; /* ASCII8             */
  QString requests;     /* HUSH               */
  QString software;     /* Kom, Vers. 0.1e-97 */
  QString xlattbl;      /* ""                 */
};

class IemsiServerInfo
{
public:
  QString system;
  QString box;
  QString location;
  QString sysop;
  time_t  localtime;
  QString notice;
  QString wait;
  QString capabilities;
};

class Iemsi : public QObject
{
Q_OBJECT

  public:
    Iemsi( Modem* mo, IemsiClientInfo* ici);
    ~Iemsi();

    void start(char* initial);

  signals:
    void doneProtocol();
    void rcv_isi(IemsiServerInfo* isi);

  public slots:
    void stopProtocol();

  private slots:
    void rcv_byte(int cc);

  private:
    char ici_bdy[1024]; /*FIXME: size*/ 

    Modem *mo;
    void Iemsi::send(int typ, char* dta);
    void Iemsi::protocol(int msg_typ, int ok, char* msg, int len);

/* message buffer */
/* 01234567890123 */
/* **EMSI_ICIxxxx */

#define EMSI_HDR_LEN 14      
#define EMSI_DTA_LEN 2048
#define EMSI_MSG_LEN (EMSI_HDR_LEN + 4 + EMSI_DTA_LEN + 8 + 1)

char emsi_msg[EMSI_MSG_LEN];
int  emsi_msg_len;

int  emsi_scn_pos;

/* state variables */

#define EMSI_SCAN 0
#define EMSI_READ 1
int emsi_scn_state;

};

#endif
