/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [autologin.cpp]            Autologin Facility                              */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */

#include "autologin.h"
#include "config.h"
#include <stdlib.h>

#include "autologin.moc"

static const char* dial_string[] =
{
/*  0 */ "",                 // use custom login
/*  1 */ "",                 // no autologin
/*  2 */ "!I",               // no autologin not iemsi //FIXME: implement
/*  3 */ "!W!E",             // Esc,IEMSI
/*  4 */ "!W!E!W!N!W!P",     // Esc,Name,Password
/*  5 */ "!W!E!W!N!!WY!W!P", // Esc,Name,Y,Password
/*  6 */ "!W!N!W!P",         // Name,Password
/*  7 */ "!W!N!!WY!W!P",     // Name,Y,Password
};

Autologin::Autologin(Modem* mo) : QObject()
{ int i = atoi(config_get(CONF_LOGIN_PROTOCOL));
  this->mo = mo;
  s = (char*)(i?dial_string[i]:config_get(CONF_CUSTOM_LOGIN));
  tick();
}

Autologin::~Autologin()
{
}

void Autologin::tick()
{ 
  for(;*s;s++)
  {
    if (*s == '!' && s[1])
    {
      s += 1;
      switch(s[0])
      {
        case 'Y' : if(config_get(CONF_LOCAL_YES)[0])
                   {
                     mo->send_byte(config_get(CONF_LOCAL_YES)[0]);
                     mo->send_byte('\r');
                   }
        case 'N' : mo->send_string(config_get(CONF_ID_USERNAME));
                   mo->send_byte('\r');
                   break;
        case 'P' : mo->send_string(config_get(CONF_ID_PASSWORD));
                   mo->send_byte('\r');
                   break;
        case 'E' : mo->send_byte(27); 
                   mo->send_byte(27);
                   break;
	    case 'W' : QTimer::singleShot(500, this, SLOT(tick()));
                   s += 1;
                   return;
        case 'I' : //FIXME: no IEMSI, not implemented yet.
                   break;
        default  : //FIXME: add hex codes.
                   break;
    }
  }
  else
    mo->send_byte(s[0]);
  }
  delete this;
}
