# the plugin code was generated by this script
# you should not change the plugin code directly, but this script
# note: this script only creates objects in your workspace,
# *EXCEPT* for the last call, see below.

require(rkwarddev)
rkwarddev.required("0.08-1")

local({
# set the output directory to overwrite the actual plugin
output.dir <- tempdir()
overwrite <- TRUE
# if you set guess.getters to TRUE, the resulting code will need RKWard >= 0.6.0
guess.getter <- TRUE
rk.set.indent(by="  ")
rk.set.empty.e(TRUE)
update.translations <- TRUE

about.info <- rk.XML.about(
  name="rk.CohenKappa",
  author=c(
    person(given="Meik", family="Michalke",
      email="meik.michalke@hhu.de", role=c("aut","cre"))),
  about=list(desc="RKWard GUI to calculate Cohen's Kappa",
    version="0.01-9", url="https://rkward.kde.org", long.desc="RKWard GUI to calculate Cohen's Kappa, i.e., the agreement of two raters (using the psych package)")
  )
dependencies.info <- rk.XML.dependencies(
  dependencies=list(rkward.min=ifelse(isTRUE(guess.getter), "0.6.0", "0.5.6")),
  package=list(c(name="psych"))
)

############
## cohen's kappa
############
varSelect <- rk.XML.varselector(label="Select data", id.name="varSelect")
data <- rk.XML.varslot(label="Data (matrix or data.frame, 2*n or p*p)", source=varSelect, classes=c("data.frame", "matrix"), required=TRUE, id.name="data")
dataWeight <- rk.XML.varslot(label="Weight matrix (p*p)", source=varSelect, classes="matrix", id.name="dataWeight")

nobs <- rk.XML.spinbox(label="Number of observations (if data is a square matrix)", min=0, real=FALSE, id.name="nobs")
alpha <- rk.XML.spinbox(label="Alpha value for confidence interval", min=0, max=1, initial=0.05, id.name="alpha")

saveResults <- rk.XML.saveobj("Save results to workspace", initial="kappa.result", id.name="saveResults")

kappa.full.dialog <- rk.XML.dialog(
  rk.XML.row(
    varSelect,
    rk.XML.col(
      data,
      dataWeight,
      rk.XML.stretch(),
      rk.XML.frame(nobs,
      alpha),
      saveResults
    )
  ),
  label="Cohen's Kappa"
)

## JavaScript
kappa.js.calc <- rk.paste.JS(
  echo("  kappa.result <- cohen.kappa("),
  js(
    if(data){
      echo("\n    x=", data)
    } else {},
    if(dataWeight){
      echo(",\n    w=", dataWeight)
    } else {},
    if(nobs > 0){
      echo(",\n    n.obs=", nobs)
    } else {},
    if(alpha != 0.05){
      echo(",\n    alpha=", alpha)
    } else {}
  ),
  echo("\n  )\n\n")
)

kappa.js.print <- rk.paste.JS(
  rk.JS.header("Correlation coefficients and confidence boundaries",
    level=3,
    .add=list(
      add=c("Alpha level", alpha),
      add=c("Number of subjects", noquote="kappa.result[[\\\"n.obs\\\"]]")
    )
  ),
  echo("rk.print(kappa.result[[\"confid\"]])\n")
)


#############
## if you run the following function call, files will be written to tempdir!
#############
# this is where it get's serious, that is, here all of the above is put together into one plugin

rk.plugin.skeleton(
  about.info,
  path=output.dir,
  guess.getter=guess.getter,
  xml=list(
    dialog=kappa.full.dialog),
  js=list(results.header="Cohen's Kappa and weighted Kappa",
    require="psych",
     calculate=kappa.js.calc,
     printout=kappa.js.print),
  pluginmap=list(name="Cohen's Kappa", hierarchy=list("analysis")),
  dependencies=dependencies.info,
  create=c("pmap", "xml", "js", "desc"),
  overwrite=overwrite,
  tests=FALSE,
#  edit=TRUE,
  load=TRUE,
#  show=TRUE,
  hints=FALSE)

  if(isTRUE(update.translations)){
    rk.updatePluginMessages(file.path(output.dir,"rk.CohenKappa","inst","rkward","rk.CohenKappa.pluginmap"))
  } else {}
})
