/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.reflect.InstanceOf;
import gnu.mapping.Procedure;

public class MappedArrayType
extends ObjectType
implements TypeValue {
    Type elementType;
    protected ObjectType implementationType;
    static ClassType utilType = ClassType.make("gnu.kawa.functions.MakeSplice");
    static Method countMethod = utilType.getDeclaredMethod("count", 1);

    public MappedArrayType(Type elementType) {
        this.elementType = elementType;
        this.implementationType = ArrayType.make(elementType.getImplementationType());
        this.setSignature(this.implementationType.getSignature());
    }

    public static Type maybe(Type type, int nesting) {
        while (--nesting >= 0) {
            type = new MappedArrayType(type);
        }
        return type;
    }

    public Type getComponentType() {
        return this.elementType;
    }

    @Override
    public Type getImplementationType() {
        return this.implementationType;
    }

    @Override
    public Type getRealType() {
        return this.implementationType;
    }

    @Override
    public void emitTestIf(Variable incoming, Declaration decl, Compilation comp) {
        this.emitTestCoerce(true, incoming, decl, comp, comp.getCode());
    }

    void emitTestCoerce(boolean testing2, Variable incoming, Declaration decl, Compilation comp, CodeAttr code) {
        Scope scope = code.pushScope();
        Label failureLabel = testing2 ? code.emitIfRaw() : null;
        Variable sizeVar = scope.addVariable(code, Type.intType, null);
        if (incoming == null) {
            incoming = scope.addVariable(code, Type.objectType, null);
            code.emitStore(incoming);
        }
        code.emitLoad(incoming);
        code.emitInvoke(countMethod);
        code.emitStore(sizeVar);
        Variable incomingElementVar = scope.addVariable(code, Type.objectType, null);
        Variable elementVar = scope.addVariable(code, this.elementType, null);
        Declaration elementDecl = testing2 ? new Declaration(elementVar) : null;
        Variable indexVar = scope.addVariable(code, Type.intType, null);
        code.emitPushInt(0);
        code.emitStore(indexVar);
        Variable arrayVar = scope.addVariable(code, ArrayType.make(this.elementType), null);
        code.emitLoad(sizeVar);
        code.emitNewArray(this.elementType.getRawType());
        code.emitStore(arrayVar);
        ClassType iteratorClass = ClassType.make("java.util.Iterator");
        Method getIteratorMethod = ClassType.make("gnu.lists.Sequences").getDeclaredMethod("getIterator", 1);
        code.emitLoad(incoming);
        code.emitInvoke(getIteratorMethod);
        Variable iteratorVar = scope.addVariable(code, iteratorClass, null);
        code.emitStore(iteratorVar);
        Label topLabel = new Label(code);
        topLabel.define(code);
        code.emitLoad(iteratorVar);
        code.emitInvoke(iteratorClass.getDeclaredMethod("hasNext", 0));
        code.emitIfIntNotZero();
        code.emitLoad(iteratorVar);
        code.emitInvoke(iteratorClass.getDeclaredMethod("next", 0));
        code.emitStore(incomingElementVar);
        if (testing2 && this.elementType instanceof TypeValue) {
            ((TypeValue)((Object)this.elementType)).emitTestIf(incomingElementVar, elementDecl, comp);
        } else {
            if (testing2) {
                code.emitLoad(incomingElementVar);
                this.elementType.emitIsInstance(code);
                code.emitIfIntNotZero();
            }
            code.emitLoad(incomingElementVar);
            this.elementType.emitCoerceFromObject(code);
            code.emitStore(elementVar);
        }
        code.emitLoad(arrayVar);
        code.emitLoad(indexVar);
        code.emitLoad(elementVar);
        code.emitArrayStore();
        code.emitInc(indexVar, (short)1);
        code.emitGoto(topLabel);
        if (testing2) {
            code.emitElse();
            code.emitGoto(failureLabel);
            code.emitFi();
        }
        code.emitFi();
        code.emitLoad(arrayVar);
        if (testing2) {
            decl.compileStore(comp);
        }
        code.popScope();
    }

    @Override
    public String toString() {
        return "scan-array[" + this.elementType + "]";
    }

    @Override
    public String getName() {
        return "scan-array-" + this.elementType.getName();
    }

    @Override
    public int isCompatibleWithValue(Type valueType) {
        int r = LangObjType.sequenceType.isCompatibleWithValue(valueType);
        return r == 2 ? 1 : r;
    }

    @Override
    public Expression convertValue(Expression value) {
        return null;
    }

    @Override
    public Procedure getConstructor() {
        return null;
    }

    @Override
    public void emitIsInstance(Variable incoming, Compilation comp, Target target) {
        InstanceOf.emitIsInstance(this, incoming, comp, target);
    }

    @Override
    public String encodeType(Language language) {
        String etype = language.encodeType(this.elementType);
        if (etype == null) {
            etype = this.elementType.getName();
        }
        return "$scan-array$[" + etype + "]";
    }

    @Override
    public void emitCoerceFromObject(CodeAttr code) {
        this.emitTestCoerce(false, null, null, null, code);
    }
}

