/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.SubSequence;
import java.io.IOException;
import java.util.List;

public class SubCharSeq
extends SubSequence
implements CharSeq {
    public SubCharSeq(AbstractSequence base2, int startPos, int endPos) {
        super(base2, startPos, endPos);
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int start = this.base.nextIndex(this.ipos0);
        return ((CharSeq)((Object)this.base)).charAt(start + index);
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[dstBegin++] = this.charAt(i);
        }
    }

    @Override
    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int start = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).setCharAt(start + index, ch);
    }

    @Override
    public void setCharacterAt(int index, int ch) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int start = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).setCharacterAt(start + index, ch);
    }

    @Override
    public void fill(char value) {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).fill(index0, index1, value);
    }

    @Override
    public void fill(int fromIndex, int toIndex, char value) {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        if (fromIndex < 0 || toIndex < fromIndex || index0 + toIndex > index1) {
            throw new IndexOutOfBoundsException();
        }
        ((CharSeq)((Object)this.base)).fill(index0 + fromIndex, index0 + toIndex, value);
    }

    @Override
    public void writeTo(int start, int count, Appendable dest) throws IOException {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        if (start < 0 || count < 0 || index0 + start + count > index1) {
            throw new IndexOutOfBoundsException();
        }
        ((CharSeq)((Object)this.base)).writeTo(index0 + start, count, dest);
    }

    @Override
    public void writeTo(Appendable dest) throws IOException {
        int index0 = this.base.nextIndex(this.ipos0);
        ((CharSeq)((Object)this.base)).writeTo(index0, this.size(), dest);
    }

    @Override
    public void consume(int start, int count, Consumer out) {
        int index0 = this.base.nextIndex(this.ipos0);
        int index1 = this.base.nextIndex(this.ipos0);
        if (start < 0 || count < 0 || index0 + start + count > index1) {
            throw new IndexOutOfBoundsException();
        }
        ((CharSeq)((Object)this.base)).consume(index0 + start, count, out);
    }

    @Override
    public String toString() {
        int sz = this.size();
        StringBuffer sbuf = new StringBuffer(sz);
        for (int i = 0; i < sz; ++i) {
            sbuf.append(this.charAt(i));
        }
        return sbuf.toString();
    }

    private SubCharSeq subCharSeq(int start, int end) {
        int sz = this.size();
        if (start < 0 || end < start || end > sz) {
            throw new IndexOutOfBoundsException();
        }
        return new SubCharSeq(this.base, this.base.createRelativePos(this.ipos0, start, false), this.base.createRelativePos(this.ipos0, end, true));
    }

    @Override
    public List subList(int fromIx, int toIx) {
        return this.subCharSeq(fromIx, toIx);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subCharSeq(start, end);
    }
}

