/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.bytecode.ClassType;
import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.lists.FString;
import gnu.lists.FVector;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0or1;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.text.WriterManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import kawa.Shell;
import kawa.Telnet;
import kawa.TelnetOutputStream;
import kawa.TelnetRepl;
import kawa.Version;

public class repl
extends Procedure0or1 {
    public static String compilationTopname = null;
    Language language;
    static Language previousLanguage;
    private static int exitCounter;
    public static String[] commandLineArgArray;
    public static FVector commandLineArguments;
    public static String homeDirectory;
    static boolean shutdownRegistered;
    static String[][] propertyFields;
    public static boolean noConsole;

    public repl(Language language) {
        this.language = language;
    }

    public Object apply0() {
        Shell.run(this.language, Environment.getCurrent());
        return Values.empty;
    }

    public Object apply1(Object object2) {
        Shell.run(this.language, (Environment)object2);
        return Values.empty;
    }

    static void bad_option(String string) {
        System.err.println("kawa: bad option '" + string + "'");
        repl.printOptions(System.err);
        System.exit(-1);
    }

    public static void printOption(PrintStream printStream, String string, String string2) {
        printStream.print(" ");
        printStream.print(string);
        int n = string.length() + 1;
        for (int i = 0; i < 30 - n; ++i) {
            printStream.print(" ");
        }
        printStream.print(" ");
        printStream.println(string2);
    }

    public static void printOptions(PrintStream printStream) {
        printStream.println("Usage: [java kawa.repl | kawa] [options ...]");
        printStream.println();
        printStream.println(" Generic options:");
        repl.printOption(printStream, "--help", "Show help about options");
        repl.printOption(printStream, "--author", "Show author information");
        repl.printOption(printStream, "--version", "Show version information");
        printStream.println();
        printStream.println(" Options");
        repl.printOption(printStream, "-e <expr>", "Evaluate expression <expr>");
        repl.printOption(printStream, "-c <expr>", "Same as -e, but make sure ~/.kawarc.scm is run first");
        repl.printOption(printStream, "-f <filename>", "File to interpret");
        repl.printOption(printStream, "-s| --", "Start reading commands interactively from console");
        repl.printOption(printStream, "-w", "Launch the interpreter in a GUI window");
        repl.printOption(printStream, "--server <port>", "Start a server accepting telnet connections on <port>");
        repl.printOption(printStream, "--debug-dump-zip", "Compiled interactive expressions to a zip archive");
        repl.printOption(printStream, "--debug-print-expr", "Print generated internal expressions");
        repl.printOption(printStream, "--debug-print-final-expr", "Print expression after any optimizations");
        repl.printOption(printStream, "--debug-error-prints-stack-trace", "Print stack trace with errors");
        repl.printOption(printStream, "--debug-warning-prints-stack-trace", "Print stack trace with warnings");
        repl.printOption(printStream, "--[no-]full-tailcalls", "(Don't) use full tail-calls");
        repl.printOption(printStream, "-C <filename> ...", "Compile named files to Java class files");
        repl.printOption(printStream, "--output-format <format>", "Use <format> when printing top-level output");
        repl.printOption(printStream, "--<language>", "Select source language, one of:");
        String[][] stringArray = Language.getLanguages();
        for (int i = 0; i < stringArray.length; ++i) {
            printStream.print("   ");
            String[] stringArray2 = stringArray[i];
            int n = stringArray2.length - 1;
            for (int j = 0; j < n; ++j) {
                printStream.print(stringArray2[j] + " ");
            }
            if (i == 0) {
                printStream.print("[default]");
            }
            printStream.println();
        }
        printStream.println(" Compilation options, must be specified before -C");
        repl.printOption(printStream, "-d <dirname>", "Directory to place .class files in");
        repl.printOption(printStream, "-P <prefix>", "Prefix to prepand to class names");
        repl.printOption(printStream, "-T <topname>", "name to give to top-level class");
        repl.printOption(printStream, "--main", "Generate an application, with a main method");
        repl.printOption(printStream, "--applet", "Generate an applet");
        repl.printOption(printStream, "--servlet", "Generate a servlet");
        repl.printOption(printStream, "--module-static", "Top-leval definitions are by default static");
        Vector vector = Compilation.options.keys();
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            repl.printOption(printStream, "--" + string, Compilation.options.getDoc(string));
        }
        printStream.println();
        printStream.println("For more information go to:  http://www.gnu.org/software/kawa/");
    }

    public static synchronized void exitIncrement() {
        if (exitCounter == 0) {
            ++exitCounter;
        }
        ++exitCounter;
    }

    public static synchronized void exitDecrement() {
        int n = exitCounter;
        if (n > 0) {
            if (--n == 0) {
                System.exit(0);
            } else {
                exitCounter = n;
            }
        }
    }

    static void checkInitFile() {
        if (homeDirectory == null) {
            Comparable<Boolean> comparable;
            File file = null;
            homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null) {
                comparable = new FString(homeDirectory);
                String string = System.getProperty("file.separator");
                String string2 = "/".equals(string) ? ".kawarc.scm" : "kawarc.scm";
                file = new File(homeDirectory, string2);
            } else {
                comparable = Boolean.FALSE;
            }
            Environment.getCurrent().put("home-directory", (Object)comparable);
            if (file != null && file.exists() && !Shell.runFile(file.getPath(), 0)) {
                System.exit(-1);
            }
        }
    }

    public static void setArgs(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        Object[] objectArray = new Object[n2];
        if (n == 0) {
            commandLineArgArray = stringArray;
        } else {
            String[] stringArray2 = new String[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                stringArray2[n3] = stringArray[n3 + n];
            }
            commandLineArgArray = stringArray2;
        }
        int n4 = n2;
        while (--n4 >= 0) {
            objectArray[n4] = new FString(stringArray[n4 + n]);
        }
        commandLineArguments = new FVector(objectArray);
        Environment.getCurrent().put("command-line-arguments", (Object)commandLineArguments);
    }

    public static void getLanguageFromFilenameExtension(String string) {
        if (previousLanguage == null && (previousLanguage = Language.getInstanceFromFilenameExtension(string)) != null) {
            Language.setDefaults(previousLanguage);
            return;
        }
        repl.getLanguage();
    }

    public static void getLanguage() {
        if (previousLanguage == null) {
            previousLanguage = Language.getInstance(null);
            Language.setDefaults(previousLanguage);
        }
    }

    public static int processArgs(String[] stringArray, int n, int n2) {
        boolean bl = false;
        while (n < n2) {
            Object object2;
            String string = stringArray[n];
            if (string.equals("-c") || string.equals("-e")) {
                if (++n == n2) {
                    repl.bad_option(string);
                }
                repl.getLanguage();
                repl.setArgs(stringArray, n + 1);
                if (string.equals("-c")) {
                    repl.checkInitFile();
                }
                Language language = Language.getDefaultLanguage();
                object2 = new SourceMessages();
                Throwable throwable = Shell.run(language, Environment.getCurrent(), (InPort)new CharArrayInPort(stringArray[n]), OutPort.outDefault(), null, (SourceMessages)object2);
                if (throwable != null) {
                    Shell.printError(throwable, (SourceMessages)object2, OutPort.errDefault());
                    System.exit(-1);
                }
                bl = true;
            } else if (string.equals("-f")) {
                if (++n == n2) {
                    repl.bad_option(string);
                }
                String string2 = stringArray[n];
                repl.getLanguageFromFilenameExtension(string2);
                repl.setArgs(stringArray, n + 1);
                repl.checkInitFile();
                if (!Shell.runFile(string2, 0)) {
                    System.exit(-1);
                }
                bl = true;
            } else {
                Object object3;
                Object object4;
                Object object5;
                if (string.startsWith("--script")) {
                    String string3 = string.substring(8);
                    ++n;
                    int n3 = 0;
                    if (string3.length() > 0) {
                        try {
                            n3 = Integer.parseInt(string3);
                        }
                        catch (Throwable throwable) {
                            n = n2;
                        }
                    }
                    if (n == n2) {
                        repl.bad_option(string);
                    }
                    String string4 = stringArray[n];
                    repl.getLanguageFromFilenameExtension(string4);
                    repl.setArgs(stringArray, n + 1);
                    repl.checkInitFile();
                    if (!Shell.runFile(string4, n3)) {
                        System.exit(-1);
                    }
                    return -1;
                }
                if (string.equals("\\")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    String string5 = stringArray[n];
                    SourceMessages sourceMessages = new SourceMessages();
                    try {
                        object5 = new BufferedInputStream(new FileInputStream(string5));
                        int n4 = ((InputStream)object5).read();
                        if (n4 == 35) {
                            int n5;
                            object4 = new StringBuffer(100);
                            object3 = new Vector(10);
                            int n6 = 0;
                            while (n4 != 10 && n4 != 13 && n4 >= 0) {
                                n4 = ((InputStream)object5).read();
                            }
                            while (true) {
                                if ((n4 = ((InputStream)object5).read()) < 0) {
                                    System.err.println("unexpected end-of-file processing argument line for: '" + string5 + '\'');
                                    System.exit(-1);
                                }
                                if (n6 == 0) {
                                    if (n4 == 92 || n4 == 39 || n4 == 34) {
                                        n6 = n4;
                                        continue;
                                    }
                                    if (n4 == 10 || n4 == 13) break;
                                    if (n4 == 32 || n4 == 9) {
                                        if (((StringBuffer)object4).length() <= 0) continue;
                                        ((Vector)object3).addElement(((StringBuffer)object4).toString());
                                        ((StringBuffer)object4).setLength(0);
                                        continue;
                                    }
                                } else if (n6 == 92) {
                                    n6 = 0;
                                } else if (n4 == n6) {
                                    n6 = 0;
                                    continue;
                                }
                                ((StringBuffer)object4).append((char)n4);
                            }
                            if (((StringBuffer)object4).length() > 0) {
                                ((Vector)object3).addElement(((StringBuffer)object4).toString());
                            }
                            if ((n5 = ((Vector)object3).size()) > 0) {
                                Object[] objectArray = new String[n5];
                                ((Vector)object3).copyInto(objectArray);
                                int n7 = repl.processArgs((String[])objectArray, 0, n5);
                                if (n7 >= 0 && n7 < n5) {
                                    System.err.println("" + (n5 - n7) + " unused meta args");
                                }
                            }
                        }
                        repl.getLanguageFromFilenameExtension(string5);
                        object2 = InPort.openFile((InputStream)object5, string5);
                        repl.setArgs(stringArray, n + 1);
                        repl.checkInitFile();
                        object4 = OutPort.errDefault();
                        object3 = Shell.run(Language.getDefaultLanguage(), Environment.getCurrent(), (InPort)object2, OutPort.outDefault(), null, sourceMessages);
                        sourceMessages.printAll((PrintWriter)object4, 20);
                        if (object3 != null) {
                            SyntaxException syntaxException;
                            if (object3 instanceof SyntaxException && (syntaxException = (SyntaxException)object3).getMessages() == sourceMessages) {
                                System.exit(1);
                            }
                            throw object3;
                        }
                    }
                    catch (Throwable throwable) {
                        Shell.printError(throwable, sourceMessages, OutPort.errDefault());
                        System.exit(1);
                    }
                    return -1;
                }
                if (string.equals("-s") || string.equals("--")) {
                    repl.getLanguage();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    Shell.run(Language.getDefaultLanguage(), Environment.getCurrent());
                    return -1;
                }
                if (string.equals("-w")) {
                    repl.getLanguage();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    repl.startGuiConsole();
                    bl = true;
                } else if (string.equals("-d")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    ModuleManager moduleManager = ModuleManager.getInstance();
                    moduleManager.setCompilationDirectory(stringArray[n]);
                } else if (string.equals("--target") || string.equals("target")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    if ((string = stringArray[n]).equals("7")) {
                        Compilation.defaultClassFileVersion = 0x330000;
                    }
                    if (string.equals("6") || string.equals("1.6")) {
                        Compilation.defaultClassFileVersion = 0x320000;
                    } else if (string.equals("5") || string.equals("1.5")) {
                        Compilation.defaultClassFileVersion = 0x310000;
                    } else if (string.equals("1.4")) {
                        Compilation.defaultClassFileVersion = 0x300000;
                    } else if (string.equals("1.3")) {
                        Compilation.defaultClassFileVersion = 0x2F0000;
                    } else if (string.equals("1.2")) {
                        Compilation.defaultClassFileVersion = 0x2E0000;
                    } else if (string.equals("1.1")) {
                        Compilation.defaultClassFileVersion = 2949123;
                    } else {
                        repl.bad_option(string);
                    }
                } else if (string.equals("-P")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    Compilation.classPrefixDefault = stringArray[n];
                } else if (string.equals("-T")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationTopname = stringArray[n];
                } else {
                    if (string.equals("-C")) {
                        if (++n == n2) {
                            repl.bad_option(string);
                        }
                        repl.compileFiles(stringArray, n, n2);
                        return -1;
                    }
                    if (string.equals("--output-format") || string.equals("--format")) {
                        if (++n == n2) {
                            repl.bad_option(string);
                        }
                        Shell.setDefaultFormat(stringArray[n]);
                    } else {
                        if (string.equals("--connect")) {
                            int n8;
                            if (++n == n2) {
                                repl.bad_option(string);
                            }
                            if (stringArray[n].equals("-")) {
                                n8 = 0;
                            } else {
                                try {
                                    n8 = Integer.parseInt(stringArray[n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    repl.bad_option("--connect port#");
                                    n8 = -1;
                                }
                            }
                            try {
                                object2 = new Socket(InetAddress.getByName(null), n8);
                                Telnet telnet = new Telnet((Socket)object2, true);
                                object5 = telnet.getInputStream();
                                TelnetOutputStream telnetOutputStream = telnet.getOutputStream();
                                object4 = new PrintStream(telnetOutputStream, true);
                                System.setIn((InputStream)object5);
                                System.setOut((PrintStream)object4);
                                System.setErr((PrintStream)object4);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace(System.err);
                                throw new Error(iOException.toString());
                            }
                        }
                        if (string.equals("--server")) {
                            int n9;
                            repl.getLanguage();
                            if (++n == n2) {
                                repl.bad_option(string);
                            }
                            if (stringArray[n].equals("-")) {
                                n9 = 0;
                            } else {
                                try {
                                    n9 = Integer.parseInt(stringArray[n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    repl.bad_option("--server port#");
                                    n9 = -1;
                                }
                            }
                            try {
                                object2 = new ServerSocket(n9);
                                n9 = ((ServerSocket)object2).getLocalPort();
                                System.err.println("Listening on port " + n9);
                                while (true) {
                                    System.err.print("waiting ... ");
                                    System.err.flush();
                                    Socket socket = ((ServerSocket)object2).accept();
                                    System.err.println("got connection from " + socket.getInetAddress() + " port:" + socket.getPort());
                                    TelnetRepl.serve(Language.getDefaultLanguage(), socket);
                                }
                            }
                            catch (IOException iOException) {
                                throw new Error(iOException.toString());
                            }
                        }
                        if (string.equals("--main")) {
                            Compilation.generateMainDefault = true;
                        } else if (string.equals("--applet")) {
                            Compilation.generateAppletDefault = true;
                        } else if (string.equals("--servlet")) {
                            Compilation.generateServletDefault = true;
                        } else if (string.equals("--debug-dump-zip")) {
                            ModuleExp.dumpZipPrefix = "kawa-zip-dump-";
                        } else if (string.equals("--debug-print-expr")) {
                            Compilation.debugPrintExpr = true;
                        } else if (string.equals("--debug-print-final-expr")) {
                            Compilation.debugPrintFinalExpr = true;
                        } else if (string.equals("--debug-error-prints-stack-trace")) {
                            SourceMessages.debugStackTraceOnError = true;
                        } else if (string.equals("--debug-warning-prints-stack-trace")) {
                            SourceMessages.debugStackTraceOnWarning = true;
                        } else if (string.equals("--module-static")) {
                            Compilation.moduleStatic = 1;
                        } else if (string.equals("--module-static-run")) {
                            Compilation.moduleStatic = 2;
                        } else if (string.equals("--fewer-classes")) {
                            Compilation.fewerClasses = true;
                        } else if (string.equals("--no-inline") || string.equals("--inline=none")) {
                            Compilation.inlineOk = false;
                        } else if (string.equals("--no-console")) {
                            noConsole = true;
                        } else if (string.equals("--inline")) {
                            Compilation.inlineOk = true;
                        } else if (string.equals("--cps")) {
                            Compilation.fewerClasses = true;
                            Compilation.defaultCallConvention = 4;
                        } else if (string.equals("--full-tailcalls")) {
                            Compilation.defaultCallConvention = 3;
                        } else if (string.equals("--no-full-tailcalls")) {
                            Compilation.defaultCallConvention = 1;
                        } else if (string.equals("--pedantic")) {
                            Language.requirePedantic = true;
                        } else if (string.equals("--help")) {
                            repl.printOptions(System.out);
                            System.exit(0);
                        } else if (string.equals("--author")) {
                            System.out.println("Per Bothner <per@bothner.com>");
                            System.exit(0);
                        } else if (string.equals("--version")) {
                            System.out.print("Kawa ");
                            System.out.print(Version.getVersion());
                            System.out.println();
                            System.out.println("Copyright (C) 2009 Per Bothner");
                            bl = true;
                        } else if (string.length() > 0 && string.charAt(0) == '-') {
                            String string6 = string;
                            if (string6.length() > 2 && string6.charAt(0) == '-') {
                                string6 = string6.substring(string6.charAt(1) == '-' ? 2 : 1);
                            }
                            if ((object2 = Language.getInstance(string6)) != null) {
                                if (previousLanguage == null) {
                                    Language.setDefaults((Language)object2);
                                } else {
                                    Language.setDefaultLanguage((Language)object2);
                                }
                                previousLanguage = object2;
                            } else {
                                boolean bl2;
                                int n10 = string6.indexOf("=");
                                if (n10 < 0) {
                                    object5 = null;
                                } else {
                                    object5 = string6.substring(n10 + 1);
                                    string6 = string6.substring(0, n10);
                                }
                                boolean bl3 = bl2 = string6.startsWith("no-") && string6.length() > 3;
                                if (object5 == null && bl2) {
                                    object5 = "no";
                                    string6 = string6.substring(3);
                                }
                                if ((object4 = Compilation.options.set(string6, (String)object5)) != null) {
                                    if (bl2 && object4 == "unknown option name") {
                                        object4 = "both '--no-' prefix and '=" + (String)object5 + "' specified";
                                    }
                                    if (object4 == "unknown option name") {
                                        repl.bad_option(string);
                                    } else {
                                        System.err.println("kawa: bad option '" + string + "': " + (String)object4);
                                        System.exit(-1);
                                    }
                                }
                            }
                        } else {
                            Object object6;
                            int n11 = string.indexOf(61);
                            if (n11 <= 0) break;
                            object2 = string.substring(0, n11);
                            String string7 = string.substring(n11 + 1);
                            int n12 = 0;
                            while ((object6 = propertyFields[n12]) != null) {
                                if (((String)object2).equals(object6[0])) {
                                    object4 = object6[1];
                                    object3 = object6[2];
                                    try {
                                        Class<?> clazz = Class.forName((String)object4);
                                        ThreadLocation threadLocation = (ThreadLocation)clazz.getDeclaredField((String)object3).get(null);
                                        threadLocation.setGlobal(string7);
                                        break;
                                    }
                                    catch (Throwable throwable) {
                                        System.err.println("error setting property " + (String)object2 + " field " + (String)object4 + '.' + (String)object3 + ": " + throwable);
                                        System.exit(-1);
                                    }
                                }
                                ++n12;
                            }
                            object5 = Symbol.parse((String)object2);
                            Language.getDefaultLanguage();
                            object6 = Environment.getCurrent();
                            ((Environment)object6).define((Symbol)object5, null, string7);
                        }
                    }
                }
            }
            ++n;
        }
        return bl ? -1 : n;
    }

    public static void compileFiles(String[] stringArray, int n, int n2) {
        Object object2;
        String string;
        int n3;
        ModuleManager moduleManager = ModuleManager.getInstance();
        Compilation[] compilationArray = new Compilation[n2 - n];
        ModuleInfo[] moduleInfoArray = new ModuleInfo[n2 - n];
        SourceMessages sourceMessages = new SourceMessages();
        for (n3 = n; n3 < n2; ++n3) {
            block10: {
                string = stringArray[n3];
                repl.getLanguageFromFilenameExtension(string);
                object2 = Language.getDefaultLanguage();
                Compilation compilation = null;
                try {
                    InPort inPort;
                    try {
                        inPort = InPort.openFile(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println(fileNotFoundException);
                        System.exit(-1);
                        break;
                    }
                    compilation = ((Language)object2).parse(inPort, sourceMessages, 8);
                    if (compilationTopname != null) {
                        String string2 = Compilation.mangleNameIfNeeded(compilationTopname);
                        ClassType classType = new ClassType(string2);
                        ModuleExp moduleExp = compilation.getModule();
                        moduleExp.setType(classType);
                        moduleExp.setName(compilationTopname);
                        compilation.mainClass = classType;
                    }
                    moduleInfoArray[n3 - n] = moduleManager.find(compilation);
                    compilationArray[n3 - n] = compilation;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof SyntaxException && ((SyntaxException)throwable).getMessages() == sourceMessages) break block10;
                    repl.internalError(throwable, compilation, string);
                }
            }
            if (!sourceMessages.seenErrorsOrWarnings()) continue;
            System.err.println("(compiling " + string + ')');
            if (!sourceMessages.checkErrors(System.err, 20)) continue;
            System.exit(1);
        }
        for (n3 = n; n3 < n2; ++n3) {
            string = stringArray[n3];
            object2 = compilationArray[n3 - n];
            try {
                System.err.println("(compiling " + string + " to " + ((Compilation)object2).mainClass.getName() + ')');
                moduleInfoArray[n3 - n].loadByStages(14);
                boolean bl = sourceMessages.seenErrors();
                sourceMessages.checkErrors(System.err, 50);
                if (bl) {
                    System.exit(-1);
                }
                compilationArray[n3 - n] = object2;
                bl = sourceMessages.seenErrors();
                sourceMessages.checkErrors(System.err, 50);
                if (!bl) continue;
                System.exit(-1);
                continue;
            }
            catch (Throwable throwable) {
                repl.internalError(throwable, (Compilation)object2, string);
            }
        }
    }

    static void internalError(Throwable throwable, Compilation compilation, Object object2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (compilation != null) {
            String string = compilation.getFileName();
            int n = compilation.getLineNumber();
            if (string != null && n > 0) {
                stringBuffer.append(string);
                stringBuffer.append(':');
                stringBuffer.append(n);
                stringBuffer.append(": ");
            }
        }
        stringBuffer.append("internal error while compiling ");
        stringBuffer.append(object2);
        System.err.println(stringBuffer.toString());
        throwable.printStackTrace(System.err);
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            int n = repl.processArgs(stringArray, 0, stringArray.length);
            if (n < 0) {
                return;
            }
            if (n < stringArray.length) {
                String string = stringArray[n];
                repl.getLanguageFromFilenameExtension(string);
                repl.setArgs(stringArray, n + 1);
                repl.checkInitFile();
                boolean bl = Shell.runFile(string, 0);
            } else {
                repl.getLanguage();
                repl.setArgs(stringArray, n);
                repl.checkInitFile();
                if (repl.shouldUseGuiConsole()) {
                    repl.startGuiConsole();
                } else {
                    boolean bl = Shell.run(Language.getDefaultLanguage(), Environment.getCurrent());
                    if (!bl) {
                        System.exit(-1);
                    }
                }
            }
        }
        finally {
            if (!shutdownRegistered) {
                OutPort.runCleanups();
            }
            repl.exitDecrement();
        }
    }

    public static boolean shouldUseGuiConsole() {
        if (noConsole) {
            return true;
        }
        try {
            if (Class.forName("java.lang.System").getMethod("console", new Class[0]).invoke((Object)new Object[0], new Object[0]) == null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void startGuiConsole() {
        try {
            Class.forName("kawa.GuiConsole").newInstance();
        }
        catch (Exception exception) {
            System.err.println("failed to create Kawa window: " + exception);
            System.exit(-1);
        }
    }

    static {
        shutdownRegistered = WriterManager.instance.registerShutdownHook();
        propertyFields = new String[][]{{"out:doctype-system", "gnu.xml.XMLPrinter", "doctypeSystem"}, {"out:doctype-public", "gnu.xml.XMLPrinter", "doctypePublic"}, {"out:base", "gnu.kawa.functions.DisplayFormat", "outBase"}, {"out:radix", "gnu.kawa.functions.DisplayFormat", "outRadix"}, {"out:line-length", "gnu.text.PrettyWriter", "lineLengthLoc"}, {"out:right-margin", "gnu.text.PrettyWriter", "lineLengthLoc"}, {"out:miser-width", "gnu.text.PrettyWriter", "miserWidthLoc"}, {"out:xml-indent", "gnu.xml.XMLPrinter", "indentLoc"}, {"display:toolkit", "gnu.kawa.models.Display", "myDisplay"}, null};
    }
}

