/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.bytecode.ClassType;
import gnu.kawa.functions.Arithmetic;
import gnu.kawa.xml.XDataType;
import gnu.kawa.xml.XInteger;
import gnu.math.IntNum;
import gnu.math.RealNum;
import java.math.BigDecimal;

public class XIntegerType
extends XDataType {
    public final IntNum minValue;
    public final IntNum maxValue;
    static ClassType typeIntNum = ClassType.make("gnu.math.IntNum");
    boolean isUnsignedType;
    public static final XIntegerType integerType = new XIntegerType("integer", decimalType, 5, null, null);
    public static final XIntegerType longType = new XIntegerType("long", (XDataType)integerType, 8, IntNum.make(Long.MIN_VALUE), IntNum.make(Long.MAX_VALUE));
    public static final XIntegerType intType = new XIntegerType("int", (XDataType)longType, 9, IntNum.make(Integer.MIN_VALUE), IntNum.make(Integer.MAX_VALUE));
    public static final XIntegerType shortType = new XIntegerType("short", (XDataType)intType, 10, IntNum.make(Short.MIN_VALUE), IntNum.make(Short.MAX_VALUE));
    public static final XIntegerType byteType = new XIntegerType("byte", (XDataType)shortType, 11, IntNum.make(-128), IntNum.make(127));
    public static final XIntegerType nonPositiveIntegerType = new XIntegerType("nonPositiveInteger", (XDataType)integerType, 6, null, IntNum.zero());
    public static final XIntegerType negativeIntegerType = new XIntegerType("negativeInteger", (XDataType)nonPositiveIntegerType, 7, null, IntNum.minusOne());
    public static final XIntegerType nonNegativeIntegerType = new XIntegerType("nonNegativeInteger", (XDataType)integerType, 12, IntNum.zero(), null);
    public static final XIntegerType unsignedLongType = new XIntegerType("unsignedLong", (XDataType)nonNegativeIntegerType, 13, IntNum.zero(), IntNum.valueOf("18446744073709551615"));
    public static final XIntegerType unsignedIntType = new XIntegerType("unsignedInt", (XDataType)unsignedLongType, 14, IntNum.zero(), IntNum.make(0xFFFFFFFFL));
    public static final XIntegerType unsignedShortType = new XIntegerType("unsignedShort", (XDataType)unsignedIntType, 15, IntNum.zero(), IntNum.make(65535));
    public static final XIntegerType unsignedByteType = new XIntegerType("unsignedByte", (XDataType)unsignedShortType, 16, IntNum.zero(), IntNum.make(255));
    public static final XIntegerType positiveIntegerType = new XIntegerType("positiveInteger", (XDataType)nonNegativeIntegerType, 17, IntNum.one(), null);

    public boolean isUnsignedType() {
        return this.isUnsignedType;
    }

    public XIntegerType(String string, XDataType xDataType, int n, IntNum intNum, IntNum intNum2) {
        this((Object)string, xDataType, n, intNum, intNum2);
        this.isUnsignedType = string.startsWith("unsigned");
    }

    public XIntegerType(Object object2, XDataType xDataType, int n, IntNum intNum, IntNum intNum2) {
        super(object2, typeIntNum, n);
        this.minValue = intNum;
        this.maxValue = intNum2;
        this.baseType = xDataType;
    }

    public boolean isInstance(Object object2) {
        XDataType xDataType;
        if (!(object2 instanceof IntNum)) {
            return false;
        }
        if (this == integerType) {
            return true;
        }
        XIntegerType xIntegerType = xDataType = object2 instanceof XInteger ? ((XInteger)object2).getIntegerType() : integerType;
        while (xDataType != null) {
            if (xDataType == this) {
                return true;
            }
            xDataType = xDataType.baseType;
        }
        return false;
    }

    public Object coerceFromObject(Object object2) {
        return this.valueOf((IntNum)object2);
    }

    public IntNum valueOf(IntNum intNum) {
        if (this != integerType) {
            if (this.minValue != null && IntNum.compare(intNum, this.minValue) < 0 || this.maxValue != null && IntNum.compare(intNum, this.maxValue) > 0) {
                throw new ClassCastException("cannot cast " + intNum + " to " + this.name);
            }
            return new XInteger(intNum, this);
        }
        return intNum;
    }

    public Object cast(Object object2) {
        if (object2 instanceof Boolean) {
            return this.valueOf((Boolean)object2 != false ? IntNum.one() : IntNum.zero());
        }
        if (object2 instanceof IntNum) {
            return this.valueOf((IntNum)object2);
        }
        if (object2 instanceof BigDecimal) {
            return this.valueOf(Arithmetic.asIntNum((BigDecimal)object2));
        }
        if (object2 instanceof RealNum) {
            return this.valueOf(((RealNum)object2).toExactInt(3));
        }
        if (object2 instanceof Number) {
            return this.valueOf(RealNum.toExactInt(((Number)object2).doubleValue(), 3));
        }
        return super.cast(object2);
    }

    public Object valueOf(String string) {
        char c;
        int n = (string = string.trim()).length();
        if (n > 0 && (c = string.charAt(0)) == '+') {
            string = string.substring(1);
        }
        return this.valueOf(IntNum.valueOf(string, 10));
    }

    public IntNum valueOf(String string, int n) {
        return this.valueOf(IntNum.valueOf(string.trim(), n));
    }
}

