/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.lists.Pair;
import gnu.mapping.Symbol;
import kawa.lang.Lambda;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;
import kawa.standard.Scheme;

public class define
extends Syntax {
    public static final define defineRaw = new define(Scheme.lambda);
    Lambda lambda;

    String getName(int options) {
        if ((options & 4) != 0) {
            return "define-private";
        }
        if ((options & 8) != 0) {
            return "define-constant";
        }
        return "define";
    }

    public define(Lambda lambda2) {
        this.lambda = lambda2;
    }

    public void scanForm(Pair st, ScopeExp defs, Translator tr) {
        Pair p1 = (Pair)st.cdr;
        Pair p2 = (Pair)p1.cdr;
        Pair p3 = (Pair)p2.cdr;
        Pair p4 = (Pair)p3.cdr;
        SyntaxForm nameSyntax = null;
        Object name = p1.car;
        while (name instanceof SyntaxForm) {
            nameSyntax = (SyntaxForm)name;
            name = nameSyntax.form;
        }
        int options = ((Number)Translator.stripSyntax(p2.car)).intValue();
        boolean makePrivate = (options & 4) != 0;
        boolean makeConstant = (options & 8) != 0;
        ScopeExp scope = tr.currentScope();
        if (!((name = tr.namespaceResolve(name)) instanceof String) && !(name instanceof Symbol)) {
            tr.error('e', "'" + name + "' is not a valid identifier");
            name = null;
        }
        Object savePos = tr.pushPositionOf(p1);
        Declaration decl = tr.define(name, nameSyntax, defs);
        tr.popPositionOf(savePos);
        name = decl.getSymbol();
        if (makePrivate) {
            decl.setFlag(0x1000000);
            decl.setPrivate(true);
        }
        if (makeConstant) {
            decl.setFlag(16384);
        }
        if ((options & 2) != 0) {
            LambdaExp lexp = new LambdaExp();
            decl.setProcedureDecl(true);
            decl.setType(Compilation.typeProcedure);
            lexp.setSymbol(name);
            lexp.nameDecl = decl;
            Object formals = p4.car;
            Object body = p4.cdr;
            Translator.setLine(lexp, (Object)p1);
            this.lambda.rewriteFormals(lexp, formals, tr, null);
            Object realBody = this.lambda.rewriteAttrs(lexp, body, tr);
            if (realBody != body) {
                p2 = new Pair(p2.car, new Pair(p3.car, new Pair(formals, realBody)));
            }
            decl.noteValue(lexp);
        }
        if (defs instanceof ModuleExp && !makePrivate) {
            decl.setCanRead(true);
            if (!(makeConstant || (options & 2) != 0 && Compilation.inlineOk)) {
                decl.setCanWrite(true);
            }
        }
        if ((options & 1) != 0) {
            decl.setType(tr.exp2Type(p3));
            decl.setFlag(8192);
        }
        st = Translator.makePair(st, this, Translator.makePair(p1, decl, p2));
        Translator.setLine(decl, (Object)p1);
        tr.formStack.addElement(st);
    }

    public Expression rewriteForm(Pair form, Translator tr) {
        Expression value;
        boolean makePrivate;
        Pair p1 = (Pair)form.cdr;
        Pair p2 = (Pair)p1.cdr;
        Pair p3 = (Pair)p2.cdr;
        Pair p4 = (Pair)p3.cdr;
        Object name = Translator.stripSyntax(p1.car);
        int options = ((Number)Translator.stripSyntax(p2.car)).intValue();
        boolean bl = makePrivate = (options & 4) != 0;
        if (!(name instanceof Declaration)) {
            return tr.syntaxError(this.getName(options) + " is only allowed in a <body>");
        }
        Declaration decl = (Declaration)name;
        if ((options & 2) != 0) {
            LambdaExp lexp = (LambdaExp)decl.getValue();
            Object body = p4.cdr;
            this.lambda.rewriteBody(lexp, body, tr);
            value = lexp;
        } else {
            value = tr.rewrite(p4.car);
            decl.noteValue((Expression)(decl.context instanceof ModuleExp && !makePrivate && decl.getCanWrite() ? null : value));
        }
        SetExp sexp = new SetExp(decl, value);
        sexp.setDefining(true);
        if (makePrivate && !(tr.currentScope() instanceof ModuleExp)) {
            tr.error('w', "define-private not at top level " + tr.currentScope());
        }
        return sexp;
    }
}

