/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Interpreter;
import gnu.expr.Keyword;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.SlotSet;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;

public class Invoke
extends ProcedureN
implements CanInline {
    char kind;
    Interpreter interpreter;
    public static final Invoke invoke = new Invoke("invoke", 'V');
    public static final Invoke invokeStatic = new Invoke("invoke-static", 'S');
    public static final Invoke invokeSpecial = new Invoke("invoke-special", 'P');
    public static final Invoke make = new Invoke("make", 'N');
    private PrimProcedure[] cacheMethods;
    private Expression[] cacheArgs;
    private int cacheDefinitelyApplicableMethodCount;
    private int cachePossiblyApplicableMethodCount;

    public Invoke(String string, char c) {
        super(string);
        this.kind = c;
        this.interpreter = Interpreter.getInterpreter();
    }

    public Invoke(String string, char c, Interpreter interpreter) {
        super(string);
        this.kind = c;
        this.interpreter = interpreter;
    }

    public static Object invoke$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invoke, objectArray);
    }

    public static Object invokeStatic$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(invokeStatic, objectArray);
    }

    public static Object make$V(Object[] objectArray) throws Throwable {
        return Invoke.applyN(make, objectArray);
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        return Invoke.applyN(this, objectArray);
    }

    protected static Object applyN(Invoke invoke, Object[] objectArray) throws Throwable {
        Object object2;
        String string;
        ClassType classType;
        char c = invoke.kind;
        if (c == 'P') {
            throw new RuntimeException(invoke.getName() + ": invoke-special not allowed at run time");
        }
        int n = objectArray.length;
        Procedure.checkArgCount(invoke, n);
        Object object3 = objectArray[0];
        if (c == 'V') {
            classType = (ClassType)Type.make(object3.getClass());
        } else {
            if (object3 instanceof Class) {
                object3 = Type.make((Class)object3);
            }
            if (object3 instanceof ClassType) {
                classType = (ClassType)object3;
            } else if (object3 instanceof String || object3 instanceof FString) {
                classType = ClassType.make(object3.toString());
            } else if (object3 instanceof Symbol) {
                classType = ClassType.make(((Symbol)object3).getName());
            } else {
                throw new WrongType(invoke, 0, null);
            }
        }
        Object object4 = null;
        if (c == 'N') {
            string = "<init>";
            if (classType instanceof PairClassType) {
                object2 = (PairClassType)classType;
                classType = ((PairClassType)object2).instanceType;
                object4 = ((PairClassType)object2).getStaticLink();
            }
        } else {
            object2 = objectArray[1];
            if (object2 instanceof String || object2 instanceof FString) {
                string = object2.toString();
            } else if (object2 instanceof Symbol) {
                string = ((Symbol)object2).getName();
            } else {
                throw new WrongType(invoke, 1, null);
            }
            string = Compilation.mangleName(string);
        }
        if ((object2 = ClassMethods.apply(classType, string, null, null, invoke.kind == 's' ? 8 : 0, invoke.kind == 'S' ? 0 : 8)) == null) {
            throw new RuntimeException(invoke.getName() + ": no method named `" + string + "' in class " + classType.getName());
        }
        Object[] objectArray2 = new Object[n - (c == 'S' || c == 's' ? 2 : (object4 != null ? 0 : 1))];
        int n2 = 0;
        if (c == 'V') {
            objectArray2[n2++] = objectArray[0];
        } else if (object4 != null) {
            objectArray2[n2++] = object4;
        }
        System.arraycopy(objectArray, c == 'N' ? 1 : 2, objectArray2, n2, n - (c == 'N' ? 1 : 2));
        if (c == 'N') {
            CallContext callContext = CallContext.getInstance();
            int n3 = ((MethodProc)object2).match(callContext, objectArray2);
            int n4 = n - 1;
            if (n3 == 0) {
                return ((MethodProc)object2).applyV(callContext);
            }
            if ((n4 & 1) == 0) {
                Object object5;
                for (n2 = 0; n2 < n4; n2 += 2) {
                    if (objectArray2[n2] instanceof Keyword) continue;
                    throw MethodProc.matchFailAsException(n3, invoke, objectArray);
                }
                if (object4 == null) {
                    object5 = ((ProcedureN)object2).apply0();
                    n2 = 0;
                } else {
                    object5 = ((ProcedureN)object2).apply1(object4);
                    n2 = 1;
                }
                while (n2 < n4) {
                    Keyword keyword = (Keyword)objectArray2[n2];
                    Object object6 = objectArray2[n2 + 1];
                    SlotSet.apply(false, object5, keyword.getName(), object6);
                    n2 += 2;
                }
                return object5;
            }
            throw MethodProc.matchFailAsException(n3, invoke, objectArray);
        }
        return ((MethodProc)object2).applyN(objectArray2);
    }

    public int numArgs() {
        return 0xFFFFF000 | (this.kind == 'N' ? 1 : 2);
    }

    protected PrimProcedure[] getMethods(ClassType classType, String string, Expression[] expressionArray, int n, int n2, int n3) {
        if (expressionArray == this.cacheArgs) {
            return this.cacheMethods;
        }
        Type[] typeArray = new Type[n];
        int n4 = 0;
        if (n3 >= 0) {
            typeArray[n4++] = classType;
        }
        for (int i = n2; i < expressionArray.length && n4 < typeArray.length; ++i, ++n4) {
            typeArray[n4] = expressionArray[i].getType();
        }
        PrimProcedure[] primProcedureArray = ClassMethods.getMethods(classType, string, this.kind == 's' ? 8 : 0, this.kind == 'S' ? 0 : 8, this.kind == 'P', this.interpreter);
        long l = ClassMethods.selectApplicable(primProcedureArray, typeArray);
        this.cacheArgs = expressionArray;
        this.cacheDefinitelyApplicableMethodCount = (int)(l >> 32);
        this.cachePossiblyApplicableMethodCount = (int)l;
        this.cacheMethods = primProcedureArray;
        return this.cacheMethods;
    }

    static Object[] checkKeywords(Type type, Expression[] expressionArray, int n) {
        int n2 = expressionArray.length;
        if ((n2 - n & 1) != 0) {
            return null;
        }
        Object[] objectArray = new Object[n2 - n >> 1];
        int n3 = objectArray.length;
        while (--n3 >= 0) {
            Expression expression = expressionArray[n + 2 * n3];
            if (!(expression instanceof QuoteExp)) {
                return null;
            }
            Object object2 = ((QuoteExp)expression).getValue();
            if (!(object2 instanceof Keyword)) {
                return null;
            }
            String string = ((Keyword)object2).getName();
            Object object3 = SlotSet.getField(type, string);
            objectArray[n3] = object3 != null ? object3 : string;
        }
        return objectArray;
    }

    public static Expression inlineClassName(ApplyExp applyExp, int n, InlineCalls inlineCalls) {
        Compilation compilation = inlineCalls.getCompilation();
        Interpreter interpreter = compilation.getInterpreter();
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length > n) {
            Type type = interpreter.getTypeFor(expressionArray[n]);
            if (type instanceof PairClassType) {
                type = ((PairClassType)type).instanceType;
            } else if (!(type instanceof Type)) {
                return applyExp;
            }
            if (type instanceof ClassType && ((ClassType)type).isExisting()) {
                try {
                    type.getReflectClass();
                }
                catch (Exception exception) {
                    compilation.error('e', "unknown class: " + type.getName());
                }
            }
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            System.arraycopy(expressionArray, 0, expressionArray2, 0, expressionArray.length);
            expressionArray2[n] = new QuoteExp(type);
            return new ApplyExp(applyExp.getFunction(), expressionArray2).setLine(applyExp);
        }
        return applyExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Expression inline(ApplyExp applyExp, ExpWalker expWalker) {
        block30: {
            int n;
            int n2;
            MethodProc[] methodProcArray;
            int n3;
            int n4;
            Expression[] expressionArray;
            block29: {
                int n5;
                String string;
                ClassType classType;
                block37: {
                    block38: {
                        StringBuffer stringBuffer;
                        Object[] objectArray;
                        block34: {
                            block36: {
                                block35: {
                                    int n6;
                                    block32: {
                                        block33: {
                                            block31: {
                                                int n7;
                                                expressionArray = applyExp.getArgs();
                                                int n8 = expressionArray.length;
                                                classType = this.getClassType(expressionArray);
                                                string = this.getMethodName(expressionArray);
                                                if (this.kind == 'V') {
                                                    n4 = n8 - 1;
                                                    n7 = 2;
                                                    n3 = 0;
                                                } else if (this.kind == 'N') {
                                                    n4 = n8 - 1;
                                                    n7 = 1;
                                                    n3 = -1;
                                                } else if (this.kind == 'S' || this.kind == 's') {
                                                    n4 = n8 - 2;
                                                    n7 = 2;
                                                    n3 = -1;
                                                } else {
                                                    if (this.kind != 'P') {
                                                        return expWalker.noteError("unknown invoke kind: " + this.kind);
                                                    }
                                                    n4 = n8 - 2;
                                                    n7 = 3;
                                                    n3 = 1;
                                                }
                                                if (classType == null || string == null || this.kind == 'N' && !classType.isExisting()) break block30;
                                                Invoke invoke = this;
                                                synchronized (invoke) {
                                                    try {
                                                        methodProcArray = this.getMethods(classType, string, expressionArray, n4, n7, n3);
                                                    }
                                                    catch (Exception exception) {
                                                        expWalker.error('w', "unknown class: " + classType.getName());
                                                        methodProcArray = null;
                                                    }
                                                    n5 = this.cacheDefinitelyApplicableMethodCount;
                                                    n6 = this.cachePossiblyApplicableMethodCount;
                                                    if (methodProcArray == null) break block30;
                                                }
                                                n2 = -1;
                                                if (methodProcArray.length != 0) break block31;
                                                if (expWalker.getCompilation().getBooleanOption("warn-invoke-unknown-method", true)) {
                                                    expWalker.error('w', "no method `" + string + "' in " + classType.getName());
                                                }
                                                break block29;
                                            }
                                            if (n5 + n6 != 0) break block32;
                                            if (this.kind != 'N' || ClassMethods.selectApplicable((PrimProcedure[])methodProcArray, Type.typeArray0) >> 32 != 1L || (objectArray = Invoke.checkKeywords(classType, expressionArray, 1)) == null) break block33;
                                            stringBuffer = null;
                                            break block34;
                                        }
                                        expWalker.error('w', "no possibly applicable method `" + string + "' in " + classType.getName());
                                        break block29;
                                    }
                                    if (n5 != 1 && (n5 != 0 || n6 != 1)) break block35;
                                    n2 = 0;
                                    break block29;
                                }
                                if (n5 <= 0) break block36;
                                n2 = MethodProc.mostSpecific(methodProcArray, n5);
                                if (n2 >= 0 || this.kind != 'S') break block37;
                                break block38;
                            }
                            if (n5 == 0) {
                                expWalker.error('w', "no definitely applicable method `" + string + "' in " + classType.getName());
                                break block29;
                            } else {
                                expWalker.error('w', "more than one possibly applicable method `" + string + "' in " + classType.getName());
                                int n9 = 0;
                                while (n9 < n5) {
                                    expWalker.error('w', "candidate: " + methodProcArray[n9]);
                                }
                            }
                            break block29;
                        }
                        for (n = 0; n < objectArray.length; ++n) {
                            if (!(objectArray[n] instanceof String)) continue;
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer();
                                stringBuffer.append("no field or setter ");
                            } else {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append('`');
                            stringBuffer.append(objectArray[n]);
                            stringBuffer.append('\'');
                        }
                        if (stringBuffer != null) {
                            stringBuffer.append(" in class ");
                            stringBuffer.append(classType.getName());
                            expWalker.error('w', stringBuffer.toString());
                            break block29;
                        } else {
                            MethodProc methodProc = methodProcArray[0];
                            ApplyExp applyExp2 = new ApplyExp(methodProc, new Expression[0]);
                            int n10 = 0;
                            while (true) {
                                if (n10 >= objectArray.length) {
                                    return applyExp2.setLine(applyExp);
                                }
                                Expression[] expressionArray2 = new Expression[]{applyExp2, new QuoteExp(objectArray[n10]), expressionArray[2 * n10 + 2]};
                                applyExp2 = new ApplyExp(SlotSet.setFieldReturnObject, expressionArray2);
                                ++n10;
                            }
                        }
                    }
                    for (int i = 0; i < n5; ++i) {
                        if (!((PrimProcedure)methodProcArray[i]).getStaticFlag()) continue;
                        if (n2 >= 0) {
                            n2 = -1;
                            break;
                        }
                        n2 = i;
                    }
                }
                if (n2 < 0) {
                    expWalker.error('w', "more than one definitely applicable method `" + string + "' in " + classType.getName());
                    for (int i = 0; i < n5; ++i) {
                        expWalker.error('w', "candidate: " + methodProcArray[i]);
                    }
                }
            }
            if (n2 >= 0) {
                Expression[] expressionArray3 = new Expression[n4];
                int n11 = 0;
                if (n3 >= 0) {
                    expressionArray3[n11++] = expressionArray[n3];
                }
                for (n = n7; n < expressionArray.length && n11 < expressionArray3.length; ++n, ++n11) {
                    expressionArray3[n11] = expressionArray[n];
                }
                MethodProc methodProc = methodProcArray[n2];
                return new ApplyExp(methodProc, expressionArray3).setLine(applyExp);
            }
        }
        return applyExp;
    }

    private ClassType getClassType(Expression[] expressionArray) {
        if (expressionArray.length > 0) {
            Type type;
            Expression expression = expressionArray[0];
            Type type2 = type = this.kind == 'V' ? expression.getType() : this.interpreter.getTypeFor(expression);
            if (type instanceof PairClassType) {
                return ((PairClassType)type).instanceType;
            }
            if (type instanceof ClassType) {
                return (ClassType)type;
            }
        }
        return null;
    }

    private String getMethodName(Expression[] expressionArray) {
        int n;
        if (this.kind == 'N') {
            return "<init>";
        }
        int n2 = n = this.kind == 'P' ? 2 : 1;
        if (expressionArray.length >= n + 1) {
            return ClassMethods.checkName(expressionArray[n], false);
        }
        return null;
    }

    public static synchronized ApplyExp makeInvokeStatic(ClassType classType, String string, Expression[] expressionArray) {
        PrimProcedure primProcedure = Invoke.getStaticMethod(classType, string, expressionArray);
        if (primProcedure == null) {
            throw new RuntimeException("missing or ambiguous method `" + string + "' in " + classType.getName());
        }
        return new ApplyExp(primProcedure, expressionArray);
    }

    public static synchronized PrimProcedure getStaticMethod(ClassType classType, String string, Expression[] expressionArray) {
        MethodProc[] methodProcArray = invokeStatic.getMethods(classType, string, expressionArray, expressionArray.length, 0, -1);
        int n = Invoke.invokeStatic.cacheDefinitelyApplicableMethodCount;
        int n2 = Invoke.invokeStatic.cachePossiblyApplicableMethodCount;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }

    public static synchronized PrimProcedure getMethod(ClassType classType, String string, boolean bl, Type[] typeArray, Interpreter interpreter) {
        MethodProc[] methodProcArray = ClassMethods.getMethods(classType, string, bl ? 8 : 0, 8, interpreter);
        long l = ClassMethods.selectApplicable((PrimProcedure[])methodProcArray, typeArray);
        int n = (int)(l >> 32);
        int n2 = (int)l;
        int n3 = methodProcArray == null ? -1 : (n > 0 ? MethodProc.mostSpecific(methodProcArray, n) : (n2 == 1 ? 0 : -1));
        return n3 < 0 ? null : methodProcArray[n3];
    }
}

