/*
 * Decompiled with CFR 0.152.
 */
package kawa.lib;

import gnu.bytecode.ClassType;
import gnu.expr.GenericProc;
import gnu.expr.Keyword;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleMethod;
import gnu.kawa.functions.AddOp;
import gnu.kawa.lispexpr.LispReader;
import gnu.lists.Consumer;
import gnu.lists.EofClass;
import gnu.lists.FString;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.InPort;
import gnu.mapping.LocationProc;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.TtyInPort;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.math.IntNum;
import gnu.text.Char;
import gnu.text.LineBufferedReader;
import gnu.text.Path;
import gnu.text.SyntaxException;
import java.io.Writer;
import kawa.lib.characters;
import kawa.lib.numbers;
import kawa.lib.strings;
import kawa.standard.Scheme;
import kawa.standard.char_ready_p;
import kawa.standard.read_line;

public class ports
extends ModuleBody {
    public static final ModuleMethod open$Mninput$Mnfile;
    public static final ModuleMethod open$Mnoutput$Mnfile;
    public static final ModuleMethod call$Mnwith$Mninput$Mnfile;
    public static final ModuleMethod call$Mnwith$Mnoutput$Mnfile;
    public static final ModuleMethod with$Mninput$Mnfrom$Mnfile;
    public static final ModuleMethod with$Mnoutput$Mnto$Mnfile;
    public static final ModuleMethod input$Mnport$Qu;
    public static final ModuleMethod output$Mnport$Qu;
    public static final LocationProc current$Mninput$Mnport;
    public static final LocationProc current$Mnoutput$Mnport;
    public static final LocationProc current$Mnerror$Mnport;
    public static final ModuleMethod write$Mnchar;
    public static final ModuleMethod open$Mninput$Mnstring;
    public static final ModuleMethod open$Mnoutput$Mnstring;
    public static final ModuleMethod get$Mnoutput$Mnstring;
    public static final ModuleMethod call$Mnwith$Mninput$Mnstring;
    public static final ModuleMethod call$Mnwith$Mnoutput$Mnstring;
    public static final ModuleMethod force$Mnoutput;
    public static final ModuleMethod newline;
    public static final ModuleMethod eof$Mnobject$Qu;
    public static final ModuleMethod char$Mnready$Qu;
    public static final ModuleMethod write;
    public static final ModuleMethod display;
    public static final ModuleMethod input$Mnport$Mnread$Mnstate;
    public static final ModuleMethod set$Mnport$Mnline$Ex;
    public static final GenericProc port$Mnline;
    public static final ModuleMethod set$Mninput$Mnport$Mnline$Mnnumber$Ex;
    public static final GenericProc input$Mnport$Mnline$Mnnumber;
    public static final ModuleMethod port$Mncolumn;
    public static final ModuleMethod input$Mnport$Mncolumn$Mnnumber;
    public static final ModuleMethod default$Mnprompter;
    public static final ModuleMethod set$Mninput$Mnport$Mnprompter$Ex;
    public static final GenericProc input$Mnport$Mnprompter;
    public static final ModuleMethod close$Mninput$Mnport;
    public static final ModuleMethod close$Mnoutput$Mnport;
    public static final ModuleMethod read;
    public static final ModuleMethod read$Mnline;
    public static final ModuleMethod transcript$Mnon;
    public static final ModuleMethod transcript$Mnoff;
    static final SimpleSymbol Lit0;
    static final ModuleMethod lambda$Fn1;
    static final ClassType Lit1;
    static final SimpleSymbol Lit2;
    static final ModuleMethod lambda$Fn2;
    static final ClassType Lit3;
    static final SimpleSymbol Lit4;
    static final ModuleMethod lambda$Fn3;
    static final Keyword Lit5;
    static final ModuleMethod port$Mnline$Fn4;
    static final IntNum Lit6;
    static final ModuleMethod input$Mnport$Mnline$Mnnumber$Fn5;
    static final Char Lit7;
    static final Char Lit8;
    static final ModuleMethod input$Mnport$Mnprompter$Fn6;
    static final SimpleSymbol Lit9;
    public static final ports $instance;
    static final SimpleSymbol Lit10;
    static final SimpleSymbol Lit11;
    static final SimpleSymbol Lit12;
    static final SimpleSymbol Lit13;
    static final SimpleSymbol Lit14;
    static final SimpleSymbol Lit15;
    static final SimpleSymbol Lit16;
    static final SimpleSymbol Lit17;
    static final SimpleSymbol Lit18;
    static final SimpleSymbol Lit19;
    static final SimpleSymbol Lit20;
    static final SimpleSymbol Lit21;
    static final SimpleSymbol Lit22;
    static final SimpleSymbol Lit23;
    static final SimpleSymbol Lit24;
    static final SimpleSymbol Lit25;
    static final SimpleSymbol Lit26;
    static final SimpleSymbol Lit27;
    static final SimpleSymbol Lit28;
    static final SimpleSymbol Lit29;
    static final SimpleSymbol Lit30;
    static final SimpleSymbol Lit31;
    static final SimpleSymbol Lit32;
    static final SimpleSymbol Lit33;
    static final SimpleSymbol Lit34;
    static final SimpleSymbol Lit35;
    static final SimpleSymbol Lit36;
    static final SimpleSymbol Lit37;
    static final SimpleSymbol Lit38;
    static final SimpleSymbol Lit39;
    static final SimpleSymbol Lit40;
    static final SimpleSymbol Lit41;
    static final SimpleSymbol Lit42;
    static final SimpleSymbol Lit43;
    static final SimpleSymbol Lit44;
    static final SimpleSymbol Lit45;

    public ports() {
        ModuleInfo.register(this);
    }

    public static InPort openInputFile(Path name) {
        return InPort.openFile(name);
    }

    public static OutPort openOutputFile(Path name) {
        return OutPort.openFile(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object callWithInputFile(Path path, Procedure proc) {
        Throwable throwable2;
        Object object2;
        InPort port = ports.openInputFile(path);
        try {
            object2 = proc.apply1(port);
            throwable2 = null;
        }
        catch (Throwable throwable2) {
            object2 = null;
        }
        ports.closeInputPort(port);
        Throwable throwable3 = throwable2;
        if (throwable3 != null) {
            throw throwable3;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object callWithOutputFile(Path path, Procedure proc) {
        Throwable throwable2;
        Object object2;
        OutPort port = ports.openOutputFile(path);
        try {
            object2 = proc.apply1(port);
            throwable2 = null;
        }
        catch (Throwable throwable2) {
            object2 = null;
        }
        ports.closeOutputPort(port);
        Throwable throwable3 = throwable2;
        if (throwable3 != null) {
            throw throwable3;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object withInputFromFile(Path pathname, Procedure proc) {
        Throwable throwable2;
        Object object2;
        InPort save = InPort.inDefault();
        InPort port = InPort.openFile(pathname);
        try {
            InPort.setInDefault(port);
            object2 = proc.apply0();
            throwable2 = null;
        }
        catch (Throwable throwable2) {
            object2 = null;
        }
        InPort.setInDefault(save);
        port.close();
        Throwable throwable3 = throwable2;
        if (throwable3 != null) {
            throw throwable3;
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object withOutputToFile(Path path, Procedure proc) {
        Throwable throwable2;
        Object object2;
        OutPort port = OutPort.openFile(path);
        OutPort save = OutPort.outDefault();
        try {
            OutPort.setOutDefault(port);
            object2 = proc.apply0();
            throwable2 = null;
        }
        catch (Throwable throwable2) {
            object2 = null;
        }
        OutPort.setOutDefault(save);
        port.close();
        Throwable throwable3 = throwable2;
        if (throwable3 != null) {
            throw throwable3;
        }
        return object2;
    }

    public static boolean isInputPort(Object x) {
        return x instanceof InPort;
    }

    public static boolean isOutputPort(Object x) {
        return x instanceof OutPort;
    }

    public static void writeChar(Object object2) {
        ports.writeChar(object2, OutPort.outDefault());
    }

    public static void writeChar(Object ch, OutPort port) {
        Object object2 = ch;
        try {
            Char.print(characters.char$To$Integer((Char)object2), port);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "char->integer", 1, object2);
        }
    }

    public static InPort openInputString(CharSequence str) {
        CharSequence charSequence = str;
        return new CharArrayInPort((String)(charSequence == null ? null : ((Object)charSequence).toString()));
    }

    public static CharArrayOutPort openOutputString() {
        return new CharArrayOutPort();
    }

    public static FString getOutputString(CharArrayOutPort output$Mnport) {
        return new FString(output$Mnport.toCharArray());
    }

    /*
     * WARNING - void declaration
     */
    public static Object callWithInputString(CharSequence str, Procedure proc) {
        void var3_3;
        CharSequence charSequence = str;
        CharArrayInPort port = new CharArrayInPort((String)(charSequence == null ? null : ((Object)charSequence).toString()));
        Object result = proc.apply1(port);
        ports.closeInputPort(port);
        return var3_3;
    }

    public static FString callWithOutputString(Procedure proc) {
        CharArrayOutPort port = new CharArrayOutPort();
        proc.apply1(port);
        char[] chars = port.toCharArray();
        port.close();
        return new FString(chars);
    }

    public static void forceOutput() {
        ports.forceOutput(((Procedure)current$Mnoutput$Mnport).apply0());
    }

    public static void forceOutput(Object port) {
        Object object2 = port;
        try {
            ((Writer)object2).flush();
            return;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "java.io.Writer.flush()", 1, object2);
        }
    }

    public static void newline() {
        ports.newline(((Procedure)current$Mnoutput$Mnport).apply0());
    }

    public static void newline(Object port) {
        Object object2 = port;
        try {
            ((OutPort)object2).println();
            return;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.mapping.OutPort.println()", 1, object2);
        }
    }

    public static boolean isEofObject(Object obj) {
        return obj == EofClass.eofValue;
    }

    public static boolean isCharReady() {
        return ports.isCharReady(((Procedure)current$Mninput$Mnport).apply0());
    }

    public static boolean isCharReady(Object port) {
        return char_ready_p.ready(port);
    }

    public static void write(Object object2) {
        ports.write(object2, ((Procedure)current$Mnoutput$Mnport).apply0());
    }

    public static void write(Object value, Object out) {
        Object object2 = out;
        try {
            Scheme.writeFormat.format(value, (Consumer)object2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.lists.AbstractFormat.format(java.lang.Object,gnu.lists.Consumer)", 3, object2);
        }
    }

    public static void display(Object object2) {
        ports.display(object2, ((Procedure)current$Mnoutput$Mnport).apply0());
    }

    public static void display(Object value, Object out) {
        Object object2 = out;
        try {
            Scheme.displayFormat.format(value, (Consumer)object2);
            return;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.lists.AbstractFormat.format(java.lang.Object,gnu.lists.Consumer)", 3, object2);
        }
    }

    public static char inputPortReadState(Object port) {
        Object object2 = port;
        try {
            return ((InPort)object2).getReadState();
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.mapping.InPort.getReadState()", 1, object2);
        }
    }

    public static void setPortLine$Ex(Object port, Object line) {
        LineBufferedReader lineBufferedReader;
        Object object2 = port;
        try {
            lineBufferedReader = (LineBufferedReader)object2;
            object2 = line;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.text.LineBufferedReader.setLineNumber(int)", 1, object2);
        }
        try {
            lineBufferedReader.setLineNumber(((Number)object2).intValue());
            return;
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.text.LineBufferedReader.setLineNumber(int)", 2, object2);
        }
    }

    public static int portLine(LineBufferedReader port) {
        return port.getLineNumber();
    }

    public static void setInputPortLineNumber$Ex(Object port, Object num) {
        ports.setPortLine$Ex(port, ((Procedure)AddOp.$Mn).apply2(num, Lit6));
    }

    public static Object inputPortLineNumber(LineBufferedReader port) {
        return ((Procedure)AddOp.$Pl).apply2(Lit6, ((Procedure)port$Mnline).apply1(port));
    }

    public static int portColumn(Object port) {
        Object object2 = port;
        try {
            return ((LineBufferedReader)object2).getColumnNumber();
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "gnu.text.LineBufferedReader.getColumnNumber()", 1, object2);
        }
    }

    public static int inputPortColumnNumber(Object port) {
        return 1 + ports.portColumn(port);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object defaultPrompter(Object port) {
        char state = ports.inputPortReadState(port);
        if (characters.isChar$Eq(Char.make(state), Lit7)) {
            return "";
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = characters.isChar$Eq(Char.make(state), Lit8) ? "#|kawa:" : strings.stringAppend("#|", strings.makeString(1, Char.make(state)), "---:");
        Object object2 = ((Procedure)input$Mnport$Mnline$Mnnumber).apply1(port);
        try {
            objectArray[1] = numbers.number$To$String((Number)object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "number->string", 0, object2);
        }
        objectArray[2] = "|# ";
        CharSequence charSequence = strings.stringAppend(objectArray);
        return charSequence;
    }

    public static void setInputPortPrompter$Ex(TtyInPort port, Procedure prompter) {
        port.setPrompter(prompter);
    }

    public static Procedure inputPortPrompter(TtyInPort port) {
        return port.getPrompter();
    }

    public static Object closeInputPort(InPort port) {
        port.close();
        return Values.empty;
    }

    public static Object closeOutputPort(OutPort port) {
        port.close();
        return Values.empty;
    }

    public static Object read() {
        return ports.read((InPort)((Procedure)current$Mninput$Mnport).apply0());
    }

    /*
     * WARNING - void declaration
     */
    public static Object read(InPort port) {
        void var2_4;
        LispReader lexer = new LispReader(port);
        try {
            void ex;
            Object result = lexer.readObject();
            if (lexer.seenErrors()) {
                throw (Throwable)new SyntaxException(lexer.getMessages());
            }
            var2_4 = ex;
        }
        catch (SyntaxException ex) {
            ex.setHeader("syntax error in read:");
            throw (Throwable)ex;
        }
        return var2_4;
    }

    public static Object readLine() {
        return ports.readLine((LineBufferedReader)((Procedure)current$Mninput$Mnport).apply0(), Lit9);
    }

    public static Object readLine(LineBufferedReader lineBufferedReader) {
        return ports.readLine(lineBufferedReader, Lit9);
    }

    public static Object readLine(LineBufferedReader port, Symbol handling) {
        Symbol symbol = handling;
        return read_line.apply(port, (String)(symbol == null ? null : ((Object)symbol).toString()));
    }

    public static void transcriptOn(Object filename) {
        OutPort.setLogFile(filename.toString());
    }

    public static void transcriptOff() {
        OutPort.closeLogFile();
    }

    @Override
    public final void run(CallContext $ctx) {
        Consumer $result = $ctx.consumer;
        current$Mninput$Mnport = LocationProc.makeNamed(Lit0, InPort.inLocation);
        current$Mninput$Mnport.pushConverter(lambda$Fn1);
        current$Mnoutput$Mnport = LocationProc.makeNamed(Lit2, OutPort.outLocation);
        current$Mnoutput$Mnport.pushConverter(lambda$Fn2);
        current$Mnerror$Mnport = LocationProc.makeNamed(Lit4, OutPort.errLocation);
        current$Mnerror$Mnport.pushConverter(lambda$Fn3);
        port$Mnline = new GenericProc("port-line");
        Object[] objectArray = new Object[3];
        objectArray[0] = Lit5;
        objectArray[1] = set$Mnport$Mnline$Ex;
        ModuleMethod port$Mnline = port$Mnline$Fn4;
        objectArray[2] = port$Mnline$Fn4;
        ports.port$Mnline.setProperties(objectArray);
        input$Mnport$Mnline$Mnnumber = new GenericProc("input-port-line-number");
        objectArray = new Object[3];
        objectArray[0] = Lit5;
        objectArray[1] = set$Mninput$Mnport$Mnline$Mnnumber$Ex;
        ModuleMethod input$Mnport$Mnline$Mnnumber = input$Mnport$Mnline$Mnnumber$Fn5;
        objectArray[2] = input$Mnport$Mnline$Mnnumber$Fn5;
        ports.input$Mnport$Mnline$Mnnumber.setProperties(objectArray);
        input$Mnport$Mnprompter = new GenericProc("input-port-prompter");
        objectArray = new Object[3];
        objectArray[0] = Lit5;
        objectArray[1] = set$Mninput$Mnport$Mnprompter$Ex;
        ModuleMethod input$Mnport$Mnprompter = input$Mnport$Mnprompter$Fn6;
        objectArray[2] = input$Mnport$Mnprompter$Fn6;
        ports.input$Mnport$Mnprompter.setProperties(objectArray);
    }

    static Object lambda1(Object arg) {
        InPort inPort;
        try {
            inPort = (InPort)arg;
        }
        catch (ClassCastException ex) {
            WrongType wt = WrongType.make(ex, current$Mninput$Mnport, 1, arg);
            wt.expectedType = Lit1;
            throw (Throwable)wt;
        }
        return inPort;
    }

    static Object lambda2(Object arg) {
        OutPort outPort;
        try {
            outPort = (OutPort)arg;
        }
        catch (ClassCastException ex) {
            WrongType wt = WrongType.make(ex, current$Mnoutput$Mnport, 1, arg);
            wt.expectedType = Lit3;
            throw (Throwable)wt;
        }
        return outPort;
    }

    static Object lambda3(Object arg) {
        OutPort outPort;
        try {
            outPort = (OutPort)arg;
        }
        catch (ClassCastException ex) {
            WrongType wt = WrongType.make(ex, current$Mnerror$Mnport, 1, arg);
            wt.expectedType = Lit3;
            throw (Throwable)wt;
        }
        return outPort;
    }

    static {
        Lit45 = (SimpleSymbol)new SimpleSymbol("transcript-off").readResolve();
        Lit44 = (SimpleSymbol)new SimpleSymbol("transcript-on").readResolve();
        Lit43 = (SimpleSymbol)new SimpleSymbol("read-line").readResolve();
        Lit42 = (SimpleSymbol)new SimpleSymbol("read").readResolve();
        Lit41 = (SimpleSymbol)new SimpleSymbol("close-output-port").readResolve();
        Lit40 = (SimpleSymbol)new SimpleSymbol("close-input-port").readResolve();
        Lit39 = (SimpleSymbol)new SimpleSymbol("input-port-prompter").readResolve();
        Lit38 = (SimpleSymbol)new SimpleSymbol("set-input-port-prompter!").readResolve();
        Lit37 = (SimpleSymbol)new SimpleSymbol("default-prompter").readResolve();
        Lit36 = (SimpleSymbol)new SimpleSymbol("input-port-column-number").readResolve();
        Lit35 = (SimpleSymbol)new SimpleSymbol("port-column").readResolve();
        Lit34 = (SimpleSymbol)new SimpleSymbol("input-port-line-number").readResolve();
        Lit33 = (SimpleSymbol)new SimpleSymbol("set-input-port-line-number!").readResolve();
        Lit32 = (SimpleSymbol)new SimpleSymbol("port-line").readResolve();
        Lit31 = (SimpleSymbol)new SimpleSymbol("set-port-line!").readResolve();
        Lit30 = (SimpleSymbol)new SimpleSymbol("input-port-read-state").readResolve();
        Lit29 = (SimpleSymbol)new SimpleSymbol("display").readResolve();
        Lit28 = (SimpleSymbol)new SimpleSymbol("write").readResolve();
        Lit27 = (SimpleSymbol)new SimpleSymbol("char-ready?").readResolve();
        Lit26 = (SimpleSymbol)new SimpleSymbol("eof-object?").readResolve();
        Lit25 = (SimpleSymbol)new SimpleSymbol("newline").readResolve();
        Lit24 = (SimpleSymbol)new SimpleSymbol("force-output").readResolve();
        Lit23 = (SimpleSymbol)new SimpleSymbol("call-with-output-string").readResolve();
        Lit22 = (SimpleSymbol)new SimpleSymbol("call-with-input-string").readResolve();
        Lit21 = (SimpleSymbol)new SimpleSymbol("get-output-string").readResolve();
        Lit20 = (SimpleSymbol)new SimpleSymbol("open-output-string").readResolve();
        Lit19 = (SimpleSymbol)new SimpleSymbol("open-input-string").readResolve();
        Lit18 = (SimpleSymbol)new SimpleSymbol("write-char").readResolve();
        Lit17 = (SimpleSymbol)new SimpleSymbol("output-port?").readResolve();
        Lit16 = (SimpleSymbol)new SimpleSymbol("input-port?").readResolve();
        Lit15 = (SimpleSymbol)new SimpleSymbol("with-output-to-file").readResolve();
        Lit14 = (SimpleSymbol)new SimpleSymbol("with-input-from-file").readResolve();
        Lit13 = (SimpleSymbol)new SimpleSymbol("call-with-output-file").readResolve();
        Lit12 = (SimpleSymbol)new SimpleSymbol("call-with-input-file").readResolve();
        Lit11 = (SimpleSymbol)new SimpleSymbol("open-output-file").readResolve();
        Lit10 = (SimpleSymbol)new SimpleSymbol("open-input-file").readResolve();
        Lit9 = (SimpleSymbol)new SimpleSymbol("trim").readResolve();
        Lit8 = Char.make(32);
        Lit7 = Char.make(10);
        Lit6 = IntNum.make(1);
        Lit5 = Keyword.make("setter");
        Lit4 = (SimpleSymbol)new SimpleSymbol("current-error-port").readResolve();
        Lit3 = ClassType.make("gnu.mapping.OutPort");
        Lit2 = (SimpleSymbol)new SimpleSymbol("current-output-port").readResolve();
        Lit1 = ClassType.make("gnu.mapping.InPort");
        Lit0 = (SimpleSymbol)new SimpleSymbol("current-input-port").readResolve();
        ports ports2 = $instance = new ports();
        open$Mninput$Mnfile = new ModuleMethod(ports2, 1, Lit10, 4097);
        open$Mnoutput$Mnfile = new ModuleMethod(ports2, 2, Lit11, 4097);
        call$Mnwith$Mninput$Mnfile = new ModuleMethod(ports2, 3, Lit12, 8194);
        call$Mnwith$Mnoutput$Mnfile = new ModuleMethod(ports2, 4, Lit13, 8194);
        with$Mninput$Mnfrom$Mnfile = new ModuleMethod(ports2, 5, Lit14, 8194);
        with$Mnoutput$Mnto$Mnfile = new ModuleMethod(ports2, 6, Lit15, 8194);
        input$Mnport$Qu = new ModuleMethod(ports2, 7, Lit16, 4097);
        output$Mnport$Qu = new ModuleMethod(ports2, 8, Lit17, 4097);
        lambda$Fn1 = new ModuleMethod(ports2, 9, null, 4097);
        lambda$Fn2 = new ModuleMethod(ports2, 10, null, 4097);
        lambda$Fn3 = new ModuleMethod(ports2, 11, null, 4097);
        write$Mnchar = new ModuleMethod(ports2, 12, Lit18, 8193);
        open$Mninput$Mnstring = new ModuleMethod(ports2, 14, Lit19, 4097);
        open$Mnoutput$Mnstring = new ModuleMethod(ports2, 15, Lit20, 0);
        get$Mnoutput$Mnstring = new ModuleMethod(ports2, 16, Lit21, 4097);
        call$Mnwith$Mninput$Mnstring = new ModuleMethod(ports2, 17, Lit22, 8194);
        call$Mnwith$Mnoutput$Mnstring = new ModuleMethod(ports2, 18, Lit23, 4097);
        force$Mnoutput = new ModuleMethod(ports2, 19, Lit24, 4096);
        newline = new ModuleMethod(ports2, 21, Lit25, 4096);
        eof$Mnobject$Qu = new ModuleMethod(ports2, 23, Lit26, 4097);
        char$Mnready$Qu = new ModuleMethod(ports2, 24, Lit27, 4096);
        write = new ModuleMethod(ports2, 26, Lit28, 8193);
        display = new ModuleMethod(ports2, 28, Lit29, 8193);
        input$Mnport$Mnread$Mnstate = new ModuleMethod(ports2, 30, Lit30, 4097);
        set$Mnport$Mnline$Ex = new ModuleMethod(ports2, 31, Lit31, 8194);
        port$Mnline$Fn4 = new ModuleMethod(ports2, 32, Lit32, 4097);
        set$Mninput$Mnport$Mnline$Mnnumber$Ex = new ModuleMethod(ports2, 33, Lit33, 8194);
        input$Mnport$Mnline$Mnnumber$Fn5 = new ModuleMethod(ports2, 34, Lit34, 4097);
        port$Mncolumn = new ModuleMethod(ports2, 35, Lit35, 4097);
        input$Mnport$Mncolumn$Mnnumber = new ModuleMethod(ports2, 36, Lit36, 4097);
        default$Mnprompter = new ModuleMethod(ports2, 37, Lit37, 4097);
        set$Mninput$Mnport$Mnprompter$Ex = new ModuleMethod(ports2, 38, Lit38, 8194);
        input$Mnport$Mnprompter$Fn6 = new ModuleMethod(ports2, 39, Lit39, 4097);
        close$Mninput$Mnport = new ModuleMethod(ports2, 40, Lit40, 4097);
        close$Mnoutput$Mnport = new ModuleMethod(ports2, 41, Lit41, 4097);
        read = new ModuleMethod(ports2, 42, Lit42, 4096);
        read$Mnline = new ModuleMethod(ports2, 44, Lit43, 8192);
        transcript$Mnon = new ModuleMethod(ports2, 47, Lit44, 4097);
        transcript$Mnoff = new ModuleMethod(ports2, 48, Lit45, 0);
        $instance.run();
    }

    @Override
    public int match0(ModuleMethod moduleMethod, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 48: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
            case 44: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
            case 42: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
            case 24: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
            case 21: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
            case 19: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
            case 15: {
                callContext.proc = moduleMethod;
                callContext.pc = 0;
                return 0;
            }
        }
        return super.match0(moduleMethod, callContext);
    }

    @Override
    public int match1(ModuleMethod moduleMethod, Object object2, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 47: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 44: {
                Object object3 = object2;
                if (!(object3 instanceof LineBufferedReader)) {
                    return -786431;
                }
                callContext.value1 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 42: {
                Object object4 = object2;
                if (!(object4 instanceof InPort)) {
                    return -786431;
                }
                callContext.value1 = object4;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 41: {
                Object object5 = object2;
                if (!(object5 instanceof OutPort)) {
                    return -786431;
                }
                callContext.value1 = object5;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 40: {
                Object object6 = object2;
                if (!(object6 instanceof InPort)) {
                    return -786431;
                }
                callContext.value1 = object6;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 39: {
                Object object7 = object2;
                if (!(object7 instanceof TtyInPort)) {
                    return -786431;
                }
                callContext.value1 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 37: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 36: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 35: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 34: {
                Object object8 = object2;
                if (!(object8 instanceof LineBufferedReader)) {
                    return -786431;
                }
                callContext.value1 = object8;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 32: {
                Object object9 = object2;
                if (!(object9 instanceof LineBufferedReader)) {
                    return -786431;
                }
                callContext.value1 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 30: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 28: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 26: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 24: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 23: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 21: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 19: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 18: {
                Object object10 = object2;
                if (!(object10 instanceof Procedure)) {
                    return -786431;
                }
                callContext.value1 = object10;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 16: {
                Object object11 = object2;
                if (!(object11 instanceof CharArrayOutPort)) {
                    return -786431;
                }
                callContext.value1 = object11;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 14: {
                Object object12 = object2;
                if (!(object12 instanceof CharSequence)) {
                    return -786431;
                }
                callContext.value1 = object12;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 12: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 11: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 10: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 9: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 8: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 7: {
                callContext.value1 = object2;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 2: {
                Object object13 = object2;
                if (Path.coerceToPathOrNull(object13) == null) {
                    return -786431;
                }
                callContext.value1 = object13;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
            case 1: {
                Object object14 = object2;
                if (Path.coerceToPathOrNull(object14) == null) {
                    return -786431;
                }
                callContext.value1 = object14;
                callContext.proc = moduleMethod;
                callContext.pc = 1;
                return 0;
            }
        }
        return super.match1(moduleMethod, object2, callContext);
    }

    @Override
    public int match2(ModuleMethod moduleMethod, Object object2, Object object3, CallContext callContext) {
        switch (moduleMethod.selector) {
            case 44: {
                Object object4 = object2;
                if (!(object4 instanceof LineBufferedReader)) {
                    return -786431;
                }
                callContext.value1 = object4;
                Object object5 = object3;
                if (!(object5 instanceof Symbol)) {
                    return -786430;
                }
                callContext.value2 = object5;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 38: {
                Object object6 = object2;
                if (!(object6 instanceof TtyInPort)) {
                    return -786431;
                }
                callContext.value1 = object6;
                Object object7 = object3;
                if (!(object7 instanceof Procedure)) {
                    return -786430;
                }
                callContext.value2 = object7;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 33: {
                callContext.value1 = object2;
                callContext.value2 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 31: {
                callContext.value1 = object2;
                callContext.value2 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 28: {
                callContext.value1 = object2;
                callContext.value2 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 26: {
                callContext.value1 = object2;
                callContext.value2 = object3;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 17: {
                Object object8 = object2;
                if (!(object8 instanceof CharSequence)) {
                    return -786431;
                }
                callContext.value1 = object8;
                Object object9 = object3;
                if (!(object9 instanceof Procedure)) {
                    return -786430;
                }
                callContext.value2 = object9;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 12: {
                callContext.value1 = object2;
                Object object10 = object3;
                if (!(object10 instanceof OutPort)) {
                    return -786430;
                }
                callContext.value2 = object10;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 6: {
                Object object11 = object2;
                if (Path.coerceToPathOrNull(object11) == null) {
                    return -786431;
                }
                callContext.value1 = object11;
                Object object12 = object3;
                if (!(object12 instanceof Procedure)) {
                    return -786430;
                }
                callContext.value2 = object12;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 5: {
                Object object13 = object2;
                if (Path.coerceToPathOrNull(object13) == null) {
                    return -786431;
                }
                callContext.value1 = object13;
                Object object14 = object3;
                if (!(object14 instanceof Procedure)) {
                    return -786430;
                }
                callContext.value2 = object14;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 4: {
                Object object15 = object2;
                if (Path.coerceToPathOrNull(object15) == null) {
                    return -786431;
                }
                callContext.value1 = object15;
                Object object16 = object3;
                if (!(object16 instanceof Procedure)) {
                    return -786430;
                }
                callContext.value2 = object16;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
            case 3: {
                Object object17 = object2;
                if (Path.coerceToPathOrNull(object17) == null) {
                    return -786431;
                }
                callContext.value1 = object17;
                Object object18 = object3;
                if (!(object18 instanceof Procedure)) {
                    return -786430;
                }
                callContext.value2 = object18;
                callContext.proc = moduleMethod;
                callContext.pc = 2;
                return 0;
            }
        }
        return super.match2(moduleMethod, object2, object3, callContext);
    }

    @Override
    public Object apply0(ModuleMethod moduleMethod) {
        switch (moduleMethod.selector) {
            case 15: {
                return ports.openOutputString();
            }
            case 19: {
                ports.forceOutput();
                return Values.empty;
            }
            case 21: {
                ports.newline();
                return Values.empty;
            }
            case 24: {
                return ports.isCharReady() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return ports.read();
            }
            case 44: {
                return ports.readLine();
            }
            case 48: {
                ports.transcriptOff();
                return Values.empty;
            }
        }
        return super.apply0(moduleMethod);
    }

    /*
     * Loose catch block
     */
    @Override
    public Object apply1(ModuleMethod moduleMethod, Object object2) {
        switch (moduleMethod.selector) {
            case 1: {
                return ports.openInputFile(Path.valueOf(object2));
            }
            case 2: {
                return ports.openOutputFile(Path.valueOf(object2));
            }
            case 7: {
                return ports.isInputPort(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return ports.isOutputPort(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 9: {
                return ports.lambda1(object2);
            }
            case 10: {
                return ports.lambda2(object2);
            }
            case 11: {
                return ports.lambda3(object2);
            }
            case 12: {
                ports.writeChar(object2);
                return Values.empty;
            }
            case 14: {
                return ports.openInputString((CharSequence)object2);
            }
            case 16: {
                return ports.getOutputString((CharArrayOutPort)object2);
            }
            case 18: {
                return ports.callWithOutputString((Procedure)object2);
            }
            case 19: {
                ports.forceOutput(object2);
                return Values.empty;
            }
            case 21: {
                ports.newline(object2);
                return Values.empty;
            }
            case 23: {
                return ports.isEofObject(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 24: {
                return ports.isCharReady(object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 26: {
                ports.write(object2);
                return Values.empty;
            }
            case 28: {
                ports.display(object2);
                return Values.empty;
            }
            case 30: {
                return Char.make(ports.inputPortReadState(object2));
            }
            case 32: {
                return ports.portLine((LineBufferedReader)object2);
            }
            case 34: {
                return ports.inputPortLineNumber((LineBufferedReader)object2);
            }
            case 35: {
                return ports.portColumn(object2);
            }
            case 36: {
                return ports.inputPortColumnNumber(object2);
            }
            case 37: {
                return ports.defaultPrompter(object2);
            }
            case 39: {
                return ports.inputPortPrompter((TtyInPort)object2);
            }
            case 40: {
                return ports.closeInputPort((InPort)object2);
            }
            case 41: {
                return ports.closeOutputPort((OutPort)object2);
            }
            case 42: {
                return ports.read((InPort)object2);
            }
            case 44: {
                return ports.readLine((LineBufferedReader)object2);
            }
            case 47: {
                ports.transcriptOn(object2);
                return Values.empty;
            }
        }
        return super.apply1(moduleMethod, object2);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "open-input-file", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "open-output-file", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "open-input-string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "get-output-string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-output-string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "port-line", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "input-port-line-number", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "input-port-prompter", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "close-input-port", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "close-output-port", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "read", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "read-line", 1, object2);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Object apply2(ModuleMethod moduleMethod, Object object2, Object object3) {
        switch (moduleMethod.selector) {
            case 3: {
                Path path = Path.valueOf(object2);
                return ports.callWithInputFile(path, (Procedure)object3);
            }
            case 4: {
                Path path = Path.valueOf(object2);
                return ports.callWithOutputFile(path, (Procedure)object3);
            }
            case 5: {
                Path path = Path.valueOf(object2);
                return ports.withInputFromFile(path, (Procedure)object3);
            }
            case 6: {
                Path path = Path.valueOf(object2);
                return ports.withOutputToFile(path, (Procedure)object3);
            }
            case 12: {
                ports.writeChar(object2, (OutPort)object3);
                return Values.empty;
            }
            case 17: {
                CharSequence charSequence = (CharSequence)object2;
                return ports.callWithInputString(charSequence, (Procedure)object3);
            }
            case 26: {
                ports.write(object2, object3);
                return Values.empty;
            }
            case 28: {
                ports.display(object2, object3);
                return Values.empty;
            }
            case 31: {
                ports.setPortLine$Ex(object2, object3);
                return Values.empty;
            }
            case 33: {
                ports.setInputPortLineNumber$Ex(object2, object3);
                return Values.empty;
            }
            case 38: {
                TtyInPort ttyInPort = (TtyInPort)object2;
                ports.setInputPortPrompter$Ex(ttyInPort, (Procedure)object3);
                return Values.empty;
            }
            case 44: {
                LineBufferedReader lineBufferedReader = (LineBufferedReader)object2;
                return ports.readLine(lineBufferedReader, (Symbol)object3);
            }
        }
        return super.apply2(moduleMethod, object2, object3);
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-input-file", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-input-file", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-output-file", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-output-file", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "with-input-from-file", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "with-input-from-file", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "with-output-to-file", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "with-output-to-file", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "write-char", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-input-string", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "call-with-input-string", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "set-input-port-prompter!", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "set-input-port-prompter!", 2, object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "read-line", 1, object2);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(classCastException, "read-line", 2, object3);
        }
    }
}

