/*
 * This file is part of SpyBlock <https://www.gnu.org/software/gnuzilla/>,
 * Copyright (C) 2006-2017 eyeo GmbH
 *
 * SpyBlock is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * SpyBlock is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SpyBlock.  If not, see <http://www.gnu.org/licenses/>.
 */

"use strict";

/* global IO */

let port = browser.runtime.connect();

port.onMessage.addListener(message =>
{
  IO[message.method](...message.args).then(result =>
  {
    port.postMessage({
      id: message.id,
      success: true,
      result
    });
  }).catch(error =>
  {
    port.postMessage({
      id: message.id,
      success: false,
      result: String(error)
    });
  });
});
