/*
 * This file is part of SpyBlock <https://www.gnu.org/software/gnuzilla/>,
 * Copyright (C) 2006-2017 eyeo GmbH
 *
 * SpyBlock is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * SpyBlock is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with SpyBlock.  If not, see <http://www.gnu.org/licenses/>.
 */

let {port} = require("messaging");

// Only initialize after receiving a "response" to a dummy message - this makes
// sure that on update the old version has enough time to receive and process
// the shutdown message.
port.emitWithResponse("ping").then(() =>
{
  require("child/elemHide");
  require("child/contentPolicy");
  require("child/contextMenu");
  require("child/dataCollector");
  require("child/elemHideEmulation");
  require("child/subscribeLinks");
}).catch(e => Cu.reportError(e));
