// global async_test, assert_equals
//
// This test generates a couple of scenarios (each a
// SVGSizing.TestData) for sizing inline <svg> and uses a simple
// JavaScript sizing implementation for comparison.
//
// The tests loops through different combinations of:
//
// * width and height on <object>, <iframe> (input dependent)
//
// * width and height on <svg>
//
// * viewBox on <svg> (gives intrinsic ratio)
//
// * width and height on containing block of <object>
//
// All these contribute to the final size of the SVG in some way.
//
// The test focuses on the size of the CSS box generated by the SVG.
// The SVG is always empty by itself so no actual SVG are tested.
// Little focus is put on variations within an attribute that doesn't
// affect the sizing behavior.
//
// To debug a specific test, append ?<test-id> to the URL. An <iframe>
// is generated with equivalent test and the source code of the test
// can be downloaded.

var debugHint = function(id) { return "(append ?"+id+" to debug) "; };
var testSingleId;
if (window.location.search) {
    testSingleId = parseInt(window.location.search.substring(1));
    debugHint = function(id) { return ""; };
}

function testPlaceholderWithHeight(placeholder,
                                   placeholderHeightAttr) {
    var testContainer = document.querySelector('#testContainer');
    var outerWidth = testContainer.getBoundingClientRect().width;
    var outerHeight = testContainer.getBoundingClientRect().height;

    SVGSizing.doCombinationTest(
        [["placeholder", [ placeholder ]],
         ["containerWidthStyle", [null, "400px"]],
         ["containerHeightStyle", [null, "400px"]],
         ["placeholderWidthAttr", [null, "100", "50%"]],
         ["placeholderHeightAttr", [placeholderHeightAttr]],
         ["svgViewBoxAttr", [ null, "0 0 100 200" ]],
         ["svgWidthAttr", [ null, "200", "25%" ]],
         ["svgHeightAttr", [ null, "200", "25%" ]]],
        function (config, id, cont) {
            var testData = new SVGSizing.TestData(config);
            var t = async_test(testData.name);
            var expectedRect =
                    testData.computeInlineReplacedSize(outerWidth, outerHeight);
            var placeholder = testData.buildSVGOrPlaceholder();
            var container =
                    testData.buildContainer(placeholder);

            var checkSize = function() {
                var placeholderRect =
                        placeholder.getBoundingClientRect();

                try {
                    assert_equals(placeholderRect.width,
                                  expectedRect.width,
                                  debugHint(id) + "Wrong width");
                    assert_equals(placeholderRect.height,
                                  expectedRect.height,
                                  debugHint(id) + "Wrong height");
                } finally {
                    testContainer.removeChild(container);
                    if (testSingleId)
                        document.body.removeChild(testContainer);
                    cont(id+1);
                }
                t.done();
            };

            if (!config.placeholder) {
                testContainer.appendChild(container);
                test(checkSize, testData.name);
            } else {
                t.step(function() {
                    placeholder.addEventListener('load', function() {
                        // setTimeout is a work-around to let engines
                        // finish layout of child browsing contexts even
                        // after the load event
                        setTimeout(t.step_func(checkSize), 0);
                    });
                    testContainer.appendChild(container);
                });
            }
            if (testSingleId == id)
                testData.buildDemo(expectedRect, id);
        }, testSingleId);
}
