/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Address;
import com.sun.electric.tool.simulation.acl2.mods.Aliaspair;
import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.ModInst;
import com.sun.electric.tool.simulation.acl2.mods.ModName;
import com.sun.electric.tool.simulation.acl2.mods.Module;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.mods.Wiretype;
import com.sun.electric.tool.simulation.acl2.modsext.parmods.coretype;
import com.sun.electric.tool.simulation.acl2.modsext.parmods.gate_buf;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.Vec2;
import com.sun.electric.tool.simulation.acl2.svex.Vec4;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec3Fix;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4BitExtract;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitand;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitnot;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitor;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Bitxor;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Concat;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Equality;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Ite;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4IteStmt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4PartSelect;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Plus;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ReductionOr;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Rsh;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4SignExt;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4ZeroExt;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Object;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ParameterizedModule {
    public final String libName;
    public final String modName;
    private final String paramPrefix;
    private final String paramDelim;
    private String curInstName;
    private Map<String, ACL2Object> params;
    private final Map<String, Name> names = new HashMap<String, Name>();
    private SvexManager<Address> sm;
    private final List<Wire> wires = new ArrayList<Wire>();
    private final List<ModInst> insts = new ArrayList<ModInst>();
    private final List<Assign<Address>> assigns = new ArrayList<Assign<Address>>();
    private final List<Aliaspair<Address>> aliaspairs = new ArrayList<Aliaspair<Address>>();

    public ParameterizedModule(String libName, String modName) {
        this(libName, modName, "$", "=");
    }

    protected ParameterizedModule(String libName, String modName, String paramPrefix, String paramDelim) {
        this.libName = libName;
        this.modName = modName;
        this.paramPrefix = paramPrefix;
        this.paramDelim = paramDelim;
    }

    public static List<ParameterizedModule> getStandardModules() {
        ArrayList<ParameterizedModule> result = new ArrayList<ParameterizedModule>();
        result.add(gate_buf.INSTANCE);
        result.add(coretype.INSTANCE);
        return result;
    }

    protected Map<String, ACL2Object> matchModName(ModName modName) {
        if (!modName.isString()) {
            return null;
        }
        String modNameStr = modName.toString();
        if (!modNameStr.startsWith(this.modName)) {
            return null;
        }
        String params = modNameStr.substring(this.modName.length());
        LinkedHashMap<String, ACL2Object> parMap = new LinkedHashMap<String, ACL2Object>();
        while (!params.isEmpty()) {
            String paramVal;
            String paramName;
            if (!params.startsWith(this.paramPrefix)) {
                return null;
            }
            int nextPrefix = (params = params.substring(this.paramPrefix.length())).indexOf(this.paramPrefix);
            if (nextPrefix < 0) {
                nextPrefix = params.length();
            }
            if (this.paramDelim != null) {
                int indDelim = params.lastIndexOf(this.paramDelim, nextPrefix - this.paramDelim.length());
                if (indDelim < 0) {
                    return null;
                }
                paramName = params.substring(0, indDelim);
                paramVal = params.substring(indDelim + this.paramDelim.length(), nextPrefix);
            } else {
                paramName = "";
                paramVal = params.substring(0, nextPrefix);
            }
            Integer defaultInt = this.getDefaultInt(paramName);
            if (defaultInt != null) {
                parMap.put(paramName, ACL2Object.valueOf(Integer.parseInt(paramVal)));
            } else {
                parMap.put(paramName, ACL2Object.valueOf(paramVal));
            }
            params = params.substring(nextPrefix);
        }
        return parMap;
    }

    protected boolean exportsAreStrings() {
        return true;
    }

    protected boolean hasState() {
        return false;
    }

    public boolean setCurBuilder(ModName modName, SvexManager<Address> sm) {
        this.clear();
        this.params = this.matchModName(modName);
        if (this.params != null) {
            this.sm = sm != null ? sm : new SvexManager();
            return true;
        }
        return false;
    }

    protected void clear() {
        this.sm = null;
        this.names.clear();
        this.wires.clear();
        this.insts.clear();
        this.assigns.clear();
        this.aliaspairs.clear();
        this.curInstName = null;
    }

    public String getModNameStr() {
        return this.modName;
    }

    protected Integer getDefaultInt(String paramName) {
        return null;
    }

    protected int getIntParam(String paramName) {
        ACL2Object val = this.getParam(paramName);
        return val != null ? val.intValueExact() : this.getDefaultInt(paramName).intValue();
    }

    protected String getStrParam(String paramName) {
        ACL2Object val = this.getParam(paramName);
        return val != null ? val.stringValueExact() : null;
    }

    protected ACL2Object getParam(String paramName) {
        return this.params.get(paramName);
    }

    private Name getName(String nameStr) {
        Name name = this.names.get(nameStr);
        if (name == null) {
            name = Name.fromACL2(ACL2.honscopy(ACL2Object.valueOf(nameStr)));
            this.names.put(nameStr, name);
        }
        return name;
    }

    protected void wire(String wireName, int width) {
        this.wire(this.getName(wireName), width, 0);
    }

    protected void wire(Name name, int width, int lowIdx) {
        this.wires.add(new Wire(name, width, lowIdx, 0, false, Wiretype.WIRE));
    }

    protected void input(String wireName, int width) {
        this.wire(wireName, width);
    }

    protected void global(String wireName, int width) {
        this.wire(wireName, width);
    }

    protected void output(String wireName, int width) {
        this.wire(wireName, width);
    }

    protected void unused(String wireName, int width) {
        this.wire(wireName, width);
    }

    protected void unused(Name name, int width) {
        this.wire(name, width, 0);
    }

    protected void instance(String instName, ModName modName) {
        this.insts.add(new ModInst(this.getName(instName), modName));
        this.curInstName = instName;
    }

    public void instance(ModName modName, String instName) {
    }

    protected void instance(String instName, String modName) {
        this.instance(instName, ModName.fromACL2(ACL2Object.valueOf(modName)));
    }

    protected Lhrange<Address> r(String wireName, int msb, int lsb) {
        return this.r(this.getName(wireName), msb, lsb);
    }

    protected Lhrange<Address> r(Name wireName, int msb, int lsb) {
        Path path = Path.simplePath(wireName);
        Address address = Address.valueOf(path);
        Svar<Address> svar = this.sm.getVar(address);
        return this.r(svar, msb, lsb);
    }

    protected Lhrange<Address> r(String instName, String portName, int msb, int lsb) {
        Path path = Path.makePath(Collections.singletonList(this.getName(instName)), this.getName(portName));
        Address address = Address.valueOf(path);
        Svar<Address> svar = this.sm.getVar(address);
        return this.r(svar, msb, lsb);
    }

    private Lhrange<Address> r(Svar<Address> svar, int msb, int lsb) {
        int width = msb - lsb + 1;
        if (width <= 0) {
            throw new IllegalArgumentException();
        }
        return new Lhrange<Address>(width, Lhatom.valueOf(svar, lsb));
    }

    protected Svex<Address> unfloat(Svex<Address> x) {
        return this.sm.newCall(Vec3Fix.FUNCTION, x);
    }

    protected Svex<Address> uor(Svex<Address> x) {
        return this.sm.newCall(Vec4ReductionOr.FUNCTION, x);
    }

    protected Svex<Address> ite(Svex<Address> test, Svex<Address> th, Svex<Address> el) {
        return this.sm.newCall(Vec4Ite.FUNCTION, test, th, el);
    }

    protected Svex<Address> iteStmt(Svex<Address> test, Svex<Address> th, Svex<Address> el) {
        return this.sm.newCall(Vec4IteStmt.FUNCTION, test, th, el);
    }

    protected Svex<Address> bitnot(Svex<Address> x) {
        return this.sm.newCall(Vec4Bitnot.FUNCTION, x);
    }

    protected Svex<Address> bitnotE(int width, Svex<Address> x) {
        return this.zext(this.q(width), this.bitnot(x));
    }

    protected Svex<Address> bitnotE(Svex<Address> x) {
        return this.bitnotE(1, x);
    }

    protected Svex<Address> bitand(Svex<Address> x, Svex<Address> y) {
        return this.sm.newCall(Vec4Bitand.FUNCTION, x, y);
    }

    @SafeVarargs
    protected final Svex<Address> bitandE(int width, Svex<Address> ... x) {
        Svex<Address> result = null;
        for (Svex<Address> xi : x) {
            result = result != null ? this.zext(this.q(width), this.bitand(result, xi)) : xi;
        }
        return result;
    }

    @SafeVarargs
    protected final Svex<Address> bitandE(Svex<Address> ... x) {
        return this.bitandE(1, x);
    }

    protected Svex<Address> bitor(Svex<Address> x, Svex<Address> y) {
        return this.sm.newCall(Vec4Bitor.FUNCTION, x, y);
    }

    @SafeVarargs
    protected final Svex<Address> bitorE(int width, Svex<Address> ... x) {
        Svex<Address> result = null;
        for (Svex<Address> xi : x) {
            result = result != null ? this.zext(this.q(width), this.bitor(result, xi)) : xi;
        }
        return result;
    }

    @SafeVarargs
    protected final Svex<Address> bitorE(Svex<Address> ... x) {
        return this.bitorE(1, x);
    }

    protected Svex<Address> bitxor(Svex<Address> x, Svex<Address> y) {
        return this.sm.newCall(Vec4Bitxor.FUNCTION, x, y);
    }

    @SafeVarargs
    protected final Svex<Address> bitxorE(int width, Svex<Address> ... x) {
        Svex<Address> result = null;
        for (Svex<Address> xi : x) {
            result = result != null ? this.zext(this.q(width), this.bitxor(result, xi)) : xi;
        }
        return result;
    }

    protected Svex<Address> bitxorE(int width, List<Svex<Address>> x) {
        return this.bitxorE(width, x.toArray(Svex.newSvexArray(x.size())));
    }

    @SafeVarargs
    protected final Svex<Address> bitxorE(Svex<Address> ... x) {
        return this.bitxorE(1, x);
    }

    protected Svex<Address> plus(Svex<Address> x, Svex<Address> y) {
        return this.sm.newCall(Vec4Plus.FUNCTION, x, y);
    }

    protected Svex<Address> eq(Svex<Address> x, Svex<Address> y) {
        return this.sm.newCall(Vec4Equality.FUNCTION, x, y);
    }

    protected Svex<Address> concat(Svex<Address> n, Svex<Address> lower, Svex<Address> upper) {
        return this.sm.newCall(Vec4Concat.FUNCTION, n, lower, upper);
    }

    protected Svex<Address> bitExtract(Svex<Address> index, Svex<Address> x) {
        return this.sm.newCall(Vec4BitExtract.FUNCTION, index, x);
    }

    protected Svex<Address> partSelect(Svex<Address> lsb, Svex<Address> width, Svex<Address> x) {
        return this.sm.newCall(Vec4PartSelect.FUNCTION, lsb, width, x);
    }

    protected Svex<Address> rsh(Svex<Address> n, Svex<Address> x) {
        return this.sm.newCall(Vec4Rsh.FUNCTION, n, x);
    }

    protected Svex<Address> zext(Svex<Address> n, Svex<Address> x) {
        return this.sm.newCall(Vec4ZeroExt.FUNCTION, n, x);
    }

    protected Svex<Address> sext(Svex<Address> n, Svex<Address> x) {
        return this.sm.newCall(Vec4SignExt.FUNCTION, n, x);
    }

    protected Svex<Address> q(int val) {
        return this.q(Vec2.valueOf(val));
    }

    protected Svex<Address> q(int upper, int lower) {
        return this.q(Vec4.valueOf(BigInteger.valueOf(upper), BigInteger.valueOf(lower)));
    }

    protected Svex<Address> q(Vec4 val) {
        return SvexQuote.valueOf(val);
    }

    protected Svex<Address> v(String wireName) {
        return this.v(wireName, 0);
    }

    protected Svex<Address> v(String wireName, int delay) {
        Name name = this.getName(wireName);
        Path path = Path.simplePath(name);
        Address address = Address.valueOf(path);
        return this.sm.getSvex(address, delay, false);
    }

    protected Svex<Address> vE(String wireName) {
        return this.zext(this.q(1), this.v(wireName, 0));
    }

    protected void assign(String wireName, int width, Svex<Address> svex) {
        this.assign(this.r(wireName, width - 1, 0), svex);
    }

    protected void assign(String instName, String portName, int width, Svex<Address> svex) {
        this.assign(this.r(instName, portName, width - 1, 0), svex);
    }

    protected void assign(Lhrange<Address> range, Svex<Address> svex) {
        this.assign(new Lhs<Address>(Arrays.asList(range)), svex);
    }

    protected void assign(Lhrange<Address> upperRange, Lhrange<Address> lowerRange, Svex<Address> svex) {
        this.assign(new Lhs<Address>(Arrays.asList(lowerRange, upperRange)), svex);
    }

    private void assign(Lhs<Address> lhs, Svex<Address> svex) {
        Driver<Address> driver = new Driver<Address>(svex);
        Assign<Address> assign = new Assign<Address>(lhs, driver);
        this.assigns.add(assign);
    }

    @SafeVarargs
    protected final void conn(String portName, Lhrange<Address> ... ranges) {
        this.conn(this.curInstName, portName, ranges);
    }

    protected void conn(String portName, String wireName, int width) {
        this.conn(portName, this.r(wireName, width - 1, 0));
    }

    @SafeVarargs
    private final void conn(String instName, String portName, Lhrange<Address> ... ranges) {
        int width = 0;
        for (Lhrange<Address> range : ranges) {
            width += range.getWidth();
        }
        Lhrange<Address> lrange = this.r(instName, portName, width - 1, 0);
        this.conn(lrange, ranges);
    }

    @SafeVarargs
    protected final void conn(Lhrange<Address> lrange, Lhrange<Address> ... ranges) {
        Lhs lhs = new Lhs(Arrays.asList(lrange));
        Lhs rhs = new Lhs(Arrays.asList(ranges));
        Util.check(lhs.width() == rhs.width());
        Aliaspair aliaspair = new Aliaspair(lhs, rhs);
        this.aliaspairs.add(aliaspair);
    }

    protected Module<Address> getModule() {
        return new Module<Address>(this.sm, this.wires, this.insts, this.assigns, this.aliaspairs);
    }

    protected Module<Address> genModule() {
        return null;
    }

    protected String[] genDepModNameStrings() {
        return new String[0];
    }

    protected ModName[] genDepModNames() {
        String[] modNameStrings = this.genDepModNameStrings();
        ModName[] result = new ModName[modNameStrings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ModName.valueOf(modNameStrings[i]);
        }
        return result;
    }

    protected ModInst[] genAllModInsts(ModName[] n) {
        Util.check(n.length == 0);
        return new ModInst[0];
    }

    protected int getNumInsts() {
        return 0;
    }

    protected int getNumAssigns() {
        return 1;
    }

    protected int getTotalInsts() {
        return this.genAllModInsts(this.genDepModNames()).length;
    }

    protected int getTotalAssigns() {
        return 1;
    }

    protected static Lhs<IndexName> aliasWire(List<Lhs<IndexName>> arr, SvexManager<IndexName> sm, int width) {
        IndexName name = IndexName.valueOf(arr.size());
        Svar<IndexName> svar = sm.getVar(name);
        Lhatom<IndexName> atom = Lhatom.valueOf(svar);
        Lhrange<IndexName> range = new Lhrange<IndexName>(width, atom);
        Lhs<IndexName> lhs = new Lhs<IndexName>(Collections.singletonList(range));
        arr.add(lhs);
        return lhs;
    }

    protected static Lhs<IndexName> aliasWire(List<Lhs<IndexName>> arr, SvexManager<IndexName> sm, int width, int offset) {
        IndexName name = IndexName.valueOf(arr.size() + offset);
        Svar<IndexName> svar = sm.getVar(name);
        Lhatom<IndexName> atom = Lhatom.valueOf(svar);
        Lhrange<IndexName> range = new Lhrange<IndexName>(width, atom);
        Lhs<IndexName> lhs = new Lhs<IndexName>(Collections.singletonList(range));
        return lhs;
    }

    protected static Lhs<IndexName> aliasRange(Lhs<IndexName> in, int width, int rsh) {
        return in.rsh(rsh).concat(width, Lhs.empty());
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterizedModule) {
            ParameterizedModule that = (ParameterizedModule)o;
            return this.modName.equals(that.modName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.modName.hashCode();
        return hash;
    }

    public String toString() {
        return this.libName.isEmpty() ? this.modName : this.libName + "." + this.modName;
    }
}

