/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.flag.FlagConfig;
import com.sun.electric.tool.generator.flag.LayoutNetlist;
import com.sun.electric.tool.generator.flag.Utils;
import com.sun.electric.tool.generator.flag.router.Blockage1D;
import com.sun.electric.tool.generator.flag.router.Channel;
import com.sun.electric.tool.generator.flag.router.Interval;
import com.sun.electric.tool.generator.flag.router.LayerChannels;
import com.sun.electric.tool.generator.flag.router.Segment;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.generator.flag.scan.Scan;
import com.sun.electric.tool.generator.layout.AbutRouter;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Router {
    public static final double DEF_SIZE = Double.POSITIVE_INFINITY;
    private final FlagConfig config;
    private final Scan scan;
    private final EditingPreferences ep;

    private TechType tech() {
        return this.config.tech();
    }

    public EditingPreferences getEditingPreferences() {
        return this.ep;
    }

    private void prln(String s2) {
        Utils.prln(s2);
    }

    private void pr(String s2) {
        Utils.pr(s2);
    }

    private void error(boolean cond, String msg) {
        Utils.error(cond, msg);
    }

    private void saveTaskDescription(String s2) {
        Utils.saveTaskDescription(s2);
    }

    private void clearTaskDescription() {
        Utils.clearTaskDescription();
    }

    private void sortLeftToRight(List<PortInfo> pis) {
        Collections.sort(pis, new Comparator<PortInfo>(){

            @Override
            public int compare(PortInfo p1, PortInfo p2) {
                double diff2 = p1.portInst.getCenter().getX() - p2.portInst.getCenter().getX();
                return (int)Math.signum(diff2);
            }
        });
    }

    private void sortBotToTop(List<PortInfo> pis) {
        Collections.sort(pis, new Comparator<PortInfo>(){

            @Override
            public int compare(PortInfo p1, PortInfo p2) {
                double diff2 = p1.portInst.getCenter().getY() - p2.portInst.getCenter().getY();
                return (int)Math.signum(diff2);
            }
        });
    }

    private void blockInvisibleM3(Blockage1D m3block, double xLeft) {
        double pitch = this.config.m3PwrGndPitch;
        for (int i = 0; i < 36; ++i) {
            double x = xLeft + pitch / 2.0 + pitch * (double)i;
            m3block.block(x - this.config.m3PwrGndWid / 2.0, x + this.config.m3PwrGndWid / 2.0);
        }
    }

    private void blockInvisibleM2(LayerChannels m2Chnls, Rectangle2D bounds) {
        double[] yBlocks;
        double xCenter = bounds.getCenterX();
        for (double y : yBlocks = new double[]{-44.0, 228.0, 476.0, 716.0}) {
            Channel m2ch = m2Chnls.findChanOverVertInterval(xCenter, y, y);
            Segment s2 = m2ch.allocate(m2ch.getMinTrackEnd() + 6.0, m2ch.getMaxTrackEnd() - 6.0, y, y);
            this.prln("Blocking m2: " + s2.toString());
        }
    }

    private void findChannels(LayerChannels m2Chnls, LayerChannels m3Chnls, List<NodeInst> stages) {
        Rectangle2D colBounds = Utils.findBounds(stages.get(0).getParent());
        Blockage1D m2block = new Blockage1D();
        Blockage1D m3block = new Blockage1D();
        for (NodeInst ni : stages) {
            Iterator<PortInst> piIt = ni.getPortInsts();
            while (piIt.hasNext()) {
                PortInst pi = piIt.next();
                double x = pi.getCenter().getX();
                double y = pi.getCenter().getY();
                if (!Utils.isPwrGnd(pi) && !this.scan.isScan(pi)) continue;
                if (this.connectsToM2(pi)) {
                    m2block.block(y - this.config.m2PwrGndWid / 2.0, y + this.config.m2PwrGndWid / 2.0);
                    continue;
                }
                if (this.connectsToM3(pi)) {
                    m3block.block(x - this.config.m3PwrGndWid / 2.0, x + this.config.m3PwrGndWid / 2.0);
                    continue;
                }
                this.error(true, "unexpected metal for port: " + pi.toString());
            }
        }
        this.blockInvisibleM3(m3block, colBounds.getMinX());
        Interval prv = null;
        for (Interval i : m2block.getBlockages()) {
            if (prv != null) {
                m2Chnls.add(new Channel(true, colBounds.getMinX(), colBounds.getMaxX(), prv.getMax(), i.getMin(), "metal-2"));
            }
            prv = i;
        }
        this.blockInvisibleM2(m2Chnls, colBounds);
        prv = null;
        for (Interval i : m3block.getBlockages()) {
            double prvMax = prv == null ? colBounds.getMinX() : prv.getMax();
            m3Chnls.add(new Channel(false, colBounds.getMinY(), colBounds.getMaxY(), prvMax, i.getMin(), "metal-3"));
            prv = i;
        }
        Interval last2 = prv;
        m3Chnls.add(new Channel(false, colBounds.getMinY(), colBounds.getMaxY(), last2.getMax(), colBounds.getMaxX(), "metal-3"));
        this.prln("Found: " + m2Chnls.numChannels() + " metal-2 channels");
        this.prln("Found: " + m3Chnls.numChannels() + " metal-3 channels");
    }

    private void routeTwoOrThreePinNet(ToConnect toConn, LayerChannels m2Chan, LayerChannels m3Chan) {
        if (toConn.numPortInsts() == 2) {
            this.routeTwoPinNet(toConn, m2Chan, m3Chan);
        }
        if (toConn.numPortInsts() == 3) {
            this.routeThreePinNet(toConn, m2Chan, m3Chan);
        }
    }

    private void routeThreePinNet(ToConnect toConn, LayerChannels m2Chan, LayerChannels m3Chan) {
        this.saveTaskDescription("Connecting three pins: " + toConn);
        List<PortInst> pis = toConn.getPortInsts();
        ArrayList<PortInfo> infos = new ArrayList<PortInfo>();
        for (PortInst pi : pis) {
            PortInfo inf = new PortInfo(pi, m2Chan);
            if (inf.m2Chan == null) {
                return;
            }
            infos.add(inf);
        }
        this.sortLeftToRight(infos);
        PortInfo infoL = (PortInfo)infos.get(0);
        PortInfo infoLR = (PortInfo)infos.get(1);
        PortInfo infoR = (PortInfo)infos.get(2);
        this.sortBotToTop(infos);
        PortInfo infoB = (PortInfo)infos.get(0);
        PortInfo infoT = (PortInfo)infos.get(2);
        for (PortInfo inf : infos) {
            inf.getM2OnlySeg(infoL.x, infoR.x);
        }
        for (int i = 0; i < infos.size(); ++i) {
            PortInfo inf1 = (PortInfo)infos.get(i);
            for (int j = i + 1; j < infos.size(); ++j) {
                PortInfo inf2 = (PortInfo)infos.get(j);
                if (inf1.m2Chan != inf2.m2Chan || inf1.m2Seg != null && inf2.m2Seg != null) continue;
                if (inf1.m2Seg == null && inf2.m2Seg != null) {
                    inf2.m2Seg = inf1.m2Seg;
                    continue;
                }
                if (inf1.m2Seg != null && inf2.m2Seg == null) {
                    inf2.m2Seg = inf1.m2Seg;
                    continue;
                }
                inf1.m2Seg = inf2.m2Seg = inf1.m2Chan.allocate(infoL.x, infoR.x, inf1.y, inf2.y);
                if (inf1.m2Seg != null) continue;
                return;
            }
        }
        Channel c3 = m3Chan.findVertBridge(infoB.m2Chan, infoT.m2Chan, infoL.x, infoR.x);
        if (c3 == null) {
            this.prln("no m3 channel");
            return;
        }
        Segment m3Seg = c3.allocate(infoB.m2Chan.getMinTrackCenter(), infoT.m2Chan.getMaxTrackCenter(), infoL.x, infoR.x);
        if (m3Seg == null) {
            return;
        }
        for (PortInfo inf : infos) {
            if (inf.m2Seg != null) continue;
            inf.m2Seg = inf.m2Chan.allocate(infoL.x, infoR.x, infoB.y, infoT.y);
            if (inf.m2Seg != null) continue;
            return;
        }
        this.routeUseM3(infoL.portInst, infoLR.portInst, infoL.m2Seg, infoLR.m2Seg, m3Seg);
        this.routeUseM3(infoLR.portInst, infoR.portInst, infoLR.m2Seg, infoR.m2Seg, m3Seg);
        this.clearTaskDescription();
    }

    private void routeTwoPinNet(ToConnect toConn, LayerChannels m2Chan, LayerChannels m3Chan) {
        List<PortInst> pis = toConn.getPortInsts();
        this.saveTaskDescription("Connecting two pins: " + toConn);
        ArrayList<PortInfo> infos = new ArrayList<PortInfo>();
        for (PortInst pi : pis) {
            PortInfo inf = new PortInfo(pi, m2Chan);
            if (inf.m2Chan == null) {
                return;
            }
            infos.add(inf);
        }
        this.sortLeftToRight(infos);
        PortInfo infoL = (PortInfo)infos.get(0);
        PortInfo infoR = (PortInfo)infos.get(1);
        for (PortInfo inf : infos) {
            inf.getM2OnlySeg(infoL.x, infoR.x);
        }
        Segment s3 = null;
        if (infoL.m2Chan == infoR.m2Chan && (infoL.m2Seg == null || infoR.m2Seg == null)) {
            if (infoL.m2Seg == null && infoR.m2Seg != null) {
                infoR.m2Seg = infoL.m2Seg;
            } else if (infoL.m2Seg != null && infoR.m2Seg == null) {
                infoR.m2Seg = infoL.m2Seg;
            } else if (infoL.m2Seg == null && infoR.m2Seg == null) {
                infoL.m2Seg = infoR.m2Seg = infoL.m2Chan.allocate(infoL.x, infoR.x, infoL.y, infoR.y);
                if (infoL.m2Seg == null) {
                    return;
                }
            }
        } else {
            Channel c3 = m3Chan.findVertBridge(infoL.m2Chan, infoR.m2Chan, infoL.x, infoR.x);
            if (c3 == null) {
                this.prln("no m3 channel");
                return;
            }
            for (PortInfo inf : infos) {
                if (inf.m2Seg != null) continue;
                double minX = Math.min(c3.getMinTrackCenter(), infoL.x);
                double maxX = Math.max(c3.getMaxTrackCenter(), infoR.x);
                inf.m2Seg = inf.m2Chan.allocate(minX, maxX, infoL.y, infoR.y);
                if (inf.m2Seg != null) continue;
                return;
            }
            double minY = Math.min(infoL.m2Seg.getTrackCenter(), infoR.m2Seg.getTrackCenter());
            double maxY = Math.max(infoL.m2Seg.getTrackCenter(), infoR.m2Seg.getTrackCenter());
            s3 = c3.allocate(minY, maxY, infoL.x, infoR.x);
            infoL.m2Seg.trim(infoL.x - this.config.trackPitch, s3.getTrackCenter() + this.config.trackPitch);
            infoR.m2Seg.trim(s3.getTrackCenter() - this.config.trackPitch, infoR.x + this.config.trackPitch);
        }
        this.routeUseM3(infoL.portInst, infoR.portInst, infoL.m2Seg, infoR.m2Seg, s3);
        this.clearTaskDescription();
    }

    private void routeUseM3(PortInst pL, PortInst pR, Segment m2L, Segment m2R, Segment m3) {
        if (m2L == null) {
            this.prln("no m2 track for left PortInst");
        }
        if (m2R == null) {
            this.prln("no m2 track for right PortInst");
        }
        if (m3 == null) {
            this.prln("no m3 track");
        }
        if (m2L == null || m2R == null || m3 == null) {
            return;
        }
        PortInst m2PortA = null;
        Cell parent = pL.getNodeInst().getParent();
        if (this.connectsToM1(pL)) {
            NodeInst m1m2a = LayoutLib.newNodeInst(this.tech().m1m2(), this.ep, pL.getCenter().getX(), m2L.getTrackCenter(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            LayoutLib.newArcInst(this.tech().m1(), this.ep, this.config.signalWid, pL, m1m2a.getOnlyPortInst());
            m2PortA = m1m2a.getOnlyPortInst();
        } else {
            m2PortA = pL;
        }
        PortInst m2PortB = null;
        if (this.connectsToM1(pR)) {
            NodeInst m1m2b = LayoutLib.newNodeInst(this.tech().m1m2(), this.ep, pR.getCenter().getX(), m2R.getTrackCenter(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            LayoutLib.newArcInst(this.tech().m1(), this.ep, this.config.signalWid, m1m2b.getOnlyPortInst(), pR);
            m2PortB = m1m2b.getOnlyPortInst();
        } else {
            m2PortB = pR;
        }
        if (m3 != null) {
            NodeInst m2m3a = LayoutLib.newNodeInst(this.tech().m2m3(), this.ep, m3.getTrackCenter(), m2L.getTrackCenter(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            this.newM2SignalWire(m2PortA, m2m3a.getOnlyPortInst());
            NodeInst m2m3b = LayoutLib.newNodeInst(this.tech().m2m3(), this.ep, m3.getTrackCenter(), m2R.getTrackCenter(), Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            LayoutLib.newArcInst(this.tech().m3(), this.ep, this.config.signalWid, m2m3a.getOnlyPortInst(), m2m3b.getOnlyPortInst());
            this.newM2SignalWire(m2m3b.getOnlyPortInst(), m2PortB);
        } else {
            this.newM2SignalWire(m2PortA, m2PortB);
        }
    }

    public void newM2SignalWire(PortInst p1, PortInst p2) {
        PortInst pR;
        PortInst pL;
        if (p1.getCenter().getX() < p2.getCenter().getX()) {
            pL = p1;
            pR = p2;
        } else {
            pL = p2;
            pR = p1;
        }
        Cell parent = pL.getNodeInst().getParent();
        double y = p1.getCenter().getY();
        double yR = p2.getCenter().getY();
        this.error(y != yR, "M2 must be horizontal");
        double xL = pL.getCenter().getX();
        double xR = pR.getCenter().getX();
        double len = xR - xL;
        double extend = this.config.minM2Len - (len + this.config.signalWid);
        if (extend > 0.0) {
            double halfExt = Math.ceil(10.0 * extend / 2.0) / 10.0;
            NodeInst pin1 = LayoutLib.newNodeInst(this.tech().m2pin(), this.ep, xL - halfExt, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            NodeInst pin2 = LayoutLib.newNodeInst(this.tech().m2pin(), this.ep, xR + halfExt, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            LayoutLib.newArcInst(this.tech().m2(), this.ep, this.config.signalWid, pin1.getOnlyPortInst(), pL);
            LayoutLib.newArcInst(this.tech().m2(), this.ep, this.config.signalWid, pR, pin2.getOnlyPortInst());
        }
        LayoutLib.newArcInst(this.tech().m2(), this.ep, this.config.signalWid, pL, pR);
    }

    private boolean connectsToM1(PortProto pp) {
        return pp.connectsTo(this.tech().m1());
    }

    private boolean connectsToM1(PortInst pi) {
        return this.connectsToM1(pi.getPortProto());
    }

    private boolean connectsToM2(PortProto pp) {
        return pp.connectsTo(this.tech().m2());
    }

    public boolean connectsToM2(PortInst pi) {
        return this.connectsToM2(pi.getPortProto());
    }

    private boolean connectsToM3(PortProto pp) {
        return pp.connectsTo(this.tech().m3());
    }

    public boolean connectsToM3(PortInst pi) {
        return this.connectsToM3(pi.getPortProto());
    }

    private boolean hasM2Pin(ToConnect toConn) {
        for (PortInst pi : toConn.getPortInsts()) {
            if (!this.connectsToM2(pi)) continue;
            return true;
        }
        return false;
    }

    private boolean hasM3Pin(ToConnect toConn) {
        for (PortInst pi : toConn.getPortInsts()) {
            if (!this.connectsToM3(pi)) continue;
            return true;
        }
        return false;
    }

    public void connectPwrGnd(List<NodeInst> nodeInsts) {
        ArrayList<ArcProto> vertLayers = new ArrayList<ArcProto>();
        vertLayers.add(this.tech().m3());
        NodeInst prev = null;
        for (NodeInst ni : nodeInsts) {
            if (prev != null) {
                AbutRouter.abutRouteBotTop(prev, ni, 0.0, vertLayers, this.ep);
            }
            prev = ni;
        }
    }

    public Router(FlagConfig config, Scan scan2, EditingPreferences ep) {
        this.config = config;
        this.scan = scan2;
        this.ep = ep;
    }

    public PortInst raiseToM3(PortInst pi) {
        if (this.connectsToM3(pi)) {
            return pi;
        }
        if (this.connectsToM2(pi)) {
            double x = pi.getBounds().getCenterX();
            double y = pi.getBounds().getCenterY();
            Cell parent = pi.getNodeInst().getParent();
            NodeInst via = LayoutLib.newNodeInst(this.tech().m2m3(), this.ep, x, y, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, parent);
            this.newM2SignalWire(pi, via.getOnlyPortInst());
            return via.getOnlyPortInst();
        }
        Utils.error(true, "scan port on other than m2 or m3?");
        return null;
    }

    private List<List<PortInst>> groupConnectedPorts(ToConnect tc) {
        PortInst firstPi = tc.getPortInsts().get(0);
        Cell parent = firstPi.getNodeInst().getParent();
        Netlist nl = parent.getNetlist(Netlist.ShortResistors.PARASITIC);
        HashMap<Network, ArrayList<PortInst>> netToPorts = new HashMap<Network, ArrayList<PortInst>>();
        for (PortInst pi : tc.getPortInsts()) {
            Network n = nl.getNetwork(pi);
            ArrayList<PortInst> ports = (ArrayList<PortInst>)netToPorts.get(n);
            if (ports == null) {
                ports = new ArrayList<PortInst>();
                netToPorts.put(n, ports);
            }
            ports.add(pi);
        }
        ArrayList<List<PortInst>> groupedPorts = new ArrayList<List<PortInst>>();
        for (Network n : netToPorts.keySet()) {
            groupedPorts.add((List<PortInst>)netToPorts.get(n));
        }
        return groupedPorts;
    }

    private double manhDist(PortInst pi1, PortInst pi2) {
        return Math.abs(pi1.getCenter().getX() - pi2.getCenter().getX()) + Math.abs(pi1.getCenter().getY() - pi2.getCenter().getY());
    }

    private PortPair findClosest(List<PortInst> pl1, List<PortInst> pl2) {
        PortPair closest = new PortPair();
        closest.dist = Double.MAX_VALUE;
        for (PortInst p1 : pl1) {
            for (PortInst p2 : pl2) {
                double d = this.manhDist(p1, p2);
                if (!(d < closest.dist)) continue;
                closest.dist = d;
                closest.p1 = p1;
                closest.p2 = p2;
            }
        }
        this.error(closest.dist == Double.MAX_VALUE, "empty port lists?");
        return closest;
    }

    private ClosestClusters findClosest(List<List<PortInst>> portLists) {
        ClosestClusters closest = new ClosestClusters();
        closest.pair.dist = Double.MAX_VALUE;
        for (int i = 0; i < portLists.size(); ++i) {
            for (int j = i + 1; j < portLists.size(); ++j) {
                PortPair pair = this.findClosest(portLists.get(i), portLists.get(j));
                if (!(pair.dist < closest.pair.dist)) continue;
                closest.pair = pair;
                closest.ndx1 = i;
                closest.ndx2 = j;
            }
        }
        return closest;
    }

    private void dumpConnPorts(List<List<PortInst>> connPorts) {
        this.prln("Clustered port connections:");
        for (List<PortInst> ports : connPorts) {
            this.pr("    cluster: ");
            for (PortInst port : ports) {
                this.pr(port.toString() + " ");
            }
            this.prln("");
        }
    }

    private boolean isSimple(List<List<PortInst>> connPorts) {
        if (connPorts.isEmpty() || connPorts.size() == 1) {
            return true;
        }
        if (connPorts.size() == 2 || connPorts.size() == 3) {
            for (List<PortInst> ports : connPorts) {
                if (ports.size() == 1) continue;
                this.prln("Can't handle pre-connected PortInsts");
                this.dumpConnPorts(connPorts);
                return false;
            }
            return true;
        }
        this.prln("Can't handle Nets that connect more than three PortInsts:");
        this.dumpConnPorts(connPorts);
        return false;
    }

    private List<ToConnect> reduceToTwoOrThreePin(List<ToConnect> toConns) {
        ArrayList<ToConnect> twoOrThreePin = new ArrayList<ToConnect>();
        for (ToConnect tc : toConns) {
            if (tc.numPortInsts() == 0) continue;
            List<List<PortInst>> connPorts = this.groupConnectedPorts(tc);
            if (connPorts.size() == 2) {
                connPorts = this.makeTwoClusterSimple(connPorts);
            }
            if (!this.isSimple(connPorts) || connPorts.size() != 2 && connPorts.size() != 3) continue;
            ToConnect tcX = new ToConnect();
            for (List<PortInst> ports : connPorts) {
                this.error(ports.size() != 1, "We only allow one port per cluster");
                tcX.addPortInst(ports.get(0));
            }
            twoOrThreePin.add(tcX);
        }
        return twoOrThreePin;
    }

    private List<List<PortInst>> makeTwoClusterSimple(List<List<PortInst>> portLists) {
        this.error(portLists.size() != 2, "only handle 2 clusters");
        ClosestClusters cc = this.findClosest(portLists);
        ArrayList<List<PortInst>> pls = new ArrayList<List<PortInst>>();
        ArrayList<PortInst> pl = new ArrayList<PortInst>();
        pl.add(cc.pair.p1);
        pls.add(pl);
        pl = new ArrayList();
        pl.add(cc.pair.p2);
        pls.add(pl);
        return pls;
    }

    private void getM3PwrGndExports(Map<Double, PortInst> pwr, Map<Double, PortInst> gnd, NodeInst ni, double y) {
        Iterator<PortInst> piIt = ni.getPortInsts();
        while (piIt.hasNext()) {
            PortInst pi = piIt.next();
            if (pi.getCenter().getY() != y || !this.connectsToM3(pi)) continue;
            double x = pi.getCenter().getX();
            if (Utils.isPwr(pi)) {
                pwr.put(x, pi);
                continue;
            }
            if (!Utils.isGnd(pi)) continue;
            gnd.put(x, pi);
        }
    }

    private void route(List<ToConnect> toConns, LayerChannels m2Chan, LayerChannels m3Chan) {
        for (ToConnect toConn : toConns) {
            if (!this.hasM2Pin(toConn)) continue;
            this.routeTwoOrThreePinNet(toConn, m2Chan, m3Chan);
        }
        for (ToConnect toConn : toConns) {
            if (this.hasM2Pin(toConn) || this.hasM3Pin(toConn)) continue;
            this.routeTwoOrThreePinNet(toConn, m2Chan, m3Chan);
        }
    }

    public void routeSignals(List<ToConnect> toConns, LayoutNetlist layNets) {
        List<NodeInst> layInsts = layNets.getLayoutInstancesSortedBySchematicPosition();
        if (layInsts.isEmpty()) {
            return;
        }
        List<ToConnect> twoOrThreePins = this.reduceToTwoOrThreePin(toConns);
        LayerChannels m2chan = new LayerChannels();
        LayerChannels m3chan = new LayerChannels();
        this.findChannels(m2chan, m3chan, layInsts);
        this.route(twoOrThreePins, m2chan, m3chan);
    }

    private static class ClosestClusters {
        public int ndx1;
        public int ndx2;
        public PortPair pair = new PortPair();

        private ClosestClusters() {
        }
    }

    private static class PortPair {
        public PortInst p1;
        public PortInst p2;
        public double dist;

        private PortPair() {
        }
    }

    private class PortInfo {
        public final PortInst portInst;
        public final double x;
        public final double y;
        public final double maxY;
        public final double minY;
        public final Channel m2Chan;
        public Segment m2Seg;

        public PortInfo(PortInst pi, LayerChannels m2Chans) {
            this.portInst = pi;
            this.x = pi.getCenter().getX();
            this.y = pi.getCenter().getY();
            this.maxY = this.y + ((Router)Router.this).config.pinHeight;
            this.minY = this.y - ((Router)Router.this).config.pinHeight;
            this.m2Chan = m2Chans.findChanOverVertInterval(this.x, this.minY, this.maxY);
            if (this.m2Chan == null) {
                Router.this.prln("no m2 channel for PortInst: " + pi.toString());
                Router.this.prln(m2Chans.toString());
            }
        }

        public void getM2OnlySeg(double xL, double xR) {
            if (Router.this.connectsToM2(this.portInst)) {
                this.m2Seg = this.m2Chan.allocateBiggestFromTrack(xL - ((Router)Router.this).config.trackPitch, this.x, xR + ((Router)Router.this).config.trackPitch, this.y);
                if (this.m2Seg == null) {
                    Router.this.prln("failed to get segment for m2-only PortInst: center=" + this.y + "[" + (xL - ((Router)Router.this).config.trackPitch) + ", " + (xR + ((Router)Router.this).config.trackPitch) + "]");
                    Router.this.prln(this.m2Chan.toString());
                }
            }
        }
    }
}

