/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import com.sun.electric.tool.ncc.result.PortReport;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.user.ncc.ExportMismatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportChecker {
    private NccGlobals globals;
    private HashMap<Port, Port>[] equivPortMaps;
    private NoPortNameMatches noPortNameMatches = new NoPortNameMatches();

    private Port[][] getPortsForEachCell() {
        int numCells = this.globals.getNumNetlistsBeingCompared();
        Port[][] portsPerCell = new Port[numCells][];
        EquivRecord portRec = this.globals.getPorts();
        if (portRec == null) {
            for (int i = 0; i < numCells; ++i) {
                portsPerCell[i] = new Port[0];
            }
        } else {
            this.globals.error(!portRec.isLeaf(), "globals ports must hold circuits");
            int cellNdx = 0;
            Iterator<Circuit> it = portRec.getCircuits();
            while (it.hasNext()) {
                Circuit ckt = it.next();
                portsPerCell[cellNdx] = new Port[ckt.numNetObjs()];
                int portNdx = 0;
                Iterator<NetObject> pit = ckt.getNetObjs();
                while (pit.hasNext()) {
                    portsPerCell[cellNdx][portNdx] = (Port)pit.next();
                    ++portNdx;
                }
                ++cellNdx;
            }
        }
        return portsPerCell;
    }

    private HashMap<String, Port> mapFromExportNameToPort(Port[] ports) {
        HashMap<String, Port> map = new HashMap<String, Port>();
        for (int portNdx = 0; portNdx < ports.length; ++portNdx) {
            Port p = ports[portNdx];
            Iterator<String> itN = p.getExportNames();
            while (itN.hasNext()) {
                map.put(itN.next(), p);
            }
        }
        return map;
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void printOneToManyError(String design1, String exports1, String design2, Set<Port> exports2) {
        this.prln("  A single network in: " + design1 + " has Exports with names that " + "match multiple Exports in: " + design2);
        this.prln("  However, the " + design2 + " Exports are attached to more than one network.");
        this.prln("    The " + design1 + " Exports: " + exports1);
        for (Port p2 : exports2) {
            this.prln("      matches the " + design2 + " Exports: " + p2.exportNamesString());
        }
    }

    private boolean matchPortsByName(HashMap<Port, Port> p1ToP2, Port[][] portsPerCell, String[] designNames, int ckt1, int ckt2) {
        boolean match = true;
        HashMap<String, Port> exportName2ToPort2 = this.mapFromExportNameToPort(portsPerCell[ckt2]);
        if (p1ToP2 == null) {
            p1ToP2 = new HashMap();
        }
        Port[] ckt1Ports = portsPerCell[ckt1];
        VarContext[] rootContexts = this.globals.getRootContexts();
        Cell[] rootCells = this.globals.getRootCells();
        for (int portNdx = 0; portNdx < ckt1Ports.length; ++portNdx) {
            ExportMismatch.MultiMatch em;
            Port p1 = ckt1Ports[portNdx];
            HashSet<Port> p2ports = new HashSet<Port>();
            Iterator<String> itN = p1.getExportNames();
            while (itN.hasNext()) {
                String exportNm1 = itN.next();
                Port p = exportName2ToPort2.get(exportNm1);
                if (p == null) continue;
                p2ports.add(p);
            }
            if (p2ports.size() == 0) {
                this.prln("  In " + designNames[ckt1] + " the network with Exports: " + p1.exportNamesString() + "    matches no Export with the same name in: " + designNames[ckt2]);
                this.noPortNameMatches.add(p1, ckt1, ckt2);
                match = false;
                em = new ExportMismatch.MultiMatch();
                em.setNames(designNames[ckt1], designNames[ckt2]);
                em.setCells(rootCells[ckt1], rootCells[ckt2]);
                em.setContexts(rootContexts[ckt1], rootContexts[ckt2]);
                em.add(0, p1);
                em.setValidOnlyWhenTopologyMismatch(true);
                this.globals.getNccGuiInfo().addExportMismatch(em);
                continue;
            }
            if (p2ports.size() == 1) {
                p1ToP2.put(p1, (Port)p2ports.iterator().next());
                continue;
            }
            this.printOneToManyError(designNames[ckt1], p1.exportNamesString(), designNames[ckt2], p2ports);
            match = false;
            em = new ExportMismatch.MultiMatch();
            em.setNames(designNames[ckt1], designNames[ckt2]);
            em.setCells(rootCells[ckt1], rootCells[ckt2]);
            em.setContexts(rootContexts[ckt1], rootContexts[ckt2]);
            em.add(0, p1);
            HashSet<PortReport.PortReportable> p2portReportables = new HashSet<PortReport.PortReportable>();
            p2portReportables.addAll(p2ports);
            em.add(1, p2portReportables);
            this.globals.getNccGuiInfo().addExportMismatch(em);
        }
        return match;
    }

    private SubcircuitInfo getInfoForReferenceCell(Cell refCell, HierarchyInfo hierInfo) {
        SubcircuitInfo refInfo = hierInfo.getSubcircuitInfo(refCell);
        if (refInfo != null) {
            return refInfo;
        }
        Port[] refCktPorts = this.getFirstCktPorts();
        refInfo = new SubcircuitInfo(hierInfo.currentSubcircuitName(), hierInfo.currentSubcircuitID(), refCktPorts);
        hierInfo.addSubcircuitInfo(refCell, refInfo);
        return refInfo;
    }

    private Port[] getFirstCktPorts() {
        Port[][] portsPerCell = this.getPortsForEachCell();
        return portsPerCell[0];
    }

    private Map<String, Integer> mapExportNameToPortIndex(SubcircuitInfo refCellInfo, Map<Port, Port> equivPortMap) {
        HashMap<String, Integer> exportNameToPortIndex = new HashMap<String, Integer>();
        Port[] firstCktPorts = this.getFirstCktPorts();
        for (int i = 0; i < firstCktPorts.length; ++i) {
            Port firstCktPort = firstCktPorts[i];
            String firstCktPortName = firstCktPort.getExportNames().next();
            int portNdx = refCellInfo.getPortIndex(firstCktPortName);
            Port equivPort = equivPortMap.get(firstCktPort);
            if (equivPort == null) continue;
            Iterator<String> it = equivPort.getExportNames();
            while (it.hasNext()) {
                exportNameToPortIndex.put(it.next(), new Integer(portNdx));
            }
        }
        return exportNameToPortIndex;
    }

    private Circuit getNthCircuit(EquivRecord er, int nth) {
        Job.error(!er.isLeaf(), "only leaf EquivRecords have Circuits!");
        Iterator<Circuit> it = er.getCircuits();
        for (int i = 0; i < nth; ++i) {
            Job.error(!it.hasNext(), "EquivRec has no Circuit at index: " + nth);
            it.next();
        }
        Job.error(!it.hasNext(), "EquivRec has no Circuit at index: " + nth);
        return it.next();
    }

    private Object findMatchingPortOrWire(Port lonely, int nth) {
        Wire lonelyWire = lonely.getWire();
        Circuit lonelyCkt = lonelyWire.getParent();
        if (lonelyCkt.numNetObjs() != 1) {
            return null;
        }
        EquivRecord equivRecord = lonelyCkt.getParent();
        Circuit nthCircuit = this.getNthCircuit(equivRecord, nth);
        if (nthCircuit.numNetObjs() != 1) {
            return null;
        }
        Wire wire = (Wire)nthCircuit.getNetObjs().next();
        Port port = wire.getPort();
        return port != null ? port : wire;
    }

    private String getDescription(Object portOrWire) {
        if (portOrWire instanceof Wire) {
            return "network: " + ((Wire)portOrWire).getName();
        }
        Job.error(!(portOrWire instanceof Port), "not a Wire?");
        return "network with Exports: " + ((Port)portOrWire).exportNamesString();
    }

    private void markPortForRenaming(Port p, NccCellAnnotations ann) {
        Iterator<String> it = p.getExportNames();
        while (it.hasNext()) {
            String name = it.next();
            if (!ann.renameExport(name)) continue;
            p.setToBeRenamed();
            return;
        }
    }

    private void markPortsForRenaming(Cell cell, Port[] ports) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cell);
        if (ann == null) {
            return;
        }
        for (int portNdx = 0; portNdx < ports.length; ++portNdx) {
            this.markPortForRenaming(ports[portNdx], ann);
        }
    }

    private void printNewPortNames(Port[] ports, Cell rootCell, int cktIndex) {
        boolean printedHeader = false;
        int otherCktIndex = cktIndex == 0 ? 1 : 0;
        for (int portNdx = 0; portNdx < ports.length; ++portNdx) {
            Port p = ports[portNdx];
            if (!p.getToBeRenamed()) continue;
            if (!printedHeader) {
                this.prln("  Attempting to find better names for Exports in Cell: " + NccUtils.fullName(rootCell));
                printedHeader = true;
            }
            Object o = this.findMatchingPortOrWire(p, otherCktIndex);
            this.prln("    " + p.exportNamesString() + " -> " + this.getDescription(o));
        }
    }

    private void printNewNamesForPortsThatTheUserWantsUsToRename() {
        Cell[] rootCells = this.globals.getRootCells();
        Port[][] portsPerCell = this.getPortsForEachCell();
        for (int cellNdx = 0; cellNdx < portsPerCell.length; ++cellNdx) {
            this.printNewPortNames(portsPerCell[cellNdx], rootCells[cellNdx], cellNdx);
        }
    }

    private void suggestMatchForPortsThatDontMatchByName() {
        String[] rootCellNames = this.globals.getRootCellNames();
        boolean printedHeader = false;
        VarContext[] rootContexts = this.globals.getRootContexts();
        Cell[] rootCells = this.globals.getRootCells();
        NoPortNameMatch no = this.noPortNameMatches.removeFirst();
        while (no != null) {
            if (!no.port.getToBeRenamed()) {
                Object o = this.findMatchingPortOrWire(no.port, no.circuitNoMatchingPort);
                if (o == null) {
                    ExportMismatch.MultiMatch em = new ExportMismatch.MultiMatch();
                    em.setNames(rootCellNames[no.circuit], rootCellNames[no.circuitNoMatchingPort]);
                    em.setCells(rootCells[no.circuit], rootCells[no.circuitNoMatchingPort]);
                    em.setContexts(rootContexts[no.circuit], rootContexts[no.circuitNoMatchingPort]);
                    em.add(0, no.port);
                    this.globals.getNccGuiInfo().addExportMismatch(em);
                } else {
                    if (!printedHeader) {
                        printedHeader = true;
                        this.prln("  The following list suggests possible matches for Exports that failed to match by name.");
                    }
                    this.prln("    in Cell " + rootCellNames[no.circuit] + " the network with Exports: " + no.port.exportNamesString() + " might match in Cell " + rootCellNames[no.circuitNoMatchingPort] + " the " + this.getDescription(o));
                    if (o instanceof Port) {
                        this.noPortNameMatches.removeMismatches(no.port, no.circuit, (Port)o, no.circuitNoMatchingPort);
                    }
                    ExportMismatch.NameMismatch esm = new ExportMismatch.NameMismatch();
                    esm.setNames(rootCellNames[no.circuit], rootCellNames[no.circuitNoMatchingPort]);
                    esm.setCells(rootCells[no.circuit], rootCells[no.circuitNoMatchingPort]);
                    esm.setContexts(rootContexts[no.circuit], rootContexts[no.circuitNoMatchingPort]);
                    esm.setFirstExport(no.port);
                    esm.setSuggestion((NetObject)o);
                    this.globals.getNccGuiInfo().addExportMismatch(esm);
                }
            }
            no = this.noPortNameMatches.removeFirst();
        }
        if (printedHeader) {
            this.prln("");
        }
    }

    public ExportChecker(NccGlobals globals) {
        this.globals = globals;
    }

    public void markPortsForRenaming() {
        Cell[] rootCells = this.globals.getRootCells();
        Port[][] portsPerCell = this.getPortsForEachCell();
        for (int cellNdx = 0; cellNdx < portsPerCell.length; ++cellNdx) {
            this.markPortsForRenaming(rootCells[cellNdx], portsPerCell[cellNdx]);
        }
    }

    public boolean matchByName() {
        int numCkts = this.globals.getNumNetlistsBeingCompared();
        String[] rootCellNames = this.globals.getRootCellNames();
        Port[][] portsPerCell = this.getPortsForEachCell();
        this.equivPortMaps = new HashMap[numCkts];
        boolean match = true;
        for (int i = 1; i < numCkts; ++i) {
            match &= this.matchPortsByName(null, portsPerCell, rootCellNames, i, 0);
            HashMap<Port, Port> p0ToPi = new HashMap<Port, Port>();
            match &= this.matchPortsByName(p0ToPi, portsPerCell, rootCellNames, 0, i);
            this.equivPortMaps[i] = p0ToPi;
        }
        return match;
    }

    public void saveInfoNeededToMakeMeASubcircuit(HierarchyInfo hierInfo) {
        if (hierInfo == null) {
            return;
        }
        Cell[] rootCells = this.globals.getRootCells();
        Cell refCell = this.globals.getRootCells()[0];
        SubcircuitInfo refCellInfo = this.getInfoForReferenceCell(refCell, hierInfo);
        HashSet<Cell> doneCells = new HashSet<Cell>();
        doneCells.add(refCell);
        for (int i = 1; i < this.equivPortMaps.length; ++i) {
            if (doneCells.contains(rootCells[i])) continue;
            doneCells.add(rootCells[i]);
            Map<String, Integer> exportNameToPortIndex = this.mapExportNameToPortIndex(refCellInfo, this.equivPortMaps[i]);
            SubcircuitInfo subInf = new SubcircuitInfo(refCellInfo, exportNameToPortIndex);
            hierInfo.addSubcircuitInfo(rootCells[i], subInf);
        }
    }

    public boolean ensureExportsWithMatchingNamesAreOnEquivalentNets() {
        boolean match = true;
        String[] rootCellNames = this.globals.getRootCellNames();
        VarContext[] rootContexts = this.globals.getRootContexts();
        Cell[] rootCells = this.globals.getRootCells();
        for (int i = 1; i < this.equivPortMaps.length; ++i) {
            HashMap<Port, Port> portToPort = this.equivPortMaps[i];
            for (Port p0 : portToPort.keySet()) {
                EquivRecord ern;
                Port pn = portToPort.get(p0);
                if (p0.getToBeRenamed() || pn.getToBeRenamed()) continue;
                Wire w0 = p0.getWire();
                Wire wn = pn.getWire();
                EquivRecord er0 = w0.getParent().getParent();
                if (er0 == (ern = wn.getParent().getParent())) continue;
                this.prln("  Exports that match by name aren't on equivalent networks");
                this.prln("    Cell1: " + rootCellNames[0]);
                this.prln("    Exports1: " + p0.exportNamesString());
                this.prln("    Cell2: " + rootCellNames[i]);
                this.prln("    Exports2: " + pn.exportNamesString());
                Object portOrWire = this.findMatchingPortOrWire(p0, i);
                if (portOrWire != null) {
                    this.prln("    However the Cell1 network appears to match Cell2's: " + this.getDescription(portOrWire));
                }
                this.prln("");
                match = false;
                ExportMismatch.TopologyMismatch esm = new ExportMismatch.TopologyMismatch();
                esm.setNames(rootCellNames[0], rootCellNames[i]);
                esm.setCells(rootCells[0], rootCells[i]);
                esm.setContexts(rootContexts[0], rootContexts[i]);
                esm.setFirstExport(p0);
                esm.setSecondExport(pn);
                if (portOrWire != null) {
                    esm.setSuggestion((NetObject)portOrWire);
                }
                this.globals.getNccGuiInfo().addExportMismatch(esm);
            }
        }
        return match;
    }

    public void suggestPortMatchesBasedOnTopology() {
        this.printNewNamesForPortsThatTheUserWantsUsToRename();
        this.suggestMatchForPortsThatDontMatchByName();
    }

    private static class NoPortNameMatches {
        private List<NoPortNameMatch> unmatched = new LinkedList<NoPortNameMatch>();

        private NoPortNameMatches() {
        }

        public void add(Port port, int circuit, int circuitNoMatchingPort) {
            this.unmatched.add(new NoPortNameMatch(port, circuit, circuitNoMatchingPort));
        }

        public NoPortNameMatch removeFirst() {
            Iterator<NoPortNameMatch> it = this.unmatched.iterator();
            if (!it.hasNext()) {
                return null;
            }
            NoPortNameMatch u = it.next();
            it.remove();
            return u;
        }

        public void removeMismatches(Port port1, int circuit1, Port port2, int circuit2) {
            Iterator<NoPortNameMatch> it = this.unmatched.iterator();
            while (it.hasNext()) {
                NoPortNameMatch u = it.next();
                if ((u.port != port1 || u.circuitNoMatchingPort != circuit2) && (u.port != port2 || u.circuitNoMatchingPort != circuit1)) continue;
                it.remove();
            }
        }
    }

    private static class NoPortNameMatch {
        public final Port port;
        public final int circuit;
        public final int circuitNoMatchingPort;

        public NoPortNameMatch(Port port, int circuit, int circuitNoMatchingPort) {
            this.port = port;
            this.circuit = circuit;
            this.circuitNoMatchingPort = circuitNoMatchingPort;
        }
    }
}

