/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.StartupPrefs;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.Progress;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ErrorLoggerTree;
import com.sun.electric.tool.user.ui.JobTree;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInterfaceMain
extends AbstractUserInterface {
    static final Logger logger = Logger.getLogger("com.sun.electric.tool.user");
    static volatile boolean initializationFinished = false;
    private static volatile boolean undoEnabled = false;
    private static volatile boolean redoEnabled = false;
    private static EventListenerList listenerList = new EventListenerList();
    private static Snapshot currentSnapshot = IdManager.stdIdManager.getInitialSnapshot();
    private static GraphicsPreferences currentGraphicsPreferences = null;
    protected static Progress progress = null;
    private SplashWindow sw = null;
    private PrintStream stdout = System.out;
    private static PrintWriter printWriter = null;
    private static boolean newCommand = true;
    private static int commandNumber = 1;
    private static EditingPreferences lastSavedEp;
    private static boolean badAccessReported;
    private int lastId = 0;
    private ArrayList<SavedHighlights> savedHighlights = new ArrayList();

    public UserInterfaceMain(List<String> argsList, Mode mode, boolean showSplash) {
        super(-1);
        new EventProcessor();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    assert (SwingUtilities.isEventDispatchThread());
                    UserInterfaceMain.this.setClientThread();
                    Environment.setThreadEnvironment(IdManager.stdIdManager.getInitialEnvironment());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mode == null) {
            int defMode = StartupPrefs.getDisplayStyle();
            if (defMode == 1) {
                mode = Mode.MDI;
            } else if (defMode == 2) {
                mode = Mode.SDI;
            }
        }
        SwingUtilities.invokeLater(new InitializationRun(argsList, mode, showSplash));
    }

    @Override
    protected void terminateJob(EJob ejob) {
        boolean undoRedo;
        boolean bl = undoRedo = ejob.jobType == Job.Type.UNDO;
        if (!ejob.isExamine()) {
            int restoredHighlights = Undo.endChanges(ejob.oldSnapshot, ejob.getJob().getTool(), ejob.jobName, ejob.newSnapshot);
            this.showSnapshot(ejob.newSnapshot, undoRedo);
            this.restoreHighlights(restoredHighlights);
        }
        Throwable jobException = null;
        if (ejob.startedByServer) {
            jobException = ejob.deserializeToClient();
        }
        if (jobException != null) {
            System.out.println("Error deserializing " + ejob.jobName);
            ActivityLogger.logException(jobException);
            return;
        }
        jobException = ejob.deserializeResult();
        Job job = ejob.clientJob;
        if (job == null) {
            ActivityLogger.logException(jobException);
            return;
        }
        try {
            job.terminateIt(jobException);
        }
        catch (Throwable ex) {
            System.out.println("Exception executing terminateIt");
            ex.printStackTrace(System.out);
        }
        job.endTime = System.currentTimeMillis();
        job.finished = true;
        if (job.reportExecution || job.endTime - job.startTime >= 60000L) {
            if (User.isBeepAfterLongJobs()) {
                Job.getExtendedUserInterface().beep();
            }
            System.out.println(job.getInfo());
        }
    }

    @Override
    protected void showJobQueue(Job.Inform[] jobQueue) {
        boolean busyCursor = false;
        for (Job.Inform jobInform : jobQueue) {
            if (!jobInform.isChangeJobQueuedOrRunning()) continue;
            busyCursor = true;
        }
        JobTree.update(Arrays.asList(jobQueue));
        TopLevel.setBusyCursor(busyCursor);
    }

    @Override
    public void addEvent(Client.ServerEvent serverEvent) {
        SwingUtilities.invokeLater(serverEvent);
    }

    private static String getMacClassName() {
        return "com.sun.electric.tool.user.MacOSXInterface";
    }

    @Override
    public void finishInitialization() {
        initializationFinished = true;
        if (this.sw != null) {
            this.sw.removeNotify();
            this.sw = null;
        }
        TopLevel.InitializeWindows();
        WindowFrame.wantToOpenCurrentLibrary(true, null);
    }

    @Override
    public EDatabase getDatabase() {
        return EDatabase.clientDatabase();
    }

    @Override
    public EditWindow_ getCurrentEditWindow_() {
        return EditWindow.getCurrent();
    }

    @Override
    public EditWindow_ needCurrentEditWindow_() {
        return EditWindow.needCurrent();
    }

    @Override
    public Cell getCurrentCell() {
        return WindowFrame.getCurrentCell();
    }

    @Override
    public Cell needCurrentCell() {
        return WindowFrame.needCurCell();
    }

    @Override
    public void adjustReferencePoint(Cell theCell, double cX, double cY) {
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell cell;
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow_) || (cell = content.getCell()) != theCell) continue;
            EditWindow_ wnd = (EditWindow_)((Object)content);
            Point2D off = wnd.getOffset();
            off.setLocation(off.getX() - cX, off.getY() - cY);
            wnd.setOffset(off);
        }
    }

    @Override
    public void repaintAllWindows() {
        WindowFrame.repaintAllWindows();
    }

    @Override
    public int getDefaultTextSize() {
        return EditWindow.getDefaultFontSize();
    }

    @Override
    public EditWindow_ displayCell(Cell cell) {
        WindowFrame wf = WindowFrame.createEditWindow(cell);
        if (wf.getContent() instanceof EditWindow_) {
            return (EditWindow_)((Object)wf.getContent());
        }
        return null;
    }

    @Override
    public void termLogging(ErrorLogger log, boolean explain, boolean terminate) {
        if (!log.isPersistent() && log.getNumLogs() == 0) {
            return;
        }
        ErrorLoggerTree.addLogger(log, explain, terminate);
    }

    @Override
    public void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        ErrorLoggerTree.updateNetworkErrors(cell, errors);
    }

    @Override
    public void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        ErrorLoggerTree.updateDrcErrors(cell, newErrors, delErrors);
    }

    @Override
    public String reportLog(ErrorLogger.MessageLog log, boolean showhigh, Geometric[] gPair, int position) {
        ErrorHighlight eh;
        Iterator<ErrorHighlight> it;
        EDatabase database = EDatabase.clientDatabase();
        if (gPair != null) {
            Geometric geom1 = null;
            Geometric geom2 = null;
            it = log.getHighlights();
            while (it.hasNext()) {
                eh = it.next();
                if (geom1 == null) {
                    geom1 = (Geometric)eh.getObject(database);
                    continue;
                }
                if (geom2 != null) continue;
                geom2 = (Geometric)eh.getObject(database);
            }
            if (geom1 != null) {
                gPair[0] = geom1;
            }
            if (geom2 != null) {
                gPair[1] = geom2;
            }
        }
        if (showhigh) {
            Cell logCell;
            EditWindow wnd;
            HashMap<EditWindow, Highlighter> hMap = new HashMap<EditWindow, Highlighter>();
            int pos = -1;
            it = log.getHighlights();
            while (it.hasNext()) {
                eh = it.next();
                Highlighter highlighter = null;
                if (position != -1 && ++pos != position) continue;
                Cell cell = eh.getCell(database);
                if (cell != null) {
                    if (!cell.isLinked()) {
                        return "(cell deleted): " + log.getMessageString();
                    }
                    wnd = EditWindow.showEditWindowForCell(cell, eh.getVarContext());
                    highlighter = (Highlighter)hMap.get(wnd);
                    if (highlighter == null) {
                        highlighter = wnd.getHighlighter();
                        highlighter.clear();
                        hMap.put(wnd, highlighter);
                    }
                } else if (Job.getDebug()) {
                    System.out.println("Check this case in UserInterfaceMain::reportLog");
                }
                if (highlighter == null) continue;
                eh.addToHighlighter(highlighter, database);
            }
            boolean nothingDone = true;
            for (Map.Entry e : hMap.entrySet()) {
                Highlighter highlighter = (Highlighter)e.getValue();
                wnd = (EditWindow)e.getKey();
                if (highlighter != null) {
                    highlighter.ensureHighlightingSeen();
                    highlighter.finished();
                    Rectangle2D hBounds = highlighter.getHighlightedArea(wnd);
                    Rectangle2D shown = wnd.getDisplayedBounds();
                    if (!shown.intersects(hBounds)) {
                        wnd.focusOnHighlighted();
                    }
                }
                nothingDone = false;
            }
            if (nothingDone && (logCell = log.getCell()) != null && logCell.isLinked()) {
                EditWindow.showEditWindowForCell(logCell, null);
            }
        }
        return log.getMessageString();
    }

    @Override
    public void showErrorMessage(final String message, final String title) {
        if (Job.isClientThread()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(false), message, title, 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserInterfaceMain.this.showErrorMessage(message, title);
                }
            });
        }
    }

    @Override
    public void showInformationMessage(final String message, final String title) {
        if (Job.isClientThread()) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), message, title, 1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserInterfaceMain.this.showInformationMessage(message, title);
                }
            });
        }
    }

    @Override
    public void printMessage(String message, boolean newLine) {
        String s;
        String string = s = newLine ? message + "\n" : message;
        if (Job.isClientThread()) {
            this.appendString(s);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessagesWindow messagesWindow = TopLevel.getMessagesWindow();
                    if (messagesWindow != null) {
                        UserInterfaceMain.this.appendString(s);
                    } else {
                        UserInterfaceMain.this.stdout.print(s);
                    }
                }
            });
        }
    }

    @Override
    public void saveMessages(final String filePath) {
        if (!Job.isClientThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserInterfaceMain.this.saveMessages(filePath);
                }
            });
        }
        try {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
            if (filePath == null) {
                return;
            }
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
        }
        catch (IOException e) {
            System.err.println("Error creating " + filePath);
            System.out.println("Error creating " + filePath);
            return;
        }
        System.out.println("Messages will be saved to " + filePath);
    }

    public static void userCommandIssued() {
        newCommand = true;
    }

    public void appendString(String str) {
        MessagesWindow mw;
        if (str.length() == 0) {
            return;
        }
        if (newCommand) {
            newCommand = false;
            str = "=================================" + commandNumber++ + "=================================\n" + str;
        }
        if (printWriter != null) {
            printWriter.print(str);
            printWriter.flush();
        }
        if ((mw = TopLevel.getMessagesWindow()) != null) {
            TopLevel.getMessagesWindow().appendString(str);
        } else {
            System.err.println(str);
        }
    }

    @Override
    public boolean confirmMessage(Object message) {
        int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), message);
        return response == 0;
    }

    @Override
    public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
        String msg = message;
        int size = msg.length();
        int pos = 0;
        String newMsg = "";
        for (int lineNumber = 0; pos < size && lineNumber < 10; pos += 256, ++lineNumber) {
            int endIndex = pos + 256;
            if (endIndex > size) {
                endIndex = size;
            }
            newMsg = newMsg + msg.substring(pos, endIndex);
            newMsg = newMsg + "\n";
        }
        if (pos < size) {
            newMsg = newMsg + "........\n";
            int index = size - pos > 256 ? size - 256 : pos;
            newMsg = newMsg + msg.substring(index, size);
        }
        message = msg = newMsg;
        int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), message, title, -1, 2, null, choices, defaultChoice);
        return val;
    }

    @Override
    public String askForInput(Object message, String title, String def) {
        Object ret = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), message, title, 3, null, null, def);
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    public static void importPrefs(URL fileURL) {
        assert (Job.isClientThread());
        if (fileURL == null) {
            return;
        }
        System.out.println("Importing preferences...");
        Pref.importPrefs(fileURL);
        Environment env = EDatabase.clientDatabase().getEnvironment();
        env.saveToPreferences();
        UserInterfaceMain.loadPreferences(env.techPool);
        TopLevel.getCurrentJFrame().getEMenuBar().restoreSavedBindings(false);
        WindowFrame.repaintAllWindows();
        System.out.println("...preferences imported from " + fileURL.getFile());
    }

    @Override
    public int saveHighlights() {
        EditWindow_ wnd = this.getCurrentEditWindow_();
        if (wnd == null) {
            return -1;
        }
        SavedHighlights sh = new SavedHighlights(this.lastId++, wnd);
        while (this.savedHighlights.size() >= User.getMaxUndoHistory() && !this.savedHighlights.isEmpty()) {
            this.savedHighlights.remove(0);
        }
        this.savedHighlights.add(sh);
        return sh.id;
    }

    @Override
    public void restoreHighlights(int highlightsId) {
        for (SavedHighlights sh : this.savedHighlights) {
            if (sh.id != highlightsId) continue;
            sh.restore();
            break;
        }
    }

    @Override
    public void showUndoRedoStatus(boolean newUndoEnabled, boolean newRedoEnabled) {
        PropertyChangeEvent e = null;
        if (undoEnabled != newUndoEnabled) {
            undoEnabled = newUndoEnabled;
            SwingUtilities.invokeLater(new PropertyChangeRun(e));
        }
        if (redoEnabled != newRedoEnabled) {
            redoEnabled = newRedoEnabled;
            SwingUtilities.invokeLater(new PropertyChangeRun(e));
        }
    }

    @Override
    public void showSnapshot(Snapshot newSnapshot, boolean undoRedo) {
        assert (Job.isClientThread());
        DatabaseChangeEvent event = new DatabaseChangeEvent(currentSnapshot, newSnapshot);
        Snapshot oldSnapshot = currentSnapshot;
        currentSnapshot = newSnapshot;
        if (newSnapshot.environment != oldSnapshot.environment) {
            Environment.setThreadEnvironment(newSnapshot.environment);
            if (newSnapshot.environment.toolSettings != oldSnapshot.environment.toolSettings) {
                ToolSettings.attachToGroup(newSnapshot.environment.toolSettings);
            }
            if (newSnapshot.techPool != oldSnapshot.techPool) {
                UserInterfaceMain.loadPreferences(newSnapshot.techPool);
                User.technologyChanged();
                WindowFrame.updateTechnologyLists();
                WindowFrame.repaintAllWindows();
            }
        }
        Iterator<Listener> it = Tool.getListeners();
        while (it.hasNext()) {
            Listener listener = it.next();
            listener.endBatch(oldSnapshot, newSnapshot, undoRedo);
        }
        UserInterfaceMain.fireDatabaseChangeEvent(event);
    }

    @Override
    public void beep() {
        if (Job.isClientThread()) {
            User.playSound();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserInterfaceMain.this.beep();
                }
            });
        }
    }

    public static boolean getUndoEnabled() {
        return undoEnabled;
    }

    public static boolean getRedoEnabled() {
        return redoEnabled;
    }

    private static void firePropertyChange(PropertyChangeEvent e) {
        assert (Job.isClientThread());
        ToolBar.updateUndoRedoButtons(UserInterfaceMain.getUndoEnabled(), UserInterfaceMain.getRedoEnabled());
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell c;
            WindowFrame wf = it.next();
            WindowContent content = wf.getContent();
            if (content == null || (c = content.getCell()) == null || c.isLinked()) continue;
            wf.setCellWindow(null, null);
            content.fullRepaint();
        }
    }

    public static synchronized void addDatabaseChangeListener(DatabaseChangeListener l) {
        listenerList.add(DatabaseChangeListener.class, l);
    }

    public static synchronized void removeDatabaseChangeListener(DatabaseChangeListener l) {
        listenerList.remove(DatabaseChangeListener.class, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireDatabaseChangeEvent(DatabaseChangeEvent e) {
        Class<User> clazz = User.class;
        synchronized (User.class) {
            Object[] listeners = listenerList.getListenerList();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != DatabaseChangeListener.class) continue;
                ((DatabaseChangeListener)listeners[i + 1]).databaseChanged(e);
            }
            return;
        }
    }

    private static void loadPreferences(TechPool techPool) {
        Pref.setCachedObjsFromPreferences();
        EditingPreferences ep = new EditingPreferences(false, techPool);
        EditingPreferences.setThreadEditingPreferences(ep);
        lastSavedEp = ep;
        currentGraphicsPreferences = new GraphicsPreferences(false, techPool);
        LayerVisibility.setTechPool(techPool);
        ClickZoomWireListener.readPrefs();
    }

    public static EditingPreferences getEditingPreferences() {
        assert (Job.isClientThread());
        return EditingPreferences.getThreadEditingPreferences();
    }

    public static void setEditingPreferences(EditingPreferences newEp) {
        EditingPreferences oldEp = UserInterfaceMain.getEditingPreferences();
        if (newEp.equals(oldEp)) {
            return;
        }
        EditingPreferences.setThreadEditingPreferences(newEp);
        Pref.delayPrefFlushing();
        newEp.putPrefs(Pref.getPrefRoot(), true, lastSavedEp);
        lastSavedEp = newEp;
        Pref.resumePrefFlushing();
    }

    public static GraphicsPreferences getGraphicsPreferences() {
        if (!badAccessReported && !Job.isClientThread()) {
            String msg = "GraphicsPreferences is accessed from " + Job.getRunningJob();
            if (Job.getDebug()) {
                ActivityLogger.logMessage(msg);
                System.out.println(msg);
            }
            badAccessReported = true;
        }
        return currentGraphicsPreferences;
    }

    public static void setGraphicsPreferences(GraphicsPreferences gp) {
        assert (Job.isClientThread());
        if (gp.equals(currentGraphicsPreferences)) {
            return;
        }
        Pref.delayPrefFlushing();
        gp.putPrefs(Pref.getPrefRoot(), true, currentGraphicsPreferences);
        Pref.resumePrefFlushing();
        currentGraphicsPreferences = gp;
    }

    @Override
    public void startProgressDialog(String msg, String filePath) {
        this.stopProgressDialog();
        try {
            String message = filePath == null ? msg + "..." : "Reading " + msg + " " + filePath + "...";
            progress = new Progress(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        progress.setProgress(0);
    }

    @Override
    public void stopProgressDialog() {
        if (progress != null) {
            progress.close();
            progress = null;
        }
    }

    @Override
    public void setProgressValue(int pct) {
        if (progress != null) {
            progress.setProgress(pct);
        }
    }

    @Override
    public void setProgressNote(String message) {
        if (progress != null) {
            progress.setNote(message);
        }
    }

    @Override
    public String getProgressNote() {
        if (progress == null) {
            return "";
        }
        return progress.getNote();
    }

    static {
        badAccessReported = false;
    }

    private static class EventProcessor
    extends EventQueue {
        private final String CLASS_NAME = this.getClass().getName();
        private int dispatchDepth = 0;

        private EventProcessor() {
            Toolkit kit = Toolkit.getDefaultToolkit();
            kit.getSystemEventQueue().push(this);
        }

        protected void dispatchEvent(AWTEvent e) {
            block2: {
                ++this.dispatchDepth;
                try {
                    super.dispatchEvent(e);
                }
                catch (Throwable ex) {
                    ex.printStackTrace(System.err);
                    ActivityLogger.logException(ex);
                    if (!(ex instanceof Error)) break block2;
                    logger.throwing(this.CLASS_NAME, "dispatchEvent", ex);
                    throw (Error)ex;
                }
            }
        }
    }

    private static class WindowsEvents
    implements WindowListener {
        SplashWindow sw;

        WindowsEvents(SplashWindow sw) {
            this.sw = sw;
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
            Window w;
            TopLevel tl = TopLevel.getCurrentJFrame(false);
            if (tl == (w = e.getOppositeWindow())) {
                this.sw.toFront();
            }
        }
    }

    private static class SplashWindow
    extends JFrame {
        public SplashWindow() {
            this.setUndecorated(true);
            this.setTitle("Electric Splash");
            this.setIconImage(TopLevel.getFrameIcon().getImage());
            JPanel whole = new JPanel();
            whole.setBorder(BorderFactory.createLineBorder(new Color(0, 170, 0), 5));
            whole.setLayout(new BorderLayout());
            ImageIcon splashImage = Resources.getResource(TopLevel.class, "SplashImage.gif");
            JLabel l = new JLabel(splashImage);
            whole.add((Component)l, "Center");
            JLabel v = new JLabel("Version " + Version.getVersion(), 0);
            whole.add((Component)v, "South");
            String fontName = User.getFactoryDefaultFont();
            Font font = new Font(fontName, 1, 24);
            v.setFont(font);
            v.setForeground(Color.BLACK);
            v.setBackground(Color.WHITE);
            this.getContentPane().add((Component)whole, "South");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = this.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addWindowListener(new WindowsEvents(this));
            this.setVisible(true);
            this.toFront();
            this.paint(this.getGraphics());
        }
    }

    private static class SavedHighlights {
        private final int id;
        private final EditWindow_ wnd;
        private final List<Highlight2> savedHighlights;
        private final Point2D savedHighlightsOffset;

        private SavedHighlights(int id, EditWindow_ wnd) {
            this.id = id;
            this.wnd = wnd;
            this.savedHighlights = wnd.saveHighlightList();
            this.savedHighlightsOffset = wnd.getHighlightOffset();
        }

        private void restore() {
            this.wnd.restoreHighlightList(this.savedHighlights);
            this.wnd.setHighlightOffset((int)this.savedHighlightsOffset.getX(), (int)this.savedHighlightsOffset.getY());
            this.wnd.finishedHighlighting();
        }
    }

    private static class PropertyChangeRun
    implements Runnable {
        private PropertyChangeEvent e;

        private PropertyChangeRun(PropertyChangeEvent e) {
            this.e = e;
        }

        public void run() {
            UserInterfaceMain.firePropertyChange(this.e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InitializationRun
    implements Runnable {
        List<String> argsList;
        Mode mode;
        boolean showSplash;

        InitializationRun(List<String> argsList, Mode mode, boolean showSplash) {
            this.argsList = argsList;
            this.mode = mode;
            this.showSplash = showSplash;
        }

        @Override
        public void run() {
            if (!Job.isClientThread()) assert (Job.isClientThread());
            Pref.setCachedObjsFromPreferences();
            EditingPreferences.setThreadEditingPreferences(new EditingPreferences(true, null));
            currentGraphicsPreferences = new GraphicsPreferences(true, new TechPool(IdManager.stdIdManager));
            if (Client.isOSMac()) {
                try {
                    Class<?> osXClass = Class.forName(UserInterfaceMain.getMacClassName());
                    Method osXRegisterMethod = null;
                    try {
                        osXRegisterMethod = osXClass.getMethod("registerMacOSXApplication", List.class);
                    }
                    catch (NoSuchMethodException e) {
                        osXRegisterMethod = null;
                    }
                    if (osXRegisterMethod != null) {
                        try {
                            osXRegisterMethod.invoke(osXClass, this.argsList);
                        }
                        catch (Exception e) {
                            System.out.println("Error initializing Mac OS/X interface");
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (this.showSplash) {
                UserInterfaceMain.this.sw = new SplashWindow();
            }
            TopLevel.OSInitialize(this.mode);
            TopLevel.InitializeMessagesWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        MDI,
        SDI;

    }
}

