/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;

public class TechTypeMoCMOS
extends TechType {
    private static final long serialVersionUID = 0L;
    private static boolean singletonCreated = false;
    private static final String[] LAYER_NAMES = new String[]{"Polysilicon-1", "Metal-1", "Metal-2", "Metal-3", "Metal-4", "Metal-5", "Metal-6"};

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public TechTypeMoCMOS(TechType.TechTypeEnum techEnum) {
        super(Technology.getMocmosTechnology(), techEnum, LAYER_NAMES);
        if (singletonCreated) {
            throw new RuntimeException("Only one instance of TechTypeMoCMOS is allowed");
        }
        singletonCreated = true;
        this.wellSurroundDiff = 3.0;
        this.gateExtendPastMOS = 2.0;
        this.p1Width = 2.0;
        this.p1ToP1Space = 3.0;
        this.gateToGateSpace = 3.0;
        this.gateToDiffContSpace = 0.5;
        this.gateToDiffContSpaceDogBone = 1.0;
        this.gateLength = 2.0;
        this.offsetLShapePolyContact = 1.5;
        this.offsetTShapePolyContact = 3.5;
        this.selectSpace = 2.0;
        this.selectSurroundDiffInTrans = 2.0;
        this.selectSurround = Double.NaN;
        this.selectSurroundDiffInActiveContact = 2.0;
        this.selectSurroundDiffAlongGateInTrans = 2.0;
        this.m1MinArea = 0.0;
        this.diffCont_m1Width = 4.0;
        this.diffContIncr = 5.0;
    }

    public double roundToGrid(double x) {
        return Math.rint(x * 2.0) / 2.0;
    }

    public TechType.MosInst newNmosInst(double x, double y, double w, double l, Cell parent) {
        return new TechType.MosInst.MosInstH('n', x, y, w, l, this, parent);
    }

    public TechType.MosInst newPmosInst(double x, double y, double w, double l, Cell parent) {
        return new TechType.MosInst.MosInstH('p', x, y, w, l, this, parent);
    }

    public String name() {
        return "MOCMOS";
    }

    public int getNumMetals() {
        return 6;
    }

    public double reservedToLambda(int layer, double nbTracks) {
        double m1via = 4.0;
        double m1sp = 3.0;
        double m1SP = 6.0;
        double m6via = 5.0;
        double m6sp = 4.0;
        double m6SP = 8.0;
        if (layer != 6) {
            return 2.0 * m1SP - m1sp + nbTracks * (m1via + m1sp);
        }
        return 2.0 * m6SP - m6sp + nbTracks * (m6via + m6sp);
    }
}

