/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class ToolBar
extends JToolBar {
    public static final EToolBarButton openLibraryCommand = new EToolBarButton("_Open Library...", 'O', "ButtonOpenLibrary"){

        public void run() {
            FileMenu.openLibraryCommand();
        }
    };
    public static final EToolBarButton saveLibraryCommand = new EToolBarButton("Sa_ve Library", null, "ButtonSaveLibrary"){

        public boolean isEnabled() {
            return Library.getCurrent() != null;
        }

        public void run() {
            FileMenu.saveLibraryCommand(Library.getCurrent());
        }
    };
    private static CursorMode curMode = CursorMode.CLICKZOOMWIRE;
    static final Cursor zoomCursor = ToolBar.readCursor("CursorZoom.gif", 6, 6);
    static final Cursor zoomOutCursor = ToolBar.readCursor("CursorZoomOut.gif", 6, 6);
    static final Cursor panCursor = ToolBar.readCursor("CursorPan.gif", 8, 8);
    static final Cursor wiringCursor = ToolBar.readCursor("CursorWiring.gif", 0, 0);
    static final Cursor outlineCursor = ToolBar.readCursor("CursorOutline.gif", 0, 8);
    static final Cursor measureCursor = ToolBar.readCursor("CursorMeasure.gif", 0, 0);
    private static final CursorModeButton clickZoomWireCommand = new CursorModeButton("Click/Zoom/Wire", 'S', "ButtonClickZoomWire", CursorMode.CLICKZOOMWIRE);
    private static final CursorModeButton panCommand = new CursorModeButton("Toggle Pan", 'P', "ButtonPan", CursorMode.PAN);
    private static final CursorModeButton zoomCommand = new CursorModeButton("Toggle Zoom", 'Z', "ButtonZoom", CursorMode.ZOOM);
    private static final CursorModeButton outlineCommand = new CursorModeButton("Toggle Outline Edit", 'Y', "ButtonOutline", CursorMode.OUTLINE);
    private static final CursorModeButton measureCommand = new CursorModeButton("Toggle Measure Distance", 'M', "ButtonMeasure", CursorMode.MEASURE);
    private static final ArrowDistanceButton fullArrowDistanceCommand = new ArrowDistanceButton("Full motion", 'F', "ButtonFull", ArrowDistance.FULL);
    private static final ArrowDistanceButton halfArrowDistanceCommand = new ArrowDistanceButton("Half motion", 'H', "ButtonHalf", ArrowDistance.HALF);
    private static final ArrowDistanceButton quarterArrowDistanceCommand = new ArrowDistanceButton("Quarter motion", "ButtonQuarter", ArrowDistance.QUARTER);
    private static SelectMode curSelectMode = SelectMode.OBJECTS;
    private static final SelectModeButton selectObjectsCommand = new SelectModeButton("Select Objects", "ButtonObjects", SelectMode.OBJECTS);
    private static final SelectModeButton selectAreaCommand = new SelectModeButton("Select Area", "ButtonArea", SelectMode.AREA);
    private static boolean selectSpecial = false;
    private static final ImageIcon selectSpecialIconOn = Resources.getResource(ToolBar.class, "ButtonSelectSpecialOn.gif");
    private static final ImageIcon selectSpecialIconOff = Resources.getResource(ToolBar.class, "ButtonSelectSpecialOff.gif");
    private static EToolBarButton toggleSelectSpecialCommand = new EToolBarButton("Toggle Special Select", null, "ButtonSelectSpecialOff"){

        public boolean isSelected() {
            return ToolBar.isSelectSpecial();
        }

        protected JMenuItem createMenuItem() {
            return new JCheckBoxMenuItem();
        }

        AbstractButton createToolBarButton() {
            return new JToggleButton();
        }

        public void run() {
            ToolBar.setSelectSpecial(!ToolBar.isSelectSpecial());
        }

        void updateToolBarButton(AbstractButton item) {
            super.updateToolBarButton(item);
            item.setSelected(this.isSelected());
            item.setIcon(this.isSelected() ? selectSpecialIconOn : selectSpecialIconOff);
        }
    };
    public static final EMenu modesSubMenu = new EMenu("M_odes", new EMenu("_Edit", clickZoomWireCommand, panCommand, zoomCommand, outlineCommand, measureCommand), new EMenu("_Movement", fullArrowDistanceCommand, halfArrowDistanceCommand, quarterArrowDistanceCommand), new EMenu("_Select", selectObjectsCommand, selectAreaCommand, toggleSelectSpecialCommand));
    public static final EToolBarButton preferencesCommand = new EToolBarButton("P_references...", null, "ButtonPreferences"){

        public void run() {
            PreferencesFrame.preferencesCommand();
        }
    };
    public static final EToolBarButton expandOneLevelCommand = new EToolBarButton("_One Level Down", null, "ButtonExpand"){

        public void run() {
            CircuitChanges.DoExpandCommands(false, 1);
        }
    };
    public static final EToolBarButton unexpandOneLevelCommand = new EToolBarButton("_One Level Up", null, "ButtonUnexpand"){

        public void run() {
            CircuitChanges.DoExpandCommands(true, 1);
        }
    };
    public static final EToolBarButton undoCommand = new EToolBarButton("_Undo", 'Z', "ButtonUndo"){

        public void run() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null && wf.getContent() instanceof TextWindow) {
                TextWindow tw = (TextWindow)wf.getContent();
                tw.undo();
            } else {
                GetInfoText.EditInPlaceListener eip;
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd != null && (eip = wnd.getInPlaceTextObject()) != null) {
                    eip.undo();
                    return;
                }
                Undo.undo();
            }
        }

        public boolean isEnabled() {
            return UserInterfaceMain.getUndoEnabled();
        }
    };
    public static final EToolBarButton redoCommand = new EToolBarButton("Re_do", 'Y', "ButtonRedo"){

        public void run() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null && wf.getContent() instanceof TextWindow) {
                TextWindow tw = (TextWindow)wf.getContent();
                tw.redo();
            } else {
                GetInfoText.EditInPlaceListener eip;
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd != null && (eip = wnd.getInPlaceTextObject()) != null) {
                    eip.redo();
                    return;
                }
                Undo.redo();
            }
        }

        public boolean isEnabled() {
            return UserInterfaceMain.getRedoEnabled();
        }
    };
    private CellHistoryButton goBackButton = new CellHistoryButton("Go Back a Cell", "ButtonGoBack"){

        public void run() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                wf.cellHistoryGoBack();
            }
        }
    };
    private CellHistoryButton goForwardButton = new CellHistoryButton("Go Forward a Cell", "ButtonGoForward"){

        public void run() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                wf.cellHistoryGoForward();
            }
        }
    };

    private ToolBar() {
        EToolBarButton[] buttons;
        this.setFloatable(true);
        this.setRollover(true);
        for (EToolBarButton b : buttons = new EToolBarButton[]{openLibraryCommand, saveLibraryCommand, null, clickZoomWireCommand, panCommand, zoomCommand, outlineCommand, measureCommand, null, fullArrowDistanceCommand, halfArrowDistanceCommand, quarterArrowDistanceCommand, null, selectObjectsCommand, selectAreaCommand, null, toggleSelectSpecialCommand, null, preferencesCommand, null, undoCommand, redoCommand, null, this.goBackButton, this.goForwardButton, null, expandOneLevelCommand, unexpandOneLevelCommand}) {
            if (b == null) {
                this.addSeparator();
                continue;
            }
            AbstractButton j = b.genToolBarButton();
            this.add(j);
            j.setFocusable(false);
        }
        this.setFocusable(false);
    }

    public static ToolBar createToolBar() {
        return new ToolBar();
    }

    public static void setSaveLibraryButton() {
        ToolBar.updateToolBarButtons();
    }

    public static Cursor readCursor(String cursorName, int hotX, int hotY) {
        ImageIcon imageIcon = Resources.getResource(ToolBar.class, cursorName);
        Image image = imageIcon.getImage();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Dimension bestSize = Toolkit.getDefaultToolkit().getBestCursorSize(width, height);
        int bestWidth = (int)bestSize.getWidth();
        int bestHeight = (int)bestSize.getHeight();
        if (bestWidth != 0 && bestHeight != 0 && (bestWidth != width || bestHeight != height)) {
            if (bestWidth > width && bestHeight > height) {
                BufferedImage newImage = new BufferedImage(bestWidth, bestHeight, 2);
                Graphics g = ((Image)newImage).getGraphics();
                g.drawImage(image, (bestWidth - width) / 2, (bestHeight - height) / 2, null);
                image = newImage;
                hotX += (bestWidth - width) / 2;
                hotY += (bestHeight - height) / 2;
            } else {
                image = image.getScaledInstance(bestWidth, bestHeight, 0);
                hotX = hotX * bestWidth / width;
                hotY = hotY * bestHeight / height;
            }
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(hotX, hotY), cursorName);
        return cursor;
    }

    public static CursorMode getCursorMode() {
        return curMode;
    }

    private static void setCursorMode(CursorMode cm) {
        switch (cm) {
            case CLICKZOOMWIRE: {
                ToolBar.checkLeavingOutlineMode();
                WindowFrame.setListener(ClickZoomWireListener.theOne);
                TopLevel.setCurrentCursor(Cursor.getPredefinedCursor(0));
                curMode = CursorMode.CLICKZOOMWIRE;
                break;
            }
            case PAN: {
                if (WindowFrame.getListener() == ZoomAndPanListener.theOne && curMode == CursorMode.PAN) {
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                WindowFrame.setListener(ZoomAndPanListener.theOne);
                TopLevel.setCurrentCursor(panCursor);
                curMode = CursorMode.PAN;
                break;
            }
            case ZOOM: {
                if (WindowFrame.getListener() == ZoomAndPanListener.theOne && curMode == CursorMode.ZOOM) {
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                ToolBar.checkLeavingOutlineMode();
                WindowFrame.setListener(ZoomAndPanListener.theOne);
                TopLevel.setCurrentCursor(zoomCursor);
                curMode = CursorMode.ZOOM;
                break;
            }
            case OUTLINE: {
                if (WindowFrame.getListener() == OutlineListener.theOne) {
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                EditWindow wnd = EditWindow.needCurrent();
                if (wnd == null) {
                    return;
                }
                Highlighter highlighter = wnd.getHighlighter();
                CursorMode oldMode = curMode;
                NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
                if (ni == null) {
                    if (oldMode == CursorMode.OUTLINE) {
                        ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    } else {
                        ToolBar.setCursorMode(oldMode);
                    }
                    return;
                }
                NodeProto np = ni.getProto();
                if (ni.isCellInstance() || !((PrimitiveNode)np).isHoldsOutline()) {
                    System.out.println("Sorry, " + np + " does not hold outline information");
                    if (oldMode == CursorMode.OUTLINE) {
                        ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    } else {
                        ToolBar.setCursorMode(oldMode);
                    }
                    return;
                }
                if (WindowFrame.getListener() != OutlineListener.theOne) {
                    OutlineListener.theOne.setNode(ni);
                }
                WindowFrame.setListener(OutlineListener.theOne);
                TopLevel.setCurrentCursor(outlineCursor);
                curMode = CursorMode.OUTLINE;
                break;
            }
            case MEASURE: {
                if (WindowFrame.getListener() == MeasureListener.theOne) {
                    ToolBar.setCursorMode(CursorMode.CLICKZOOMWIRE);
                    return;
                }
                ToolBar.checkLeavingOutlineMode();
                MeasureListener.theOne.reset();
                WindowFrame.setListener(MeasureListener.theOne);
                TopLevel.setCurrentCursor(measureCursor);
                curMode = CursorMode.MEASURE;
            }
        }
    }

    private static void checkLeavingOutlineMode() {
        Highlight2 high;
        Highlighter highlighter;
        NodeInst ni;
        EditWindow wnd;
        if (WindowFrame.getListener() == OutlineListener.theOne && curMode == CursorMode.OUTLINE && (wnd = EditWindow.needCurrent()) != null && (ni = (NodeInst)(highlighter = wnd.getHighlighter()).getOneElectricObject(NodeInst.class)) != null && (high = highlighter.getOneHighlight()) != null) {
            high.setPoint(-1);
            wnd.repaint();
        }
    }

    public static void setGridAligment() {
        ToolBar.updateToolBarButtons();
    }

    public static SelectMode getSelectMode() {
        return curSelectMode;
    }

    private static void setSelectMode(SelectMode selectMode) {
        curSelectMode = selectMode;
    }

    public static boolean isSelectSpecial() {
        return selectSpecial;
    }

    private static void setSelectSpecial(boolean b) {
        selectSpecial = b;
    }

    public static void updateUndoRedoButtons(boolean undo, boolean redo) {
        ToolBar.updateToolBarButtons();
    }

    public void updateCellHistoryStatus(boolean backEnabled, boolean forwardEnabled) {
        this.goBackButton.setEnabled(backEnabled);
        this.goForwardButton.setEnabled(forwardEnabled);
        ToolBar.updateToolBarButtons();
    }

    private static void showHistoryPopup(MouseEvent e) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        List<WindowFrame.CellHistory> historyList = wf.getCellHistoryList();
        int location = wf.getCellHistoryLocation();
        JPopupMenu popup = new JPopupMenu();
        HashMap<Cell, Cell> listed = new HashMap<Cell, Cell>();
        for (int i = historyList.size() - 1; i > -1; --i) {
            WindowFrame.CellHistory entry = historyList.get(i);
            Cell cell = entry.getCell();
            if (cell == null || listed.get(cell) != null) continue;
            listed.put(cell, cell);
            boolean shown = i == location;
            JMenuItem m = new JMenuItem(cell.noLibDescribe() + (shown ? "  (shown)" : ""));
            m.addActionListener(new HistoryPopupAction(wf, i));
            popup.add(m);
        }
        Component invoker = e.getComponent();
        if (invoker != null) {
            popup.setInvoker(invoker);
            Point loc = invoker.getLocationOnScreen();
            popup.setLocation((int)((Point2D)loc).getX() + invoker.getWidth() / 2, (int)((Point2D)loc).getY() + invoker.getHeight() / 2);
        }
        popup.setVisible(true);
    }

    public static void updateToolBarButtons() {
        for (ToolBar toolBar : TopLevel.getToolBars()) {
            for (Component c : toolBar.getComponents()) {
                if (!(c instanceof AbstractButton)) continue;
                AbstractButton b = (AbstractButton)c;
                for (ActionListener a : b.getActionListeners()) {
                    if (!(a instanceof EToolBarButton)) continue;
                    ((EToolBarButton)a).updateToolBarButton(b);
                }
            }
        }
        MenuCommands.menuBar().updateAllButtons();
    }

    public void finished() {
    }

    private static class HistoryPopupAction
    implements ActionListener {
        private final WindowFrame wf;
        private final int historyLocation;

        private HistoryPopupAction(WindowFrame wf, int loc) {
            this.wf = wf;
            this.historyLocation = loc;
        }

        public void actionPerformed(ActionEvent e) {
            this.wf.setCellByHistory(this.historyLocation);
        }
    }

    private static abstract class CellHistoryButton
    extends EToolBarButton
    implements MouseListener {
        private boolean enabled;

        CellHistoryButton(String text, String iconName) {
            super(text, null, iconName);
        }

        AbstractButton genToolBarButton() {
            AbstractButton b = super.genToolBarButton();
            b.addMouseListener(this);
            return b;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        void setEnabled(boolean b) {
            this.enabled = b;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (ClickZoomWireListener.isRightMouse(e) && b.contains(e.getX(), e.getY())) {
                ToolBar.showHistoryPopup(e);
            }
        }
    }

    public static class SelectModeButton
    extends EToolBarRadioButton {
        private final SelectMode sm;

        SelectModeButton(String text, String iconName, SelectMode sm) {
            super(text, null, iconName);
            this.sm = sm;
        }

        public boolean isSelected() {
            return ToolBar.getSelectMode() == this.sm;
        }

        public void run() {
            ToolBar.setSelectMode(this.sm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectMode {
        OBJECTS,
        AREA;

    }

    private static class ArrowDistanceButton
    extends EToolBarRadioButton {
        private final ArrowDistance ad;

        ArrowDistanceButton(String text, String iconName, ArrowDistance ad) {
            super(text, null, iconName);
            this.ad = ad;
        }

        ArrowDistanceButton(String text, char acceleratorChar, String iconName, ArrowDistance ad) {
            super(text, KeyStroke.getKeyStroke((int)acceleratorChar, 0), iconName);
            this.ad = ad;
        }

        public boolean isSelected() {
            return this.ad.isSelected();
        }

        public void run() {
            this.ad.setAlignmentToGrid();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArrowDistance {
        FULL(1.0, 0),
        HALF(0.5, 1),
        QUARTER(0.25, 2);

        private final int position;

        private ArrowDistance(double amount, int pos) {
            this.position = pos;
        }

        public boolean isSelected() {
            double[] vals = User.getAlignmentToGridVector();
            for (int i = 0; i < vals.length; ++i) {
                if (!(vals[i] < 0.0)) continue;
                return i == this.position;
            }
            return false;
        }

        public void setAlignmentToGrid() {
            double[] vals = User.getAlignmentToGridVector();
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = i != this.position ? Math.abs(vals[i]) : Math.abs(vals[i]) * -1.0;
            }
            User.setAlignmentToGridVector(vals);
        }
    }

    private static class CursorModeButton
    extends EToolBarRadioButton {
        private final CursorMode cm;

        CursorModeButton(String text, char acceleratorChar, String iconName, CursorMode cm) {
            super(text, KeyStroke.getKeyStroke((int)acceleratorChar, 0), iconName);
            this.cm = cm;
        }

        public boolean isSelected() {
            return ToolBar.getCursorMode() == this.cm;
        }

        public void run() {
            ToolBar.setCursorMode(this.cm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CursorMode {
        CLICKZOOMWIRE,
        PAN,
        ZOOM,
        OUTLINE,
        MEASURE;

    }

    private static abstract class EToolBarRadioButton
    extends EToolBarButton {
        EToolBarRadioButton(String text, KeyStroke accelerator, String iconName) {
            super(text, accelerator, iconName);
        }

        EToolBarRadioButton(String text, char acceleratorChar, String iconName) {
            super(text, acceleratorChar, iconName);
        }

        protected JMenuItem createMenuItem() {
            if (Client.isOSMac()) {
                return new JMenuItem();
            }
            return new JRadioButtonMenuItem();
        }

        JToggleButton createToolBarButton() {
            return new JToggleButton();
        }
    }

    private static abstract class EToolBarButton
    extends EMenuItem {
        private ImageIcon defaultIcon;

        EToolBarButton(String text, KeyStroke accelerator, String iconName) {
            super(text, accelerator);
            this.defaultIcon = Resources.getResource(ToolBar.class, iconName + ".gif");
        }

        EToolBarButton(String text, char acceleratorChar, String iconName) {
            super(text, acceleratorChar);
            this.defaultIcon = Resources.getResource(ToolBar.class, iconName + ".gif");
        }

        AbstractButton genToolBarButton() {
            AbstractButton b = this.createToolBarButton();
            b.setToolTipText(this.getToolTipText());
            b.setIcon(this.defaultIcon);
            b.addActionListener(this);
            this.updateToolBarButton(b);
            return b;
        }

        AbstractButton createToolBarButton() {
            return new JButton();
        }

        void updateToolBarButton(AbstractButton item) {
            item.setEnabled(this.isEnabled());
            item.setSelected(this.isSelected());
            item.setToolTipText(this.getToolTipText());
        }

        protected void registerItem() {
            super.registerItem();
            this.registerUpdatable();
        }

        protected void updateButtons() {
            ToolBar.updateToolBarButtons();
        }
    }
}

