/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeaOfGatesEngine {
    private static final boolean DEBUGSTEPS = false;
    private static final boolean DEBUGFAILURE = false;
    private static final boolean NEWNOTCH = true;
    private static final boolean FULLGRAIN = false;
    private static final double GRANULARITY = 1.0;
    private static final double GRAINSIZE = 1.0;
    private static final int COSTALTERNATINGMETAL = 4;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 5;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    private Cell cell;
    private Technology tech;
    private Map<Layer, RTNode> metalTrees;
    private Map<Layer, RTNode> viaTrees;
    private Map<ArcInst, Integer> netIDs;
    private int numMetalLayers;
    private Layer[] metalLayers;
    private Layer[] viaLayers;
    private ArcProto[] metalArcs;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private MetalVias[] metalVias;
    private Map<Double, Double>[] layerSurround;
    private double[] worstMetalSurround;
    private double[] viaSurround;
    private Map<Integer, Set<Integer>>[] searchVertexPlanes;
    private Map<Double, Set<Double>>[] searchVertexPlanesDBL;
    private double destX;
    private double destY;
    private int destZ;
    private double totalWireLength;
    private boolean firstFailure;
    private ErrorLogger errorLogger;

    public void routeIt(Job job, Cell cell, List<ArcInst> arcsToRoute) {
        if (this.initializeDesignRules(cell)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        Job.getUserInterface().startProgressDialog("Routing " + arcsToRoute.size() + " nets", null);
        Job.getUserInterface().setProgressNote("Building blockage information...");
        this.errorLogger = ErrorLogger.newInstance("Routing (Sea of gates)");
        this.metalTrees = new HashMap<Layer, RTNode>();
        this.viaTrees = new HashMap<Layer, RTNode>();
        this.netIDs = new HashMap<ArcInst, Integer>();
        BlockageVisitor visitor = new BlockageVisitor(arcsToRoute);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)visitor);
        this.addBlockagesAtPorts(arcsToRoute);
        int numFailedRoutes = 0;
        int numRoutedSegments = 0;
        int numSegments = 0;
        this.firstFailure = true;
        this.totalWireLength = 0.0;
        int numToRoute = arcsToRoute.size();
        for (int a = 0; a < numToRoute; ++a) {
            if (job.checkAbort()) {
                System.out.println("Sea-of-gates routing aborted");
                break;
            }
            ArcInst ai = arcsToRoute.get(a);
            Netlist netList = cell.acquireUserNetlist();
            if (netList == null) {
                System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
                break;
            }
            Network net = netList.getNetwork(ai, 0);
            if (net == null) {
                System.out.println("Arc " + ai.describe(false) + " has no network!");
                continue;
            }
            Job.getUserInterface().setProgressValue(a * 100 / numToRoute);
            Job.getUserInterface().setProgressNote("Network " + net.getName());
            System.out.println("Routing network " + net.getName() + "...");
            HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
            HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
            List<Connection> netEnds = Routing.findNetEnds(net, arcsToDelete, nodesToDelete, netList, true);
            List<PortInst> orderedPorts = this.makeOrderedPorts(net, netEnds);
            if (orderedPorts == null) {
                System.out.println("No valid connection points found on the network.");
                continue;
            }
            double minWidth = this.getMinWidth(orderedPorts);
            boolean allRouted = true;
            boolean[] segRouted = new boolean[orderedPorts.size() - 1];
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null) {
                netID = netIDI - 1;
            }
            for (int i = 0; i < orderedPorts.size() - 1; ++i) {
                PortInst fromPi = orderedPorts.get(i);
                PortInst toPi = orderedPorts.get(i + 1);
                ++numSegments;
                if (this.inValidPort(fromPi) || this.inValidPort(toPi)) {
                    allRouted = false;
                    continue;
                }
                segRouted[i] = this.findPath(netID, fromPi, toPi, minWidth);
                if (segRouted[i]) {
                    ++numRoutedSegments;
                    continue;
                }
                allRouted = false;
            }
            if (allRouted) {
                for (ArcInst aiKill : arcsToDelete) {
                    aiKill.kill();
                }
                cell.killNodes(nodesToDelete);
                continue;
            }
            ++numFailedRoutes;
            for (ArcInst aiKill : arcsToDelete) {
                int headPort = -1;
                int tailPort = -1;
                for (int i = 0; i < orderedPorts.size(); ++i) {
                    PortInst pi = orderedPorts.get(i);
                    if (aiKill.getHeadPortInst() == pi) {
                        headPort = i;
                        continue;
                    }
                    if (aiKill.getTailPortInst() != pi) continue;
                    tailPort = i;
                }
                if (headPort < 0 || tailPort < 0) continue;
                boolean failed = false;
                if (headPort > tailPort) {
                    int swap = headPort;
                    headPort = tailPort;
                    tailPort = swap;
                }
                for (int i = headPort; i < tailPort; ++i) {
                    if (segRouted[i]) continue;
                    failed = true;
                }
                if (failed) continue;
                aiKill.kill();
            }
        }
        this.errorLogger.termLogging(true);
        long stopTime = System.currentTimeMillis();
        Job.getUserInterface().stopProgressDialog();
        System.out.println("Routed " + numRoutedSegments + " out of " + numSegments + " segments; total length of routed wires is " + TextUtils.formatDouble(this.totalWireLength) + "; took " + TextUtils.getElapsedTime(stopTime - startTime));
        if (numFailedRoutes > 0) {
            System.out.println("NOTE: " + numFailedRoutes + " nets were not routed");
        }
    }

    private boolean initializeDesignRules(Cell c) {
        int i;
        this.cell = c;
        this.tech = this.cell.getTechnology();
        this.numMetalLayers = this.tech.getNumMetals();
        this.metalLayers = new Layer[this.numMetalLayers];
        this.metalArcs = new ArcProto[this.numMetalLayers];
        this.favorArcs = new boolean[this.numMetalLayers];
        this.preventArcs = new boolean[this.numMetalLayers];
        this.viaLayers = new Layer[this.numMetalLayers - 1];
        this.metalVias = new MetalVias[this.numMetalLayers - 1];
        for (int i2 = 0; i2 < this.numMetalLayers - 1; ++i2) {
            this.metalVias[i2] = new MetalVias();
        }
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            int layerIndex;
            Layer lay = it.next();
            if (!lay.getFunction().isMetal() || lay.isPseudoLayer() || (layerIndex = lay.getFunction().getLevel() - 1) >= this.numMetalLayers) continue;
            this.metalLayers[layerIndex] = lay;
        }
        boolean hasFavorites = false;
        Iterator<ArcProto> it2 = this.tech.getArcs();
        block2: while (it2.hasNext()) {
            ArcProto ap = it2.next();
            for (int i3 = 0; i3 < this.numMetalLayers; ++i3) {
                if (ap.getLayer(0) != this.metalLayers[i3]) continue;
                this.metalArcs[i3] = ap;
                this.favorArcs[i3] = Routing.isSeaOfGatesFavor(ap);
                if (this.favorArcs[i3]) {
                    hasFavorites = true;
                }
                this.preventArcs[i3] = Routing.isSeaOfGatesPrevent(ap);
                continue block2;
            }
        }
        if (!hasFavorites) {
            for (int i4 = 0; i4 < this.numMetalLayers; ++i4) {
                this.favorArcs[i4] = true;
            }
        }
        Iterator<PrimitiveNode> it22 = this.tech.getNodes();
        block5: while (it22.hasNext()) {
            PrimitiveNode np = it22.next();
            if (np.isNotUsed() || np.getFunction() != PrimitiveNode.Function.CONTACT) continue;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i5 = 0; i5 < this.numMetalLayers - 1; ++i5) {
                if ((conns[0] != this.metalArcs[i5] || conns[1] != this.metalArcs[i5 + 1]) && (conns[1] != this.metalArcs[i5] || conns[0] != this.metalArcs[i5 + 1])) continue;
                this.metalVias[i5].addVia(np, 0);
                boolean square = true;
                boolean offCenter = false;
                NodeInst dummyNi = NodeInst.makeDummyInstance(np);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (lFun.isMetal()) {
                        Rectangle2D conRect = conPoly.getBounds2D();
                        if (conRect.getWidth() != conRect.getHeight()) {
                            square = false;
                        }
                        if (conRect.getCenterX() == 0.0 && conRect.getCenterY() == 0.0) continue;
                        offCenter = true;
                        continue;
                    }
                    if (!lFun.isContact()) continue;
                    this.viaLayers[i5] = conLayer;
                }
                if (offCenter) {
                    this.metalVias[i5].addVia(np, 90);
                    this.metalVias[i5].addVia(np, 180);
                    this.metalVias[i5].addVia(np, 270);
                    continue block5;
                }
                if (square) continue block5;
                this.metalVias[i5].addVia(np, 90);
                continue block5;
            }
        }
        for (i = 0; i < this.numMetalLayers; ++i) {
            if (this.metalLayers[i] == null) {
                System.out.println("ERROR: Cannot find layer for Metal " + (i + 1));
                return true;
            }
            if (this.metalArcs[i] == null) {
                System.out.println("ERROR: Cannot find arc for Metal " + (i + 1));
                return true;
            }
            if (i >= this.numMetalLayers - 1) continue;
            if (this.metalVias[i].getVias().size() == 0) {
                System.out.println("ERROR: Cannot find contact node between Metal " + (i + 1) + " and Metal " + (i + 2));
                return true;
            }
            if (this.viaLayers[i] != null) continue;
            System.out.println("ERROR: Cannot find contact layer between Metal " + (i + 1) + " and Metal " + (i + 2));
            return true;
        }
        this.layerSurround = new Map[this.numMetalLayers];
        this.worstMetalSurround = new double[this.numMetalLayers];
        for (i = 0; i < this.numMetalLayers; ++i) {
            this.layerSurround[i] = new HashMap<Double, Double>();
            this.worstMetalSurround[i] = DRC.getMaxSurround(this.metalLayers[i], Double.MAX_VALUE);
        }
        this.viaSurround = new double[this.numMetalLayers - 1];
        for (i = 0; i < this.numMetalLayers - 1; ++i) {
            Layer lay = this.viaLayers[i];
            double spacing = 2.0;
            double arcWidth = this.metalArcs[i].getDefaultLambdaBaseWidth();
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, arcWidth, 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double width = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            List<MetalVia> nps = this.metalVias[i].getVias();
            for (MetalVia mv : nps) {
                NodeInst dummyNi = NodeInst.makeDummyInstance(mv.via);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    if (!conPoly.getLayer().getFunction().isContact()) continue;
                    Rectangle2D bounds = conPoly.getBounds2D();
                    width = Math.max(width, bounds.getWidth());
                    width = Math.max(width, bounds.getHeight());
                }
            }
            this.viaSurround[i] = spacing + width;
        }
        return false;
    }

    private double getSpacingRule(int layer, double width, double length) {
        Double wid;
        Double value;
        if (width < 0.0) {
            width = this.metalArcs[layer].getDefaultLambdaBaseWidth();
        }
        if (length < 0.0) {
            length = 50.0;
        }
        if ((value = this.layerSurround[layer].get(wid = new Double(this.upToGrain(width)))) == null) {
            Layer lay = this.metalLayers[layer];
            DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, width, length);
            double v = 0.0;
            if (rule != null) {
                v = rule.getValue(0);
            }
            value = new Double(v);
            this.layerSurround[layer].put(wid, value);
        }
        return value;
    }

    private double getMinWidth(List<PortInst> orderedPorts) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > Routing.getSeaOfGatesMaxWidth()) {
            minWidth = Routing.getSeaOfGatesMaxWidth();
        }
        return minWidth;
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (!ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    private boolean inValidPort(PortInst pi) {
        ArcProto[] conns = pi.getPortProto().getBasePort().getConnections();
        boolean valid = false;
        for (int j = 0; j < conns.length; ++j) {
            ArcProto ap = conns[j];
            if (ap.getTechnology() != this.tech || !ap.getFunction().isMetal() || this.preventArcs[conns[j].getFunction().getLevel() - 1]) continue;
            valid = true;
            break;
        }
        if (!valid) {
            System.out.println("Cannot connect to port " + pi.getPortProto().getName() + " on node " + pi.getNodeInst().describe(false) + " because all connecting layers have been prevented by Routing Preferences");
            return true;
        }
        return false;
    }

    private void addBlockagesAtPorts(List<ArcInst> arcsToRoute) {
        Netlist netList = this.cell.acquireUserNetlist();
        if (netList == null) {
            return;
        }
        for (ArcInst ai : arcsToRoute) {
            HashSet<NodeInst> nodesToDelete;
            HashSet<ArcInst> arcsToDelete;
            List<Connection> netEnds;
            Network net;
            List<PortInst> orderedPorts;
            int netID = -1;
            Integer netIDI = this.netIDs.get(ai);
            if (netIDI != null && (netID = -(netIDI - 1)) > 0) {
                System.out.println("INTERNAL ERROR! net=" + netID + " but should be negative");
            }
            if ((orderedPorts = this.makeOrderedPorts(net = netList.getNetwork(ai, 0), netEnds = Routing.findNetEnds(net, arcsToDelete = new HashSet<ArcInst>(), nodesToDelete = new HashSet<NodeInst>(), netList, true))) == null) continue;
            double minWidth = this.getMinWidth(orderedPorts);
            for (PortInst pi : orderedPorts) {
                Poly poly = pi.getPoly();
                Rectangle2D polyBounds = poly.getBounds2D();
                ArcProto[] poss = pi.getPortProto().getBasePort().getConnections();
                int lowMetal = -1;
                int highMetal = -1;
                for (int i = 0; i < poss.length; ++i) {
                    if (poss[i].getTechnology() != this.tech || !poss[i].getFunction().isMetal()) continue;
                    int level = poss[i].getFunction().getLevel();
                    if (lowMetal < 0) {
                        lowMetal = highMetal = level;
                        continue;
                    }
                    lowMetal = Math.min(lowMetal, level);
                    highMetal = Math.max(highMetal, level);
                }
                if (lowMetal < 0) continue;
                for (int via = lowMetal - 2; via < highMetal; ++via) {
                    if (via < 0 || via >= this.numMetalLayers - 1) continue;
                    MetalVia mv = this.metalVias[via].getVias().get(0);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = this.tech.getShapeOfNode(dummy);
                    for (int i = 0; i < polys.length; ++i) {
                        Poly viaPoly = polys[i];
                        Layer layer = viaPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        Rectangle2D viaBounds = viaPoly.getBounds2D();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(viaBounds.getMinX() + polyBounds.getCenterX(), viaBounds.getMinY() + polyBounds.getCenterY(), viaBounds.getWidth(), viaBounds.getHeight());
                        this.addRectangle(bounds, layer, netID);
                    }
                }
            }
        }
    }

    private List<PortInst> makeOrderedPorts(Network net, List<Connection> netEnds) {
        ArrayList<PortInst> portEndList = new ArrayList<PortInst>();
        for (int i = 0; i < netEnds.size(); ++i) {
            PortInst pi = netEnds.get(i).getPortInst();
            if (!pi.getNodeInst().isCellInstance() && ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() == Generic.tech || portEndList.contains(pi)) continue;
            portEndList.add(pi);
        }
        int count = portEndList.size();
        if (count == 0) {
            return null;
        }
        if (count == 1) {
            System.out.println("Error: Network " + net.describe(false) + " has only one end");
            return null;
        }
        PortInst[] portEnds = new PortInst[count];
        int k = 0;
        for (PortInst pi : portEndList) {
            portEnds[k++] = pi;
        }
        int closest1 = 0;
        int closest2 = 0;
        double closestDist = Double.MAX_VALUE;
        for (int i = 0; i < count; ++i) {
            Poly poly1 = portEnds[i].getPoly();
            for (int j = i + 1; j < count; ++j) {
                Poly poly2 = portEnds[j].getPoly();
                double dist = poly1.getCenter().distance(poly2.getCenter());
                if (!(dist < closestDist)) continue;
                closestDist = dist;
                closest1 = i;
                closest2 = j;
            }
        }
        ArrayList<PortInst> orderedPorts = new ArrayList<PortInst>();
        orderedPorts.add(portEnds[closest1]);
        orderedPorts.add(portEnds[closest2]);
        portEnds[closest1] = null;
        portEnds[closest2] = null;
        while (true) {
            boolean foundsome = false;
            double closestDist1 = Double.MAX_VALUE;
            double closestDist2 = Double.MAX_VALUE;
            for (int i = 0; i < count; ++i) {
                if (portEnds[i] == null) continue;
                Poly poly = portEnds[i].getPoly();
                Poly poly1 = ((PortInst)orderedPorts.get(0)).getPoly();
                double dist1 = poly.getCenter().distance(poly1.getCenter());
                if (dist1 < closestDist1) {
                    closestDist1 = dist1;
                    closest1 = i;
                    foundsome = true;
                }
                Poly poly2 = ((PortInst)orderedPorts.get(orderedPorts.size() - 1)).getPoly();
                double dist2 = poly.getCenter().distance(poly2.getCenter());
                if (!(dist2 < closestDist2)) continue;
                closestDist2 = dist2;
                closest2 = i;
                foundsome = true;
            }
            if (!foundsome) break;
            if (closestDist1 < closestDist2) {
                orderedPorts.add(0, portEnds[closest1]);
                portEnds[closest1] = null;
                continue;
            }
            orderedPorts.add(portEnds[closest2]);
            portEnds[closest2] = null;
        }
        return orderedPorts;
    }

    private boolean findPath(int netID, PortInst fromPi, PortInst toPi, double minWidth) {
        double surround;
        double fromY;
        double toY;
        double fromX;
        double toX;
        ArcProto fromArc = null;
        ArcProto[] fromArcs = fromPi.getPortProto().getBasePort().getConnections();
        for (int i = 0; i < fromArcs.length; ++i) {
            if (!fromArcs[i].getFunction().isMetal()) continue;
            fromArc = fromArcs[i];
            break;
        }
        if (fromArc == null) {
            String errorMsg = "Cannot connect port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " because it has no metal connection";
            System.out.println("ERROR: " + errorMsg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(fromPi.getPoly());
            this.errorLogger.logError(errorMsg, null, null, null, null, polyList, this.cell, 0);
            return false;
        }
        EPoint fromLoc = fromPi.getPoly().getCenter();
        ArcProto toArc = null;
        ArcProto[] toArcs = toPi.getPortProto().getBasePort().getConnections();
        for (int i = 0; i < toArcs.length; ++i) {
            if (!toArcs[i].getFunction().isMetal()) continue;
            toArc = toArcs[i];
            break;
        }
        if (toArc == null) {
            String errorMsg = "Cannot connect port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because it has no metal connection";
            System.out.println("ERROR: " + errorMsg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(toPi.getPoly());
            this.errorLogger.logError(errorMsg, null, null, null, null, polyList, this.cell, 0);
            return false;
        }
        EPoint toLoc = toPi.getPoly().getCenter();
        if (toLoc.getX() < fromLoc.getX()) {
            toX = this.upToGrain(toLoc.getX());
            fromX = this.downToGrain(fromLoc.getX());
        } else if (toLoc.getX() > fromLoc.getX()) {
            toX = this.downToGrain(toLoc.getX());
            fromX = this.upToGrain(fromLoc.getX());
        } else {
            toX = fromX = this.upToGrain(fromLoc.getX());
        }
        if (toLoc.getY() < fromLoc.getY()) {
            toY = this.upToGrain(toLoc.getY());
            fromY = this.downToGrain(fromLoc.getY());
        } else if (toLoc.getY() > fromLoc.getY()) {
            toY = this.downToGrain(toLoc.getY());
            fromY = this.upToGrain(fromLoc.getY());
        } else {
            toY = fromY = this.upToGrain(fromLoc.getY());
        }
        int fromZ = fromArc.getFunction().getLevel() - 1;
        int toZ = toArc.getFunction().getLevel() - 1;
        if (fromArc.getTechnology() != this.tech || toArc.getTechnology() != this.tech) {
            String errorMsg = "Route from port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " on arc " + fromArc.describe() + " cannot connect to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " on arc " + toArc.describe() + " because they have different technologies";
            System.out.println("ERROR: " + errorMsg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            Poly fromPoly = fromPi.getPoly();
            Poly toPoly = toPi.getPoly();
            polyList.add(fromPoly);
            polyList.add(toPoly);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(toPoly.getCenterX(), toPoly.getCenterY()));
            lineList.add(new EPoint(fromPoly.getCenterX(), fromPoly.getCenterY()));
            this.errorLogger.logError(errorMsg, null, null, lineList, null, polyList, this.cell, 0);
            return false;
        }
        double metalSpacing = Math.max(this.metalArcs[fromZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0;
        SOGBound block = this.getMetalBlockage(netID, fromZ, metalSpacing, metalSpacing, surround = this.getSpacingRule(fromZ, -1.0, -1.0), fromX, fromY);
        if (block != null) {
            String errorMsg = "Cannot Route to port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " because it is blocked on layer " + this.metalLayers[fromZ].getName() + " [needs " + TextUtils.formatDouble(metalSpacing + surround) + " all around, has blockage at (" + TextUtils.formatDouble(block.bound.getCenterX()) + "," + TextUtils.formatDouble(block.bound.getCenterY()) + ") that is " + TextUtils.formatDouble(block.bound.getWidth()) + "x" + TextUtils.formatDouble(block.bound.getHeight()) + "]";
            System.out.println(errorMsg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(new PolyBase(fromX, fromY, (metalSpacing + surround) * 2.0, (metalSpacing + surround) * 2.0));
            polyList.add(new PolyBase(block.bound));
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMinY()));
            lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMaxY()));
            lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMaxY()));
            lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMinY()));
            this.errorLogger.logError(errorMsg, null, null, lineList, null, polyList, this.cell, 0);
            return false;
        }
        metalSpacing = Math.max(this.metalArcs[toZ].getDefaultLambdaBaseWidth(), minWidth) / 2.0;
        block = this.getMetalBlockage(netID, toZ, metalSpacing, metalSpacing, surround = this.getSpacingRule(toZ, -1.0, -1.0), toX, toY);
        if (block != null) {
            String errorMsg = "Cannot route to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false) + " because it is blocked on layer " + this.metalLayers[toZ].getName() + ".  Needs " + TextUtils.formatDouble(metalSpacing + surround) + " all around, has blockage at (" + TextUtils.formatDouble(block.bound.getCenterX()) + "," + TextUtils.formatDouble(block.bound.getCenterY()) + ") that is " + TextUtils.formatDouble(block.bound.getWidth()) + "x" + TextUtils.formatDouble(block.bound.getHeight());
            System.out.println("ERROR: " + errorMsg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(new PolyBase(toX, toY, (metalSpacing + surround) * 2.0, (metalSpacing + surround) * 2.0));
            polyList.add(new PolyBase(block.bound));
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMinY()));
            lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMaxY()));
            lineList.add(new EPoint(block.bound.getMinX(), block.bound.getMaxY()));
            lineList.add(new EPoint(block.bound.getMaxX(), block.bound.getMinY()));
            this.errorLogger.logError(errorMsg, null, null, lineList, null, polyList, this.cell, 0);
            return false;
        }
        List<SearchVertex> vertices = this.doDijkstra(fromX, fromY, fromZ, toX, toY, toZ, netID, minWidth);
        Object saveD1Planes = null;
        List<SearchVertex> verticesRev = this.doDijkstra(toX, toY, toZ, fromX, fromY, fromZ, netID, minWidth);
        double verLength = this.getVertexLength(vertices);
        double verLengthRev = this.getVertexLength(verticesRev);
        if (verLength == Double.MAX_VALUE && verLengthRev == Double.MAX_VALUE) {
            String errorMsg = vertices == null && verticesRev == null ? "Search too complex (exceeds complexity limit of " + Routing.getSeaOfGatesComplexityLimit() + " steps)" : "Failed to route from port " + fromPi.getPortProto().getName() + " of node " + fromPi.getNodeInst().describe(false) + " to port " + toPi.getPortProto().getName() + " of node " + toPi.getNodeInst().describe(false);
            System.out.println("ERROR: " + errorMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            lineList.add(new EPoint(toX, toY));
            lineList.add(new EPoint(fromX, fromY));
            this.errorLogger.logError(errorMsg, null, null, lineList, null, null, this.cell, 0);
            return false;
        }
        if (verLength == Double.MAX_VALUE || verLength > verLengthRev) {
            vertices = verticesRev;
            PortInst pi = toPi;
            toPi = fromPi;
            fromPi = pi;
            double s = toX;
            toX = fromX;
            fromX = s;
            s = toY;
            toY = fromY;
            fromY = s;
            int a = toZ;
            toZ = fromZ;
            fromZ = a;
        }
        PortInst lastPort = toPi;
        Poly toPoly = toPi.getPoly();
        if ((toPoly.getCenterX() != toX || toPoly.getCenterY() != toY) && vertices.size() >= 2) {
            NodeInst ni;
            SearchVertex v1 = vertices.get(0);
            SearchVertex v2 = vertices.get(1);
            ArcProto type = this.metalArcs[toZ];
            double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
            PrimitiveNode np = this.metalArcs[toZ].findPinProto();
            if (v1.getX() == v2.getX()) {
                ni = this.makeNodeInst(np, new EPoint(v1.getX(), toPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                this.makeArcInst(type, width, ni.getOnlyPortInst(), toPi, netID);
                lastPort = ni.getOnlyPortInst();
            } else if (v1.getY() == v2.getY()) {
                ni = this.makeNodeInst(np, new EPoint(toPoly.getCenterX(), v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                this.makeArcInst(type, width, ni.getOnlyPortInst(), toPi, netID);
                lastPort = ni.getOnlyPortInst();
            }
        }
        for (int i = 0; i < vertices.size(); ++i) {
            SearchVertex sv = vertices.get(i);
            boolean madeContacts = false;
            while (i < vertices.size() - 1) {
                SearchVertex svNext = vertices.get(i + 1);
                if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), svNext.getZ())].getVias();
                int whichContact = sv.getContactNo();
                MetalVia mv = nps.get(whichContact);
                PrimitiveNode np = mv.via;
                Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                SizeOffset so = np.getProtoSizeOffset();
                double xOffset = so.getLowXOffset() + so.getHighXOffset();
                double yOffset = so.getLowYOffset() + so.getHighYOffset();
                double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                NodeInst ni = this.makeNodeInst(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient, this.cell, netID);
                ArcProto type = this.metalArcs[sv.getZ()];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                this.makeArcInst(type, width, lastPort, ni.getOnlyPortInst(), netID);
                lastPort = ni.getOnlyPortInst();
                madeContacts = true;
                sv = svNext;
                ++i;
            }
            if (madeContacts && i != vertices.size() - 1) continue;
            PrimitiveNode np = this.metalArcs[sv.getZ()].findPinProto();
            PortInst pi = null;
            if (i == vertices.size() - 1) {
                pi = fromPi;
                Poly fromPoly = fromPi.getPoly();
                if ((fromPoly.getCenterX() != sv.getX() || fromPoly.getCenterY() != sv.getY()) && vertices.size() >= 2) {
                    PrimitiveNode pNp;
                    SearchVertex v1 = vertices.get(vertices.size() - 2);
                    SearchVertex v2 = vertices.get(vertices.size() - 1);
                    ArcProto type = this.metalArcs[fromZ];
                    double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                    if (v1.getX() == v2.getX()) {
                        pNp = this.metalArcs[fromZ].findPinProto();
                        NodeInst ni = this.makeNodeInst(pNp, new EPoint(v1.getX(), fromPoly.getCenterY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                        this.makeArcInst(type, width, ni.getOnlyPortInst(), fromPi, netID);
                        pi = ni.getOnlyPortInst();
                    } else if (v1.getY() == v2.getY()) {
                        pNp = this.metalArcs[fromZ].findPinProto();
                        NodeInst ni = this.makeNodeInst(pNp, new EPoint(fromPoly.getCenterX(), v1.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                        this.makeArcInst(type, width, ni.getOnlyPortInst(), fromPi, netID);
                        pi = ni.getOnlyPortInst();
                    }
                }
            } else {
                NodeInst ni = this.makeNodeInst(np, new EPoint(sv.getX(), sv.getY()), np.getDefWidth(), np.getDefHeight(), Orientation.IDENT, this.cell, netID);
                pi = ni.getOnlyPortInst();
            }
            if (lastPort != null) {
                ArcProto type = this.metalArcs[sv.getZ()];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                this.makeArcInst(type, width, lastPort, pi, netID);
            }
            lastPort = pi;
        }
        return true;
    }

    private double getVertexLength(List<SearchVertex> vertices) {
        if (vertices == null) {
            return Double.MAX_VALUE;
        }
        if (vertices.size() == 0) {
            return Double.MAX_VALUE;
        }
        double sum = 0.0;
        SearchVertex last = null;
        for (SearchVertex sv : vertices) {
            if (last != null) {
                sum += Math.abs(sv.getX() - last.getX()) + Math.abs(sv.getY() - last.getY()) + (double)(Math.abs(sv.getZ() - last.getZ()) * 10);
            }
            last = sv;
        }
        return sum;
    }

    private NodeInst makeNodeInst(NodeProto np, EPoint loc, double wid, double hei, Orientation orient, Cell cell, int netID) {
        NodeInst ni = NodeInst.makeInstance(np, loc, wid, hei, cell, orient, null, 0);
        if (ni != null) {
            AffineTransform trans = ni.rotateOut();
            Poly[] nodeInstPolyList = this.tech.getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (poly.getPort() == null) continue;
                poly.transform(trans);
                this.addLayer(poly, GenMath.MATID, netID, false);
            }
        }
        return ni;
    }

    private ArcInst makeArcInst(ArcProto type, double wid, PortInst from, PortInst to, int netID) {
        ArcInst ai = ArcInst.makeInstanceBase(type, wid, from, to);
        if (ai != null) {
            Poly[] polys = this.tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                this.addLayer(polys[i], GenMath.MATID, netID, false);
            }
            Poly fromPoly = from.getPoly();
            Poly toPoly = to.getPoly();
            double length = fromPoly.getCenter().distance(toPoly.getCenter());
            this.totalWireLength += length;
        }
        return ai;
    }

    private List<SearchVertex> doDijkstra(double fromX, double fromY, int fromZ, double toX, double toY, int toZ, int netID, double minWidth) {
        ERectangle bounds = this.cell.getBounds();
        double lowX = this.downToGrain(bounds.getMinX());
        double highX = this.upToGrain(((RectangularShape)bounds).getMaxX());
        double lowY = this.downToGrain(bounds.getMinY());
        double highY = this.upToGrain(((RectangularShape)bounds).getMaxY());
        Rectangle2D.Double jumpBound = new Rectangle2D.Double(Math.min(fromX, toX), Math.min(fromY, toY), Math.abs(fromX - toX), Math.abs(fromY - toY));
        this.searchVertexPlanes = new Map[this.numMetalLayers];
        this.searchVertexPlanesDBL = new Map[this.numMetalLayers];
        this.destX = toX;
        this.destY = toY;
        this.destZ = toZ;
        int numSearchVertices = 0;
        SearchVertex cannotMove = new SearchVertex(0.0, 0.0, 0, 0, null, 0);
        SearchVertex outOfBounds = new SearchVertex(0.0, 0.0, 0, 0, null, 0);
        SearchVertex alreadyVisited = new SearchVertex(0.0, 0.0, 0, 0, null, 0);
        SearchVertex blocked = new SearchVertex(0.0, 0.0, 0, 0, null, 0);
        SearchVertex blockedNotch = new SearchVertex(0.0, 0.0, 0, 0, null, 0);
        SearchVertex foundDestination = new SearchVertex(0.0, 0.0, 0, 0, null, 0);
        SearchVertex[] costs = new SearchVertex[6];
        SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, 0, null, 0);
        svStart.cost = 0;
        this.setVertex(fromX, fromY, fromZ);
        TreeSet<SearchVertex> active = new TreeSet<SearchVertex>();
        active.add(svStart);
        SearchVertex thread = null;
        while (active.size() > 0) {
            SearchVertex svCurrent = (SearchVertex)active.first();
            active.remove(svCurrent);
            double curX = svCurrent.getX();
            double curY = svCurrent.getY();
            int curZ = svCurrent.getZ();
            for (int i = 0; i < 6; ++i) {
                double dx = 0.0;
                double dy = 0.0;
                int dz = 0;
                switch (i) {
                    case 0: {
                        dx = -1.0;
                        break;
                    }
                    case 1: {
                        dx = 1.0;
                        break;
                    }
                    case 2: {
                        dy = -1.0;
                        break;
                    }
                    case 3: {
                        dy = 1.0;
                        break;
                    }
                    case 4: {
                        dz = -1;
                        break;
                    }
                    case 5: {
                        dz = 1;
                    }
                }
                if (dz == 0) {
                    boolean goFarther = false;
                    if (dx != 0.0) {
                        if ((toX - curX) * dx > 0.0) {
                            goFarther = true;
                        }
                    } else if ((toY - curY) * dy > 0.0) {
                        goFarther = true;
                    }
                    if (goFarther) {
                        double jumpSize = this.getJumpSize(curX, curY, curZ, dx, dy, toX, toY, jumpBound, netID, minWidth);
                        if (dx > 0.0) {
                            if (jumpSize <= 0.0) continue;
                            dx = jumpSize;
                        }
                        if (dx < 0.0) {
                            if (jumpSize >= 0.0) continue;
                            dx = jumpSize;
                        }
                        if (dy > 0.0) {
                            if (jumpSize <= 0.0) continue;
                            dy = jumpSize;
                        }
                        if (dy < 0.0) {
                            if (jumpSize >= 0.0) continue;
                            dy = jumpSize;
                        }
                    }
                }
                double nX = curX + dx;
                double nY = curY + dy;
                int nZ = curZ + dz;
                if (nX < lowX || nX > highX || nY < lowY || nY > highY || nZ < 0 || nZ >= this.numMetalLayers || this.preventArcs[nZ] || this.getVertex(nX, nY, nZ)) continue;
                int whichContact = 0;
                Point2D[] cuts = null;
                if (dz == 0) {
                    double width = Math.max(this.metalArcs[nZ].getDefaultLambdaBaseWidth(), minWidth);
                    double metalSpacing = width / 2.0;
                    boolean allClear = false;
                    while (true) {
                        double newNY;
                        double newNX;
                        SOGBound sb;
                        SearchVertex prevPath = svCurrent;
                        double checkX = (curX + nX) / 2.0;
                        double checkY = (curY + nY) / 2.0;
                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                        while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                            if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                                checkY = (prevPath.last.yv + nY) / 2.0;
                                halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                                prevPath = prevPath.last;
                                continue;
                            }
                            if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                            checkX = (prevPath.last.xv + nX) / 2.0;
                            halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                            prevPath = prevPath.last;
                        }
                        if ((sb = this.getMetalBlockageAndNotch(netID, nZ, halfWid, halfHei, checkX, checkY, prevPath, minWidth)) == null) {
                            allClear = true;
                            break;
                        }
                        if (i == 0) {
                            newNX = this.downToGrainAlways(nX + 1.0);
                            if (newNX >= curX) break;
                            dx = newNX - curX;
                        } else if (i == 1) {
                            newNX = this.upToGrainAlways(nX - 1.0);
                            if (newNX <= curX) break;
                            dx = newNX - curX;
                        } else if (i == 2) {
                            newNY = this.downToGrainAlways(nY + 1.0);
                            if (newNY >= curY) break;
                            dy = newNY - curY;
                        } else if (i == 3) {
                            newNY = this.upToGrainAlways(nY - 1.0);
                            if (newNY <= curY) break;
                            dy = newNY - curY;
                        }
                        nX = curX + dx;
                        nY = curY + dy;
                    }
                    if (!allClear) {
                        continue;
                    }
                } else {
                    int lowMetal = Math.min(curZ, nZ);
                    int highMetal = Math.max(curZ, nZ);
                    List<MetalVia> nps = this.metalVias[lowMetal].getVias();
                    whichContact = -1;
                    for (int contactNo = 0; contactNo < nps.size(); ++contactNo) {
                        MetalVia mv = nps.get(contactNo);
                        PrimitiveNode np = mv.via;
                        Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                        SizeOffset so = np.getProtoSizeOffset();
                        double conWid = Math.max(np.getDefWidth() - so.getLowXOffset() - so.getHighXOffset(), minWidth) + so.getLowXOffset() + so.getHighXOffset();
                        double conHei = Math.max(np.getDefHeight() - so.getLowYOffset() - so.getHighYOffset(), minWidth) + so.getLowYOffset() + so.getHighYOffset();
                        NodeInst dummyNi = NodeInst.makeDummyInstance(np, new EPoint(nX, nY), conWid, conHei, orient);
                        Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                        AffineTransform trans = null;
                        if (orient != Orientation.IDENT) {
                            trans = dummyNi.rotateOut();
                        }
                        int cutCount = 0;
                        for (int p = 0; p < conPolys.length; ++p) {
                            if (!conPolys[p].getLayer().getFunction().isContact()) continue;
                            ++cutCount;
                        }
                        Point2D[] curCuts = new Point2D[cutCount];
                        cutCount = 0;
                        boolean failed = false;
                        for (int p = 0; p < conPolys.length; ++p) {
                            SearchVertex lastSv;
                            double conCY;
                            Rectangle2D conRect;
                            Layer conLayer;
                            Layer.Function lFun;
                            Poly conPoly = conPolys[p];
                            if (trans != null) {
                                conPoly.transform(trans);
                            }
                            if ((lFun = (conLayer = conPoly.getLayer()).getFunction()).isMetal()) {
                                double halfHei;
                                double halfWid;
                                conRect = conPoly.getBounds2D();
                                int metalNo = lFun.getLevel() - 1;
                                if (this.getMetalBlockageAndNotch(netID, metalNo, halfWid = conRect.getWidth() / 2.0, halfHei = conRect.getHeight() / 2.0, conRect.getCenterX(), conRect.getCenterY(), svCurrent, minWidth) == null) continue;
                                failed = true;
                                break;
                            }
                            if (!lFun.isContact()) continue;
                            double surround = this.viaSurround[lowMetal];
                            conRect = conPoly.getBounds2D();
                            double conCX = conRect.getCenterX();
                            if (this.getViaBlockage(netID, conLayer, surround, surround, conCX, conCY = conRect.getCenterY()) != null) {
                                failed = true;
                                break;
                            }
                            curCuts[cutCount++] = new Point2D.Double(conCX, conCY);
                            SearchVertex sv = svCurrent;
                            while (sv != null && (lastSv = sv.last) != null) {
                                if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal) {
                                    Point2D[] svCuts = sv.getCutLayer() == lowMetal ? sv.getCuts() : lastSv.getCuts();
                                    if (svCuts != null) {
                                        for (Point2D cutPt : svCuts) {
                                            if (Math.abs(cutPt.getX() - conCX) >= surround || Math.abs(cutPt.getY() - conCY) >= surround) continue;
                                            failed = true;
                                            break;
                                        }
                                    }
                                    if (failed) break;
                                }
                                sv = sv.last;
                            }
                            if (failed) break;
                        }
                        if (failed) continue;
                        whichContact = contactNo;
                        cuts = curCuts;
                        break;
                    }
                    if (whichContact < 0) continue;
                }
                SearchVertex svNext = new SearchVertex(nX, nY, nZ, whichContact, cuts, Math.min(curZ, nZ));
                svNext.last = svCurrent;
                if (nX == toX && nY == toY && nZ == toZ) {
                    costs[i] = foundDestination;
                    thread = svNext;
                    break;
                }
                if (++numSearchVertices > Routing.getSeaOfGatesComplexityLimit()) {
                    return null;
                }
                svNext.cost = svCurrent.cost;
                if (dx != 0.0) {
                    if (toX == curX) {
                        svNext.cost += 2;
                    } else if ((toX - curX) * dx < 0.0) {
                        svNext.cost += 5;
                    }
                    if (nZ % 2 == 0) {
                        svNext.cost = (int)((double)svNext.cost + 4.0 * Math.abs(dx));
                    }
                }
                if (dy != 0.0) {
                    if (toY == curY) {
                        svNext.cost += 2;
                    } else if ((toY - curY) * dy < 0.0) {
                        svNext.cost += 5;
                    }
                    if (nZ % 2 != 0) {
                        svNext.cost = (int)((double)svNext.cost + 4.0 * Math.abs(dy));
                    }
                }
                if (dz != 0) {
                    if (toZ == curZ) {
                        svNext.cost += 8;
                    } else if ((toZ - curZ) * dz < 0) {
                        svNext.cost += 40;
                    }
                } else {
                    double jumpSize1 = Math.abs(this.getJumpSize(nX, nY, nZ, dx, dy, toX, toY, jumpBound, netID, minWidth));
                    double jumpSize2 = Math.abs(this.getJumpSize(curX, curY, curZ, -dx, -dy, toX, toY, jumpBound, netID, minWidth));
                    if (jumpSize1 > 1.0 && jumpSize2 > 1.0) {
                        svNext.cost = (int)((double)svNext.cost + jumpSize1 * jumpSize2 / 10.0);
                    }
                    if (svCurrent.last != null) {
                        boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                        boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                        if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                            svNext.cost += 1;
                        }
                    }
                }
                if (!this.favorArcs[nZ]) {
                    svNext.cost = (int)((double)svNext.cost + ((double)(80 * Math.abs(dz)) + 10.0 * Math.abs(dx + dy)));
                }
                if (this.downToGrainAlways(nX) != nX && nX != toX) {
                    svNext.cost += 15;
                }
                if (this.downToGrainAlways(nY) != nY && nY != toY) {
                    svNext.cost += 15;
                }
                this.setVertex(nX, nY, nZ);
                active.add(svNext);
            }
            if (thread == null) continue;
            break;
        }
        List<SearchVertex> realVertices = this.getOptimizedList(thread);
        return realVertices;
    }

    private List<SearchVertex> getOptimizedList(SearchVertex initialThread) {
        ArrayList<SearchVertex> realVertices = new ArrayList<SearchVertex>();
        SearchVertex thread = initialThread;
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                double dx = thread.getX() - lastVertex.getX();
                double dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (!(thread == null || lastVertex.getZ() != thread.getZ() || thread.getX() - lastVertex.getX() != 0.0 && dx == 0.0 || thread.getY() - lastVertex.getY() != 0.0 && dy == 0.0)) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
        }
        return realVertices;
    }

    private double getJumpSize(double curX, double curY, int curZ, double dx, double dy, double toX, double toY, Rectangle2D jumpBound, int netID, double minWidth) {
        double width = Math.max(this.metalArcs[curZ].getDefaultLambdaBaseWidth(), minWidth);
        double metalToMetal = this.getSpacingRule(curZ, width, -1.0);
        double metalSpacing = width / 2.0 + metalToMetal;
        double lX = curX - metalSpacing;
        double hX = curX + metalSpacing;
        double lY = curY - metalSpacing;
        double hY = curY + metalSpacing;
        if (dx > 0.0) {
            hX = jumpBound.getMaxX() + metalSpacing;
        } else if (dx < 0.0) {
            lX = jumpBound.getMinX() - metalSpacing;
        } else if (dy > 0.0) {
            hY = jumpBound.getMaxY() + metalSpacing;
        } else if (dy < 0.0) {
            lY = jumpBound.getMinY() - metalSpacing;
        }
        RTNode rtree = this.metalTrees.get(this.metalLayers[curZ]);
        if (rtree != null) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
            RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
            while (sea.hasNext()) {
                Rectangle2D bound;
                SOGBound sBound = (SOGBound)sea.next();
                if (Math.abs(sBound.getNetID()) == netID || (bound = sBound.getBounds()).getMinX() >= hX || bound.getMaxX() <= lX || bound.getMinY() >= hY || bound.getMaxY() <= lY) continue;
                if (dx > 0.0 && bound.getMinX() < hX) {
                    hX = bound.getMinX();
                }
                if (dx < 0.0 && bound.getMaxX() > lX) {
                    lX = bound.getMaxX();
                }
                if (dy > 0.0 && bound.getMinY() < hY) {
                    hY = bound.getMinY();
                }
                if (!(dy < 0.0) || !(bound.getMaxY() > lY)) continue;
                lY = bound.getMaxY();
            }
        }
        if (dx > 0.0) {
            dx = this.downToGrain(hX - metalSpacing) - curX;
            if (curX + dx != toX) {
                // empty if block
            }
            return dx;
        }
        if (dx < 0.0) {
            dx = this.upToGrain(lX + metalSpacing) - curX;
            if (curX + dx != toX) {
                // empty if block
            }
            return dx;
        }
        if (dy > 0.0) {
            dy = this.downToGrain(hY - metalSpacing) - curY;
            if (curY + dy != toY) {
                // empty if block
            }
            return dy;
        }
        if (dy < 0.0) {
            dy = this.upToGrain(lY + metalSpacing) - curY;
            if (curY + dy != toY) {
                // empty if block
            }
            return dy;
        }
        return 0.0;
    }

    private double upToGrain(double v) {
        return this.upToGrainAlways(v);
    }

    private double upToGrainAlways(double v) {
        return Math.ceil(v * 1.0) * 1.0;
    }

    private double downToGrain(double v) {
        return this.downToGrainAlways(v);
    }

    private double downToGrainAlways(double v) {
        return Math.floor(v * 1.0) * 1.0;
    }

    private SOGBound getMetalBlockageAndNotch(int netID, int metNo, double halfWidth, double halfHeight, double x, double y, SearchVertex svCurrent, double minWidth) {
        Layer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        double metLX = x - halfWidth;
        double metHX = x + halfWidth;
        double metLY = y - halfHeight;
        double metHY = y + halfHeight;
        Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
        double metWid = Math.min(halfWidth, halfHeight) * 2.0;
        double metLen = Math.max(halfWidth, halfHeight) * 2.0;
        double surround = this.worstMetalSurround[metNo];
        double lX = metLX - surround;
        double hX = metHX + surround;
        double lY = metLY - surround;
        double hY = metHY + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        ArrayList<Rectangle2D> recsOnPath = new ArrayList<Rectangle2D>();
        if (svCurrent != null) {
            List<SearchVertex> svList = this.getOptimizedList(svCurrent);
            for (int ind = 1; ind < svList.size(); ++ind) {
                Poly poly;
                Rectangle2D bound;
                SearchVertex sv = svList.get(ind);
                SearchVertex lastSv = svList.get(ind - 1);
                if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                if (sv.getZ() != lastSv.getZ()) {
                    List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                    int whichContact = sv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst ni = NodeInst.makeDummyInstance(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient);
                    AffineTransform trans = null;
                    if (orient != Orientation.IDENT) {
                        trans = ni.rotateOut();
                    }
                    Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                    for (int i = 0; i < polys.length; ++i) {
                        Rectangle2D bound2;
                        Poly poly2 = polys[i];
                        if (poly2.getLayer() != layer) continue;
                        if (trans != null) {
                            poly2.transform(trans);
                        }
                        if ((bound2 = poly2.getBounds2D()).getMaxX() <= lX || bound2.getMinX() >= hX || bound2.getMaxY() <= lY || bound2.getMinY() >= hY) continue;
                        recsOnPath.add(bound2);
                    }
                    continue;
                }
                ArcProto type = this.metalArcs[metNo];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                Point2D.Double head = new Point2D.Double(sv.getX(), sv.getY());
                Point2D.Double tail = new Point2D.Double(lastSv.getX(), lastSv.getY());
                int ang = 0;
                if (((Point2D)head).getX() != ((Point2D)tail).getX() || ((Point2D)head).getY() != ((Point2D)tail).getY()) {
                    ang = GenMath.figureAngle(tail, head);
                }
                if ((bound = (poly = Poly.makeEndPointPoly(head.distance(tail), width, ang, head, width / 2.0, tail, width / 2.0, Poly.Type.FILLED)).getBounds2D()).getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                recsOnPath.add(bound);
            }
        }
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            Rectangle2D.Double drcArea;
            PolyBase poly;
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
            double drWid = Math.max(Math.min(bound.getWidth(), bound.getHeight()), metWid);
            double drLen = Math.max(Math.max(bound.getWidth(), bound.getHeight()), metLen);
            double spacing = this.getSpacingRule(metNo, drWid, drLen);
            double lXAllow = metLX - spacing;
            double hXAllow = metHX + spacing;
            double lYAllow = metLY - spacing;
            double hYAllow = metHY + spacing;
            if (bound.getMaxX() <= lXAllow || bound.getMinX() >= hXAllow || bound.getMaxY() <= lYAllow || bound.getMinY() >= hYAllow) continue;
            if (Math.abs(sBound.getNetID()) == netID) {
                if (sBound.getNetID() < 0 || !this.foundANotch(rtree, metBound, sBound.bound, netID, recsOnPath, spacing)) continue;
                return sBound;
            }
            if (sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(drcArea = new Rectangle2D.Double(lXAllow, lYAllow, hXAllow - lXAllow, hYAllow - lYAllow))) continue;
            return sBound;
        }
        if (svCurrent != null) {
            double spacing = this.getSpacingRule(metNo, metWid, metLen);
            List<SearchVertex> svList = this.getOptimizedList(svCurrent);
            for (int ind = 1; ind < svList.size(); ++ind) {
                Poly poly;
                Rectangle2D bound;
                SearchVertex sv = svList.get(ind);
                SearchVertex lastSv = svList.get(ind - 1);
                if (sv.getZ() != metNo && lastSv.getZ() != metNo) continue;
                if (sv.getZ() != lastSv.getZ()) {
                    List<MetalVia> nps = this.metalVias[Math.min(sv.getZ(), lastSv.getZ())].getVias();
                    int whichContact = sv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth() - xOffset, minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight() - yOffset, minWidth) + yOffset;
                    NodeInst ni = NodeInst.makeDummyInstance(np, new EPoint(sv.getX(), sv.getY()), wid, hei, orient);
                    AffineTransform trans = null;
                    if (orient != Orientation.IDENT) {
                        trans = ni.rotateOut();
                    }
                    Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                    for (int i = 0; i < polys.length; ++i) {
                        Rectangle2D bound3;
                        Poly poly3 = polys[i];
                        if (poly3.getLayer() != layer) continue;
                        if (trans != null) {
                            poly3.transform(trans);
                        }
                        if ((bound3 = poly3.getBounds2D()).getMaxX() <= lX || bound3.getMinX() >= hX || bound3.getMaxY() <= lY || bound3.getMinY() >= hY) continue;
                        SOGBound sBound = new SOGBound(bound3, netID);
                        if (!this.foundANotch(rtree, metBound, bound3, netID, recsOnPath, spacing)) continue;
                        return sBound;
                    }
                    continue;
                }
                ArcProto type = this.metalArcs[metNo];
                double width = Math.max(type.getDefaultLambdaBaseWidth(), minWidth);
                Point2D.Double head = new Point2D.Double(sv.getX(), sv.getY());
                Point2D.Double tail = new Point2D.Double(lastSv.getX(), lastSv.getY());
                int ang = 0;
                if (((Point2D)head).getX() != ((Point2D)tail).getX() || ((Point2D)head).getY() != ((Point2D)tail).getY()) {
                    ang = GenMath.figureAngle(tail, head);
                }
                if ((bound = (poly = Poly.makeEndPointPoly(head.distance(tail), width, ang, head, width / 2.0, tail, width / 2.0, Poly.Type.FILLED)).getBounds2D()).getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY) continue;
                SOGBound sBound = new SOGBound(bound, netID);
                if (!this.foundANotch(rtree, metBound, bound, netID, recsOnPath, spacing)) continue;
                return sBound;
            }
        }
        return null;
    }

    private boolean foundANotch(RTNode rtree, Rectangle2D metBound, Rectangle2D bound, int netID, List<Rectangle2D> recsOnPath, double dist) {
        boolean vOverlap;
        boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
        boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
        if (hOverlap && vOverlap) {
            return false;
        }
        if (hOverlap) {
            double ptY;
            if (metBound.getCenterY() > bound.getCenterY()) {
                if (metBound.getMinY() - bound.getMaxY() > dist) {
                    return false;
                }
                ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
            } else {
                if (bound.getMinY() - metBound.getMaxY() > dist) {
                    return false;
                }
                ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
            }
            double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
            double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
            double pt3X = (pt1X + pt2X) / 2.0;
            if (!this.pointInRTree(rtree, pt1X, ptY, netID, recsOnPath)) {
                return true;
            }
            if (!this.pointInRTree(rtree, pt2X, ptY, netID, recsOnPath)) {
                return true;
            }
            return !this.pointInRTree(rtree, pt3X, ptY, netID, recsOnPath);
        }
        if (vOverlap) {
            double ptX;
            if (metBound.getCenterX() > bound.getCenterX()) {
                if (metBound.getMinX() - bound.getMaxX() > dist) {
                    return false;
                }
                ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
            } else {
                if (bound.getMinX() - metBound.getMaxX() > dist) {
                    return false;
                }
                ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
            }
            double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
            double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
            double pt3Y = (pt1Y + pt2Y) / 2.0;
            if (!this.pointInRTree(rtree, ptX, pt1Y, netID, recsOnPath)) {
                return true;
            }
            if (!this.pointInRTree(rtree, ptX, pt2Y, netID, recsOnPath)) {
                return true;
            }
            return !this.pointInRTree(rtree, ptX, pt3Y, netID, recsOnPath);
        }
        if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
            double pt2Y;
            double pt1X = metBound.getMinX();
            double pt1Y = bound.getMaxY();
            double pt2X = bound.getMaxX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
            double pt2Y;
            double pt1X = metBound.getMaxX();
            double pt1Y = bound.getMaxY();
            double pt2X = bound.getMinX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
            double pt2Y;
            double pt1X = metBound.getMaxX();
            double pt1Y = bound.getMinY();
            double pt2X = bound.getMinX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
            double pt2Y;
            double pt1X = metBound.getMinX();
            double pt1Y = bound.getMinY();
            double pt2X = bound.getMaxX();
            if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > dist) {
                return false;
            }
            if (this.pointInRTree(rtree, pt1X, pt1Y, netID, recsOnPath)) {
                return false;
            }
            return !this.pointInRTree(rtree, pt2X, pt2Y, netID, recsOnPath);
        }
        return false;
    }

    private boolean pointInRTree(RTNode rtree, double x, double y, int netID, List<Rectangle2D> recsOnPath) {
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x, y, 0.0, 0.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGBound sBound = (SOGBound)sea.next();
            if (sBound.netID != netID || sBound.bound.getMinX() > x || sBound.bound.getMaxX() < x || sBound.bound.getMinY() > y || sBound.bound.getMaxY() < y) continue;
            return true;
        }
        for (Rectangle2D bound : recsOnPath) {
            if (bound.getMinX() > x || bound.getMaxX() < x || bound.getMinY() > y || bound.getMaxY() < y) continue;
            return true;
        }
        return false;
    }

    private SOGBound getMetalBlockage(int netID, int metNo, double halfWidth, double halfHeight, double surround, double x, double y) {
        Layer layer = this.metalLayers[metNo];
        RTNode rtree = this.metalTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        double lX = x - halfWidth - surround;
        double hX = x + halfWidth + surround;
        double lY = y - halfHeight - surround;
        double hY = y + halfHeight + surround;
        Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            PolyBase poly;
            SOGBound sBound = (SOGBound)sea.next();
            Rectangle2D bound = sBound.getBounds();
            if (bound.getMaxX() <= lX || bound.getMinX() >= hX || bound.getMaxY() <= lY || bound.getMinY() >= hY || Math.abs(sBound.getNetID()) == netID || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
            return sBound;
        }
        return null;
    }

    private void processNotch(Rectangle2D metBound, SOGBound sBound, NotchData notchDataL, NotchData notchDataR, NotchData notchDataT, NotchData notchDataB) {
        boolean touches = true;
        Rectangle2D bound = sBound.getBounds();
        if (bound.getMaxX() < metBound.getMinX()) {
            notchDataL.potentialNotches.add(sBound);
            touches = false;
        }
        if (bound.getMinX() > metBound.getMaxX()) {
            notchDataR.potentialNotches.add(sBound);
            touches = false;
        }
        if (bound.getMinY() > metBound.getMaxY()) {
            notchDataT.potentialNotches.add(sBound);
            touches = false;
        }
        if (bound.getMaxY() < metBound.getMinY()) {
            notchDataB.potentialNotches.add(sBound);
            touches = false;
        }
        if (touches) {
            if (bound.getMinX() < metBound.getMinX()) {
                this.addRange(notchDataL.notchRange, bound.getMinY(), bound.getMaxY());
            }
            if (bound.getMaxX() > metBound.getMaxX()) {
                this.addRange(notchDataR.notchRange, bound.getMinY(), bound.getMaxY());
            }
            if (bound.getMinY() < metBound.getMinY()) {
                this.addRange(notchDataB.notchRange, bound.getMinX(), bound.getMaxX());
            }
            if (bound.getMaxY() > metBound.getMaxY()) {
                this.addRange(notchDataT.notchRange, bound.getMinX(), bound.getMaxX());
            }
        }
    }

    private boolean rangeCovers(List<NotchInterval> notchRange, double low, double high) {
        for (NotchInterval ni : notchRange) {
            if (!ni.contains(low, high)) continue;
            return true;
        }
        return false;
    }

    private void addRange(List<NotchInterval> notchRange, double low, double high) {
        NotchInterval newNi = new NotchInterval(low, high);
        for (NotchInterval ni : notchRange) {
            if (!ni.touches(newNi)) continue;
            ni.union(newNi);
            for (int j = 0; j < notchRange.size(); ++j) {
                NotchInterval oNi = notchRange.get(j);
                if (ni == oNi || !ni.touches(oNi)) continue;
                ni.union(oNi);
                notchRange.remove(j);
                --j;
            }
            return;
        }
        notchRange.add(newNi);
    }

    private SOGVia getViaBlockage(int netID, Layer layer, double halfWidth, double halfHeight, double x, double y) {
        RTNode rtree = this.viaTrees.get(layer);
        if (rtree == null) {
            return null;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(x - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtree, true);
        while (sea.hasNext()) {
            SOGVia sLoc = (SOGVia)sea.next();
            if (sLoc.getNetID() == netID && sLoc.loc.getX() == x && sLoc.loc.getY() == y) continue;
            return sLoc;
        }
        return null;
    }

    private void addLayer(PolyBase poly, AffineTransform trans, int netID, boolean canPlacePseudo) {
        if (!canPlacePseudo && poly.isPseudoLayer()) {
            return;
        }
        Layer layer = poly.getLayer();
        if (canPlacePseudo) {
            layer = layer.getNonPseudoLayer();
        } else if (layer.isPseudoLayer()) {
            return;
        }
        Layer.Function fun = layer.getFunction();
        if (fun.isMetal()) {
            poly.transform(trans);
            Rectangle2D bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID);
            } else {
                this.addRectangle(bounds, layer, netID);
            }
        } else if (fun.isContact()) {
            Rectangle2D bounds = poly.getBounds2D();
            GenMath.transformRect(bounds, trans);
            this.addVia(new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), layer, netID);
        }
    }

    private void addRectangle(Rectangle2D bounds, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root = this.metalTrees.get(layer);
        if (root == null) {
            root = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root);
        }
        if ((newRoot = RTNode.linkGeom(null, root, new SOGBound(bounds, netID))) != root) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addPolygon(PolyBase poly, Layer layer, int netID) {
        Rectangle2D bounds;
        RTNode newRoot;
        RTNode root = this.metalTrees.get(layer);
        if (root == null) {
            root = RTNode.makeTopLevel();
            this.metalTrees.put(layer, root);
        }
        if ((newRoot = RTNode.linkGeom(null, root, new SOGPoly(bounds = poly.getBounds2D(), netID, poly))) != root) {
            this.metalTrees.put(layer, newRoot);
        }
    }

    private void addVia(Point2D loc, Layer layer, int netID) {
        RTNode newRoot;
        RTNode root = this.viaTrees.get(layer);
        if (root == null) {
            root = RTNode.makeTopLevel();
            this.viaTrees.put(layer, root);
        }
        if ((newRoot = RTNode.linkGeom(null, root, new SOGVia(loc, netID))) != root) {
            this.viaTrees.put(layer, newRoot);
        }
    }

    private boolean getVertex(double x, double y, int z) {
        Map<Integer, Set<Integer>> plane = this.searchVertexPlanes[z];
        if (plane == null) {
            return false;
        }
        Set<Integer> row = plane.get(new Integer((int)(y * 1.0)));
        if (row == null) {
            return false;
        }
        boolean found = row.contains(new Integer((int)(x * 1.0)));
        return found;
    }

    private void setVertex(double x, double y, int z) {
        Integer iY;
        Set<Integer> row;
        Map<Integer, Set<Integer>> plane = this.searchVertexPlanes[z];
        if (plane == null) {
            this.searchVertexPlanes[z] = plane = new HashMap<Integer, Set<Integer>>();
        }
        if ((row = plane.get(iY = new Integer((int)(y * 1.0)))) == null) {
            row = new HashSet<Integer>();
            plane.put(iY, row);
        }
        row.add(new Integer((int)(x * 1.0)));
    }

    private void showSearchVertices(Map<Integer, Set<Integer>>[] planes, boolean horiz) {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        for (int i = 0; i < this.numMetalLayers; ++i) {
            double offset = i;
            offset -= (double)(this.numMetalLayers - 2) / 2.0;
            offset /= (double)(this.numMetalLayers + 2);
            Map<Integer, Set<Integer>> plane = planes[i];
            if (plane == null) continue;
            for (Integer y : plane.keySet()) {
                double yv = y.doubleValue();
                Set<Integer> row = plane.get(y);
                for (Integer x : row) {
                    Point2D.Double pt2;
                    Point2D.Double pt1;
                    double xv = x.doubleValue();
                    if (horiz) {
                        pt1 = new Point2D.Double(xv - 0.5, yv + offset);
                        pt2 = new Point2D.Double(xv + 0.5, yv + offset);
                    } else {
                        pt1 = new Point2D.Double(xv + offset, yv - 0.5);
                        pt2 = new Point2D.Double(xv + offset, yv + 0.5);
                    }
                    wnd.addHighlightLine(pt1, pt2, this.cell, false);
                }
            }
        }
    }

    private class SearchVertex
    implements Comparable {
        private double xv;
        private double yv;
        private int zv;
        private int cost;
        private int cutLayer;
        private Point2D[] cuts;
        private SearchVertex last;

        SearchVertex(double x, double y, int z, int whichContact, Point2D[] cuts, int cl) {
            this.xv = x;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cuts = cuts;
            this.cutLayer = cl;
        }

        double getX() {
            return this.xv;
        }

        double getY() {
            return this.yv;
        }

        int getZ() {
            return this.zv >> 8;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Point2D[] getCuts() {
            return this.cuts;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        public int compareTo(Object svo) {
            double otherDist;
            SearchVertex sv = (SearchVertex)svo;
            int diff = this.cost - sv.cost;
            if (diff != 0) {
                return diff;
            }
            double thisDist = Math.abs(this.xv - SeaOfGatesEngine.this.destX) + Math.abs(this.yv - SeaOfGatesEngine.this.destY) + (double)Math.abs(this.zv - SeaOfGatesEngine.this.destZ);
            if (thisDist == (otherDist = Math.abs(sv.xv - SeaOfGatesEngine.this.destX) + Math.abs(sv.yv - SeaOfGatesEngine.this.destY) + (double)Math.abs(sv.zv - SeaOfGatesEngine.this.destZ))) {
                return 0;
            }
            if (thisDist > otherDist) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            PrimitiveNode pn1 = mv1.via;
            PrimitiveNode pn2 = mv2.via;
            double sz1 = pn1.getDefWidth() * pn1.getDefHeight();
            if (sz1 < (sz2 = pn2.getDefWidth() * pn2.getDefHeight())) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o) {
            this.vias.add(new MetalVia(pn, o));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;

        MetalVia(PrimitiveNode v, int o) {
            this.via = v;
            this.orientation = o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlockageVisitor
    extends HierarchyEnumerator.Visitor {
        private List<ArcInst> arcsToRoute;
        private boolean didTopLevel;

        public BlockageVisitor(List<ArcInst> arcsToRoute) {
            this.arcsToRoute = arcsToRoute;
            this.didTopLevel = false;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Netlist nl = info.getNetlist();
            AffineTransform trans = info.getTransformToRoot();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                int netID = -1;
                Network net = nl.getNetwork(ai, 0);
                if (net != null) {
                    netID = info.getNetID(net);
                }
                Technology tech = ai.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfArc(ai);
                for (int i = 0; i < polys.length; ++i) {
                    SeaOfGatesEngine.this.addLayer(polys[i], trans, netID, false);
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni;
            if (info.isRootCell() && !this.didTopLevel) {
                this.didTopLevel = true;
                if (this.arcsToRoute != null) {
                    Netlist nl = info.getNetlist();
                    for (ArcInst ai : this.arcsToRoute) {
                        Network net = nl.getNetwork(ai, 0);
                        int netID = info.getNetID(net);
                        SeaOfGatesEngine.this.netIDs.put(ai, new Integer(netID + 1));
                    }
                }
            }
            if (!(ni = no.getNodeInst()).isCellInstance()) {
                Netlist nl = info.getNetlist();
                AffineTransform trans = info.getTransformToRoot();
                AffineTransform nodeTrans = ni.rotateOut(trans);
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                boolean canPlacePseudo = info.isRootCell();
                if (!ni.hasExports()) {
                    canPlacePseudo = false;
                }
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Network net;
                    Poly poly = nodeInstPolyList[i];
                    int netID = -1;
                    if (poly.getPort() != null && (net = nl.getNetwork(no, poly.getPort(), 0)) != null) {
                        netID = info.getNetID(net);
                    }
                    SeaOfGatesEngine.this.addLayer(poly, nodeTrans, netID, canPlacePseudo);
                }
            }
            return true;
        }
    }

    private static class NotchData {
        List<SOGBound> potentialNotches = new ArrayList<SOGBound>();
        List<NotchInterval> notchRange = new ArrayList<NotchInterval>();

        NotchData() {
        }
    }

    private static class NotchInterval {
        private double low;
        private double high;

        public NotchInterval(double l, double h) {
            this.low = l;
            this.high = h;
        }

        public boolean touches(NotchInterval ni) {
            return !(ni.low > this.high) && !(ni.high < this.low);
        }

        public boolean contains(double l, double h) {
            return l >= this.low && h <= this.high;
        }

        public void union(NotchInterval ni) {
            this.low = Math.min(this.low, ni.low);
            this.high = Math.max(this.high, ni.high);
        }
    }

    private static class SOGVia
    implements RTBounds {
        private Point2D loc;
        private int netID;

        SOGVia(Point2D loc, int netID) {
            this.loc = loc;
            this.netID = netID;
        }

        public Rectangle2D getBounds() {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGVia on net " + this.netID;
        }
    }

    private static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(Rectangle2D bound, int netID, PolyBase poly) {
            super(bound, netID);
            this.poly = poly;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    private static class SOGBound
    implements RTBounds {
        private Rectangle2D bound;
        private int netID;

        SOGBound(Rectangle2D bound, int netID) {
            this.bound = bound;
            this.netID = netID;
        }

        public Rectangle2D getBounds() {
            return this.bound;
        }

        public int getNetID() {
            return this.netID;
        }

        public String toString() {
            return "SOGBound on net " + this.netID;
        }
    }
}

