/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Stimuli;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

public class EpicOut
extends Simulate {
    private static String VERSION_STRING = ";! output_format 5.3";

    EpicOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        EpicOut.startProgressDialog("EPIC output", fileURL.getFile());
        Stimuli sd = this.readEpicFile(new EpicReader(fileURL));
        sd.setCell(cell);
        EpicOut.stopProgressDialog();
        return sd;
    }

    private Stimuli readEpicFile(EpicReader reader) {
        char separator = '.';
        EpicStimuli sd = reader.sd;
        sd.setSeparatorChar(separator);
        for (int i = 0; i < reader.signals.size(); ++i) {
            EpicAnalogSignal s = reader.signals.get(i);
            if (s == null) continue;
            double resolution = 1.0;
            switch (s.type) {
                case 1: {
                    resolution = sd.voltageResolution;
                    break;
                }
                case 2: {
                    resolution = sd.currentResolution;
                }
            }
            EpicProcessing ep = reader.processingData.get(s);
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, (double)ep.minV * resolution, (double)reader.maxT * sd.timeResolution, (double)(ep.maxV - ep.minV) * resolution);
            s.setBounds(bounds);
        }
        return sd;
    }

    static class EpicReader {
        EpicStimuli sd;
        Analysis an;
        String filePath;
        InputStream inputStream;
        long fileLength;
        long byteCount;
        byte[] buf = new byte[65536];
        int bufL;
        int bufP;
        StringBuilder builder = new StringBuilder();
        Pattern whiteSpace = Pattern.compile("[ \t]+");
        int timesC = 0;
        int eventsC = 0;
        ArrayList<EpicAnalogSignal> signals = new ArrayList();
        HashMap<EpicAnalogSignal, EpicProcessing> processingData = new HashMap();
        int numSignals = 0;
        int curTime = 0;
        int maxT = 0;
        HashMap<String, String> contextNames;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EpicReader(URL fileURL) {
            this.sd = new EpicStimuli();
            this.an = new Analysis(this.sd, Analysis.ANALYSIS_TRANS);
            try {
                this.readFile(fileURL);
            }
            finally {
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        boolean readFile(URL fileURL) {
            this.filePath = fileURL.getFile();
            long startTime = System.currentTimeMillis();
            URLConnection urlCon = null;
            try {
                urlCon = fileURL.openConnection();
                urlCon.setConnectTimeout(10000);
                urlCon.setReadTimeout(1000);
                String contentLength = urlCon.getHeaderField("content-length");
                this.fileLength = -1L;
                try {
                    this.fileLength = Long.parseLong(contentLength);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.inputStream = urlCon.getInputStream();
            }
            catch (IOException e) {
                System.out.println("Could not find file: " + this.filePath);
                return true;
            }
            this.contextNames = new HashMap();
            this.byteCount = 0L;
            try {
                String firstLine = this.getLine();
                if (firstLine == null || !firstLine.equals(VERSION_STRING)) {
                    System.out.println("Unknown Epic Version: " + firstLine);
                }
                while (this.bufP < this.bufL || !this.readBuf()) {
                    int startLine = this.bufP;
                    if (this.parseNumLineFast()) continue;
                    this.bufP = startLine;
                    String line = this.getLine();
                    assert (this.bufP <= this.bufL);
                    if (line != null) {
                        this.parseNumLine(line);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            long stopTime = System.currentTimeMillis();
            System.out.println((double)(stopTime - startTime) / 1000.0 + " sec; file size is " + this.byteCount + " bytes");
            System.out.println("Found " + this.numSignals + " signals (" + this.timesC + " timepoints and " + this.eventsC + " events)");
            return false;
        }

        private void parseNumLine(String line) {
            if (line.length() == 0) {
                return;
            }
            char ch = line.charAt(0);
            if (ch == '.') {
                String[] split = this.whiteSpace.split(line);
                if (split[0].equals(".index") && split.length == 4) {
                    int type;
                    if (split[3].equals("v")) {
                        type = 1;
                    } else if (split[3].equals("i")) {
                        type = 2;
                    } else {
                        System.out.println("Unknown waveform type: " + line);
                        return;
                    }
                    String name = split[1];
                    int sigNum = TextUtils.atoi(split[2]);
                    while (this.signals.size() <= sigNum) {
                        this.signals.add(null);
                    }
                    EpicAnalogSignal s = this.signals.get(sigNum);
                    if (s == null) {
                        s = new EpicAnalogSignal(this.an);
                        EpicProcessing ep = new EpicProcessing();
                        this.processingData.put(s, ep);
                        this.signals.set(sigNum, s);
                        ++this.numSignals;
                    }
                    if (name.startsWith("v(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    } else if (name.startsWith("i(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    } else if (name.startsWith("i1(") && name.endsWith(")")) {
                        name = name.substring(3, name.length() - 1);
                    }
                    name = Simulate.removeLeadingX(name);
                    int lastSlashPos = name.lastIndexOf(this.sd.getSeparatorChar());
                    if (lastSlashPos > 0) {
                        String contextName = name.substring(0, lastSlashPos);
                        String contextNameToSet = this.contextNames.get(contextName);
                        if (contextNameToSet == null) {
                            this.contextNames.put(contextName, contextName);
                            contextNameToSet = contextName;
                        }
                        s.setSignalContext(contextNameToSet);
                        name = name.substring(lastSlashPos + 1);
                    }
                    if (s.type == 2) {
                        name = "i(" + name + ")";
                    }
                    s.setSignalName(name);
                    s.type = (byte)type;
                } else if (!split[0].equals(".vdd") || split.length != 2) {
                    if (split[0].equals(".time_resolution") && split.length == 2) {
                        this.sd.timeResolution = TextUtils.atof(split[1]) * 1.0E-9;
                    } else if (split[0].equals(".current_resolution") && split.length == 2) {
                        this.sd.currentResolution = TextUtils.atof(split[1]);
                    } else if (split[0].equals(".voltage_resolution") && split.length == 2) {
                        this.sd.voltageResolution = TextUtils.atof(split[1]);
                    } else if (!(split[0].equals(".high_threshold") && split.length == 2 || split[0].equals(".low_threshold") && split.length == 2 || split[0].equals(".nnodes") && split.length == 2 || split[0].equals(".nelems") && split.length == 2 || split[0].equals(".extra_nodes") && split.length == 2 || split[0].equals(".bus_notation") && split.length == 4 || split[0].equals(".hier_separator") && split.length == 2 || split[0].equals(".case") && split.length == 2)) {
                        System.out.println("Unrecognized Epic line: " + line);
                    }
                }
            } else if (ch >= '0' || ch <= '9') {
                String[] split = this.whiteSpace.split(line);
                int num = TextUtils.atoi(split[0]);
                if (split.length > 1) {
                    this.putValue(num, TextUtils.atoi(split[1]));
                } else {
                    this.putTime(num);
                }
            } else if (ch != ';' && !Character.isSpaceChar(ch)) {
                System.out.println("Unrecognized Epic line: " + line);
            }
        }

        private boolean parseNumLineFast() {
            byte ch;
            int MAX_DIGITS = 9;
            if (this.bufP + 22 >= this.bufL) {
                return false;
            }
            if ((ch = this.buf[this.bufP++]) < 48 || ch > 57) {
                return false;
            }
            int num1 = ch - 48;
            ch = this.buf[this.bufP++];
            int lim = this.bufP + 8;
            while (48 <= ch && ch <= 57 && this.bufP < lim) {
                num1 = num1 * 10 + (ch - 48);
                ch = this.buf[this.bufP++];
            }
            boolean twoNumbers = false;
            int num2 = 0;
            if (ch == 32) {
                ch = this.buf[this.bufP++];
                boolean sign = false;
                if (ch == 45) {
                    sign = true;
                    ch = this.buf[this.bufP++];
                }
                if (ch < 48 || ch > 57) {
                    return false;
                }
                num2 = ch - 48;
                ch = this.buf[this.bufP++];
                int lim2 = this.bufP + 8;
                while (48 <= ch && ch <= 57 && this.bufP < lim2) {
                    num2 = num2 * 10 + (ch - 48);
                    ch = this.buf[this.bufP++];
                }
                if (sign) {
                    num2 = -num2;
                }
                twoNumbers = true;
            }
            if (ch != 10) {
                if (ch == 13) {
                    if (this.buf[this.bufP] == 10) {
                        ++this.bufP;
                    }
                } else {
                    return false;
                }
            }
            if (twoNumbers) {
                this.putValue(num1, num2);
            } else {
                this.putTime(num1);
            }
            return true;
        }

        private void putTime(int time) {
            ++this.timesC;
            this.maxT = this.curTime = Math.max(this.curTime, time);
        }

        void putValue(int sigNum, int value) {
            EpicProcessing ep;
            ++this.eventsC;
            while (this.signals.size() <= sigNum) {
                this.signals.add(null);
            }
            EpicAnalogSignal s = this.signals.get(sigNum);
            if (s == null) {
                s = new EpicAnalogSignal(this.an);
                ep = new EpicProcessing();
                this.processingData.put(s, ep);
                s.setSignalName("Signal " + sigNum);
                this.signals.set(sigNum, s);
                ++this.numSignals;
            }
            ep = this.processingData.get(s);
            s.putEvent(ep, this.curTime, value);
        }

        private String getLine() throws IOException {
            this.builder.setLength(0);
            while (true) {
                if (this.bufP < this.bufL) {
                    int ch;
                    if ((ch = this.buf[this.bufP++] & 0xFF) == 10) {
                        return this.builder.toString();
                    }
                    if (ch == 13) {
                        if (this.bufP == this.bufL) {
                            this.readBuf();
                        }
                        if (this.bufP < this.bufL && this.buf[this.bufP] == 10) {
                            ++this.bufP;
                        }
                        return this.builder.toString();
                    }
                    this.builder.append((char)ch);
                    continue;
                }
                if (this.readBuf()) break;
            }
            return this.builder.length() != 0 ? this.builder.toString() : null;
        }

        private boolean readBuf() throws IOException {
            assert (this.bufP == this.bufL);
            this.bufL = 0;
            this.bufP = 0;
            this.bufL = this.inputStream.read(this.buf, 0, this.buf.length);
            if (this.bufL <= 0) {
                this.bufL = 0;
                return true;
            }
            this.byteCount += (long)this.bufL;
            Input.setProgressValue(this.fileLength != 0L ? (int)((double)this.byteCount / (double)this.fileLength * 100.0) : 0);
            return false;
        }
    }

    private static class EpicAnalogSignal
    extends AnalogSignal {
        static final byte VOLTAGE_TYPE = 1;
        static final byte CURRENT_TYPE = 2;
        byte type;
        byte[] waveform = null;
        int position = -1;

        EpicAnalogSignal(Analysis an) {
            super(an);
        }

        public void getEvent(int sweep, int index, double[] result) {
            if (sweep != 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.getTimeVector() == null) {
                this.makeData();
            }
            super.getEvent(sweep, index, result);
        }

        public int getNumEvents(int sweep) {
            if (sweep != 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.getTimeVector() == null) {
                this.makeData();
            }
            return super.getNumEvents(0);
        }

        private void makeData() {
            EpicStimuli sd = (EpicStimuli)this.an.getStimuli();
            double resolution = 1.0;
            switch (this.type) {
                case 1: {
                    resolution = sd.voltageResolution;
                    break;
                }
                case 2: {
                    resolution = sd.currentResolution;
                }
            }
            int[] intData = this.getWaveform();
            int len = intData.length / 2;
            this.buildTime(len);
            this.buildValues(len);
            for (int i = 0; i < len; ++i) {
                double timeValue = (double)intData[i * 2] * sd.timeResolution;
                this.setTime(i, timeValue);
                double dataValue = (double)intData[i * 2 + 1] * resolution;
                this.setValue(i, dataValue);
            }
        }

        private void setBounds(Rectangle2D bounds) {
            this.bounds = bounds;
        }

        private void putEvent(EpicProcessing ep, int t, int v) {
            int val1 = t - ep.lastT;
            int val2 = v - ep.lastV;
            int totalSpace = this.calculateUnsignedSpace(val1) + this.calculateSignedSpace(val2);
            this.makeCapacitity(totalSpace);
            this.putUnsigned(val1);
            this.putSigned(val2);
            ep.lastT = t;
            ep.lastV = v;
            ep.minV = Math.min(ep.minV, v);
            ep.maxV = Math.max(ep.maxV, v);
        }

        private int calculateUnsignedSpace(int value) {
            if (value < 192) {
                return 1;
            }
            if (value < 16128) {
                return 2;
            }
            return 5;
        }

        private void putUnsigned(int value) {
            if (value < 192) {
                this.put1Byte(value);
            } else if (value < 16128) {
                this.put2Bytes(value + 49152 >> 8, value);
            } else {
                this.put5Bytes(255, value >> 24, value >> 16, value >> 8, value);
            }
        }

        private int calculateSignedSpace(int value) {
            if (-96 <= value && value < 96) {
                return 1;
            }
            if (-7936 <= value && value < 8192) {
                return 2;
            }
            return 5;
        }

        private void putSigned(int value) {
            if (-96 <= value && value < 96) {
                this.put1Byte(value + 96);
            } else if (-7936 <= value && value < 8192) {
                this.put2Bytes(value + 57088 >> 8, value);
            } else {
                this.put5Bytes(255, value >> 24, value >> 16, value >> 8, value);
            }
        }

        private int[] getWaveform() {
            int count = 0;
            int i = 0;
            while (i < this.position) {
                int b;
                int l = (b = this.waveform[i++] & 0xFF) < 192 ? 0 : (b < 255 ? 1 : 4);
                i += l;
                b = this.waveform[i++] & 0xFF;
                l = b < 192 ? 0 : (b < 255 ? 1 : 4);
                i += l;
                ++count;
            }
            int[] w = new int[count * 2];
            count = 0;
            int t = 0;
            int v = 0;
            int i2 = 0;
            while (i2 < this.position) {
                int l;
                int b;
                if ((b = this.waveform[i2++] & 0xFF) < 192) {
                    l = 0;
                } else if (b < 255) {
                    l = 1;
                    b -= 192;
                } else {
                    l = 4;
                }
                while (l > 0) {
                    b = b << 8 | this.waveform[i2++] & 0xFF;
                    --l;
                }
                w[count * 2] = t += b;
                if ((b = this.waveform[i2++] & 0xFF) < 192) {
                    l = 0;
                    b -= 96;
                } else if (b < 255) {
                    l = 1;
                    b -= 223;
                } else {
                    l = 4;
                }
                while (l > 0) {
                    b = b << 8 | this.waveform[i2++] & 0xFF;
                    --l;
                }
                w[count * 2 + 1] = v += b;
                ++count;
            }
            assert (count * 2 == w.length);
            return w;
        }

        private void put1Byte(int value) {
            int fillPos = this.ensureCapacity(1);
            this.waveform[fillPos] = (byte)value;
        }

        private void put2Bytes(int value1, int value2) {
            int fillPos = this.ensureCapacity(2);
            this.waveform[fillPos++] = (byte)value1;
            this.waveform[fillPos] = (byte)value2;
        }

        private void put5Bytes(int value1, int value2, int value3, int value4, int value5) {
            int fillPos = this.ensureCapacity(5);
            this.waveform[fillPos++] = (byte)value1;
            this.waveform[fillPos++] = (byte)value2;
            this.waveform[fillPos++] = (byte)value3;
            this.waveform[fillPos++] = (byte)value4;
            this.waveform[fillPos] = (byte)value5;
        }

        private void makeCapacitity(int l) {
            int waveformLen = 0;
            if (this.waveform != null) {
                waveformLen = this.waveform.length;
            }
            byte[] newWaveform = new byte[waveformLen + l];
            if (waveformLen > 0) {
                System.arraycopy(this.waveform, 0, newWaveform, 0, waveformLen);
            }
            this.waveform = newWaveform;
        }

        private int ensureCapacity(int l) {
            assert (this.position + l < this.waveform.length);
            int pos = this.position;
            this.position += l;
            return pos + 1;
        }
    }

    private static class EpicProcessing {
        int lastT;
        int lastV;
        int minV = Integer.MAX_VALUE;
        int maxV = Integer.MIN_VALUE;

        private EpicProcessing() {
        }
    }

    private static class EpicStimuli
    extends Stimuli {
        double timeResolution;
        double voltageResolution;
        double currentResolution;

        private EpicStimuli() {
        }
    }
}

