/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.cvspm;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.cvspm.CVS;
import com.sun.electric.tool.cvspm.Edit;
import com.sun.electric.tool.cvspm.State;
import com.sun.electric.tool.cvspm.Update;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.user.dialogs.OpenFile;
import java.awt.Color;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CVSLibrary {
    private FileType type;
    private State libState;
    private Map<Cell, State> cellStates;
    private Map<Cell, Cell> editing;
    private boolean libEditing;
    private static Map<Library, CVSLibrary> CVSLibraries = new HashMap<Library, CVSLibrary>();

    private CVSLibrary(Library lib) {
        String libFile = lib.getLibFile().getPath();
        this.type = OpenFile.getOpenFileType(libFile, FileType.JELIB);
        this.libState = State.NONE;
        this.libEditing = false;
        this.cellStates = new HashMap<Cell, State>();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            this.cellStates.put(cell, State.NONE);
            if (!CVS.isDELIB(lib) || CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
            this.cellStates.put(cell, State.UNKNOWN);
        }
        this.editing = new HashMap<Cell, Cell>();
    }

    public static void addLibrary(Library lib) {
        CVSLibrary.addLibrary(lib, false);
    }

    private static void addLibrary(Library lib, boolean added) {
        if (lib.isHidden()) {
            return;
        }
        if (!lib.isFromDisk()) {
            return;
        }
        String libFile = lib.getLibFile().getPath();
        if (!added && !CVS.isFileInCVS(new File(libFile))) {
            return;
        }
        CVSLibrary cvslib = new CVSLibrary(lib);
        CVSLibraries.put(lib, cvslib);
    }

    public static void removeLibrary(Library lib) {
        CVSLibraries.remove(lib);
    }

    public static LibsCells getNotInCVS(List<Library> libs, List<Cell> cells) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Library lib : libs) {
            if (CVS.isInCVS(lib)) continue;
            bad.libs.add(lib);
        }
        for (Cell cell : cells) {
            if (CVS.isInCVS(cell)) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells getInCVS(List<Library> libs, List<Cell> cells) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Library lib : libs) {
            if (!CVS.isInCVS(lib)) continue;
            bad.libs.add(lib);
        }
        for (Cell cell : cells) {
            if (!CVS.isInCVS(cell)) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells getModified(List<Library> libs, List<Cell> cells) {
        if (libs == null) {
            libs = new ArrayList<Library>();
        }
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Library lib : libs) {
            if (!lib.isChanged()) continue;
            bad.libs.add(lib);
        }
        for (Cell cell : cells) {
            if (!cell.isModified(true)) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static LibsCells consolidate(List<Library> libs, List<Cell> cells) {
        LibsCells consolidated = new LibsCells();
        consolidated.libs.addAll(libs);
        for (Cell cell : cells) {
            if (libs.contains(cell.getLibrary())) continue;
            consolidated.cells.add(cell);
        }
        return consolidated;
    }

    public static LibsCells notFromDELIB(List<Cell> cells) {
        if (cells == null) {
            cells = new ArrayList<Cell>();
        }
        LibsCells bad = new LibsCells();
        for (Cell cell : cells) {
            if (CVS.isDELIB(cell.getLibrary())) continue;
            bad.cells.add(cell);
        }
        return bad;
    }

    public static boolean hasUnknownCells(Library lib) {
        CVSLibrary cvslib = CVSLibraries.get(lib);
        if (cvslib == null) {
            return false;
        }
        if (cvslib.type != FileType.DELIB) {
            return false;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State state = cvslib.cellStates.get(cell);
            if (state == null) {
                return true;
            }
            if (state != State.UNKNOWN) continue;
            return true;
        }
        return false;
    }

    public static void setState(Cell cell, State state) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary());
        if (cvslib == null && state == State.ADDED) {
            CVSLibrary.addLibrary(cell.getLibrary(), true);
            cvslib = CVSLibraries.get(cell.getLibrary());
        }
        if (cvslib == null) {
            return;
        }
        if (state == null) {
            return;
        }
        cvslib.cellStates.put(cell, state);
    }

    public static void setState(Library lib, State state) {
        CVSLibrary cvslib = CVSLibraries.get(lib);
        if (cvslib == null && state == State.ADDED) {
            CVSLibrary.addLibrary(lib, true);
            cvslib = CVSLibraries.get(lib);
        }
        if (cvslib == null) {
            return;
        }
        if (state == null) {
            return;
        }
        if (cvslib.type != FileType.DELIB) {
            cvslib.libState = state;
            return;
        }
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State currentState = cvslib.cellStates.get(cell);
            if (currentState == State.UNKNOWN) continue;
            cvslib.cellStates.put(cell, state);
        }
    }

    public static Color getColor(Library lib) {
        return CVSLibrary.getColor(CVSLibrary.getState(lib));
    }

    public static Color getColor(Cell cell) {
        return CVSLibrary.getColor(CVSLibrary.getState(cell));
    }

    public static State getState(Library lib) {
        CVSLibrary cvslib = CVSLibraries.get(lib);
        if (cvslib == null) {
            return State.UNKNOWN;
        }
        if (cvslib.type != FileType.DELIB) {
            return cvslib.libState;
        }
        TreeSet<State> states = new TreeSet<State>();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State state = cvslib.cellStates.get(cell);
            if (state == null) continue;
            states.add(state);
        }
        it = states.iterator();
        if (it.hasNext()) {
            return (State)((Object)it.next());
        }
        return State.UNKNOWN;
    }

    public static State getState(Cell cell) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary());
        if (cvslib == null) {
            return State.UNKNOWN;
        }
        if (!CVS.isDELIB(cell.getLibrary())) {
            return cvslib.libState;
        }
        State state = cvslib.cellStates.get(cell);
        if (state == null) {
            return State.UNKNOWN;
        }
        return state;
    }

    public static Color getColor(Cell.CellGroup cg) {
        TreeSet<State> states = new TreeSet<State>();
        Iterator<Cell> it = cg.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            State state = CVSLibrary.getState(cell);
            states.add(state);
        }
        return CVSLibrary.getColor(states);
    }

    public static Color getColor(State state) {
        if (state == State.NONE) {
            return Color.black;
        }
        if (state == State.UPDATE) {
            return Color.magenta;
        }
        if (state == State.MODIFIED) {
            return Color.blue;
        }
        if (state == State.CONFLICT) {
            return Color.red;
        }
        if (state == State.ADDED) {
            return Color.green;
        }
        if (state == State.REMOVED) {
            return Color.green;
        }
        if (state == State.PATCHED) {
            return Color.black;
        }
        if (state == State.UNKNOWN) {
            return Color.orange;
        }
        return Color.black;
    }

    public static Color getColor(Set<State> states) {
        Iterator<State> it = states.iterator();
        if (it.hasNext()) {
            return CVSLibrary.getColor(it.next());
        }
        return Color.black;
    }

    public static void setEditing(Cell cell, boolean editing) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary());
        if (cvslib == null) {
            return;
        }
        if (editing) {
            cvslib.editing.put(cell, cell);
        } else {
            cvslib.editing.remove(cell);
        }
    }

    public static boolean isEditing(Cell cell) {
        CVSLibrary cvslib = CVSLibraries.get(cell.getLibrary());
        if (cvslib == null) {
            return false;
        }
        return cvslib.editing.containsKey(cell);
    }

    public static void setEditing(Library lib, boolean editing) {
        CVSLibrary cvslib = CVSLibraries.get(lib);
        if (cvslib == null) {
            return;
        }
        if (!CVS.isDELIB(lib)) {
            cvslib.libEditing = editing;
        } else {
            editing = false;
            if (false) {
                cvslib.editing.clear();
            }
        }
    }

    public static boolean isEditing(Library lib) {
        CVSLibrary cvslib = CVSLibraries.get(lib);
        if (cvslib == null) {
            return false;
        }
        if (!CVS.isDELIB(lib)) {
            return cvslib.libEditing;
        }
        return !cvslib.editing.isEmpty();
    }

    public static void savingLibrary(Library lib) {
        URL libFile = lib.getLibFile();
        if (libFile != null) {
            FileType type = OpenFile.getOpenFileType(libFile.getFile(), FileType.JELIB);
            CVSLibrary cvslib = CVSLibraries.get(lib);
            if (cvslib != null && cvslib.type != type) {
                CVSLibrary.removeLibrary(lib);
                CVSLibrary.addLibrary(lib);
            }
        }
        if (!CVS.isDELIB(lib)) {
            if (lib.getLibFile() == null) {
                return;
            }
            File file = TextUtils.getFile(lib.getLibFile());
            if (file == null) {
                return;
            }
            if (!CVS.isFileInCVS(new File(lib.getLibFile().getPath()))) {
                return;
            }
            if (CVSLibrary.getState(lib) == State.ADDED) {
                return;
            }
            if (!CVSLibrary.isEditing(lib)) {
                Edit.edit(file.getName(), file.getParentFile().getPath());
                CVSLibrary.setEditing(lib, true);
            }
            if (lib.isChanged()) {
                CVSLibrary.setState(lib, State.MODIFIED);
            }
            return;
        }
        ArrayList<Cell> modifiedCells = new ArrayList<Cell>();
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (CVSLibrary.getState(cell) == State.ADDED || !cell.isModified(true)) continue;
            modifiedCells.add(cell);
        }
        StringBuffer buf = new StringBuffer();
        for (Cell cell : modifiedCells) {
            if (!CVS.isFileInCVS(CVS.getCellFile(cell))) continue;
            CVSLibrary.setState(cell, State.MODIFIED);
            if (CVSLibrary.isEditing(cell)) continue;
            buf.append(DELIB.getCellFile(cell) + " ");
            CVSLibrary.setEditing(cell, true);
        }
        if (buf.length() == 0) {
            return;
        }
        File file = TextUtils.getFile(lib.getLibFile());
        if (file != null) {
            Edit.edit(buf.toString(), file.getPath());
        }
    }

    public static void savedLibrary(Library lib, List<String> deletedCellFiles, List<String> writtenCellFiles) {
        ArrayList<Library> libs = new ArrayList<Library>();
        libs.add(lib);
        String useDir = CVS.getUseDir(libs, null);
        if (CVS.isInCVS(lib) && CVS.isDELIB(lib)) {
            int exitVal;
            StringBuffer buf = new StringBuffer();
            for (String s : deletedCellFiles) {
                File file = new File(s);
                if (!CVS.isFileInCVS(file) || file.exists()) continue;
                if (s.startsWith(useDir)) {
                    buf.append(s.substring(useDir.length() + 1) + " ");
                    continue;
                }
                buf.append(s + " ");
            }
            String arg = buf.toString();
            if (!arg.trim().equals("")) {
                int exitVal2 = CVS.runCVSCommand("-q remove " + arg, "Removing deleted cells from CVS", useDir, System.out);
                if (exitVal2 != 0) {
                    System.out.println("  Error running CVS remove command (exit status " + exitVal2 + ")");
                    return;
                }
                exitVal2 = CVS.runCVSCommandWithQuotes("-q commit -m \"Automatic commit of removed cell file by Electric\" " + arg, "Committing removed files to CVS", useDir, System.out);
            }
            buf = new StringBuffer();
            for (String s : writtenCellFiles) {
                File file = new File(s);
                File parent = file.getParentFile();
                if (!CVS.isFileInCVS(parent) && parent.exists()) {
                    if (parent.getAbsolutePath().startsWith(useDir)) {
                        buf.append(parent.getAbsolutePath().substring(useDir.length() + 1) + " ");
                    } else {
                        buf.append(parent.getAbsolutePath() + " ");
                    }
                }
                if (CVS.isFileInCVS(file) || !file.exists()) continue;
                if (s.startsWith(useDir)) {
                    buf.append(s.substring(useDir.length() + 1) + " ");
                    continue;
                }
                buf.append(s + " ");
            }
            arg = buf.toString();
            if (!arg.trim().equals("") && (exitVal = CVS.runCVSCommand("-q add " + buf.toString(), "Adding new cells to CVS", useDir, System.out)) != 0) {
                System.out.println("  Error running CVS add command (exit status " + exitVal + ")");
                return;
            }
        }
        if (CVS.isInCVS(lib)) {
            Update.statusNoJob(libs, null, false);
        }
    }

    public static void closeLibrary(Library lib) {
        CVSLibrary.removeLibrary(lib);
    }

    protected static class LibsCells {
        public List<Library> libs = new ArrayList<Library>();
        public List<Cell> cells = new ArrayList<Cell>();

        protected LibsCells() {
        }
    }
}

