/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.Variable;

public class VarContext {
    private VarContext prev;
    private Nodable ni;
    private PortInst pi;
    public static VarContext globalContext = new VarContext();

    public VarContext push(Nodable ni) {
        return new VarContext(ni, this, null);
    }

    public VarContext push(PortInst pi) {
        return new VarContext(pi.getNodeInst(), this, pi);
    }

    private VarContext(Nodable ni, VarContext prev, PortInst pi) {
        this.ni = ni;
        this.prev = prev;
        this.pi = pi;
    }

    private VarContext() {
        this.ni = null;
        this.prev = this;
    }

    public VarContext pop() {
        return this.prev;
    }

    public Nodable getNodable() {
        return this.ni;
    }

    public PortInst getPortInst() {
        return this.pi;
    }

    public boolean equals(VarContext c) {
        if (this == c) {
            return true;
        }
        if (this.ni != c.getNodable()) {
            return false;
        }
        return this.prev.equals(c.pop());
    }

    public Object evalVar(Variable var) {
        return this.evalVar(var, null);
    }

    public Object evalVar(Variable var, Object info) {
        if (var == null) {
            return null;
        }
        Variable.Code code = var.getCode();
        if (code == Variable.Code.JAVA) {
            return EvalJavaBsh.evalJavaBsh.eval(var.getObject(), this, info);
        }
        return var.getObject();
    }

    public Object lookupVarEval(String name) {
        if (this.ni == null) {
            return null;
        }
        Variable var = this.ni.getVar(name);
        if (var == null) {
            Cell cell;
            NodeProto np = this.ni.getProto();
            if (np.isIcon() && (cell = ((Cell)np).getEquivalent()) != null) {
                np = cell;
            }
            var = np.getVar(name);
        }
        if (var == null) {
            return "Var " + name.replaceFirst("ATTR_", "") + " not found";
        }
        return this.pop().evalVar(var, this.ni);
    }

    public Object lookupVarFarEval(String name) {
        VarContext scan = this;
        while (scan != null && this.ni != null) {
            Cell cell;
            Nodable ni = scan.getNodable();
            if (ni == null) {
                return null;
            }
            Variable var = ni.getVar(name);
            if (var != null) {
                return scan.pop().evalVar(var, ni);
            }
            NodeProto np = ni.getProto();
            if (np.isIcon() && (cell = ((Cell)np).getEquivalent()) != null) {
                np = cell;
            }
            if ((var = np.getVar(name)) != null) {
                return scan.pop().evalVar(var, ni);
            }
            scan = scan.prev;
        }
        return null;
    }

    public String getInstPath(String sep) {
        Nodable no2;
        if (this == globalContext) {
            return "";
        }
        String prefix = this.pop() == globalContext ? "" : this.pop().getInstPath(sep);
        Nodable no = this.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        if (no instanceof NodeInst && (no2 = Netlist.getNodableFor((NodeInst)no, 0)) != null) {
            no = no2;
        }
        String me = no.getName();
        if (prefix.equals("")) {
            return me;
        }
        return prefix + sep + me;
    }

    public static float objectToFloat(Object obj, float def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        try {
            return Float.valueOf(obj.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static int objectToInt(Object obj, int def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.valueOf(obj.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static short objectToShort(Object obj, short def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        try {
            return Short.valueOf(obj.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static double objectToDouble(Object obj, double def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            return Double.valueOf(obj.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }
}

