dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2003 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ(2.57)

AC_DEFUN([CL_FSTAT],
[AC_BEFORE([$0], [CL_STAT])dnl
AC_BEFORE([$0], [CL_LSTAT])dnl
dnl Must use AC_TRY_LINK instead of CL_PROTO because Linux defines fstat()
dnl as an inline function in <sys/stat.h> and libc-5.0.9 doesn't define `fstat',
dnl hence when compiling in C++ mode the declaration in <sys/stat.h> and that
dnl of CL_PROTO may not clash.
CL_PROTO([fstat], [
AC_TRY_LINK([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
]
AC_LANG_EXTERN
[#if defined(__STDC__) || defined(__cplusplus)
int fstat (int fd, struct stat * buf);
#else
int fstat();
#endif
], [return fstat(0,(struct stat *)0);],
cl_cv_proto_fstat_inline=no
have_fstat_decl=1)
if test -z "$have_fstat_decl"; then
  # This happens on Linux with g++ and libc-5.0.9.
  cl_cv_proto_fstat_inline=yes
fi
], [extern int fstat (int, struct stat *);])
if test $cl_cv_proto_fstat_inline = yes; then
  AC_DEFINE(FSTAT_INLINE,,[does fstat() function have C linkage?])
fi
])

AC_DEFUN([CL_STAT],
[AC_REQUIRE([CL_FSTAT])dnl
dnl Must use AC_TRY_LINK instead of CL_PROTO because Linux defines stat()
dnl as an inline function in <sys/stat.h> and libc-5.0.9 doesn't define `stat',
dnl hence when compiling in C++ mode the declaration in <sys/stat.h> and that
dnl of CL_PROTO may not clash.
dnl Just assume that `stat' is defined as an inline function if and only if
dnl `fstat' is. We do this because if it is, in C++ mode, exactly one of the two
dnl trial declarations `extern "C" int stat ([const] char *, struct stat *)'
dnl will give an error, and the other will or will not link correctly (depends
dnl on libc: will with libc-5.2.18, will not with libc-5.0.9).
cl_cv_proto_stat_inline=$cl_cv_proto_fstat_inline
if test $cl_cv_proto_stat_inline = yes; then
  AC_DEFINE(STAT_INLINE,,[does stat() function have C linkage?])
fi
CL_PROTO([stat], [
AC_TRY_LINK([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#if defined(__cplusplus) && defined(STAT_INLINE)
extern
#else
]
AC_LANG_EXTERN
[#endif
#if defined(__STDC__) || defined(__cplusplus)
int stat (char* path, struct stat * buf);
#else
int stat();
#endif
], [return stat((char*)"",(struct stat *)0);],
cl_cv_proto_stat_arg1=""
have_stat_decl=1)
if test -z "$have_stat_decl"; then
AC_TRY_LINK([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#if defined(__cplusplus) && defined(STAT_INLINE)
extern
#else
]
AC_LANG_EXTERN
[#endif
#if defined(__STDC__) || defined(__cplusplus)
int stat (const char* path, struct stat * buf);
#else
int stat();
#endif
], [return stat((const char*)"",(struct stat *)0);],
cl_cv_proto_stat_arg1="const"
have_stat_decl=1)
fi
dnl if test -z "$have_stat_decl"; then
dnl   # This happens on Linux with g++ and libc-5.0.9.
dnl   cl_cv_proto_stat_arg1="const"
dnl   cl_cv_proto_stat_inline=yes
dnl fi
], [extern int stat ($cl_cv_proto_stat_arg1 char*, struct stat *);])
AC_DEFINE_UNQUOTED(STAT_CONST,$cl_cv_proto_stat_arg1,[declaration of stat() needs const])
dnl if test $cl_cv_proto_stat_inline = yes; then
dnl   AC_DEFINE(STAT_INLINE)
dnl fi
])

AC_DEFUN([CL_LSTAT],
[AC_REQUIRE([CL_FSTAT])dnl
dnl Cannot use AC_CHECK_FUNCS(lstat) because Linux defines lstat() as an
dnl inline function in <sys/stat.h>. Must use AC_TRY_LINK instead of CL_PROTO
dnl because Linux defines lstat() as an inline function in <sys/stat.h> and
dnl libc-5.0.9 doesn't define `lstat', hence when compiling in C++ mode
dnl the declaration in <sys/stat.h> and that of CL_PROTO may not clash.
CL_LINK_CHECK([lstat],cl_cv_func_lstat,[
#include <sys/types.h>
#include <sys/stat.h>
], [return lstat("",(struct stat *)0);],
AC_DEFINE(HAVE_LSTAT,,[have lstat()?]))dnl
if test $cl_cv_func_lstat = yes; then
dnl Just assume that `lstat' is defined as an inline function if and only if
dnl `fstat' is. We do this because if it is, in C++ mode, exactly one of the two
dnl trial declarations `extern "C" int lstat ([const] char *, struct stat *)'
dnl will give an error, and the other will or will not link correctly (depends
dnl on libc: will with libc-5.2.18, will not with libc-5.0.9).
cl_cv_proto_lstat_inline=$cl_cv_proto_fstat_inline
if test $cl_cv_proto_lstat_inline = yes; then
  AC_DEFINE(LSTAT_INLINE,,[does lstat() function have C linkage?])
fi
CL_PROTO([lstat], [
AC_TRY_LINK([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#if defined(__cplusplus) && defined(LSTAT_INLINE)
extern
#else
]
AC_LANG_EXTERN
[#endif
#if defined(__STDC__) || defined(__cplusplus)
int lstat (char* path, struct stat * buf);
#else
int lstat();
#endif
], [return lstat((char*)"",(struct stat *)0);],
cl_cv_proto_lstat_arg1=""
have_lstat_decl=1)
if test -z "$have_lstat_decl"; then
AC_TRY_LINK([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#if defined(__cplusplus) && defined(STAT_INLINE)
extern
#else
]
AC_LANG_EXTERN
[#endif
#if defined(__STDC__) || defined(__cplusplus)
int lstat (const char* path, struct stat * buf);
#else
int lstat();
#endif
], [return lstat((const char*)"",(struct stat *)0);],
cl_cv_proto_lstat_arg1="const"
have_lstat_decl=1)
fi
dnl if test -z "$have_lstat_decl"; then
dnl   # This happens on Linux with g++ and libc-5.0.9.
dnl   cl_cv_proto_lstat_arg1="const"
dnl   cl_cv_proto_lstat_inline=yes
dnl fi
], [extern int lstat ($cl_cv_proto_lstat_arg1 char*, struct stat *);])
AC_DEFINE_UNQUOTED(LSTAT_CONST,$cl_cv_proto_lstat_arg1,[declaration of lstat() needs const])
dnl if test $cl_cv_proto_lstat_inline = yes; then
dnl   AC_DEFINE(LSTAT_INLINE)
dnl fi
fi
])
