#ifndef GNUMERIC_PARSE_UTIL_H
# define GNUMERIC_PARSE_UTIL_H

#include "gnumeric.h"

char const  *col_name                 (int col);
char const  *cols_name                (int start_col, int end_col);
char const  *row_name                 (int row);
char const  *rows_name                (int start_row, int end_col);

char        *cellref_name            (CellRef const *cell_ref,
				      ParsePos const *pp, gboolean no_sheetname);
gboolean     cellref_get             (CellRef *out, char const *in,
				      CellPos const *pos);
gboolean     cellref_a1_get          (CellRef *out, char const *in,
				      CellPos const *pos);
gboolean     cellref_r1c1_get        (CellRef *out, char const *in,
				      CellPos const *pos);

char const *cell_coord_name	     (int col, int row);
char const *cell_pos_name	     (CellPos const *pos);
char const *cell_name                (Cell const *cell);

/* Various parsing routines */
int         parse_col_name           (char const *cell_str, char const **endptr);
gboolean    parse_cell_name          (char const *cell_str, int *col, int *row,
				      gboolean strict, int *chars_read);
gboolean    parse_cell_name_or_range (char const *cell_str, int *col, int *row,
				      int *cols, int *rows, gboolean strict);
gboolean    parse_cell_range         (Sheet *sheet, char const *range, Value **v);
GSList     *parse_cell_name_list     (Sheet *sheet, char const *cell_name_str,
				      int *error_flag, gboolean strict);

StyleFormat *parse_text_value_or_expr (EvalPos const *pos,
				       char const *text,
				       Value **val, ExprTree **expr,
				       StyleFormat const *current_format /* can be NULL */);

/* Is this string potentially the start of an expression */
char const * gnumeric_char_start_expr_p (char const * c);

/* In parser.y  */
typedef struct {
	char *message;
	int begin_char, end_char;
} ParseError;
ParseError *parse_error_init (ParseError *pe);
void        parse_error_free (ParseError *pe);

ExprTree *gnumeric_expr_parser (char const *expr_text, ParsePos const *pos,
				gboolean use_excel_range_conventions,
				gboolean create_place_holder_for_unknown_func,
				StyleFormat **desired_format,
				ParseError *pe);

#endif /* GNUMERIC_PARSE_UTIL_H */
