/* gcp-view.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-view.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <gio/gio.h>


#define GCP_TYPE_VIEW (gcp_view_get_type ())
#define GCP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_VIEW, GcpView))
#define GCP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_VIEW, GcpViewClass))
#define GCP_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_VIEW))
#define GCP_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_VIEW))
#define GCP_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_VIEW, GcpViewClass))

typedef struct _GcpView GcpView;
typedef struct _GcpViewClass GcpViewClass;
typedef struct _GcpViewPrivate GcpViewPrivate;

#define GCP_TYPE_BACKEND (gcp_backend_get_type ())
#define GCP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_BACKEND, GcpBackend))
#define GCP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_BACKEND, GcpBackendClass))
#define GCP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_BACKEND))
#define GCP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_BACKEND))
#define GCP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_BACKEND, GcpBackendClass))

typedef struct _GcpBackend GcpBackend;
typedef struct _GcpBackendClass GcpBackendClass;

#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;

#define GCP_TYPE_DIAGNOSTIC_TAGS (gcp_diagnostic_tags_get_type ())
#define GCP_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTags))
#define GCP_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))
#define GCP_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))

typedef struct _GcpDiagnosticTags GcpDiagnosticTags;
typedef struct _GcpDiagnosticTagsClass GcpDiagnosticTagsClass;

#define GCP_TYPE_SCROLLBAR_MARKER (gcp_scrollbar_marker_get_type ())
#define GCP_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarker))
#define GCP_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))
#define GCP_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))

typedef struct _GcpScrollbarMarker GcpScrollbarMarker;
typedef struct _GcpScrollbarMarkerClass GcpScrollbarMarkerClass;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;

#define GCP_TYPE_DIAGNOSTIC_MESSAGE (gcp_diagnostic_message_get_type ())
#define GCP_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessage))
#define GCP_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessageClass))
#define GCP_IS_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE))
#define GCP_IS_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_MESSAGE))
#define GCP_DIAGNOSTIC_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessageClass))

typedef struct _GcpDiagnosticMessage GcpDiagnosticMessage;
typedef struct _GcpDiagnosticMessageClass GcpDiagnosticMessageClass;

#define GCP_TYPE_SEMANTIC_VALUE (gcp_semantic_value_get_type ())
#define GCP_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValue))
#define GCP_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValueClass))
#define GCP_IS_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SEMANTIC_VALUE))
#define GCP_IS_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SEMANTIC_VALUE))
#define GCP_SEMANTIC_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValueClass))

typedef struct _GcpSemanticValue GcpSemanticValue;
typedef struct _GcpSemanticValueClass GcpSemanticValueClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gcp_diagnostic_tags_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_tags_unref (var), NULL)))
#define _gcp_scrollbar_marker_unref0(var) ((var == NULL) ? NULL : (var = (gcp_scrollbar_marker_unref (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCP_TYPE_BACKEND_MANAGER (gcp_backend_manager_get_type ())
#define GCP_BACKEND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_BACKEND_MANAGER, GcpBackendManager))
#define GCP_BACKEND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_BACKEND_MANAGER, GcpBackendManagerClass))
#define GCP_IS_BACKEND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_BACKEND_MANAGER))
#define GCP_IS_BACKEND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_BACKEND_MANAGER))
#define GCP_BACKEND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_BACKEND_MANAGER, GcpBackendManagerClass))

typedef struct _GcpBackendManager GcpBackendManager;
typedef struct _GcpBackendManagerClass GcpBackendManagerClass;

#define GCP_TYPE_DIAGNOSTIC_SUPPORT (gcp_diagnostic_support_get_type ())
#define GCP_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupport))
#define GCP_IS_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT))
#define GCP_DIAGNOSTIC_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupportIface))

typedef struct _GcpDiagnosticSupport GcpDiagnosticSupport;
typedef struct _GcpDiagnosticSupportIface GcpDiagnosticSupportIface;

#define GCP_TYPE_SOURCE_INDEX (gcp_source_index_get_type ())
#define GCP_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndex))
#define GCP_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))
#define GCP_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_INDEX))
#define GCP_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_INDEX))
#define GCP_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))

typedef struct _GcpSourceIndex GcpSourceIndex;
typedef struct _GcpSourceIndexClass GcpSourceIndexClass;

#define GCP_TYPE_SEMANTIC_VALUE_SUPPORT (gcp_semantic_value_support_get_type ())
#define GCP_SEMANTIC_VALUE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT, GcpSemanticValueSupport))
#define GCP_IS_SEMANTIC_VALUE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT))
#define GCP_SEMANTIC_VALUE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT, GcpSemanticValueSupportIface))

typedef struct _GcpSemanticValueSupport GcpSemanticValueSupport;
typedef struct _GcpSemanticValueSupportIface GcpSemanticValueSupportIface;

#define GCP_TYPE_DIAGNOSTIC_COLORS (gcp_diagnostic_colors_get_type ())
#define GCP_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColors))
#define GCP_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))
#define GCP_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))

typedef struct _GcpDiagnosticColors GcpDiagnosticColors;
typedef struct _GcpDiagnosticColorsClass GcpDiagnosticColorsClass;
#define _gcp_diagnostic_colors_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_colors_unref (var), NULL)))

#define GCP_SOURCE_INDEX_TYPE_ITERATOR (gcp_source_index_iterator_get_type ())
#define GCP_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIterator))
#define GCP_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))
#define GCP_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SOURCE_INDEX_TYPE_ITERATOR))
#define GCP_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SOURCE_INDEX_TYPE_ITERATOR, GcpSourceIndexIteratorClass))

typedef struct _GcpSourceIndexIterator GcpSourceIndexIterator;
typedef struct _GcpSourceIndexIteratorClass GcpSourceIndexIteratorClass;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_SEMANTIC_VALUE_TYPE_KIND (gcp_semantic_value_kind_get_type ())

#define GCP_SEMANTIC_VALUE_TYPE_REFERENCE_TYPE (gcp_semantic_value_reference_type_get_type ())

struct _GcpView {
	GObject parent_instance;
	GcpViewPrivate * priv;
};

struct _GcpViewClass {
	GObjectClass parent_class;
	gboolean (*find_definition) (GcpView* self);
	gboolean (*find_reference) (GcpView* self, gint direction);
};

struct _GcpViewPrivate {
	GeditView* d_view;
	GeditDocument* d_buffer;
	GcpBackend* d_backend;
	GcpDocument* d_document;
	GcpDiagnosticTags* d_tags;
	GcpScrollbarMarker* d_scrollbarMarker;
	GeeHashMap* d_diagnosticsAtEnd;
	GcpDiagnostic** d_cursorDiagnostics;
	gint d_cursorDiagnostics_length1;
	gint _d_cursorDiagnostics_size_;
	GcpDiagnosticMessage* d_cursorDiagnosticMessage;
	GcpSemanticValue* d_semanticValue;
	GtkTextTag* d_semanticTag;
	guint d_lastMergeId;
	GdkRGBA d_refColor;
};

struct _GcpDiagnosticSupportIface {
	GTypeInterface parent_iface;
	GcpDiagnosticTags* (*get_tags) (GcpDiagnosticSupport* self);
	void (*set_tags) (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
	GcpSourceIndex* (*get_diagnostics) (GcpDiagnosticSupport* self);
};

struct _GcpSemanticValueSupportIface {
	GTypeInterface parent_iface;
	GcpSourceIndex* (*get_semantics) (GcpSemanticValueSupport* self);
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

typedef enum  {
	GCP_SEMANTIC_VALUE_KIND_NONE,
	GCP_SEMANTIC_VALUE_KIND_STRUCT,
	GCP_SEMANTIC_VALUE_KIND_UNION,
	GCP_SEMANTIC_VALUE_KIND_CLASS,
	GCP_SEMANTIC_VALUE_KIND_ENUM,
	GCP_SEMANTIC_VALUE_KIND_FIELD,
	GCP_SEMANTIC_VALUE_KIND_ENUM_VALUE,
	GCP_SEMANTIC_VALUE_KIND_FUNCTION,
	GCP_SEMANTIC_VALUE_KIND_MEMBER_FUNCTION,
	GCP_SEMANTIC_VALUE_KIND_CONSTRUCTOR,
	GCP_SEMANTIC_VALUE_KIND_DESTRUCTOR,
	GCP_SEMANTIC_VALUE_KIND_VARIABLE,
	GCP_SEMANTIC_VALUE_KIND_PARAMETER,
	GCP_SEMANTIC_VALUE_KIND_TYPEDEF,
	GCP_SEMANTIC_VALUE_KIND_NAMESPACE,
	GCP_SEMANTIC_VALUE_KIND_BLOCK
} GcpSemanticValueKind;

typedef enum  {
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_NONE = 1 << 0,
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DECLARATION = 1 << 0,
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_REFERENCE = 1 << 1,
	GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DEFINITION = 1 << 2
} GcpSemanticValueReferenceType;


static gpointer gcp_view_parent_class = NULL;
static GtkBindingSet* gcp_view_s_bindingSet;
static GtkBindingSet* gcp_view_s_bindingSet = NULL;
static GType gcp_view_type_id = 0;

GType gcp_view_get_type (void) G_GNUC_CONST;
GType gcp_view_register_type (GTypeModule * module);
GType gcp_backend_get_type (void) G_GNUC_CONST;
GType gcp_backend_register_type (GTypeModule * module);
GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
gpointer gcp_diagnostic_tags_ref (gpointer instance);
void gcp_diagnostic_tags_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_tags (const GValue* value);
GType gcp_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_tags_register_type (GTypeModule * module);
gpointer gcp_scrollbar_marker_ref (gpointer instance);
void gcp_scrollbar_marker_unref (gpointer instance);
GParamSpec* gcp_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gcp_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gcp_value_get_scrollbar_marker (const GValue* value);
GType gcp_scrollbar_marker_get_type (void) G_GNUC_CONST;
GType gcp_scrollbar_marker_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
GType gcp_diagnostic_message_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_message_register_type (GTypeModule * module);
GType gcp_semantic_value_get_type (void) G_GNUC_CONST;
GType gcp_semantic_value_register_type (GTypeModule * module);
#define GCP_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_VIEW, GcpViewPrivate))
enum  {
	GCP_VIEW_DUMMY_PROPERTY
};
GcpView* gcp_view_new (GeditView* view);
GcpView* gcp_view_construct (GType object_type, GeditView* view);
static void gcp_view_on_notify_buffer (GcpView* self);
static void _gcp_view_on_notify_buffer_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gcp_view_on_view_draw (GcpView* self, cairo_t* ctx);
static gboolean _gcp_view_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static gboolean gcp_view_on_view_key_press (GcpView* self, GdkEventKey* event);
static gboolean _gcp_view_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
GcpDiagnosticTags* gcp_diagnostic_tags_new (GtkTextView* view);
GcpDiagnosticTags* gcp_diagnostic_tags_construct (GType object_type, GtkTextView* view);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
static void gcp_view_connect_buffer (GcpView* self, GeditDocument* buffer);
GcpScrollbarMarker* gcp_scrollbar_marker_new (GtkScrollbar* scrollbar);
GcpScrollbarMarker* gcp_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar);
static void gcp_view_move_cursor_to_semantic_value (GcpView* self, GcpSemanticValue* val);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
static GcpSourceRange* gcp_view_highlight_range (GcpView* self, GcpSemanticValue* val);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
gboolean gcp_source_location_get_iter (GcpSourceLocation* self, GtkTextBuffer* buffer, GtkTextIter* iter);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
void gcp_view_deactivate (GcpView* self);
static void gcp_view_disconnect_buffer (GcpView* self);
static void gcp_view_on_notify_language (GcpView* self);
static void _gcp_view_on_notify_language_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_view_on_buffer_changed (GcpView* self);
static void _gcp_view_on_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void gcp_view_on_buffer_mark_set (GcpView* self, GtkTextIter* location, GtkTextMark* mark);
static void _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void gcp_view_on_notify_style_scheme (GcpView* self);
static void _gcp_view_on_notify_style_scheme_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gcp_view_remove_references (GcpView* self);
static void gcp_view_update_semantic_tag (GcpView* self);
static void gcp_view_update_references (GcpView* self);
static void gcp_view_update_backend (GcpView* self);
static void gcp_view_update_diagnostic_message (GcpView* self);
void gcp_scrollbar_marker_set_max_line (GcpScrollbarMarker* self, gint value);
gpointer gcp_backend_manager_ref (gpointer instance);
void gcp_backend_manager_unref (gpointer instance);
GParamSpec* gcp_param_spec_backend_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_backend_manager (GValue* value, gpointer v_object);
void gcp_value_take_backend_manager (GValue* value, gpointer v_object);
gpointer gcp_value_get_backend_manager (const GValue* value);
GType gcp_backend_manager_get_type (void) G_GNUC_CONST;
GType gcp_backend_manager_register_type (GTypeModule * module);
GcpBackendManager* gcp_backend_manager_get_instance (void);
GcpBackend* gcp_backend_manager_get (GcpBackendManager* self, const gchar* language);
static void gcp_view_unregister_backend (GcpView* self);
static void gcp_view_register_backend (GcpView* self, GcpBackend* backend);
GType gcp_source_index_get_type (void) G_GNUC_CONST;
GType gcp_source_index_register_type (GTypeModule * module);
GType gcp_diagnostic_support_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_support_register_type (GTypeModule * module);
static gboolean gcp_view_on_view_query_tooltip (GcpView* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
static gboolean _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self);
static void gcp_view_on_cursor_diagnostics_moved (GcpView* self);
static void _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self);
GType gcp_semantic_value_support_get_type (void) G_GNUC_CONST;
GType gcp_semantic_value_support_register_type (GTypeModule * module);
static void gcp_view_on_cursor_semantics_moved (GcpView* self);
static void _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self);
void gcp_backend_unregister (GcpBackend* self, GcpDocument* document);
static gchar* gcp_view_format_diagnostics (GcpView* self, GcpDiagnostic** diagnostics, int diagnostics_length1);
gchar* gcp_diagnostic_to_markup (GcpDiagnostic* self, gboolean include_severity);
static gchar* gcp_view_on_diagnostic_tooltip (GcpView* self, GtkSourceMarkAttributes* attributes, GtkSourceMark* mark);
GcpDiagnostic** gcp_diagnostic_support_find_at_line (GcpDiagnosticSupport* self, gint line, int* result_length1);
GcpSourceLocation* gcp_source_location_new_iter (GtkTextIter* iter);
GcpSourceLocation* gcp_source_location_construct_iter (GType object_type, GtkTextIter* iter);
GcpDiagnostic** gcp_diagnostic_support_find_at (GcpDiagnosticSupport* self, GcpSourceLocation* location, int* result_length1);
GcpDocument* gcp_backend_register (GcpBackend* self, GeditDocument* document);
void gcp_diagnostic_support_set_tags (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
static void gcp_view_on_diagnostic_updated (GcpView* self, GcpDiagnosticSupport* diagnostics);
static void _gcp_view_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self);
static gchar* _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* object, gpointer self);
const gchar* gcp_document_get_error_mark_category (void);
const gchar* gcp_document_get_warning_mark_category (void);
const gchar* gcp_document_get_info_mark_category (void);
static void gcp_view_on_semantics_updated (GcpView* self, GcpSemanticValueSupport* semantics);
static void _gcp_view_on_semantics_updated_gcp_semantic_value_support_semantic_values_updated (GcpSemanticValueSupport* _sender, gpointer self);
static gboolean gcp_view_diagnostic_is_at_end (GcpView* self, GcpSourceLocation* location);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gint gcp_source_location_get_column (GcpSourceLocation* self);
static void gcp_view_add_diagnostic_at_end (GcpView* self, GcpSourceLocation* location, GdkRGBA* color);
void gcp_scrollbar_marker_clear (GcpScrollbarMarker* self);
gpointer gcp_diagnostic_colors_ref (gpointer instance);
void gcp_diagnostic_colors_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_colors (const GValue* value);
GType gcp_diagnostic_colors_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_colors_register_type (GTypeModule * module);
GtkScrollbar* gcp_scrollbar_marker_get_scrollbar (GcpScrollbarMarker* self);
GcpDiagnosticColors* gcp_diagnostic_colors_new (GtkStyleContext* context);
GcpDiagnosticColors* gcp_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
void gcp_diagnostic_colors_mix_in_widget (GcpDiagnosticColors* self, GtkWidget* widget);
guint gcp_scrollbar_marker_new_merge_id (GcpScrollbarMarker* self);
GcpSourceIndex* gcp_diagnostic_support_get_diagnostics (GcpDiagnosticSupport* self);
GType gcp_source_index_iterator_get_type (void) G_GNUC_CONST;
GType gcp_source_index_iterator_register_type (GTypeModule * module);
GcpSourceIndexIterator* gcp_source_index_iterator (GcpSourceIndex* self);
gboolean gcp_source_index_iterator_next (GcpSourceIndexIterator* self);
gpointer gcp_source_index_iterator_get (GcpSourceIndexIterator* self);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
GdkRGBA* gcp_diagnostic_colors_get (GcpDiagnosticColors* self, GcpDiagnosticSeverity severity);
GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GcpSourceRange** gcp_source_range_support_get_ranges (GcpSourceRangeSupport* self, int* result_length1);
void gcp_scrollbar_marker_add_with_id (GcpScrollbarMarker* self, guint id, GcpSourceRange* range, GdkRGBA* color);
GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self);
GcpSourceRange* gcp_source_range_support_get_range (GcpSourceRangeSupport* self);
static gboolean gcp_view_same_diagnostics (GcpView* self, GcpDiagnostic** first, int first_length1, GcpDiagnostic** second, int second_length1);
GcpDiagnosticMessage* gcp_diagnostic_message_new (GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1);
GcpDiagnosticMessage* gcp_diagnostic_message_construct (GType object_type, GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1);
static void _lambda11_ (GcpView* self);
static void __lambda11__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static GcpDiagnostic** _vala_array_dup1 (GcpDiagnostic** self, int length);
GType gcp_semantic_value_kind_get_type (void) G_GNUC_CONST;
GcpSemanticValueKind gcp_semantic_value_get_kind (GcpSemanticValue* self);
GType gcp_semantic_value_reference_type_get_type (void) G_GNUC_CONST;
GcpSemanticValueReferenceType gcp_semantic_value_get_reference_type (GcpSemanticValue* self);
GcpSemanticValue* gcp_semantic_value_get_down (GcpSemanticValue* self);
GcpSourceLocation* gcp_source_location_copy (GcpSourceLocation* self);
GFile* gcp_source_location_get_file (GcpSourceLocation* self);
GcpSourceLocation* gcp_source_location_new (GFile* file, gint line, gint column);
GcpSourceLocation* gcp_source_location_construct (GType object_type, GFile* file, gint line, gint column);
GcpSourceRange* gcp_source_range_new (GcpSourceLocation* start, GcpSourceLocation* end);
GcpSourceRange* gcp_source_range_construct (GType object_type, GcpSourceLocation* start, GcpSourceLocation* end);
static void gcp_view_mark_reference (GcpView* self, GcpSemanticValue* val);
gboolean gcp_document_source_range (GcpDocument* self, GcpSourceRange* range, GtkTextIter* start, GtkTextIter* end);
static void gcp_view_mark_references (GcpView* self, GcpSemanticValue** refs, int refs_length1);
void gcp_scrollbar_marker_remove (GcpScrollbarMarker* self, guint id);
static GcpSemanticValue* gcp_view_semantic_value_at_cursor (GcpView* self);
GcpSourceIndex* gcp_semantic_value_support_get_semantics (GcpSemanticValueSupport* self);
gpointer gcp_source_index_find_inner_at (GcpSourceIndex* self, GcpSourceLocation* location);
static GcpSemanticValue** gcp_view_references_at_cursor (GcpView* self, GcpSemanticValue** val, gint* vidx, int* result_length1);
gint gcp_semantic_value_get_num_references (GcpSemanticValue* self);
GcpSemanticValue* gcp_semantic_value_reference (GcpSemanticValue* self, gint idx);
GFile* gcp_document_get_location (GcpDocument* self);
static gint gcp_view_compare_ranges (GcpSemanticValue* a, GcpSemanticValue* b);
gint gcp_source_range_compare_to (GcpSourceRange* self, GcpSourceRange* other);
gboolean gcp_view_find_definition (GcpView* self);
static gboolean gcp_view_real_find_definition (GcpView* self);
GcpSemanticValue* gcp_semantic_value_get_definition (GcpSemanticValue* self);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
gboolean gcp_view_find_reference (GcpView* self, gint direction);
static gboolean gcp_view_real_find_reference (GcpView* self, gint direction);
static void g_cclosure_user_marshal_BOOLEAN__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gcp_view_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gcp_view_on_notify_buffer_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_view_on_notify_buffer (self);
}


static gboolean _gcp_view_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gcp_view_on_view_draw (self, cr);
	return result;
}


static gboolean _gcp_view_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gcp_view_on_view_key_press (self, event);
	return result;
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
	dup = g_new0 (GdkRGBA, 1);
	memcpy (dup, self, sizeof (GdkRGBA));
	return dup;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GcpView* gcp_view_construct (GType object_type, GeditView* view) {
	GcpView * self = NULL;
	GcpDiagnosticTags* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_;
	GtkContainer* _tmp4_ = NULL;
	GtkContainer* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* sw;
	g_return_val_if_fail (view != NULL, NULL);
	self = (GcpView*) g_object_new (object_type, NULL);
	self->priv->d_view = view;
	g_signal_connect_object ((GObject*) self->priv->d_view, "notify::buffer", (GCallback) _gcp_view_on_notify_buffer_g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->d_view, "draw", (GCallback) _gcp_view_on_view_draw_gtk_widget_draw, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self->priv->d_view, "key-press-event", (GCallback) _gcp_view_on_view_key_press_gtk_widget_key_press_event, self, 0);
	_tmp0_ = gcp_diagnostic_tags_new ((GtkTextView*) self->priv->d_view);
	_gcp_diagnostic_tags_unref0 (self->priv->d_tags);
	self->priv->d_tags = _tmp0_;
	_tmp1_ = gee_hash_map_new (GTK_TYPE_TEXT_MARK, (GBoxedCopyFunc) g_object_ref, g_object_unref, GDK_TYPE_RGBA, (GBoxedCopyFunc) _gdk_rgba_dup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_diagnosticsAtEnd);
	self->priv->d_diagnosticsAtEnd = _tmp1_;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
	_tmp3_ = _tmp2_;
	gcp_view_connect_buffer (self, GEDIT_IS_DOCUMENT (_tmp3_) ? ((GeditDocument*) _tmp3_) : NULL);
	_tmp4_ = gtk_widget_get_parent ((GtkWidget*) self->priv->d_view);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (GTK_IS_SCROLLED_WINDOW (_tmp5_) ? ((GtkScrolledWindow*) _tmp5_) : NULL);
	sw = _tmp6_;
	if (sw != NULL) {
		GtkWidget* _tmp7_ = NULL;
		GtkWidget* _tmp8_;
		GcpScrollbarMarker* _tmp9_ = NULL;
		_tmp7_ = gtk_scrolled_window_get_vscrollbar (sw);
		_tmp8_ = _tmp7_;
		_tmp9_ = gcp_scrollbar_marker_new (GTK_IS_SCROLLBAR (_tmp8_) ? ((GtkScrollbar*) _tmp8_) : NULL);
		_gcp_scrollbar_marker_unref0 (self->priv->d_scrollbarMarker);
		self->priv->d_scrollbarMarker = _tmp9_;
	}
	_g_object_unref0 (sw);
	return self;
}


GcpView* gcp_view_new (GeditView* view) {
	return gcp_view_construct (GCP_TYPE_VIEW, view);
}


static void gcp_view_move_cursor_to_semantic_value (GcpView* self, GcpSemanticValue* val) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcpSourceRange* _tmp0_ = NULL;
	GcpSourceRange* range;
	GcpSourceLocation* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	gboolean _tmp3_;
	GcpSourceLocation* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	if (val == NULL) {
		return;
	}
	_tmp0_ = gcp_view_highlight_range (self, val);
	range = _tmp0_;
	_tmp1_ = gcp_source_range_get_start (range);
	_tmp3_ = gcp_source_location_get_iter (_tmp1_, (GtkTextBuffer*) self->priv->d_buffer, &_tmp2_);
	start = _tmp2_;
	if (!_tmp3_) {
		_g_object_unref0 (range);
		return;
	}
	_tmp4_ = gcp_source_range_get_end (range);
	_tmp6_ = gcp_source_location_get_iter (_tmp4_, (GtkTextBuffer*) self->priv->d_buffer, &_tmp5_);
	end = _tmp5_;
	if (!_tmp6_) {
		_g_object_unref0 (range);
		return;
	}
	gtk_text_buffer_select_range ((GtkTextBuffer*) self->priv->d_buffer, &start, &end);
	_g_object_unref0 (range);
}


void gcp_view_deactivate (GcpView* self) {
	guint _tmp0_;
	GQuark _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("notify::buffer", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _gcp_view_on_notify_buffer_g_object_notify, self);
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gcp_view_on_view_draw_gtk_widget_draw, self);
	g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gcp_view_on_view_key_press_gtk_widget_key_press_event, self);
	gcp_view_disconnect_buffer (self);
	self->priv->d_view = NULL;
}


static void _gcp_view_on_notify_language_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_view_on_notify_language (self);
}


static void _gcp_view_on_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	gcp_view_on_buffer_changed (self);
}


static void _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	gcp_view_on_buffer_mark_set (self, location, mark);
}


static void _gcp_view_on_notify_style_scheme_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_view_on_notify_style_scheme (self);
}


static void gcp_view_disconnect_buffer (GcpView* self) {
	guint _tmp0_;
	GQuark _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GQuark _tmp5_;
	g_return_if_fail (self != NULL);
	if (self->priv->d_buffer == NULL) {
		return;
	}
	g_signal_parse_name ("notify::language", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->d_buffer, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _gcp_view_on_notify_language_g_object_notify, self);
	g_signal_parse_name ("changed", GTK_TYPE_TEXT_BUFFER, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self->priv->d_buffer, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gcp_view_on_buffer_changed_gtk_text_buffer_changed, self);
	g_signal_parse_name ("mark-set", GTK_TYPE_TEXT_BUFFER, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self->priv->d_buffer, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set, self);
	g_signal_parse_name ("notify::style-scheme", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->d_buffer, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _gcp_view_on_notify_style_scheme_g_object_notify, self);
	if (self->priv->d_semanticTag != NULL) {
		GtkTextTagTable* _tmp6_ = NULL;
		gcp_view_remove_references (self);
		_tmp6_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) self->priv->d_buffer);
		gtk_text_tag_table_remove (_tmp6_, self->priv->d_semanticTag);
		_g_object_unref0 (self->priv->d_semanticValue);
		self->priv->d_semanticValue = NULL;
	}
	_g_object_unref0 (self->priv->d_buffer);
	self->priv->d_buffer = NULL;
}


static void gcp_view_update_semantic_tag (GcpView* self) {
	GtkSourceStyleScheme* _tmp1_ = NULL;
	GtkSourceStyle* _tmp2_ = NULL;
	GtkSourceStyle* _tmp3_;
	GtkSourceStyle* style;
	GdkColor _tmp4_ = {0};
	GdkColor bg;
	GdkColor _tmp5_ = {0};
	GdkColor fg;
	GdkRGBA _tmp20_ = {0};
	GtkTextTag* _tmp21_ = NULL;
	GtkTextTag* _tmp22_;
	g_return_if_fail (self != NULL);
	gcp_view_remove_references (self);
	_g_object_unref0 (self->priv->d_semanticValue);
	self->priv->d_semanticValue = NULL;
	if (self->priv->d_semanticTag != NULL) {
		GtkTextTagTable* _tmp0_ = NULL;
		_tmp0_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) self->priv->d_buffer);
		gtk_text_tag_table_remove (_tmp0_, self->priv->d_semanticTag);
	}
	_tmp1_ = gtk_source_buffer_get_style_scheme ((GtkSourceBuffer*) self->priv->d_buffer);
	_tmp2_ = gtk_source_style_scheme_get_style (_tmp1_, "search-match");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style = _tmp3_;
	_tmp4_.pixel = (guint32) 0;
	_tmp4_.red = (guint16) 0;
	_tmp4_.green = (guint16) 0;
	_tmp4_.blue = (guint16) 0;
	bg = _tmp4_;
	_tmp5_.pixel = (guint32) 0;
	_tmp5_.red = (guint16) 0;
	_tmp5_.green = (guint16) 0;
	_tmp5_.blue = (guint16) 0;
	fg = _tmp5_;
	if (style == NULL) {
		GdkColor _tmp6_ = {0};
		GdkColor _tmp7_ = {0};
		gdk_color_parse ("#fff600", &_tmp6_);
		bg = _tmp6_;
		gdk_color_parse ("#333", &_tmp7_);
		fg = _tmp7_;
	} else {
		GtkStyleContext* ctx = NULL;
		GtkStyleContext* _tmp8_ = NULL;
		GtkStyleContext* _tmp9_;
		GdkRGBA fgcol = {0};
		GdkRGBA bgcol = {0};
		GdkRGBA _tmp10_ = {0};
		GdkRGBA _tmp11_ = {0};
		gboolean _tmp12_;
		gboolean _tmp16_;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->d_view);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (ctx);
		ctx = _tmp9_;
		gtk_style_context_save (ctx);
		gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_VIEW);
		gtk_style_context_get_color (ctx, GTK_STATE_FLAG_NORMAL, &_tmp10_);
		fgcol = _tmp10_;
		gtk_style_context_get_background_color (ctx, GTK_STATE_FLAG_NORMAL, &_tmp11_);
		bgcol = _tmp11_;
		bg.red = (guint16) ((gushort) (bgcol.red * 65535));
		bg.green = (guint16) ((gushort) (bgcol.green * 65535));
		bg.blue = (guint16) ((gushort) (bgcol.blue * 65535));
		fg.red = (guint16) ((gushort) (fgcol.red * 65535));
		fg.green = (guint16) ((gushort) (fgcol.green * 65535));
		fg.blue = (guint16) ((gushort) (fgcol.blue * 65535));
		gtk_style_context_restore (ctx);
		g_object_get (style, "background-set", &_tmp12_, NULL);
		if (_tmp12_) {
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			GdkColor _tmp15_ = {0};
			g_object_get (style, "background", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			gdk_color_parse (_tmp14_, &_tmp15_);
			bg = _tmp15_;
			_g_free0 (_tmp14_);
		}
		g_object_get (style, "foreground-set", &_tmp16_, NULL);
		if (_tmp16_) {
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			GdkColor _tmp19_ = {0};
			g_object_get (style, "foreground", &_tmp17_, NULL);
			_tmp18_ = _tmp17_;
			gdk_color_parse (_tmp18_, &_tmp19_);
			fg = _tmp19_;
			_g_free0 (_tmp18_);
		}
		_g_object_unref0 (ctx);
	}
	_tmp20_.red = bg.red / 65535.0;
	_tmp20_.green = bg.green / 65535.0;
	_tmp20_.blue = bg.blue / 65535.0;
	_tmp20_.alpha = (gdouble) 1;
	self->priv->d_refColor = _tmp20_;
	_tmp21_ = gtk_text_buffer_create_tag ((GtkTextBuffer*) self->priv->d_buffer, "Gcp.View.Semantic", "background-gdk", &bg, "foreground-gdk", &fg, "background-full-height", TRUE, NULL);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->d_semanticTag);
	self->priv->d_semanticTag = _tmp22_;
	gcp_view_update_references (self);
	_g_object_unref0 (style);
}


static void gcp_view_connect_buffer (GcpView* self, GeditDocument* buffer) {
	GeditDocument* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	_tmp0_ = _g_object_ref0 (buffer);
	_g_object_unref0 (self->priv->d_buffer);
	self->priv->d_buffer = _tmp0_;
	if (self->priv->d_buffer == NULL) {
		return;
	}
	g_signal_connect_object ((GObject*) self->priv->d_buffer, "notify::language", (GCallback) _gcp_view_on_notify_language_g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self->priv->d_buffer, "changed", (GCallback) _gcp_view_on_buffer_changed_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self->priv->d_buffer, "mark-set", (GCallback) _gcp_view_on_buffer_mark_set_gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object ((GObject*) self->priv->d_buffer, "notify::style-scheme", (GCallback) _gcp_view_on_notify_style_scheme_g_object_notify, self, 0);
	gcp_view_update_semantic_tag (self);
	gcp_view_update_backend (self);
}


static void gcp_view_on_notify_style_scheme (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_semantic_tag (self);
	gcp_view_update_diagnostic_message (self);
}


static void gcp_view_on_buffer_changed (GcpView* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self->priv->d_buffer);
	gcp_scrollbar_marker_set_max_line (self->priv->d_scrollbarMarker, _tmp0_);
}


static void gcp_view_update_backend (GcpView* self) {
	GtkSourceLanguage* _tmp0_ = NULL;
	GtkSourceLanguage* _tmp1_;
	GtkSourceLanguage* lang;
	GcpBackend* backend;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) self->priv->d_buffer);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lang = _tmp1_;
	backend = NULL;
	if (lang != NULL) {
		GcpBackendManager* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GcpBackend* _tmp4_ = NULL;
		_tmp2_ = gcp_backend_manager_get_instance ();
		_tmp3_ = gtk_source_language_get_id (lang);
		_tmp4_ = gcp_backend_manager_get (_tmp2_, _tmp3_);
		_g_object_unref0 (backend);
		backend = _tmp4_;
	}
	gcp_view_unregister_backend (self);
	gcp_view_register_backend (self, backend);
	_g_object_unref0 (backend);
	_g_object_unref0 (lang);
}


static gboolean _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self) {
	gboolean result;
	result = gcp_view_on_view_query_tooltip (self, x, y, keyboard_tooltip, tooltip);
	return result;
}


static void _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self) {
	gcp_view_on_cursor_diagnostics_moved (self);
}


static void _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self) {
	gcp_view_on_cursor_semantics_moved (self);
}


static void gcp_view_unregister_backend (GcpView* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->d_backend == NULL) {
		return;
	}
	if (self->priv->d_document != NULL) {
		if (GCP_IS_DIAGNOSTIC_SUPPORT (self->priv->d_document)) {
			guint _tmp0_;
			guint _tmp1_;
			g_signal_parse_name ("query-tooltip", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip, self);
			gtk_source_view_set_show_line_marks ((GtkSourceView*) self->priv->d_view, FALSE);
			g_signal_parse_name ("cursor-moved", gedit_document_get_type (), &_tmp1_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (self->priv->d_buffer, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved, self);
		}
		if (GCP_IS_SEMANTIC_VALUE_SUPPORT (self->priv->d_document)) {
			guint _tmp2_;
			g_signal_parse_name ("cursor-moved", gedit_document_get_type (), &_tmp2_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (self->priv->d_buffer, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved, self);
		}
		gcp_backend_unregister (self->priv->d_backend, self->priv->d_document);
	}
	_g_object_unref0 (self->priv->d_backend);
	self->priv->d_backend = NULL;
	_g_object_unref0 (self->priv->d_document);
	self->priv->d_document = NULL;
}


static gchar* gcp_view_format_diagnostics (GcpView* self, GcpDiagnostic** diagnostics, int diagnostics_length1) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** markup;
	gint markup_length1;
	gint _markup_size_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (diagnostics_length1 == 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_new0 (gchar*, diagnostics_length1 + 1);
	markup = _tmp0_;
	markup_length1 = diagnostics_length1;
	_markup_size_ = diagnostics_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < diagnostics_length1)) {
					break;
				}
				_tmp2_ = gcp_diagnostic_to_markup (diagnostics[i], FALSE);
				_tmp3_ = _tmp2_;
				_g_free0 (markup[i]);
				markup[i] = _tmp3_;
			}
		}
	}
	_tmp4_ = g_strjoinv ("\n", markup);
	result = _tmp4_;
	markup = (_vala_array_free (markup, markup_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* gcp_view_on_diagnostic_tooltip (GcpView* self, GtkSourceMarkAttributes* attributes, GtkSourceMark* mark) {
	gchar* result = NULL;
	GtkTextIter iter = {0};
	gconstpointer _tmp0_ = NULL;
	GcpDiagnostic* _tmp1_;
	GcpDiagnostic* diagnostic;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attributes != NULL, NULL);
	g_return_val_if_fail (mark != NULL, NULL);
	_tmp0_ = g_object_get_data ((GObject*) mark, "Gcp.Document.MarkDiagnostic");
	_tmp1_ = _g_object_ref0 ((GcpDiagnostic*) _tmp0_);
	diagnostic = _tmp1_;
	if (diagnostic == NULL) {
		GtkTextBuffer* _tmp2_ = NULL;
		GtkTextIter _tmp3_ = {0};
		gint _tmp4_;
		gint line;
		GcpDocument* _tmp5_;
		GcpDiagnosticSupport* _tmp6_;
		GcpDiagnosticSupport* diag;
		gint _tmp7_;
		GcpDiagnostic** _tmp8_ = NULL;
		GcpDiagnostic** _tmp9_;
		gint _tmp9__length1;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
		gtk_text_buffer_get_iter_at_mark (_tmp2_, &_tmp3_, (GtkTextMark*) mark);
		iter = _tmp3_;
		_tmp4_ = gtk_text_iter_get_line (&iter);
		line = _tmp4_ + 1;
		_tmp5_ = self->priv->d_document;
		_tmp6_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp5_) ? ((GcpDiagnosticSupport*) _tmp5_) : NULL);
		diag = _tmp6_;
		_tmp8_ = gcp_diagnostic_support_find_at_line (diag, line, &_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _tmp7_;
		_tmp10_ = gcp_view_format_diagnostics (self, _tmp9_, _tmp7_);
		_tmp11_ = _tmp10_;
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
		result = _tmp11_;
		_g_object_unref0 (diag);
		_g_object_unref0 (diagnostic);
		return result;
	} else {
		gchar* _tmp12_ = NULL;
		_tmp12_ = gcp_diagnostic_to_markup (diagnostic, FALSE);
		result = _tmp12_;
		_g_object_unref0 (diagnostic);
		return result;
	}
	_g_object_unref0 (diagnostic);
}


static gboolean gcp_view_on_view_query_tooltip (GcpView* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gint bx = 0;
	gint by = 0;
	gint _tmp0_;
	gint _tmp1_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp2_ = {0};
	GcpSourceLocation* _tmp3_ = NULL;
	GcpSourceLocation* location;
	GcpDocument* _tmp4_;
	GcpDiagnosticSupport* _tmp5_;
	GcpDiagnosticSupport* diag;
	gint _tmp6_;
	GcpDiagnostic** _tmp7_ = NULL;
	GcpDiagnostic** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* s;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_WIDGET, x, y, &_tmp0_, &_tmp1_);
	bx = _tmp0_;
	by = _tmp1_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self->priv->d_view, &_tmp2_, bx, by);
	iter = _tmp2_;
	_tmp3_ = gcp_source_location_new_iter (&iter);
	location = _tmp3_;
	_tmp4_ = self->priv->d_document;
	_tmp5_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp4_) ? ((GcpDiagnosticSupport*) _tmp4_) : NULL);
	diag = _tmp5_;
	_tmp7_ = gcp_diagnostic_support_find_at (diag, location, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = gcp_view_format_diagnostics (self, _tmp8_, _tmp6_);
	_tmp10_ = _tmp9_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_object_unref), NULL);
	s = _tmp10_;
	if (s == NULL) {
		result = FALSE;
		_g_free0 (s);
		_g_object_unref0 (diag);
		_g_object_unref0 (location);
		return result;
	}
	gtk_tooltip_set_markup (tooltip, s);
	result = TRUE;
	_g_free0 (s);
	_g_object_unref0 (diag);
	_g_object_unref0 (location);
	return result;
}


static void _gcp_view_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated (GcpDiagnosticSupport* _sender, gpointer self) {
	gcp_view_on_diagnostic_updated (self, _sender);
}


static gchar* _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* object, gpointer self) {
	gchar* result;
	result = gcp_view_on_diagnostic_tooltip (self, _sender, object);
	return result;
}


static void _gcp_view_on_semantics_updated_gcp_semantic_value_support_semantic_values_updated (GcpSemanticValueSupport* _sender, gpointer self) {
	gcp_view_on_semantics_updated (self, _sender);
}


static void gcp_view_register_backend (GcpView* self, GcpBackend* backend) {
	GcpBackend* _tmp0_;
	GtkTextBuffer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (backend);
	_g_object_unref0 (self->priv->d_backend);
	self->priv->d_backend = _tmp0_;
	if (backend == NULL) {
		return;
	}
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
	if (_tmp1_ != NULL) {
		GtkTextBuffer* _tmp2_ = NULL;
		GtkTextBuffer* _tmp3_;
		GcpDocument* _tmp4_ = NULL;
		GcpDocument* _tmp5_;
		GcpDiagnosticSupport* _tmp6_;
		GcpDiagnosticSupport* diag;
		GcpDocument* _tmp19_;
		GcpSemanticValueSupport* _tmp20_;
		GcpSemanticValueSupport* sem;
		_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
		_tmp3_ = _tmp2_;
		_tmp4_ = gcp_backend_register (self->priv->d_backend, GEDIT_IS_DOCUMENT (_tmp3_) ? ((GeditDocument*) _tmp3_) : NULL);
		_g_object_unref0 (self->priv->d_document);
		self->priv->d_document = _tmp4_;
		_tmp5_ = self->priv->d_document;
		_tmp6_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp5_) ? ((GcpDiagnosticSupport*) _tmp5_) : NULL);
		diag = _tmp6_;
		if (diag != NULL) {
			GtkSourceMarkAttributes* attr = NULL;
			GtkSourceMarkAttributes* _tmp7_ = NULL;
			GThemedIcon* _tmp8_ = NULL;
			GThemedIcon* _tmp9_;
			const gchar* _tmp10_ = NULL;
			GtkSourceMarkAttributes* _tmp11_ = NULL;
			GThemedIcon* _tmp12_ = NULL;
			GThemedIcon* _tmp13_;
			const gchar* _tmp14_ = NULL;
			GtkSourceMarkAttributes* _tmp15_ = NULL;
			GThemedIcon* _tmp16_ = NULL;
			GThemedIcon* _tmp17_;
			const gchar* _tmp18_ = NULL;
			gcp_diagnostic_support_set_tags (diag, self->priv->d_tags);
			g_signal_connect_object (diag, "diagnostics-updated", (GCallback) _gcp_view_on_diagnostic_updated_gcp_diagnostic_support_diagnostics_updated, self, 0);
			_tmp7_ = gtk_source_mark_attributes_new ();
			_g_object_unref0 (attr);
			attr = _tmp7_;
			_tmp8_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("dialog-error-symbolic");
			_tmp9_ = _tmp8_;
			gtk_source_mark_attributes_set_gicon (attr, (GIcon*) _tmp9_);
			_g_object_unref0 (_tmp9_);
			g_signal_connect_object (attr, "query-tooltip-markup", (GCallback) _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
			_tmp10_ = gcp_document_get_error_mark_category ();
			gtk_source_view_set_mark_attributes ((GtkSourceView*) self->priv->d_view, _tmp10_, attr, 0);
			_tmp11_ = gtk_source_mark_attributes_new ();
			_g_object_unref0 (attr);
			attr = _tmp11_;
			_tmp12_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("dialog-warning-symbolic");
			_tmp13_ = _tmp12_;
			gtk_source_mark_attributes_set_gicon (attr, (GIcon*) _tmp13_);
			_g_object_unref0 (_tmp13_);
			g_signal_connect_object (attr, "query-tooltip-markup", (GCallback) _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
			_tmp14_ = gcp_document_get_warning_mark_category ();
			gtk_source_view_set_mark_attributes ((GtkSourceView*) self->priv->d_view, _tmp14_, attr, 0);
			_tmp15_ = gtk_source_mark_attributes_new ();
			_g_object_unref0 (attr);
			attr = _tmp15_;
			_tmp16_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("dialog-information-symbolic");
			_tmp17_ = _tmp16_;
			gtk_source_mark_attributes_set_gicon (attr, (GIcon*) _tmp17_);
			_g_object_unref0 (_tmp17_);
			g_signal_connect_object (attr, "query-tooltip-markup", (GCallback) _gcp_view_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
			_tmp18_ = gcp_document_get_info_mark_category ();
			gtk_source_view_set_mark_attributes ((GtkSourceView*) self->priv->d_view, _tmp18_, attr, 0);
			g_signal_connect_object ((GtkWidget*) self->priv->d_view, "query-tooltip", (GCallback) _gcp_view_on_view_query_tooltip_gtk_widget_query_tooltip, self, 0);
			gtk_source_view_set_show_line_marks ((GtkSourceView*) self->priv->d_view, TRUE);
			g_signal_connect_object (self->priv->d_buffer, "cursor-moved", (GCallback) _gcp_view_on_cursor_diagnostics_moved_gedit_document_cursor_moved, self, 0);
			_g_object_unref0 (attr);
		}
		_tmp19_ = self->priv->d_document;
		_tmp20_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp19_) ? ((GcpSemanticValueSupport*) _tmp19_) : NULL);
		sem = _tmp20_;
		if (sem != NULL) {
			g_signal_connect_object (sem, "semantic-values-updated", (GCallback) _gcp_view_on_semantics_updated_gcp_semantic_value_support_semantic_values_updated, self, 0);
			g_signal_connect_object (self->priv->d_buffer, "cursor-moved", (GCallback) _gcp_view_on_cursor_semantics_moved_gedit_document_cursor_moved, self, 0);
		}
		_g_object_unref0 (sem);
		_g_object_unref0 (diag);
	} else {
		_g_object_unref0 (self->priv->d_document);
		self->priv->d_document = NULL;
	}
}


static gboolean gcp_view_diagnostic_is_at_end (GcpView* self, GcpSourceLocation* location) {
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	gint _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = gcp_source_location_get_line (location);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self->priv->d_buffer, &_tmp1_, _tmp0_ - 1);
	iter = _tmp1_;
	_tmp2_ = gcp_source_location_get_column (location);
	gtk_text_iter_forward_chars (&iter, _tmp2_ - 1);
	_tmp3_ = gtk_text_iter_get_line (&iter);
	_tmp4_ = gcp_source_location_get_line (location);
	if (_tmp3_ != (_tmp4_ - 1)) {
		result = FALSE;
		return result;
	}
	_tmp5_ = gtk_text_iter_ends_line (&iter);
	result = _tmp5_;
	return result;
}


static void gcp_view_add_diagnostic_at_end (GcpView* self, GcpSourceLocation* location, GdkRGBA* color) {
	GtkTextIter iter = {0};
	gint _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextMark* _tmp3_;
	GtkTextMark* mark;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = gcp_source_location_get_line (location);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self->priv->d_buffer, &_tmp1_, _tmp0_ - 1);
	iter = _tmp1_;
	_tmp2_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) self->priv->d_buffer, NULL, &iter, FALSE);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	mark = _tmp3_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_diagnosticsAtEnd, mark, color);
	_g_object_unref0 (mark);
}


static void gcp_view_on_semantics_updated (GcpView* self, GcpSemanticValueSupport* semantics) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (semantics != NULL);
	gcp_view_update_references (self);
}


static void gcp_view_on_diagnostic_updated (GcpView* self, GcpDiagnosticSupport* diagnostics) {
	GcpDiagnosticColors* colors = NULL;
	GtkScrollbar* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GcpDiagnosticColors* _tmp2_ = NULL;
	GcpDiagnosticColors* mixed = NULL;
	GtkScrollbar* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GcpDiagnosticColors* _tmp5_ = NULL;
	GeeMapIterator* _tmp6_ = NULL;
	GeeMapIterator* it;
	guint _tmp10_;
	guint mid;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostics != NULL);
	gcp_scrollbar_marker_clear (self->priv->d_scrollbarMarker);
	_tmp0_ = gcp_scrollbar_marker_get_scrollbar (self->priv->d_scrollbarMarker);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = gcp_diagnostic_colors_new (_tmp1_);
	_gcp_diagnostic_colors_unref0 (colors);
	colors = _tmp2_;
	_tmp3_ = gcp_scrollbar_marker_get_scrollbar (self->priv->d_scrollbarMarker);
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	_tmp5_ = gcp_diagnostic_colors_new (_tmp4_);
	_gcp_diagnostic_colors_unref0 (mixed);
	mixed = _tmp5_;
	gcp_diagnostic_colors_mix_in_widget (mixed, (GtkWidget*) self->priv->d_view);
	_tmp6_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) self->priv->d_diagnosticsAtEnd);
	it = _tmp6_;
	while (TRUE) {
		gboolean _tmp7_;
		gpointer _tmp8_ = NULL;
		GtkTextMark* _tmp9_;
		_tmp7_ = gee_map_iterator_next (it);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = gee_map_iterator_get_key (it);
		_tmp9_ = (GtkTextMark*) _tmp8_;
		gtk_text_buffer_delete_mark ((GtkTextBuffer*) self->priv->d_buffer, _tmp9_);
		_g_object_unref0 (_tmp9_);
	}
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->d_diagnosticsAtEnd);
	_tmp10_ = gcp_scrollbar_marker_new_merge_id (self->priv->d_scrollbarMarker);
	mid = _tmp10_;
	{
		GcpSourceIndex* _tmp11_ = NULL;
		GcpSourceIndexIterator* _tmp12_ = NULL;
		GcpSourceIndexIterator* _d_it;
		_tmp11_ = gcp_diagnostic_support_get_diagnostics (diagnostics);
		_tmp12_ = gcp_source_index_iterator (_tmp11_);
		_d_it = _tmp12_;
		while (TRUE) {
			gboolean _tmp13_;
			gpointer _tmp14_ = NULL;
			GcpDiagnostic* d;
			GcpDiagnosticSeverity _tmp15_;
			GdkRGBA* _tmp16_ = NULL;
			GdkRGBA* _tmp17_;
			GdkRGBA _tmp18_;
			GdkRGBA color;
			GcpDiagnosticSeverity _tmp19_;
			GdkRGBA* _tmp20_ = NULL;
			GdkRGBA* _tmp21_;
			GdkRGBA _tmp22_;
			GdkRGBA mix;
			GcpSourceRange** _tmp23_ = NULL;
			gint _tmp24_;
			GcpSourceLocation* _tmp38_ = NULL;
			GcpSourceRange* _tmp39_ = NULL;
			GcpSourceRange* _tmp40_;
			GcpSourceLocation* _tmp41_ = NULL;
			gboolean _tmp42_;
			_tmp13_ = gcp_source_index_iterator_next (_d_it);
			if (!_tmp13_) {
				break;
			}
			_tmp14_ = gcp_source_index_iterator_get (_d_it);
			d = (GcpDiagnostic*) _tmp14_;
			_tmp15_ = gcp_diagnostic_get_severity (d);
			_tmp16_ = gcp_diagnostic_colors_get (colors, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = *_tmp17_;
			_g_free0 (_tmp17_);
			color = _tmp18_;
			_tmp19_ = gcp_diagnostic_get_severity (d);
			_tmp20_ = gcp_diagnostic_colors_get (mixed, _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = *_tmp21_;
			_g_free0 (_tmp21_);
			mix = _tmp22_;
			_tmp23_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) d, &_tmp24_);
			{
				GcpSourceRange** range_collection;
				int range_collection_length1;
				int range_it;
				range_collection = _tmp23_;
				range_collection_length1 = _tmp24_;
				for (range_it = 0; range_it < _tmp24_; range_it = range_it + 1) {
					GcpSourceRange* _tmp25_;
					GcpSourceRange* range;
					_tmp25_ = _g_object_ref0 (range_collection[range_it]);
					range = _tmp25_;
					{
						gboolean _tmp26_ = FALSE;
						GcpSourceLocation* _tmp27_ = NULL;
						gint _tmp28_;
						GcpSourceLocation* _tmp29_ = NULL;
						gint _tmp30_;
						gcp_scrollbar_marker_add_with_id (self->priv->d_scrollbarMarker, mid, range, &color);
						_tmp27_ = gcp_source_range_get_start (range);
						_tmp28_ = gcp_source_location_get_line (_tmp27_);
						_tmp29_ = gcp_source_range_get_end (range);
						_tmp30_ = gcp_source_location_get_line (_tmp29_);
						if (_tmp28_ == _tmp30_) {
							GcpSourceLocation* _tmp31_ = NULL;
							gint _tmp32_;
							GcpSourceLocation* _tmp33_ = NULL;
							gint _tmp34_;
							_tmp31_ = gcp_source_range_get_start (range);
							_tmp32_ = gcp_source_location_get_column (_tmp31_);
							_tmp33_ = gcp_source_range_get_end (range);
							_tmp34_ = gcp_source_location_get_column (_tmp33_);
							_tmp26_ = _tmp32_ == _tmp34_;
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							GcpSourceLocation* _tmp35_ = NULL;
							gboolean _tmp36_;
							_tmp35_ = gcp_source_range_get_start (range);
							_tmp36_ = gcp_view_diagnostic_is_at_end (self, _tmp35_);
							if (_tmp36_) {
								GcpSourceLocation* _tmp37_ = NULL;
								_tmp37_ = gcp_source_range_get_start (range);
								gcp_view_add_diagnostic_at_end (self, _tmp37_, &mix);
							}
						}
						_g_object_unref0 (range);
					}
				}
				range_collection = (_vala_array_free (range_collection, range_collection_length1, (GDestroyNotify) g_object_unref), NULL);
			}
			_tmp38_ = gcp_diagnostic_get_location (d);
			_tmp39_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp38_);
			_tmp40_ = _tmp39_;
			gcp_scrollbar_marker_add_with_id (self->priv->d_scrollbarMarker, mid, _tmp40_, &color);
			_g_object_unref0 (_tmp40_);
			_tmp41_ = gcp_diagnostic_get_location (d);
			_tmp42_ = gcp_view_diagnostic_is_at_end (self, _tmp41_);
			if (_tmp42_) {
				GcpSourceLocation* _tmp43_ = NULL;
				_tmp43_ = gcp_diagnostic_get_location (d);
				gcp_view_add_diagnostic_at_end (self, _tmp43_, &mix);
			}
			_g_object_unref0 (d);
		}
		_g_object_unref0 (_d_it);
	}
	gcp_view_update_diagnostic_message (self);
	_g_object_unref0 (it);
	_gcp_diagnostic_colors_unref0 (mixed);
	_gcp_diagnostic_colors_unref0 (colors);
}


static void gcp_view_on_notify_buffer (GcpView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_;
	g_return_if_fail (self != NULL);
	gcp_view_disconnect_buffer (self);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
	_tmp1_ = _tmp0_;
	gcp_view_connect_buffer (self, GEDIT_IS_DOCUMENT (_tmp1_) ? ((GeditDocument*) _tmp1_) : NULL);
}


static void gcp_view_on_notify_language (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_backend (self);
}


static gboolean gcp_view_on_view_draw (GcpView* self, cairo_t* ctx) {
	gboolean result = FALSE;
	gint _tmp0_;
	GdkWindow* _tmp1_ = NULL;
	GdkWindow* _tmp2_;
	GdkWindow* window;
	gboolean _tmp3_;
	GeeMapIterator* _tmp4_ = NULL;
	GeeMapIterator* it;
	GdkRectangle rect = {0};
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GdkRectangle _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	gint _tmp8_;
	gint window_width;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = gee_map_get_size ((GeeMap*) self->priv->d_diagnosticsAtEnd);
	if (_tmp0_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_text_view_get_window ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	window = _tmp2_;
	_tmp3_ = gtk_cairo_should_draw_window (ctx, window);
	if (!_tmp3_) {
		result = FALSE;
		_g_object_unref0 (window);
		return result;
	}
	_tmp4_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) self->priv->d_diagnosticsAtEnd);
	it = _tmp4_;
	gtk_cairo_transform_to_window (ctx, (GtkWidget*) self->priv->d_view, window);
	gtk_text_view_get_visible_rect ((GtkTextView*) self->priv->d_view, &_tmp5_);
	rect = _tmp5_;
	gtk_text_view_get_line_at_y ((GtkTextView*) self->priv->d_view, &_tmp6_, rect.y, NULL);
	start = _tmp6_;
	gtk_text_iter_backward_line (&start);
	gtk_text_view_get_line_at_y ((GtkTextView*) self->priv->d_view, &_tmp7_, rect.y + rect.height, NULL);
	end = _tmp7_;
	gtk_text_iter_forward_line (&end);
	_tmp8_ = gdk_window_get_width (window);
	window_width = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_;
		GtkTextIter iter = {0};
		GtkTextBuffer* _tmp10_ = NULL;
		gpointer _tmp11_ = NULL;
		GtkTextMark* _tmp12_;
		GtkTextIter _tmp13_ = {0};
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_;
		gint y = 0;
		gint height = 0;
		gint wy = 0;
		gint wx = 0;
		GdkRectangle irect = {0};
		gint _tmp19_;
		gint _tmp20_;
		GdkRectangle _tmp21_ = {0};
		gint _tmp22_;
		gint _tmp23_;
		gpointer _tmp24_ = NULL;
		GdkRGBA* _tmp25_;
		_tmp9_ = gee_map_iterator_next (it);
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
		_tmp11_ = gee_map_iterator_get_key (it);
		_tmp12_ = (GtkTextMark*) _tmp11_;
		gtk_text_buffer_get_iter_at_mark (_tmp10_, &_tmp13_, _tmp12_);
		iter = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_tmp15_ = gtk_text_iter_in_range (&iter, &start, &end);
		if (!_tmp15_) {
			gboolean _tmp16_;
			_tmp16_ = gtk_text_iter_equal (&iter, &end);
			_tmp14_ = !_tmp16_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			continue;
		}
		_tmp17_ = gtk_text_iter_ends_line (&iter);
		if (!_tmp17_) {
			gboolean _tmp18_;
			_tmp18_ = gtk_text_iter_forward_visible_line (&iter);
			if (_tmp18_) {
				gtk_text_iter_backward_char (&iter);
			}
		}
		gtk_text_view_get_line_yrange ((GtkTextView*) self->priv->d_view, &iter, &_tmp19_, &_tmp20_);
		y = _tmp19_;
		height = _tmp20_;
		gtk_text_view_get_iter_location ((GtkTextView*) self->priv->d_view, &iter, &_tmp21_);
		irect = _tmp21_;
		gtk_text_view_buffer_to_window_coords ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT, irect.x + irect.width, y, &_tmp22_, &_tmp23_);
		wx = _tmp22_;
		wy = _tmp23_;
		cairo_rectangle (ctx, (gdouble) wx, (gdouble) wy, (gdouble) (window_width - wx), (gdouble) height);
		_tmp24_ = gee_map_iterator_get_value (it);
		_tmp25_ = (GdkRGBA*) _tmp24_;
		gdk_cairo_set_source_rgba (ctx, _tmp25_);
		_g_free0 (_tmp25_);
		cairo_fill (ctx);
	}
	result = FALSE;
	_g_object_unref0 (it);
	_g_object_unref0 (window);
	return result;
}


static void gcp_view_on_buffer_mark_set (GcpView* self, GtkTextIter* location, GtkTextMark* mark) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mark != NULL);
	_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_diagnosticsAtEnd, mark);
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = gtk_text_iter_starts_line (location);
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_text_iter_set_line_offset (location, 0);
		gtk_text_buffer_move_mark ((GtkTextBuffer*) self->priv->d_buffer, mark, location);
	}
}


static gboolean gcp_view_same_diagnostics (GcpView* self, GcpDiagnostic** first, int first_length1, GcpDiagnostic** second, int second_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (first == second) {
		result = TRUE;
		return result;
	}
	if (first == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = second == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (first_length1 != second_length1) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < first_length1)) {
					break;
				}
				if (first[i] != second[i]) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void _lambda11_ (GcpView* self) {
	_g_object_unref0 (self->priv->d_cursorDiagnosticMessage);
	self->priv->d_cursorDiagnosticMessage = NULL;
}


static void __lambda11__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	_lambda11_ (self);
}


static GcpDiagnostic** _vala_array_dup1 (GcpDiagnostic** self, int length) {
	GcpDiagnostic** result;
	int i;
	result = g_new0 (GcpDiagnostic*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


static void gcp_view_update_diagnostic_message (GcpView* self) {
	GcpDocument* _tmp0_;
	GcpDiagnosticSupport* _tmp1_;
	GcpDiagnosticSupport* diag;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GcpSourceLocation* _tmp4_ = NULL;
	GcpSourceLocation* location;
	gint _tmp5_;
	GcpDiagnostic** _tmp6_ = NULL;
	GcpDiagnostic** diagnostics;
	gint diagnostics_length1;
	gint _diagnostics_size_;
	gboolean _tmp7_;
	GcpDiagnosticMessage* _tmp8_ = NULL;
	GcpDiagnostic** _tmp9_;
	GcpDiagnostic** _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_DIAGNOSTIC_SUPPORT (_tmp0_) ? ((GcpDiagnosticSupport*) _tmp0_) : NULL);
	diag = _tmp1_;
	if (diag == NULL) {
		_g_object_unref0 (diag);
		return;
	}
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self->priv->d_buffer);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->d_buffer, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	_tmp4_ = gcp_source_location_new_iter (&iter);
	location = _tmp4_;
	_tmp6_ = gcp_diagnostic_support_find_at (diag, location, &_tmp5_);
	diagnostics = _tmp6_;
	diagnostics_length1 = _tmp5_;
	_diagnostics_size_ = _tmp5_;
	_tmp7_ = gcp_view_same_diagnostics (self, diagnostics, diagnostics_length1, self->priv->d_cursorDiagnostics, self->priv->d_cursorDiagnostics_length1);
	if (_tmp7_) {
		diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (location);
		_g_object_unref0 (diag);
		return;
	}
	if (self->priv->d_cursorDiagnosticMessage != NULL) {
		gtk_widget_destroy ((GtkWidget*) self->priv->d_cursorDiagnosticMessage);
	}
	_tmp8_ = gcp_diagnostic_message_new ((GtkSourceView*) self->priv->d_view, diagnostics, diagnostics_length1);
	_g_object_unref0 (self->priv->d_cursorDiagnosticMessage);
	self->priv->d_cursorDiagnosticMessage = g_object_ref_sink (_tmp8_);
	g_signal_connect_object ((GtkWidget*) self->priv->d_cursorDiagnosticMessage, "destroy", (GCallback) __lambda11__gtk_widget_destroy, self, 0);
	gtk_widget_show ((GtkWidget*) self->priv->d_cursorDiagnosticMessage);
	_tmp9_ = (_tmp10_ = diagnostics, (_tmp10_ == NULL) ? ((gpointer) _tmp10_) : _vala_array_dup1 (_tmp10_, diagnostics_length1));
	self->priv->d_cursorDiagnostics = (_vala_array_free (self->priv->d_cursorDiagnostics, self->priv->d_cursorDiagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_cursorDiagnostics = _tmp9_;
	self->priv->d_cursorDiagnostics_length1 = diagnostics_length1;
	self->priv->_d_cursorDiagnostics_size_ = diagnostics_length1;
	diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (location);
	_g_object_unref0 (diag);
}


static GcpSourceRange* gcp_view_highlight_range (GcpView* self, GcpSemanticValue* val) {
	GcpSourceRange* result = NULL;
	GcpSourceRange* _tmp0_ = NULL;
	GcpSourceRange* range;
	gboolean _tmp1_ = FALSE;
	GcpSemanticValueKind _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) val);
	range = _tmp0_;
	_tmp2_ = gcp_semantic_value_get_kind (val);
	if (_tmp2_ == GCP_SEMANTIC_VALUE_KIND_FUNCTION) {
		GcpSemanticValueReferenceType _tmp3_;
		_tmp3_ = gcp_semantic_value_get_reference_type (val);
		_tmp1_ = (_tmp3_ & GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DEFINITION) != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GcpSemanticValue* _tmp4_ = NULL;
		GcpSourceRange* _tmp5_ = NULL;
		GcpSourceRange* _tmp6_;
		GcpSourceLocation* _tmp7_ = NULL;
		GcpSourceLocation* _tmp8_ = NULL;
		GcpSourceLocation* _tmp9_;
		GcpSourceLocation* paramstart;
		GFile* _tmp10_ = NULL;
		gint _tmp11_;
		gint _tmp12_;
		GcpSourceLocation* _tmp13_ = NULL;
		GcpSourceRange* _tmp14_ = NULL;
		GcpSourceRange* _tmp15_;
		GcpSourceLocation* _tmp16_ = NULL;
		GcpSourceLocation* _tmp17_ = NULL;
		GcpSourceLocation* _tmp18_;
		GcpSourceRange* _tmp19_ = NULL;
		_tmp4_ = gcp_semantic_value_get_down (val);
		_tmp5_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gcp_source_range_get_start (_tmp6_);
		_tmp8_ = gcp_source_location_copy (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp6_);
		paramstart = _tmp9_;
		_tmp10_ = gcp_source_location_get_file (paramstart);
		_tmp11_ = gcp_source_location_get_line (paramstart);
		_tmp12_ = gcp_source_location_get_column (paramstart);
		_tmp13_ = gcp_source_location_new (_tmp10_, _tmp11_, _tmp12_ - 1);
		_g_object_unref0 (paramstart);
		paramstart = _tmp13_;
		_tmp14_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) val);
		_tmp15_ = _tmp14_;
		_tmp16_ = gcp_source_range_get_start (_tmp15_);
		_tmp17_ = gcp_source_location_copy (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gcp_source_range_new (_tmp18_, paramstart);
		_g_object_unref0 (range);
		range = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (paramstart);
	}
	result = range;
	return result;
}


static void gcp_view_mark_reference (GcpView* self, GcpSemanticValue* val) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GcpSourceRange* _tmp0_ = NULL;
	GcpSourceRange* range;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = gcp_view_highlight_range (self, val);
	range = _tmp0_;
	_tmp3_ = gcp_document_source_range (self->priv->d_document, range, &_tmp1_, &_tmp2_);
	start = _tmp1_;
	end = _tmp2_;
	if (_tmp3_) {
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self->priv->d_buffer, self->priv->d_semanticTag, &start, &end);
	}
	gcp_scrollbar_marker_add_with_id (self->priv->d_scrollbarMarker, self->priv->d_lastMergeId, range, &self->priv->d_refColor);
	_g_object_unref0 (range);
}


static void gcp_view_mark_references (GcpView* self, GcpSemanticValue** refs, int refs_length1) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (refs_length1 <= 1) {
		return;
	}
	_tmp0_ = gcp_scrollbar_marker_new_merge_id (self->priv->d_scrollbarMarker);
	self->priv->d_lastMergeId = _tmp0_;
	{
		GcpSemanticValue** r_collection;
		int r_collection_length1;
		int r_it;
		r_collection = refs;
		r_collection_length1 = refs_length1;
		for (r_it = 0; r_it < refs_length1; r_it = r_it + 1) {
			GcpSemanticValue* _tmp1_;
			GcpSemanticValue* r;
			_tmp1_ = _g_object_ref0 (r_collection[r_it]);
			r = _tmp1_;
			{
				gcp_view_mark_reference (self, r);
				_g_object_unref0 (r);
			}
		}
	}
}


static void gcp_view_remove_references (GcpView* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	if (self->priv->d_lastMergeId != 0) {
		gcp_scrollbar_marker_remove (self->priv->d_scrollbarMarker, self->priv->d_lastMergeId);
		self->priv->d_lastMergeId = (guint) 0;
	}
	if (self->priv->d_semanticTag == NULL) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->priv->d_buffer, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self->priv->d_buffer, self->priv->d_semanticTag, &start, &end);
}


static GcpSemanticValue* gcp_view_semantic_value_at_cursor (GcpView* self) {
	GcpSemanticValue* result = NULL;
	GcpDocument* _tmp0_;
	GcpSemanticValueSupport* _tmp1_;
	GcpSemanticValueSupport* sem;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GcpSourceLocation* _tmp4_ = NULL;
	GcpSourceLocation* loc;
	GcpSourceIndex* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp0_) ? ((GcpSemanticValueSupport*) _tmp0_) : NULL);
	sem = _tmp1_;
	if (sem == NULL) {
		result = NULL;
		_g_object_unref0 (sem);
		return result;
	}
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self->priv->d_buffer);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self->priv->d_buffer, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	_tmp4_ = gcp_source_location_new_iter (&iter);
	loc = _tmp4_;
	_tmp5_ = gcp_semantic_value_support_get_semantics (sem);
	_tmp6_ = gcp_source_index_find_inner_at (_tmp5_, loc);
	result = (GcpSemanticValue*) _tmp6_;
	_g_object_unref0 (loc);
	_g_object_unref0 (sem);
	return result;
}


static GcpSemanticValue** gcp_view_references_at_cursor (GcpView* self, GcpSemanticValue** val, gint* vidx, int* result_length1) {
	GcpSemanticValue* _val = NULL;
	gint _vidx = 0;
	GcpSemanticValue** result = NULL;
	GcpSemanticValue* _tmp0_ = NULL;
	GeeLinkedList* _tmp3_ = NULL;
	GeeLinkedList* refs;
	gint _tmp16_;
	gpointer* _tmp17_ = NULL;
	GcpSemanticValue** ret;
	gint ret_length1;
	gint _ret_size_;
	GcpSemanticValue** _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_vidx = -1;
	_tmp0_ = gcp_view_semantic_value_at_cursor (self);
	_g_object_unref0 (_val);
	_val = _tmp0_;
	if (_val == NULL) {
		GcpSemanticValue** _tmp1_ = NULL;
		GcpSemanticValue** _tmp2_;
		_tmp1_ = g_new0 (GcpSemanticValue*, 0 + 1);
		_tmp2_ = _tmp1_;
		*result_length1 = 0;
		result = _tmp2_;
		if (val) {
			*val = _val;
		} else {
			_g_object_unref0 (_val);
		}
		if (vidx) {
			*vidx = _vidx;
		}
		return result;
	}
	_tmp3_ = gee_linked_list_new (GCP_TYPE_SEMANTIC_VALUE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	refs = _tmp3_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				GcpSemanticValue* _tmp6_ = NULL;
				GcpSemanticValue* r;
				GcpSourceRange* _tmp7_ = NULL;
				GcpSourceRange* _tmp8_;
				GcpSourceLocation* _tmp9_ = NULL;
				GFile* _tmp10_ = NULL;
				GFile* _tmp11_;
				GFile* _tmp12_;
				GFile* f;
				gboolean _tmp13_ = FALSE;
				if (!_tmp4_) {
					i = i + 1;
				}
				_tmp4_ = FALSE;
				_tmp5_ = gcp_semantic_value_get_num_references (_val);
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = gcp_semantic_value_reference (_val, i);
				r = _tmp6_;
				_tmp7_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) r);
				_tmp8_ = _tmp7_;
				_tmp9_ = gcp_source_range_get_start (_tmp8_);
				_tmp10_ = gcp_source_location_get_file (_tmp9_);
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (_tmp8_);
				f = _tmp12_;
				if (f != NULL) {
					GFile* _tmp14_ = NULL;
					gboolean _tmp15_;
					_tmp14_ = gcp_document_get_location (self->priv->d_document);
					_tmp15_ = g_file_equal (f, _tmp14_);
					_tmp13_ = _tmp15_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gee_abstract_collection_add ((GeeAbstractCollection*) refs, r);
				}
				_g_object_unref0 (f);
				_g_object_unref0 (r);
			}
		}
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) refs, _val);
	gee_list_sort ((GeeList*) refs, (GCompareFunc) gcp_view_compare_ranges);
	_tmp17_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) refs, &_tmp16_);
	ret = _tmp17_;
	ret_length1 = _tmp16_;
	_ret_size_ = _tmp16_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				if (!_tmp18_) {
					i = i + 1;
				}
				_tmp18_ = FALSE;
				if (!(i < ret_length1)) {
					break;
				}
				if (ret[i] == _val) {
					_vidx = i;
					break;
				}
			}
		}
	}
	_tmp19_ = ret;
	*result_length1 = ret_length1;
	result = _tmp19_;
	_g_object_unref0 (refs);
	if (val) {
		*val = _val;
	} else {
		_g_object_unref0 (_val);
	}
	if (vidx) {
		*vidx = _vidx;
	}
	return result;
}


static gint gcp_view_compare_ranges (GcpSemanticValue* a, GcpSemanticValue* b) {
	gint result = 0;
	GcpSourceRange* _tmp0_ = NULL;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* _tmp2_ = NULL;
	GcpSourceRange* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) b);
	_tmp3_ = _tmp2_;
	_tmp4_ = gcp_source_range_compare_to (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static void gcp_view_update_references (GcpView* self) {
	GcpDocument* _tmp0_;
	GcpSemanticValueSupport* _tmp1_;
	GcpSemanticValueSupport* sem;
	GcpSemanticValue* v = NULL;
	gint vidx = 0;
	GcpSemanticValue* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	GcpSemanticValue** _tmp5_ = NULL;
	GcpSemanticValue** refs;
	gint refs_length1;
	gint _refs_size_;
	GcpSemanticValue* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp0_) ? ((GcpSemanticValueSupport*) _tmp0_) : NULL);
	sem = _tmp1_;
	if (sem == NULL) {
		_g_object_unref0 (sem);
		return;
	}
	_tmp5_ = gcp_view_references_at_cursor (self, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_object_unref0 (v);
	v = _tmp2_;
	vidx = _tmp3_;
	refs = _tmp5_;
	refs_length1 = _tmp4_;
	_refs_size_ = _tmp4_;
	if (v == self->priv->d_semanticValue) {
		refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (v);
		_g_object_unref0 (sem);
		return;
	}
	if (self->priv->d_semanticValue != NULL) {
		gcp_view_remove_references (self);
	}
	_tmp6_ = _g_object_ref0 (v);
	_g_object_unref0 (self->priv->d_semanticValue);
	self->priv->d_semanticValue = _tmp6_;
	if (self->priv->d_semanticValue != NULL) {
		gcp_view_mark_references (self, refs, refs_length1);
	}
	refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (v);
	_g_object_unref0 (sem);
}


static void gcp_view_on_cursor_diagnostics_moved (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_diagnostic_message (self);
}


static void gcp_view_on_cursor_semantics_moved (GcpView* self) {
	g_return_if_fail (self != NULL);
	gcp_view_update_references (self);
}


static gboolean gcp_view_on_view_key_press (GcpView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (gcp_view_s_bindingSet == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gtk_binding_set_activate (gcp_view_s_bindingSet, (*event).keyval, (*event).state, (GObject*) self);
	result = _tmp0_;
	return result;
}


static gboolean gcp_view_real_find_definition (GcpView* self) {
	gboolean result = FALSE;
	GcpSemanticValue* _tmp0_ = NULL;
	GcpSemanticValue* v;
	GcpSemanticValueReferenceType _tmp1_;
	GcpSemanticValue* _tmp2_ = NULL;
	GcpSemanticValue* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gcp_view_semantic_value_at_cursor (self);
	v = _tmp0_;
	if (v == NULL) {
		result = FALSE;
		_g_object_unref0 (v);
		return result;
	}
	_tmp1_ = gcp_semantic_value_get_reference_type (v);
	if ((_tmp1_ & GCP_SEMANTIC_VALUE_REFERENCE_TYPE_DEFINITION) != 0) {
		result = TRUE;
		_g_object_unref0 (v);
		return result;
	}
	_tmp2_ = gcp_semantic_value_get_definition (v);
	_tmp3_ = _tmp2_;
	gcp_view_move_cursor_to_semantic_value (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	result = TRUE;
	_g_object_unref0 (v);
	return result;
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static gboolean gcp_view_real_find_reference (GcpView* self, gint direction) {
	gboolean result = FALSE;
	GcpDocument* _tmp0_;
	GcpSemanticValueSupport* _tmp1_;
	GcpSemanticValueSupport* sem;
	GcpSemanticValue* v = NULL;
	gint vidx = 0;
	GcpSemanticValue* _tmp2_ = NULL;
	gint _tmp3_;
	gint _tmp4_;
	GcpSemanticValue** _tmp5_ = NULL;
	GcpSemanticValue** refs;
	gint refs_length1;
	gint _refs_size_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->d_document;
	_tmp1_ = _g_object_ref0 (GCP_IS_SEMANTIC_VALUE_SUPPORT (_tmp0_) ? ((GcpSemanticValueSupport*) _tmp0_) : NULL);
	sem = _tmp1_;
	if (sem == NULL) {
		result = FALSE;
		_g_object_unref0 (sem);
		return result;
	}
	_tmp5_ = gcp_view_references_at_cursor (self, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_object_unref0 (v);
	v = _tmp2_;
	vidx = _tmp3_;
	refs = _tmp5_;
	refs_length1 = _tmp4_;
	_refs_size_ = _tmp4_;
	if (v == NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = refs_length1 <= 1;
	}
	if (_tmp6_) {
		result = TRUE;
		refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (v);
		_g_object_unref0 (sem);
		return result;
	}
	vidx = (vidx + direction) % refs_length1;
	if (vidx < 0) {
		vidx = refs_length1 + vidx;
	}
	gcp_view_move_cursor_to_semantic_value (self, refs[vidx]);
	result = TRUE;
	refs = (_vala_array_free (refs, refs_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (v);
	_g_object_unref0 (sem);
	return result;
}


static void g_cclosure_user_marshal_BOOLEAN__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void gcp_view_class_init (GcpViewClass * klass) {
	GtkBindingSet* _tmp0_ = NULL;
	gcp_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpViewPrivate));
	GCP_VIEW_CLASS (klass)->find_definition = gcp_view_real_find_definition;
	GCP_VIEW_CLASS (klass)->find_reference = gcp_view_real_find_reference;
	G_OBJECT_CLASS (klass)->finalize = gcp_view_finalize;
	g_signal_new ("find_definition", GCP_TYPE_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GcpViewClass, find_definition), NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("find_reference", GCP_TYPE_VIEW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GcpViewClass, find_reference), NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT, G_TYPE_BOOLEAN, 1, G_TYPE_INT);
	_tmp0_ = gtk_binding_set_find ("GcpViewBindings");
	gcp_view_s_bindingSet = _tmp0_;
}


static void gcp_view_instance_init (GcpView * self) {
	self->priv = GCP_VIEW_GET_PRIVATE (self);
}


static void gcp_view_finalize (GObject* obj) {
	GcpView * self;
	self = GCP_VIEW (obj);
	_g_object_unref0 (self->priv->d_buffer);
	_g_object_unref0 (self->priv->d_backend);
	_g_object_unref0 (self->priv->d_document);
	_gcp_diagnostic_tags_unref0 (self->priv->d_tags);
	_gcp_scrollbar_marker_unref0 (self->priv->d_scrollbarMarker);
	_g_object_unref0 (self->priv->d_diagnosticsAtEnd);
	self->priv->d_cursorDiagnostics = (_vala_array_free (self->priv->d_cursorDiagnostics, self->priv->d_cursorDiagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_cursorDiagnosticMessage);
	_g_object_unref0 (self->priv->d_semanticValue);
	_g_object_unref0 (self->priv->d_semanticTag);
	G_OBJECT_CLASS (gcp_view_parent_class)->finalize (obj);
}


GType gcp_view_get_type (void) {
	return gcp_view_type_id;
}


GType gcp_view_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpView), 0, (GInstanceInitFunc) gcp_view_instance_init, NULL };
	gcp_view_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpView", &g_define_type_info, 0);
	return gcp_view_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



