/* gcp-source-range.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-source-range.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;
typedef struct _GcpSourceRangePrivate GcpSourceRangePrivate;

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

struct _GcpSourceRange {
	GObject parent_instance;
	GcpSourceRangePrivate * priv;
};

struct _GcpSourceRangeClass {
	GObjectClass parent_class;
};

struct _GcpSourceRangePrivate {
	GcpSourceLocation* d_start;
	GcpSourceLocation* d_end;
};


static gpointer gcp_source_range_parent_class = NULL;
static GcpSourceRangeSupportIface* gcp_source_range_gcp_source_range_support_parent_iface = NULL;
static GType gcp_source_range_type_id = 0;

GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
#define GCP_SOURCE_RANGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_SOURCE_RANGE, GcpSourceRangePrivate))
enum  {
	GCP_SOURCE_RANGE_DUMMY_PROPERTY,
	GCP_SOURCE_RANGE_RANGE,
	GCP_SOURCE_RANGE_START,
	GCP_SOURCE_RANGE_END
};
GcpSourceRange* gcp_source_range_new (GcpSourceLocation* start, GcpSourceLocation* end);
GcpSourceRange* gcp_source_range_construct (GType object_type, GcpSourceLocation* start, GcpSourceLocation* end);
gint gcp_source_range_compare_to (GcpSourceRange* self, GcpSourceRange* other);
gint gcp_source_location_compare_to (GcpSourceLocation* self, GcpSourceLocation* other);
gboolean gcp_source_range_contains_range (GcpSourceRange* self, GcpSourceRange* range);
gboolean gcp_source_range_contains_location (GcpSourceRange* self, GcpSourceLocation* location);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
gboolean gcp_source_range_contains (GcpSourceRange* self, gint line, gint column);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gint gcp_source_location_get_column (GcpSourceLocation* self);
gboolean gcp_source_range_contains_line (GcpSourceRange* self, gint line);
gchar* gcp_source_range_to_string (GcpSourceRange* self);
gchar* gcp_source_location_to_string (GcpSourceLocation* self);
static void gcp_source_range_finalize (GObject* obj);
GcpSourceRange* gcp_source_range_support_get_range (GcpSourceRangeSupport* self);
static void _vala_gcp_source_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GcpSourceRange* gcp_source_range_construct (GType object_type, GcpSourceLocation* start, GcpSourceLocation* end) {
	GcpSourceRange * self = NULL;
	GcpSourceLocation* _tmp0_;
	GcpSourceLocation* _tmp1_;
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (end != NULL, NULL);
	self = (GcpSourceRange*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (start);
	_g_object_unref0 (self->priv->d_start);
	self->priv->d_start = _tmp0_;
	_tmp1_ = _g_object_ref0 (end);
	_g_object_unref0 (self->priv->d_end);
	self->priv->d_end = _tmp1_;
	return self;
}


GcpSourceRange* gcp_source_range_new (GcpSourceLocation* start, GcpSourceLocation* end) {
	return gcp_source_range_construct (GCP_TYPE_SOURCE_RANGE, start, end);
}


gint gcp_source_range_compare_to (GcpSourceRange* self, GcpSourceRange* other) {
	gint result = 0;
	gint _tmp0_;
	gint st;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = gcp_source_location_compare_to (self->priv->d_start, other->priv->d_start);
	st = _tmp0_;
	if (st != 0) {
		result = st;
		return result;
	}
	_tmp1_ = gcp_source_location_compare_to (other->priv->d_end, self->priv->d_end);
	result = _tmp1_;
	return result;
}


gboolean gcp_source_range_contains_range (GcpSourceRange* self, GcpSourceRange* range) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GcpSourceLocation* _tmp1_ = NULL;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (range != NULL, FALSE);
	_tmp1_ = gcp_source_range_get_start (range);
	_tmp2_ = gcp_source_range_contains_location (self, _tmp1_);
	if (_tmp2_) {
		GcpSourceLocation* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp3_ = gcp_source_range_get_end (range);
		_tmp4_ = gcp_source_range_contains_location (self, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean gcp_source_range_contains_location (GcpSourceRange* self, GcpSourceLocation* location) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = gcp_source_location_get_line (location);
	_tmp1_ = gcp_source_location_get_column (location);
	_tmp2_ = gcp_source_range_contains (self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gboolean gcp_source_range_contains (GcpSourceRange* self, gint line, gint column) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = gcp_source_location_get_line (self->priv->d_start);
	if (_tmp2_ < line) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		_tmp4_ = gcp_source_location_get_line (self->priv->d_start);
		if (_tmp4_ == line) {
			gint _tmp5_;
			_tmp5_ = gcp_source_location_get_column (self->priv->d_start);
			_tmp3_ = _tmp5_ <= column;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		_tmp7_ = gcp_source_location_get_line (self->priv->d_end);
		if (_tmp7_ > line) {
			_tmp6_ = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			gint _tmp9_;
			_tmp9_ = gcp_source_location_get_line (self->priv->d_end);
			if (_tmp9_ == line) {
				gint _tmp10_;
				_tmp10_ = gcp_source_location_get_column (self->priv->d_end);
				_tmp8_ = _tmp10_ >= column;
			} else {
				_tmp8_ = FALSE;
			}
			_tmp6_ = _tmp8_;
		}
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean gcp_source_range_contains_line (GcpSourceRange* self, gint line) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gcp_source_location_get_line (self->priv->d_start);
	if (_tmp1_ <= line) {
		gint _tmp2_;
		_tmp2_ = gcp_source_location_get_line (self->priv->d_end);
		_tmp0_ = _tmp2_ >= line;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gchar* gcp_source_range_to_string (GcpSourceRange* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gcp_source_location_get_line (self->priv->d_start);
	_tmp2_ = gcp_source_location_get_line (self->priv->d_end);
	if (_tmp1_ == _tmp2_) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gcp_source_location_get_column (self->priv->d_end);
		_tmp4_ = gcp_source_location_get_column (self->priv->d_start);
		_tmp0_ = (_tmp3_ - _tmp4_) <= 1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = gcp_source_location_to_string (self->priv->d_start);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = gcp_source_location_to_string (self->priv->d_start);
	_tmp7_ = _tmp6_;
	_tmp8_ = gcp_source_location_to_string (self->priv->d_end);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("%s-%s", _tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = _tmp11_;
	return result;
}


static GcpSourceRange* gcp_source_range_real_get_range (GcpSourceRangeSupport* base) {
	GcpSourceRange* result;
	GcpSourceRange* self;
	GcpSourceRange* _tmp0_;
	self = (GcpSourceRange*) base;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}


static GcpSourceRange** gcp_source_range_real_get_ranges (GcpSourceRangeSupport* base, int* result_length1) {
	GcpSourceRange** result;
	GcpSourceRange* self;
	GcpSourceRange* _tmp0_;
	GcpSourceRange** _tmp1_ = NULL;
	GcpSourceRange** _tmp2_;
	self = (GcpSourceRange*) base;
	_tmp0_ = _g_object_ref0 (self);
	_tmp1_ = g_new0 (GcpSourceRange*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	*result_length1 = 1;
	result = _tmp2_;
	return result;
}


GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self) {
	GcpSourceLocation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_start;
	return result;
}


GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self) {
	GcpSourceLocation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_end;
	return result;
}


static void gcp_source_range_class_init (GcpSourceRangeClass * klass) {
	gcp_source_range_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpSourceRangePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_source_range_get_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_source_range_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_SOURCE_RANGE_RANGE, "range");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_RANGE_START, g_param_spec_object ("start", "start", "start", GCP_TYPE_SOURCE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_RANGE_END, g_param_spec_object ("end", "end", "end", GCP_TYPE_SOURCE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gcp_source_range_gcp_source_range_support_interface_init (GcpSourceRangeSupportIface * iface) {
	gcp_source_range_gcp_source_range_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_range = gcp_source_range_real_get_range;
	iface->get_ranges = gcp_source_range_real_get_ranges;
}


static void gcp_source_range_instance_init (GcpSourceRange * self) {
	self->priv = GCP_SOURCE_RANGE_GET_PRIVATE (self);
}


static void gcp_source_range_finalize (GObject* obj) {
	GcpSourceRange * self;
	self = GCP_SOURCE_RANGE (obj);
	_g_object_unref0 (self->priv->d_start);
	_g_object_unref0 (self->priv->d_end);
	G_OBJECT_CLASS (gcp_source_range_parent_class)->finalize (obj);
}


GType gcp_source_range_get_type (void) {
	return gcp_source_range_type_id;
}


GType gcp_source_range_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpSourceRangeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_source_range_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpSourceRange), 0, (GInstanceInitFunc) gcp_source_range_instance_init, NULL };
	static const GInterfaceInfo gcp_source_range_support_info = { (GInterfaceInitFunc) gcp_source_range_gcp_source_range_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gcp_source_range_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpSourceRange", &g_define_type_info, 0);
	g_type_module_add_interface (module, gcp_source_range_type_id, GCP_TYPE_SOURCE_RANGE_SUPPORT, &gcp_source_range_support_info);
	return gcp_source_range_type_id;
}


static void _vala_gcp_source_range_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpSourceRange * self;
	self = GCP_SOURCE_RANGE (object);
	switch (property_id) {
		case GCP_SOURCE_RANGE_RANGE:
		g_value_take_object (value, gcp_source_range_support_get_range ((GcpSourceRangeSupport*) self));
		break;
		case GCP_SOURCE_RANGE_START:
		g_value_set_object (value, gcp_source_range_get_start (self));
		break;
		case GCP_SOURCE_RANGE_END:
		g_value_set_object (value, gcp_source_range_get_end (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



