/* gcp-source-location.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-source-location.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>


#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;
typedef struct _GcpSourceLocationPrivate GcpSourceLocationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

struct _GcpSourceLocation {
	GObject parent_instance;
	GcpSourceLocationPrivate * priv;
};

struct _GcpSourceLocationClass {
	GObjectClass parent_class;
};

struct _GcpSourceLocationPrivate {
	GFile* d_file;
	gint d_line;
	gint d_column;
};


static gpointer gcp_source_location_parent_class = NULL;
static GcpSourceRangeSupportIface* gcp_source_location_gcp_source_range_support_parent_iface = NULL;
static GType gcp_source_location_type_id = 0;

GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
#define GCP_SOURCE_LOCATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationPrivate))
enum  {
	GCP_SOURCE_LOCATION_DUMMY_PROPERTY,
	GCP_SOURCE_LOCATION_FILE,
	GCP_SOURCE_LOCATION_LINE,
	GCP_SOURCE_LOCATION_COLUMN,
	GCP_SOURCE_LOCATION_RANGE
};
GcpSourceLocation* gcp_source_location_new (GFile* file, gint line, gint column);
GcpSourceLocation* gcp_source_location_construct (GType object_type, GFile* file, gint line, gint column);
GcpSourceLocation* gcp_source_location_new_iter (GtkTextIter* iter);
GcpSourceLocation* gcp_source_location_construct_iter (GType object_type, GtkTextIter* iter);
GcpSourceLocation* gcp_source_location_copy (GcpSourceLocation* self);
static gint gcp_source_location_compare_int (GcpSourceLocation* self, gint a, gint b);
gint gcp_source_location_compare_to (GcpSourceLocation* self, GcpSourceLocation* other);
gboolean gcp_source_location_get_iter (GcpSourceLocation* self, GtkTextBuffer* buffer, GtkTextIter* iter);
gboolean gcp_source_location_buffer_coordinates (GcpSourceLocation* self, GtkTextView* view, GdkRectangle* rect);
gchar* gcp_source_location_to_string (GcpSourceLocation* self);
gint gcp_source_location_get_line (GcpSourceLocation* self);
gint gcp_source_location_get_column (GcpSourceLocation* self);
GFile* gcp_source_location_get_file (GcpSourceLocation* self);
void gcp_source_location_set_line (GcpSourceLocation* self, gint value);
GcpSourceRange* gcp_source_range_new (GcpSourceLocation* start, GcpSourceLocation* end);
GcpSourceRange* gcp_source_range_construct (GType object_type, GcpSourceLocation* start, GcpSourceLocation* end);
GcpSourceRange* gcp_source_range_support_get_range (GcpSourceRangeSupport* self);
static void gcp_source_location_finalize (GObject* obj);
static void _vala_gcp_source_location_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gcp_source_location_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GcpSourceLocation* gcp_source_location_construct (GType object_type, GFile* file, gint line, gint column) {
	GcpSourceLocation * self = NULL;
	GFile* _tmp0_;
	self = (GcpSourceLocation*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->d_file);
	self->priv->d_file = _tmp0_;
	self->priv->d_line = line;
	self->priv->d_column = column;
	return self;
}


GcpSourceLocation* gcp_source_location_new (GFile* file, gint line, gint column) {
	return gcp_source_location_construct (GCP_TYPE_SOURCE_LOCATION, file, line, column);
}


GcpSourceLocation* gcp_source_location_construct_iter (GType object_type, GtkTextIter* iter) {
	GcpSourceLocation * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = gtk_text_iter_get_line (iter);
	_tmp1_ = gtk_text_iter_get_line_offset (iter);
	self = (GcpSourceLocation*) gcp_source_location_construct (object_type, NULL, _tmp0_ + 1, _tmp1_ + 1);
	return self;
}


GcpSourceLocation* gcp_source_location_new_iter (GtkTextIter* iter) {
	return gcp_source_location_construct_iter (GCP_TYPE_SOURCE_LOCATION, iter);
}


GcpSourceLocation* gcp_source_location_copy (GcpSourceLocation* self) {
	GcpSourceLocation* result = NULL;
	GFile* _tmp0_ = NULL;
	GcpSourceLocation* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_file_dup (self->priv->d_file);
	_tmp1_ = gcp_source_location_new (_tmp0_, self->priv->d_line, self->priv->d_column);
	result = _tmp1_;
	return result;
}


static gint gcp_source_location_compare_int (GcpSourceLocation* self, gint a, gint b) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (a < b) {
		_tmp0_ = -1;
	} else {
		gint _tmp1_ = 0;
		if (a == b) {
			_tmp1_ = 0;
		} else {
			_tmp1_ = 1;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


gint gcp_source_location_compare_to (GcpSourceLocation* self, GcpSourceLocation* other) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (other != NULL, 0);
	if (self->priv->d_line == other->priv->d_line) {
		gint _tmp0_;
		_tmp0_ = gcp_source_location_compare_int (self, self->priv->d_column, other->priv->d_column);
		result = _tmp0_;
		return result;
	} else {
		gint _tmp1_ = 0;
		if (self->priv->d_line < other->priv->d_line) {
			_tmp1_ = -1;
		} else {
			_tmp1_ = 1;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean gcp_source_location_get_iter (GcpSourceLocation* self, GtkTextBuffer* buffer, GtkTextIter* iter) {
	GtkTextIter _iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gint _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (buffer != NULL, FALSE);
	gtk_text_buffer_get_iter_at_line (buffer, &_tmp0_, self->priv->d_line - 1);
	_iter = _tmp0_;
	_tmp1_ = gtk_text_iter_get_line (&_iter);
	if (_tmp1_ != (self->priv->d_line - 1)) {
		result = FALSE;
		if (iter) {
			*iter = _iter;
		}
		return result;
	}
	_tmp2_ = gtk_text_iter_forward_chars (&_iter, self->priv->d_column - 1);
	result = _tmp2_;
	if (iter) {
		*iter = _iter;
	}
	return result;
}


gboolean gcp_source_location_buffer_coordinates (GcpSourceLocation* self, GtkTextView* view, GdkRectangle* rect) {
	GdkRectangle _rect = {0};
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (view != NULL, FALSE);
	_tmp0_ = gtk_text_view_get_buffer (view);
	_tmp2_ = gcp_source_location_get_iter (self, _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		if (rect) {
			*rect = _rect;
		}
		return result;
	}
	gtk_text_view_get_iter_location (view, &iter, &_tmp3_);
	_rect = _tmp3_;
	gtk_text_view_get_line_yrange (view, &iter, &_tmp4_, &_tmp5_);
	_rect.y = _tmp4_;
	_rect.height = _tmp5_;
	result = TRUE;
	if (rect) {
		*rect = _rect;
	}
	return result;
}


gchar* gcp_source_location_to_string (GcpSourceLocation* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gcp_source_location_get_line (self);
	_tmp1_ = gcp_source_location_get_column (self);
	_tmp2_ = g_strdup_printf ("(%d.%d)", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


GFile* gcp_source_location_get_file (GcpSourceLocation* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_file;
	return result;
}


gint gcp_source_location_get_line (GcpSourceLocation* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_line;
	return result;
}


void gcp_source_location_set_line (GcpSourceLocation* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->d_line = value;
	g_object_notify ((GObject *) self, "line");
}


gint gcp_source_location_get_column (GcpSourceLocation* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_column;
	return result;
}


static GcpSourceRange* gcp_source_location_real_get_range (GcpSourceRangeSupport* base) {
	GcpSourceRange* result;
	GcpSourceLocation* self;
	GcpSourceLocation* _tmp0_ = NULL;
	GcpSourceLocation* _tmp1_;
	GcpSourceLocation* _tmp2_ = NULL;
	GcpSourceLocation* _tmp3_;
	GcpSourceRange* _tmp4_ = NULL;
	GcpSourceRange* _tmp5_;
	GcpSourceRange* r;
	GcpSourceRange* _tmp6_;
	self = (GcpSourceLocation*) base;
	_tmp0_ = gcp_source_location_new (self->priv->d_file, self->priv->d_line, self->priv->d_column);
	_tmp1_ = _tmp0_;
	_tmp2_ = gcp_source_location_new (self->priv->d_file, self->priv->d_line, self->priv->d_column);
	_tmp3_ = _tmp2_;
	_tmp4_ = gcp_source_range_new (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	r = _tmp5_;
	_tmp6_ = r;
	r = NULL;
	result = _tmp6_;
	_g_object_unref0 (r);
	return result;
}


static GcpSourceRange** gcp_source_location_real_get_ranges (GcpSourceRangeSupport* base, int* result_length1) {
	GcpSourceRange** result;
	GcpSourceLocation* self;
	GcpSourceRange* _tmp0_ = NULL;
	GcpSourceRange** _tmp1_ = NULL;
	GcpSourceRange** _tmp2_;
	self = (GcpSourceLocation*) base;
	_tmp0_ = gcp_source_range_support_get_range ((GcpSourceRangeSupport*) self);
	_tmp1_ = g_new0 (GcpSourceRange*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	*result_length1 = 1;
	result = _tmp2_;
	return result;
}


static void gcp_source_location_class_init (GcpSourceLocationClass * klass) {
	gcp_source_location_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpSourceLocationPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_source_location_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_source_location_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_source_location_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_LOCATION_FILE, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_LOCATION_LINE, g_param_spec_int ("line", "line", "line", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_SOURCE_LOCATION_COLUMN, g_param_spec_int ("column", "column", "column", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_SOURCE_LOCATION_RANGE, "range");
}


static void gcp_source_location_gcp_source_range_support_interface_init (GcpSourceRangeSupportIface * iface) {
	gcp_source_location_gcp_source_range_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_range = gcp_source_location_real_get_range;
	iface->get_ranges = gcp_source_location_real_get_ranges;
}


static void gcp_source_location_instance_init (GcpSourceLocation * self) {
	self->priv = GCP_SOURCE_LOCATION_GET_PRIVATE (self);
}


static void gcp_source_location_finalize (GObject* obj) {
	GcpSourceLocation * self;
	self = GCP_SOURCE_LOCATION (obj);
	_g_object_unref0 (self->priv->d_file);
	G_OBJECT_CLASS (gcp_source_location_parent_class)->finalize (obj);
}


GType gcp_source_location_get_type (void) {
	return gcp_source_location_type_id;
}


GType gcp_source_location_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpSourceLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_source_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpSourceLocation), 0, (GInstanceInitFunc) gcp_source_location_instance_init, NULL };
	static const GInterfaceInfo gcp_source_range_support_info = { (GInterfaceInitFunc) gcp_source_location_gcp_source_range_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gcp_source_location_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpSourceLocation", &g_define_type_info, 0);
	g_type_module_add_interface (module, gcp_source_location_type_id, GCP_TYPE_SOURCE_RANGE_SUPPORT, &gcp_source_range_support_info);
	return gcp_source_location_type_id;
}


static void _vala_gcp_source_location_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpSourceLocation * self;
	self = GCP_SOURCE_LOCATION (object);
	switch (property_id) {
		case GCP_SOURCE_LOCATION_FILE:
		g_value_set_object (value, gcp_source_location_get_file (self));
		break;
		case GCP_SOURCE_LOCATION_LINE:
		g_value_set_int (value, gcp_source_location_get_line (self));
		break;
		case GCP_SOURCE_LOCATION_COLUMN:
		g_value_set_int (value, gcp_source_location_get_column (self));
		break;
		case GCP_SOURCE_LOCATION_RANGE:
		g_value_take_object (value, gcp_source_range_support_get_range ((GcpSourceRangeSupport*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_source_location_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpSourceLocation * self;
	self = GCP_SOURCE_LOCATION (object);
	switch (property_id) {
		case GCP_SOURCE_LOCATION_LINE:
		gcp_source_location_set_line (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



