using System;
using System.Runtime.InteropServices;

namespace Evolution {
	public class CalGlueComponentUtil {

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_uid(IntPtr raw);
		public static String GetUid (IntPtr Handle)
		{
			/* default unmanaged/managged mapping seems to free/corrupt
			   the original memory. Now, the callee returns a freshly-
			   allocated pointer that the caller has to free.

			   A probable bug in Mono.
			*/
			IntPtr raw_ret = e_cal_glue_component_get_uid (Handle);
			string ret = GLib.Marshaller.PtrToStringGFree (raw_ret);
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_recur_id(IntPtr raw);
		public static string GetRecurId (IntPtr Handle)
		{
			IntPtr raw_ret = e_cal_glue_component_get_recur_id (Handle);
			string ret = GLib.Marshaller.PtrToStringGFree (raw_ret);
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_attendees(IntPtr raw);

		public static string[] GetAttendees (IntPtr Handle)
		{
			IntPtr raw_ret = e_cal_glue_component_get_attendees (Handle);
			return Evolution.CalUtil.GLibSListToStringArray (raw_ret, false);
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_descriptions(IntPtr raw);

		public static string[] GetDescriptions (IntPtr Handle)
		{ 
			IntPtr raw_ret = e_cal_glue_component_get_descriptions(Handle);
			return Evolution.CalUtil.GLibSListToStringArray (raw_ret, false);
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_comments(IntPtr raw);

		public static string[] GetComments (IntPtr Handle)
		{ 
			IntPtr raw_ret = e_cal_glue_component_get_comments(Handle);
			return Evolution.CalUtil.GLibSListToStringArray (raw_ret, false);
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_categories(IntPtr raw);

		public static string[] GetCategories (IntPtr Handle)
		{ 
			IntPtr raw_ret = e_cal_glue_component_get_categories(Handle);
			return Evolution.CalUtil.GLibSListToStringArray (raw_ret, false);
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_location(IntPtr raw);

		public static string[] GetLocation (IntPtr Handle) 
		{
			IntPtr raw_ret = e_cal_glue_component_get_location(Handle);
			return Evolution.CalUtil.GLibSListToStringArray (raw_ret, false);

		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_summaries(IntPtr raw);

		public static string[] GetSummaries (IntPtr Handle)
		{ 
			IntPtr raw_ret = e_cal_glue_component_get_summaries(Handle);
			return Evolution.CalUtil.GLibSListToStringArray (raw_ret, false);
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_dtstart(IntPtr raw);

		public static System.DateTime GetDtstart (IntPtr Handle) { 
			IntPtr raw_ret = e_cal_glue_component_get_dtstart(Handle);
			System.DateTime ret;
			
			//
			// If raw_ret is zero, we will return DateTime.MinValue.
			//
			if (raw_ret == IntPtr.Zero)
				ret = DateTime.MinValue;
			else 
				ret = GLib.Marshaller.time_tToDateTime (raw_ret);
			
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_dtend(IntPtr raw);

		public static System.DateTime GetDtend (IntPtr Handle) { 
			IntPtr raw_ret = e_cal_glue_component_get_dtend(Handle);
			System.DateTime ret;
			
			//
			// If raw_ret is zero, we will return DateTime.MinValue.
			//
			if (raw_ret == IntPtr.Zero)
				ret = DateTime.MinValue;
			else 
				ret = GLib.Marshaller.time_tToDateTime (raw_ret);
			
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_last_modified_date(IntPtr raw);

		public static System.DateTime GetLastModified (IntPtr Handle) { 
			IntPtr raw_ret = e_cal_glue_component_get_last_modified_date(Handle);
			System.DateTime ret;
			
			//
			// If raw_ret is zero, we will return DateTime.MinValue.
			//
			if (raw_ret == IntPtr.Zero)
				ret = DateTime.MinValue;
			else 
				ret = GLib.Marshaller.time_tToDateTime (raw_ret);
			
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_dtstamp(IntPtr raw);

		public static System.DateTime GetDtstamp (IntPtr Handle) { 
			//
			// Dtstamp is one of the *MUST* fields, so
			// we don't have to bother about a IntPtr.Zero 
			//condition
			//
			IntPtr raw_ret = e_cal_glue_component_get_dtstamp(Handle);
			System.DateTime ret = GLib.Marshaller.time_tToDateTime (raw_ret);
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_created(IntPtr raw);

		public static System.DateTime GetCreated (IntPtr Handle) { 
			IntPtr raw_ret = e_cal_glue_component_get_created(Handle);
			System.DateTime ret;
			
			//
			// If raw_ret is zero, we will return DateTime.MinValue.
			//
			if (raw_ret == IntPtr.Zero)
				ret = DateTime.MinValue;
			else 
				ret = GLib.Marshaller.time_tToDateTime (raw_ret);
			
			return ret;
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_rrule_list(IntPtr raw);

		public static CalRecurrence[] GetRecurrenceRules (IntPtr Handle)
		{ 
			IntPtr raw_ret = e_cal_glue_component_get_rrule_list(Handle);
			return Evolution.CalUtil.GLibSListToCalRecurrenceArray (raw_ret);
		}

		[DllImport("evolutionglue")]
		static extern IntPtr e_cal_glue_component_get_exrule_list(IntPtr raw);

		public static CalRecurrence[] GetExceptionRules (IntPtr Handle)
		{ 
			IntPtr raw_ret = e_cal_glue_component_get_exrule_list(Handle);
			return Evolution.CalUtil.GLibSListToCalRecurrenceArray (raw_ret);
		}
	}
}
