/*
 *  Copyright (C) 2005 Peter Harvey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef EPHY_BOOKMARKS_UI_H
#define EPHY_BOOKMARKS_UI_H

#include "ephy-window.h"
#include "egg-toolbars-model.h"

#include <gtk/gtk.h>

void  ephy_bookmarks_ui_attach_window        (EphyWindow *window);
void  ephy_bookmarks_ui_detach_window        (EphyWindow *window);

void  ephy_bookmarks_ui_attach_toolbar_model (EggToolbarsModel *model);
void  ephy_bookmarks_ui_detach_toolbar_model (EggToolbarsModel *model);

void ephy_bookmarks_ui_add_bookmark  (GtkWidget *parent,
				      const char *location,
				      const char *title);

void ephy_bookmarks_ui_add_topic     (GtkWidget *parent,
				      EphyNode *bookmark);

void ephy_bookmarks_ui_show_bookmark (GtkWidget *parent,
				      EphyNode *bookmark);

#endif
