// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSSERVER_H
#define _GIOMM_DBUSSERVER_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/initable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusServer GDBusServer;
typedef struct _GDBusServerClass GDBusServerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusServer_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusServerFlags operator|(DBusServerFlags, DBusServerFlags)</tt><br>
 * <tt>%DBusServerFlags operator&(DBusServerFlags, DBusServerFlags)</tt><br>
 * <tt>%DBusServerFlags operator^(DBusServerFlags, DBusServerFlags)</tt><br>
 * <tt>%DBusServerFlags operator~(DBusServerFlags)</tt><br>
 * <tt>%DBusServerFlags& operator|=(DBusServerFlags&, DBusServerFlags)</tt><br>
 * <tt>%DBusServerFlags& operator&=(DBusServerFlags&, DBusServerFlags)</tt><br>
 * <tt>%DBusServerFlags& operator^=(DBusServerFlags&, DBusServerFlags)</tt><br>
 */
enum DBusServerFlags
{
  DBUS_SERVER_FLAGS_NONE = 0x0,
  DBUS_SERVER_FLAGS_RUN_IN_THREAD = (1<<0),
  DBUS_SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS = (1<<1)
};

/** @ingroup giommEnums */
inline DBusServerFlags operator|(DBusServerFlags lhs, DBusServerFlags rhs)
  { return static_cast<DBusServerFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusServerFlags operator&(DBusServerFlags lhs, DBusServerFlags rhs)
  { return static_cast<DBusServerFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusServerFlags operator^(DBusServerFlags lhs, DBusServerFlags rhs)
  { return static_cast<DBusServerFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusServerFlags operator~(DBusServerFlags flags)
  { return static_cast<DBusServerFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusServerFlags& operator|=(DBusServerFlags& lhs, DBusServerFlags rhs)
  { return (lhs = static_cast<DBusServerFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusServerFlags& operator&=(DBusServerFlags& lhs, DBusServerFlags rhs)
  { return (lhs = static_cast<DBusServerFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusServerFlags& operator^=(DBusServerFlags& lhs, DBusServerFlags rhs)
  { return (lhs = static_cast<DBusServerFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class DBusAuthObserver;
class DBusConnection;

//TODO: Add example from the C API in class docs.
/** DBusServer - Helper for accepting connections.
 * DBusServer is a helper for listening to and accepting D-Bus connections.
 * Since DBusServer implements the Initable interface, its constructors can
 * throw an exception if construction fails.
 *
 * @newin{2,26}
 */

class DBusServer : public Glib::Object, public Initable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusServer CppObjectType;
  typedef DBusServer_Class CppClassType;
  typedef GDBusServer BaseObjectType;
  typedef GDBusServerClass BaseClassType;

private:  friend class DBusServer_Class;
  static CppClassType dbusserver_class_;

private:
  // noncopyable
  DBusServer(const DBusServer&);
  DBusServer& operator=(const DBusServer&);

protected:
  explicit DBusServer(const Glib::ConstructParams& construct_params);
  explicit DBusServer(GDBusServer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusServer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusServer*       gobj()       { return reinterpret_cast<GDBusServer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusServer* gobj() const { return reinterpret_cast<GDBusServer*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusServer* gobj_copy();

private:

  
protected:
  DBusServer(const Glib::ustring& address, DBusServerFlags flags,
    const Glib::ustring& guid, const Glib::RefPtr<DBusAuthObserver>& observer,
    const Glib::RefPtr<Cancellable>& cancellable);

public:
  

  static Glib::RefPtr<DBusServer> create(const Glib::ustring& address,
    DBusServerFlags flags, const Glib::ustring& guid,
    const Glib::RefPtr<DBusAuthObserver>& observer,
    const Glib::RefPtr<Cancellable>& cancellable);

  
  void start();
  
  void stop();
  
  bool is_active() const;
  
  Glib::ustring get_guid() const;
  
  DBusServerFlags get_flags() const;
  
  Glib::ustring get_client_address() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the server is currently active.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_active() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The address to listen on.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_address() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Object used to assist in the authentication process.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DBusAuthObserver> > property_authentication_observer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The address clients can use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_client_address() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags for the server.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<DBusServerFlags> property_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The guid of the server.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_guid() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%new_connection(const Glib::RefPtr<DBusConnection>& connection)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<DBusConnection>& > signal_new_connection();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusServer
   */
  Glib::RefPtr<Gio::DBusServer> wrap(GDBusServer* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSSERVER_H */

