/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

import org.gnu.glib.EventType;

/**
 * An event represeting action by a {@link org.gnu.gtk.CellEditable} class.
 */
public class CellEditableEvent extends GtkEvent {

    /**
     * Type of a CellEditableEvent
     */
    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        public static final Type EDITING_DONE = new Type(1, "EDITING_DONE");

        public static final Type REMOVE_WIDGET = new Type(2, "REMOVE_WIDGET");
    }

    /**
     * Creates a new CellEditableEvent. This is used internally by java-gnome.
     * Users only have to deal with listeners.
     */
    public CellEditableEvent(Object source, CellEditableEvent.Type type) {
        super(source, type);
    }

    /**
     * @return True if the type of this event is the same as that stated.
     */
    public boolean isOfType(CellEditableEvent.Type aType) {
        return (type.getID() == aType.getID());
    }
}
