// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GLIBMM_KEYFILE_H
#define _GLIBMM_KEYFILE_H


/* Copyright(C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/ustring.h>
#include <glibmm/arrayhandle.h>
#include <glibmm/error.h>
#include <glibmm/utility.h>
#include <glib/gkeyfile.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GKeyFile GKeyFile; }
#endif

namespace Glib
{

  /** @addtogroup glibmmEnums Enums and Flags */

/**
 * @ingroup glibmmEnums
 * @par Bitwise operators:
 * <tt>%KeyFileFlags operator|(KeyFileFlags, KeyFileFlags)</tt><br>
 * <tt>%KeyFileFlags operator&(KeyFileFlags, KeyFileFlags)</tt><br>
 * <tt>%KeyFileFlags operator^(KeyFileFlags, KeyFileFlags)</tt><br>
 * <tt>%KeyFileFlags operator~(KeyFileFlags)</tt><br>
 * <tt>%KeyFileFlags& operator|=(KeyFileFlags&, KeyFileFlags)</tt><br>
 * <tt>%KeyFileFlags& operator&=(KeyFileFlags&, KeyFileFlags)</tt><br>
 * <tt>%KeyFileFlags& operator^=(KeyFileFlags&, KeyFileFlags)</tt><br>
 */
enum KeyFileFlags
{
  KEY_FILE_NONE = 0,
  KEY_FILE_KEEP_COMMENTS = 1 << 0,
  KEY_FILE_KEEP_TRANSLATIONS = 1 << 1
};

/** @ingroup glibmmEnums */
inline KeyFileFlags operator|(KeyFileFlags lhs, KeyFileFlags rhs)
  { return static_cast<KeyFileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline KeyFileFlags operator&(KeyFileFlags lhs, KeyFileFlags rhs)
  { return static_cast<KeyFileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline KeyFileFlags operator^(KeyFileFlags lhs, KeyFileFlags rhs)
  { return static_cast<KeyFileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup glibmmEnums */
inline KeyFileFlags operator~(KeyFileFlags flags)
  { return static_cast<KeyFileFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup glibmmEnums */
inline KeyFileFlags& operator|=(KeyFileFlags& lhs, KeyFileFlags rhs)
  { return (lhs = static_cast<KeyFileFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline KeyFileFlags& operator&=(KeyFileFlags& lhs, KeyFileFlags rhs)
  { return (lhs = static_cast<KeyFileFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup glibmmEnums */
inline KeyFileFlags& operator^=(KeyFileFlags& lhs, KeyFileFlags rhs)
  { return (lhs = static_cast<KeyFileFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


  /** Exception class for KeyFile errors.
   */
  class KeyFileError : public Glib::Error
{
public:
  enum Code
  {
    UNKNOWN_ENCODING,
    PARSE,
    NOT_FOUND,
    KEY_NOT_FOUND,
    GROUP_NOT_FOUND,
    INVALID_VALUE
  };

  KeyFileError(Code error_code, const Glib::ustring& error_message);
  explicit KeyFileError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};


class KeyFile
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef KeyFile CppObjectType;
  typedef GKeyFile BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:

  /** Creates a new, empty KeyFile object.
   */
  KeyFile();

  /** Destructor
   */
  ~KeyFile();
  

  /** Creates a glibmm KeyFile wrapper for a GKeyFile object.
   * Note, when using this that when the wrapper is deleted, 
   * it will not automatically deleted the GKeyFile unless you
   * set the delete_c_instance boolean to true.
   * @param castitem The C instance to wrap
   * @param delete_c_instance If the C instance should be deleted when
   * the wrapper is deleted.
   */
  KeyFile(GKeyFile* castitem, bool takes_ownership = false);

public:
	
  
  /** Loads a key file into an empty G::KeyFile structure.
   * If the file could not be loaded then %error is set to 
   * either a G::FileError or G::KeyFileError.
   * @param file The path of a filename to load, in the GLib file name encoding.
   * @param flags Flags from G::KeyFileFlags.
   * @param error Return location for a G::Error, or <tt>0</tt>.
   * @return <tt>true</tt> if a key file could be loaded, <tt>false</tt> othewise
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool load_from_file(const std::string& filename, KeyFileFlags flags = Glib::KEY_FILE_NONE);
#else
  bool load_from_file(const std::string& filename, KeyFileFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Loads a KeyFile from memory
   * @param data The data to use as a KeyFile
   * @param flags Bitwise combination of the flags to use for the KeyFile
   * @return true if the KeyFile was successfully loaded, false otherwise
   * @throw Glib::KeyFileError
   */

  bool load_from_data(const Glib::ustring& data, KeyFileFlags flags = Glib::KEY_FILE_NONE);
  

  /** Looks for a KeyFile named @a file in the paths returned from
   * g_get_user_data_dir() and g_get_system_data_dirs() and loads them
   * into the keyfile object, placing the full path to the file in
   * @a full_path.
   * @param file The file to search for
   * @param full_path Return location for a string containing the full path of the file
   * @param flags Bitwise combination of the flags to use for the KeyFile
   * @return true if the KeyFile was successfully loaded, false otherwise
   * @throw Glib::KeyFileError
   * @throw Glib::FileError
   */
  bool load_from_data_dirs(const std::string& file, std::string& full_path, KeyFileFlags flags = Glib::KEY_FILE_NONE);
  

  /** Outputs the KeyFile as a string
   * @return A string object holding the contents of KeyFile
   */
  Glib::ustring to_data();
  

  /** Returns the name of the start group of the file.
   * @return The start group of the key file.
   * 
   * @newin2p6.
   */
  Glib::ustring get_start_group() const;
	
  /** Gets a list of all groups in the KeyFile
   * @returns A list containing the names of the groups
   */
  Glib::ArrayHandle<Glib::ustring> get_groups() const;
  

  /** Gets a list of all keys from the group @a group_name.
   * @param group_name The name of a group
   * @returns A list containing the names of the keys in @a group_name
   */
  Glib::ArrayHandle<Glib::ustring> get_keys(const Glib::ustring& group_name) const;
  

  /** Looks whether the key file has the group @a group_name .
   * @param group_name A group name.
   * @return <tt>true</tt> if @a group_name  is a part of @a key_file , <tt>false</tt>
   * otherwise.
   * @newin2p6.
   */
  bool has_group(const Glib::ustring& group_name) const;
  
  /** Looks whether the key file has the key @a key  in the group
   *  @a group_name .
   * @param group_name A group name.
   * @param key A key name.
   * @param error Return location for a G::Error.
   * @return <tt>true</tt> if @a key  is a part of @a group_name , <tt>false</tt>
   * otherwise.
   * 
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool has_key(const Glib::ustring& group_name, const Glib::ustring& key) const;
#else
  bool has_key(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

	
  /** Returns the value associated with @a key  under @a group_name .  
   * 
   * In the event the key cannot be found, <tt>0</tt> is returned and 
   *  @a error  is set to G::KEY_FILE_ERROR_KEY_NOT_FOUND.  In the 
   * event that the @a group_name  cannot be found, <tt>0</tt> is returned 
   * and @a error  is set to G::KEY_FILE_ERROR_GROUP_NOT_FOUND.
   * @param group_name A group name.
   * @param key A key.
   * @param error Return location for a G::Error, or <tt>0</tt>.
   * @return A newly allocated string or <tt>0</tt> if the specified 
   * key cannot be found.
   * 
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring get_value(const Glib::ustring& group_name, const Glib::ustring& key) const;
#else
  Glib::ustring get_value(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Returns the value associated with @a key  under @a group_name .  
   * 
   * In the event the key cannot be found, <tt>0</tt> is returned and 
   *  @a error  is set to G::KEY_FILE_ERROR_KEY_NOT_FOUND.  In the 
   * event that the @a group_name  cannot be found, <tt>0</tt> is returned 
   * and @a error  is set to G::KEY_FILE_ERROR_GROUP_NOT_FOUND.
   * @param group_name A group name.
   * @param key A key.
   * @param error Return location for a G::Error, or <tt>0</tt>.
   * @return A newly allocated string or <tt>0</tt> if the specified 
   * key cannot be found.
   * 
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring get_string(const Glib::ustring& group_name, const Glib::ustring& key) const;
#else
  Glib::ustring get_string(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets the value associated with @a key under @a group_name translated
  * into the current locale.
  */
  Glib::ustring get_locale_string(const Glib::ustring& group_name, const Glib::ustring& key) const;

  
  /** Returns the value associated with @a key  under @a group_name 
   * translated in the given @a locale  if available.  If @a locale  is
   * <tt>0</tt> then the current locale is assumed. 
   * 
   * If @a key  cannot be found then <tt>0</tt> is returned and @a error  is set to
   * G::KEY_FILE_ERROR_KEY_NOT_FOUND. If the value associated
   * with @a key  cannot be interpreted or no suitable translation can
   * be found then the untranslated value is returned.
   * @param group_name A group name.
   * @param key A key.
   * @param locale A locale or <tt>0</tt>.
   * @param error Return location for a G::Error, or <tt>0</tt>.
   * @return A newly allocated string or <tt>0</tt> if the specified 
   * key cannot be found.
   * 
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring get_locale_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale) const;
#else
  Glib::ustring get_locale_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Returns the value associated with @a key  under @a group_name  as a
   * boolean. 
   * 
   * If @a key  cannot be found then the return value is undefined and
   *  @a error  is set to G::KEY_FILE_ERROR_KEY_NOT_FOUND. Likewise, if
   * the value associated with @a key  cannot be interpreted as a boolean
   * then the return value is also undefined and @a error  is set to
   * G::KEY_FILE_ERROR_INVALID_VALUE.
   * @param group_name A group name.
   * @param key A key.
   * @param error Return location for a G::Error.
   * @return The value associated with the key as a boolean
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool get_boolean(const Glib::ustring& group_name, const Glib::ustring& key) const;
#else
  bool get_boolean(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets the value in the first group, under @a key, interpreting it as
   * an integer.
   * @param key The name of the key
   * @return The value of @a key as an integer
   * @throws Glib::KeyFileError
   */
  int get_integer(const Glib::ustring& key) const;

  
  /** Returns the value associated with @a key  under @a group_name  as an
   * integer. If @a group_name  is <tt>0</tt>, the start_group is used.
   * 
   * If @a key  cannot be found then the return value is undefined and
   *  @a error  is set to G::KEY_FILE_ERROR_KEY_NOT_FOUND. Likewise, if
   * the value associated with @a key  cannot be interpreted as an integer
   * then the return value is also undefined and @a error  is set to
   * G::KEY_FILE_ERROR_INVALID_VALUE.
   * @param group_name A group name.
   * @param key A key.
   * @param error Return location for a G::Error.
   * @return The value associated with the key as an integer.
   * 
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int get_integer(const Glib::ustring& group_name, const Glib::ustring& key) const;
#else
  int get_integer(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Returns the values associated with @a key under @a group_name
   * @param group_name The name of a group
   * @param key The name of a key
   * @return A list containing the values requested
   * @throws Glib::KeyFileError
   */
  Glib::ArrayHandle<Glib::ustring> get_string_list(const Glib::ustring& group_name, const Glib::ustring& key) const;
  
	
  /** Returns the values associated with @a key under @a group_name
   * translated into the current locale, if available.
   * @param group_name The name of a group
   * @param key The name of a key
   * @return A list containing the values requested
   * @throws Glib::KeyFileError
   */
  Glib::ArrayHandle<Glib::ustring> get_locale_string_list(const Glib::ustring& group_name, const Glib::ustring& key) const;
	
  /** Returns the values associated with @a key under @a group_name
   * translated into @a locale, if available.
   * @param group_name The name of a group
   * @param key The name of a key
   * @param locale The name of a locale
   * @return A list containing the values requested
   * @throws Glib::KeyFileError
   */
  Glib::ArrayHandle<Glib::ustring> get_locale_string_list(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale) const;
  

  /** Returns the values associated with @a key under @a group_name
   * @param group_name The name of a group
   * @param key The name of a key
   * @return A list of booleans
   * @throws Glib::KeyFileError
   */
  Glib::ArrayHandle<bool> get_boolean_list(const Glib::ustring& group_name, const Glib::ustring& key) const;
  

  /** Returns the values associated with @a key under @a group_name
   * @param group_name The name of a group
   * @param key The name of a key
   * @return A list of integers
   * @throws Glib::KeyFileError
   */
  Glib::ArrayHandle<int> get_integer_list(const Glib::ustring& group_name, const Glib::ustring& key) const;
  

  /** Get comment from top of file
   * @return The comment
   */
  Glib::ustring get_comment() const;

  /** Get comment from above a group
   * @param group_name The group
   * @return The comment
   */
  Glib::ustring get_comment(const Glib::ustring& group_name) const;

  
  /** Retrieves a comment above @a key  from @a group_name .
   *  @a group_name . If @a key  is <tt>0</tt> then @a comment  will
   * be read from above @a group_name .  If both @a key 
   * and @a group_name  are <tt>0</tt>, then @a comment  will
   * be read from above the first group in the file.
   * @param group_name A group name, or <tt>0</tt>.
   * @param key A key.
   * @param error Return location for a G::Error.
   * @return A comment that should be freed with g_free()
   * 
   * @newin2p6.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring get_comment(const Glib::ustring& group_name, const Glib::ustring& key) const;
#else
  Glib::ustring get_comment(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED

	
  /** Sets the character which is used to separate
   * values in lists. Typically ';' or ',' are used
   * as separators. The default list separator is ';'.
   * 
   * @newin2p6
   * @param separator The separator.
   */
  void set_list_separator(gchar separator);
  
  /** Associates a new value with @a key  under @a group_name .  If @a key 
   * cannot be found then it is created. If @a group_name  cannot be
   * found then it is created.
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param key A key.
   * @param value A string.
   */
  void set_value(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& value);
  
  /** Associates a new string value with @a key  under @a group_name .  If
   *  @a key  cannot be found then it is created.  If @a group_name 
   * cannot be found then it is created.
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param key A key.
   * @param string A string.
   */
  void set_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& string);
  
  /** Associates a string value for @a key  and @a locale  under
   *  @a group_name .  If the translation for @a key  cannot be found 
   * then it is created.
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param key A key.
   * @param locale A locale.
   * @param string A string.
   */
  void set_locale_string(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale, const Glib::ustring& string);
  
  /** Associates a new boolean value with @a key  under @a group_name .
   * If @a key  cannot be found then it is created. 
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param key A key.
   * @param value <tt>true</tt> or <tt>false</tt>.
   */
  void set_boolean(const Glib::ustring& group_name, const Glib::ustring& key, bool value);
  
  /** Associates a new integer value with @a key  under @a group_name .
   * If @a key  cannot be found then it is created.
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param key A key.
   * @param value An integer value.
   */
  void set_integer(const Glib::ustring& group_name, const Glib::ustring& key, int value);
	
  /** Sets a list of string values for @a key under @a group_name. If 
   * key cannot be found it is created. If @a group_name cannot be found
   * it is created.
   * @param group_name The name of a group
   * @param key The name of a key
   * @param list A list holding objects of type Glib::ustring
   */
  void set_string_list(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ArrayHandle<Glib::ustring>& list);
  

  /** Sets a list of string values for the @a key under @a group_name and marks
   * them as being for @a locale. If the @a key or @a group_name cannot be
   * found, they are created.
   * @param group_name The name of a group
   * @param key The name of a key
   * @param locale A locale
   * @param list A list holding objects of type Glib::ustring
   */
  void set_locale_string_list(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& locale, const Glib::ArrayHandle<Glib::ustring>& list);
  

  /** Sets a list of booleans for the @a key under @a group_name.
   * If either the @a key or @a group_name cannot be found they are created
   * @param group_name The name of a group
   * @param key The name of a key
   * @param list A list holding object of type bool
   */
  void set_boolean_list(const Glib::ustring& group_name, const Glib::ustring& key, Glib::ArrayHandle<bool>& list);
  
	
  /** Sets a list of integers for the @a key under @a group_name.
   * If either the @a key or @a group_name cannot be found they are created
   * @param group_name The name of a group
   * @param key The name of a key
   * @param list A list holding object of type int
   */
  void set_integer_list(const Glib::ustring& group_name, const Glib::ustring& key, Glib::ArrayHandle<int>& list);
  

  /** Places @a comment at the start of the file, before the first group.
   * @param comment The Comment
   */
  void set_comment(const Glib::ustring& comment);

  /** Places @a comment above @a group_name.
   * @param group_name The Group the comment should be above
   * @param comment The comment
   */
  void set_comment(const Glib::ustring& group_name, const Glib::ustring& comment);

  /** Places a comment above @a key from @a group_name.
   * @param key Key comment should be above
   * @param group_name Group comment is in
   * @param comment The comment
   */
  
  /** Places a comment above @a key  from @a group_name .
   *  @a group_name . If @a key  is <tt>0</tt> then @a comment  will
   * be written above @a group_name .  If both @a key 
   * and @a group_name  are <tt>0</tt>, then @a comment  will
   * be written above the first group in the file.
   * 
   * @newin2p6
   * @param group_name A group name, or <tt>0</tt>.
   * @param key A key.
   * @param comment A comment.
   * @param error Return location for a G::Error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void set_comment(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& comment);
#else
  void set_comment(const Glib::ustring& group_name, const Glib::ustring& key, const Glib::ustring& comment, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Removes a comment above @a key  from @a group_name .
   *  @a group_name . If @a key  is <tt>0</tt> then @a comment  will
   * be written above @a group_name .  If both @a key 
   * and @a group_name  are <tt>0</tt>, then @a comment  will
   * be written above the first group in the file.
   * 
   * @newin2p6
   * @param group_name A group name, or <tt>0</tt>.
   * @param key A key.
   * @param error Return location for a G::Error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void remove_comment(const Glib::ustring& group_name, const Glib::ustring& key);
#else
  void remove_comment(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Removes @a key  in @a group_name  from the key file. 
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param key A key name to remove.
   * @param error Return location for a G::Error or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void remove_key(const Glib::ustring& group_name, const Glib::ustring& key);
#else
  void remove_key(const Glib::ustring& group_name, const Glib::ustring& key, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Removes the specified group, @a group_name , 
   * from the key file. 
   * 
   * @newin2p6
   * @param group_name A group name.
   * @param error Return location for a G::Error or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void remove_group(const Glib::ustring& group_name);
#else
  void remove_group(const Glib::ustring& group_name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  GKeyFile*       gobj()       { return gobject_; }
  const GKeyFile* gobj() const { return gobject_; }

protected:
  GKeyFile* gobject_;
  bool owns_gobject_;

private:
  // noncopyable
  KeyFile(const KeyFile&);
  KeyFile& operator=(const KeyFile&);


};

} // namespace Glib


#endif /* _GLIBMM_KEYFILE_H */

