// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PAGESETUP_H
#define _GTKMM_PAGESETUP_H


#include <glibmm.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gtkmm/enums.h>
#include <gtkmm/papersize.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkPageSetup GtkPageSetup;
typedef struct _GtkPageSetupClass GtkPageSetupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class PageSetup_Class; } // namespace Gtk
namespace Gtk
{

/** A PageSetup object stores the page size, orientation and margins. You can get one of these from the page setup dialog 
 * and then pass it to the PrintOperation when printing. The benefit of splitting this out of the PrintSettings is that 
 * these affect the actual layout of the page, and thus need to be set long before the user prints.
 *
 * The margins specified in this object are the "print margins", i.e. the parts of the page that the printer cannot print  
 * on. These are different from the layout margins that a word processor uses; they are typically used to determine the 
 * minimal size for the layout margins.
 *
 * To obtain a PageSetup use PageSetup::create() to get the defaults, or use run_page_setup_dialog() to show the page 
 * setup dialog and receive the resulting page setup. 
 *
 * @newin2p10
 *
 * @ingroup Printing
 */

class PageSetup : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef PageSetup CppObjectType;
  typedef PageSetup_Class CppClassType;
  typedef GtkPageSetup BaseObjectType;
  typedef GtkPageSetupClass BaseClassType;

private:  friend class PageSetup_Class;
  static CppClassType pagesetup_class_;

private:
  // noncopyable
  PageSetup(const PageSetup&);
  PageSetup& operator=(const PageSetup&);

protected:
  explicit PageSetup(const Glib::ConstructParams& construct_params);
  explicit PageSetup(GtkPageSetup* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~PageSetup();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkPageSetup*       gobj()       { return reinterpret_cast<GtkPageSetup*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkPageSetup* gobj() const { return reinterpret_cast<GtkPageSetup*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkPageSetup* gobj_copy();

private:

protected:
  PageSetup();

public:
  
  static Glib::RefPtr<PageSetup> create();


  PageOrientation get_orientation() const;
  
  void set_orientation(PageOrientation orientation);

  
  PaperSize get_paper_size();
  
  const PaperSize get_paper_size() const;
  
  void set_paper_size(const PaperSize& paper_size);

  
  double get_top_margin(Unit unit) const;
  
  void set_top_margin(double margin, Unit unit);

  
  double get_bottom_margin(Unit unit) const;
  
  void set_bottom_margin(double margin, Unit unit);

  
  double get_left_margin(Unit unit) const;
  
  void set_left_margin(double margin, Unit unit);

  
  double get_right_margin(Unit unit) const;
  
  void set_right_margin(double margin, Unit unit);

  
  void set_paper_size_and_default_margins(const PaperSize& paper_size);

  
  double get_paper_width(Unit unit) const;
  
  double get_paper_height(Unit unit) const;

  
  double get_page_width(Unit unit) const;
  
  double get_page_height(Unit unit) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::PageSetup
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gtk::PageSetup> wrap(GtkPageSetup* object, bool take_copy = false);
}


#endif /* _GTKMM_PAGESETUP_H */

