/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlUtils;

public class XmlInclude {
    private final String m_name;
    private final List<Integer> m_invocationNumbers;
    private final int m_index;
    private String m_description;
    private final Map<String, String> m_parameters = Maps.newHashMap();
    private XmlClass m_xmlClass;

    public XmlInclude(String string) {
        this(string, 0);
    }

    public XmlInclude(String string, int n) {
        this(string, Lists.newArrayList(), n);
    }

    public XmlInclude(String string, List<Integer> list, int n) {
        this.m_name = string;
        this.m_invocationNumbers = list;
        this.m_index = n;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setParameters(Map<String, String> map) {
        this.m_parameters.clear();
        this.m_parameters.putAll(map);
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getName() {
        return this.m_name;
    }

    public List<Integer> getInvocationNumbers() {
        return this.m_invocationNumbers;
    }

    public int getIndex() {
        return this.m_index;
    }

    public String toXml(String string) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        Properties properties = new Properties();
        properties.setProperty("name", this.getName());
        List<Integer> list = this.getInvocationNumbers();
        if (list != null && list.size() > 0) {
            properties.setProperty("invocation-numbers", XmlClass.listToString(list).toString());
        }
        if (!this.m_parameters.isEmpty()) {
            xMLStringBuffer.push("include", properties);
            XmlUtils.dumpParameters(xMLStringBuffer, this.m_parameters);
            xMLStringBuffer.pop("include");
        } else {
            xMLStringBuffer.addEmptyElement("include", properties);
        }
        return xMLStringBuffer.toXML();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.m_index;
        n = 31 * n + (this.m_invocationNumbers == null ? 0 : this.m_invocationNumbers.hashCode());
        n = 31 * n + (this.m_parameters == null ? 0 : this.m_parameters.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlInclude xmlInclude = (XmlInclude)object;
        if (this.m_invocationNumbers == null ? xmlInclude.m_invocationNumbers != null : !this.m_invocationNumbers.equals(xmlInclude.m_invocationNumbers)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? xmlInclude.m_name != null : !this.m_name.equals(xmlInclude.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_parameters == null ? xmlInclude.m_parameters != null : !this.m_parameters.equals(xmlInclude.m_parameters)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void addParameter(String string, String string2) {
        this.m_parameters.put(string, string2);
    }

    @Deprecated
    public Map<String, String> getParameters() {
        return this.getAllParameters();
    }

    public Map<String, String> getLocalParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> map = Maps.newHashMap();
        if (this.m_xmlClass != null) {
            map.putAll(this.m_xmlClass.getAllParameters());
        }
        map.putAll(this.m_parameters);
        return map;
    }

    public void setXmlClass(XmlClass xmlClass) {
        this.m_xmlClass = xmlClass;
    }
}

