/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dita.dost.Processor;
import org.dita.dost.util.Configuration;

public final class ProcessorFactory {
    private final File ditaDir;
    private final Map<String, String> args = new HashMap<String, String>();

    private ProcessorFactory(File ditaDir) {
        this.ditaDir = ditaDir;
    }

    public static ProcessorFactory newInstance(File ditaDir) {
        if (!ditaDir.isAbsolute()) {
            throw new IllegalArgumentException("DITA-OT directory must be absolute");
        }
        return new ProcessorFactory(ditaDir);
    }

    public void setBaseTempDir(File tmp) {
        if (!tmp.isAbsolute()) {
            throw new IllegalArgumentException("Temporary directory must be absolute");
        }
        this.args.put("base.temp.dir", tmp.getAbsolutePath());
    }

    public Processor newProcessor(String transtype) {
        if (this.ditaDir == null) {
            throw new IllegalStateException();
        }
        if (!Configuration.transtypes.contains(transtype)) {
            throw new IllegalArgumentException("Transtype " + transtype + " not supported");
        }
        return new Processor(this.ditaDir, transtype, Collections.unmodifiableMap(this.args));
    }
}

