/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.io;

import java.io.IOException;
import java.io.Reader;

public class LookAheadReader
extends Reader {
    char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 16384 : 128];
    int bufPos = 0;
    int bufValid = 0;
    Reader reader;

    public LookAheadReader(Reader reader) {
        this.reader = reader;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.bufValid == 0 && this.peek(0) == -1) {
            return -1;
        }
        if (n2 > this.bufValid) {
            n2 = this.bufValid;
        }
        if (n2 > this.buf.length - this.bufPos) {
            n2 = this.buf.length - this.bufPos;
        }
        System.arraycopy(this.buf, this.bufPos, cArray, n, n2);
        this.bufValid -= n2;
        this.bufPos += n2;
        if (this.bufPos > this.buf.length) {
            this.bufPos -= this.buf.length;
        }
        return n2;
    }

    public String readTo(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.peek(0) != -1 && string.indexOf((char)this.peek(0)) == -1) {
            stringBuffer.append((char)this.read());
        }
        return stringBuffer.toString();
    }

    public String readTo(char c) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.peek(0) != -1 && this.peek(0) != c) {
            stringBuffer.append((char)this.read());
        }
        return stringBuffer.toString();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read() throws IOException {
        int n = this.peek(0);
        if (n != -1) {
            if (++this.bufPos == this.buf.length) {
                this.bufPos = 0;
            }
            --this.bufValid;
        }
        return n;
    }

    public int peek(int n) throws IOException {
        if (n > 127) {
            throw new RuntimeException("peek > 127 not supported!");
        }
        while (n >= this.bufValid) {
            int n2 = (this.bufPos + this.bufValid) % this.buf.length;
            int n3 = Math.min(this.buf.length - n2, this.buf.length - this.bufValid);
            if ((n3 = this.reader.read(this.buf, n2, n3)) == -1) {
                return -1;
            }
            this.bufValid += n3;
        }
        return this.buf[this.bufPos + n % this.buf.length];
    }

    public String readLine() throws IOException {
        if (this.peek(0) == -1) {
            return null;
        }
        String string = this.readTo("\r\n");
        if (this.read() == 13 && this.peek(0) == 10) {
            this.read();
        }
        return string;
    }

    public String readWhile(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.peek(0) != -1 && string.indexOf((char)this.peek(0)) != -1) {
            stringBuffer.append((char)this.read());
        }
        return stringBuffer.toString();
    }

    public void skip(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.peek(0) != -1 && string.indexOf((char)this.peek(0)) != -1) {
            this.read();
        }
    }
}

