<?php

declare(strict_types=1);

namespace OpenStack\Identity\v3\Models;

use OpenStack\Common\Resource\Creatable;
use OpenStack\Common\Resource\Deletable;
use OpenStack\Common\Resource\Listable;
use OpenStack\Common\Resource\OperatorResource;
use OpenStack\Common\Resource\Retrievable;
use OpenStack\Common\Resource\Updateable;

/**
 * @property \OpenStack\Identity\v3\Api $api
 */
class Policy extends OperatorResource implements Creatable, Listable, Retrievable, Updateable, Deletable
{
    /** @var string */
    public $blob;

    /** @var string */
    public $id;

    /** @var array */
    public $links;

    /** @var string */
    public $projectId;

    /** @var string */
    public $type;

    /** @var string */
    public $userId;

    protected $resourceKey  = 'policy';
    protected $resourcesKey = 'policies';

    protected $aliases = [
        'project_id' => 'projectId',
        'user_id'    => 'userId',
    ];

    /**
     * @param array $data {@see \OpenStack\Identity\v3\Api::postPolicies}
     */
    public function create(array $data): Creatable
    {
        $response = $this->execute($this->api->postPolicies(), $data);

        return $this->populateFromResponse($response);
    }

    public function retrieve()
    {
        $response = $this->execute($this->api->getPolicy(), ['id' => $this->id]);
        $this->populateFromResponse($response);
    }

    public function update()
    {
        $response = $this->executeWithState($this->api->patchPolicy());
        $this->populateFromResponse($response);
    }

    public function delete()
    {
        $this->execute($this->api->deletePolicy(), ['id' => $this->id]);
    }
}
